/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.wurstclient.Category;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.ChatUtils;

public final class CheatDetectorHack
extends Hack
implements UpdateListener {
    private static final double TELEPORT_DISTANCE_THRESHOLD = 6.0;
    private static final double FLIGHT_VERTICAL_TOLERANCE = 0.08;
    private static final double BOAT_VERTICAL_TOLERANCE = 0.05;
    private static final int ALERT_COOLDOWN_TICKS = 200;
    private static final int AURA_WINDOW_TICKS = 40;
    private static final int FLIGHT_GROUND_GRACE_TICKS = 8;
    private final CheckboxSetting detectSpeed = new CheckboxSetting("Detect speed", true);
    private final SliderSetting speedThreshold = new SliderSetting("Speed threshold (blocks/s)", 10.0, 5.0, 80.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting cancelDuration = new SliderSetting("Cancel movement duration (s)", 1.0, 0.0, 10.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final CheckboxSetting latencyCompensationEnabled = new CheckboxSetting("Latency compensation", true);
    private final SliderSetting latencyVeryLowFactor = new SliderSetting("very-low-ping factor", 2.9, 1.0, 10.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting latencyLowFactor = new SliderSetting("low-ping factor", 2.9, 1.0, 10.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting latencyMediumFactor = new SliderSetting("medium-ping factor", 3.3, 1.0, 12.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting latencyHighFactor = new SliderSetting("high-ping factor", 3.6, 1.0, 15.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting latencyVeryHighFactor = new SliderSetting("very-high-ping factor", 4.6, 1.0, 20.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting latencyExtremeFactor = new SliderSetting("extreme-ping factor", 5.7, 1.0, 25.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting latencyUltraFactor = new SliderSetting("ultra-ping factor", 6.6, 1.0, 30.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting latencyInsaneFactor = new SliderSetting("insane-ping factor", 7.5, 1.0, 40.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting burstDefault = new SliderSetting("burst-tolerance default", 19.0, 1.0, 200.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting burstVeryLow = new SliderSetting("burst-tolerance very-low-ping", 20.0, 1.0, 200.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting burstLow = new SliderSetting("burst-tolerance low-ping", 21.0, 1.0, 200.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting burstMedium = new SliderSetting("burst-tolerance medium-ping", 22.0, 1.0, 200.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting burstHigh = new SliderSetting("burst-tolerance high-ping", 24.0, 1.0, 200.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting burstVeryHigh = new SliderSetting("burst-tolerance very-high-ping", 27.0, 1.0, 200.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting burstExtreme = new SliderSetting("burst-tolerance extreme-ping", 30.0, 1.0, 200.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting burstUltra = new SliderSetting("burst-tolerance ultra-ping", 33.0, 1.0, 200.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting burstInsane = new SliderSetting("burst-tolerance insane-ping", 35.0, 1.0, 200.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting knockbackMultiplier = new SliderSetting("knockback multiplier", 6.0, 1.0, 20.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting knockbackDuration = new SliderSetting("knockback duration (ms)", 1000.0, 0.0, 10000.0, 100.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting riptideMultiplier = new SliderSetting("riptide multiplier", 1.5, 1.0, 10.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting riptideDuration = new SliderSetting("riptide duration (ms)", 3000.0, 0.0, 10000.0, 100.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting elytraGlidingMultiplier = new SliderSetting("elytra gliding multiplier", 1.5, 1.0, 10.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting elytraLandingDuration = new SliderSetting("elytra landing duration (ms)", 1500.0, 0.0, 10000.0, 100.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting vehicleSpeedMultiplier = new SliderSetting("vehicle speed multiplier", 1.9, 1.0, 10.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting vehicleIceSpeedMultiplier = new SliderSetting("vehicle ice speed multiplier", 4.3, 1.0, 20.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting bufferMultiplier = new SliderSetting("buffer multiplier", 1.2, 1.0, 3.0, 0.01, SliderSetting.ValueDisplay.DECIMAL);
    private final CheckboxSetting detectFlight = new CheckboxSetting("Detect flight", true);
    private final SliderSetting flightAirTicks = new SliderSetting("Flight tick threshold", 40.0, 10.0, 200.0, 5.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting flightClearanceThreshold = new SliderSetting("Flight clearance (blocks)", 6.0, 3.0, 32.0, 0.5, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting flightPatternTicks = new SliderSetting("Flight sustain ticks", 16.0, 4.0, 80.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting flightAscendDistance = new SliderSetting("Flight ascend distance (blocks)", 5.0, 2.0, 40.0, 0.5, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting flightAscendRate = new SliderSetting("Flight ascend rate (blocks/tick)", 0.25, 0.05, 1.0, 0.05, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting flightHorizontalSpeed = new SliderSetting("Flight horizontal speed (blocks/s)", 1.0, 0.2, 5.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final CheckboxSetting detectBoatFly = new CheckboxSetting("Detect boat fly", true);
    private final SliderSetting boatAirTicks = new SliderSetting("Boat-air tick threshold", 25.0, 5.0, 200.0, 5.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting boatClearanceThreshold = new SliderSetting("Boat clearance (blocks)", 4.0, 2.0, 24.0, 0.5, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting boatPatternTicks = new SliderSetting("Boat sustain ticks", 10.0, 3.0, 60.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting boatHorizontalSpeed = new SliderSetting("Boat horizontal speed (blocks/s)", 0.5, 0.1, 4.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final CheckboxSetting detectAura = new CheckboxSetting("Detect killaura", true);
    private final SliderSetting auraThreshold = new SliderSetting("Swing threshold (per second)", 12.0, 6.0, 30.0, 0.5, SliderSetting.ValueDisplay.DECIMAL);
    private final Map<UUID, PlayerStats> playerStats = new HashMap<UUID, PlayerStats>();
    private long tickCounter;
    private class_638 lastWorld;

    public CheatDetectorHack() {
        super("CheatDetector");
        this.setCategory(Category.OTHER);
        this.addSetting(this.detectSpeed);
        this.addSetting(this.speedThreshold);
        this.addSetting(this.cancelDuration);
        this.addSetting(this.latencyCompensationEnabled);
        this.addSetting(this.latencyVeryLowFactor);
        this.addSetting(this.latencyLowFactor);
        this.addSetting(this.latencyMediumFactor);
        this.addSetting(this.latencyHighFactor);
        this.addSetting(this.latencyVeryHighFactor);
        this.addSetting(this.latencyExtremeFactor);
        this.addSetting(this.latencyUltraFactor);
        this.addSetting(this.latencyInsaneFactor);
        this.addSetting(this.burstDefault);
        this.addSetting(this.burstVeryLow);
        this.addSetting(this.burstLow);
        this.addSetting(this.burstMedium);
        this.addSetting(this.burstHigh);
        this.addSetting(this.burstVeryHigh);
        this.addSetting(this.burstExtreme);
        this.addSetting(this.burstUltra);
        this.addSetting(this.burstInsane);
        this.addSetting(this.knockbackMultiplier);
        this.addSetting(this.knockbackDuration);
        this.addSetting(this.riptideMultiplier);
        this.addSetting(this.riptideDuration);
        this.addSetting(this.elytraGlidingMultiplier);
        this.addSetting(this.elytraLandingDuration);
        this.addSetting(this.vehicleSpeedMultiplier);
        this.addSetting(this.vehicleIceSpeedMultiplier);
        this.addSetting(this.bufferMultiplier);
        this.addSetting(this.detectFlight);
        this.addSetting(this.flightAirTicks);
        this.addSetting(this.flightClearanceThreshold);
        this.addSetting(this.flightPatternTicks);
        this.addSetting(this.flightAscendDistance);
        this.addSetting(this.flightAscendRate);
        this.addSetting(this.flightHorizontalSpeed);
        this.addSetting(this.detectBoatFly);
        this.addSetting(this.boatAirTicks);
        this.addSetting(this.boatClearanceThreshold);
        this.addSetting(this.boatPatternTicks);
        this.addSetting(this.boatHorizontalSpeed);
        this.addSetting(this.detectAura);
        this.addSetting(this.auraThreshold);
    }

    @Override
    protected void onEnable() {
        this.tickCounter = 0L;
        this.lastWorld = CheatDetectorHack.MC.field_1687;
        this.playerStats.clear();
        EVENTS.add(UpdateListener.class, this);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        this.playerStats.clear();
        this.lastWorld = null;
    }

    @Override
    public void onUpdate() {
        if (CheatDetectorHack.MC.field_1687 == null || CheatDetectorHack.MC.field_1724 == null) {
            this.playerStats.clear();
            this.lastWorld = null;
            return;
        }
        if (CheatDetectorHack.MC.field_1687 != this.lastWorld) {
            this.playerStats.clear();
            this.lastWorld = CheatDetectorHack.MC.field_1687;
        }
        ++this.tickCounter;
        HashSet<UUID> seen = new HashSet<UUID>();
        for (class_1657 other : CheatDetectorHack.MC.field_1687.method_18456()) {
            if (other == CheatDetectorHack.MC.field_1724 || other.method_31481()) continue;
            UUID id2 = other.method_5667();
            seen.add(id2);
            PlayerStats stats = this.playerStats.computeIfAbsent(id2, uuid -> new PlayerStats());
            this.processPlayer(other, stats);
        }
        this.playerStats.keySet().removeIf(id -> !seen.contains(id));
    }

    private void processPlayer(class_1657 player, PlayerStats stats) {
        if (player.method_7325() || player.method_68878()) {
            stats.resetPosition(player);
            return;
        }
        if (!stats.hasLastPosition) {
            stats.resetPosition(player);
            return;
        }
        double x = player.method_23317();
        double y = player.method_23318();
        double z = player.method_23321();
        double dx = x - stats.lastX;
        double dy = y - stats.lastY;
        double dz = z - stats.lastZ;
        double horizontalPerTick = Math.sqrt(dx * dx + dz * dz);
        double horizontalPerSecond = horizontalPerTick * 20.0;
        if (horizontalPerTick > 6.0 || Math.abs(dy) > 6.0) {
            stats.ignoreMovementTicks = 5;
        } else if (stats.ignoreMovementTicks > 0) {
            --stats.ignoreMovementTicks;
        }
        if (stats.ignoreMovementTicks == 0) {
            this.checkSpeed(player, stats, horizontalPerSecond);
        }
        this.updateFlightPattern(player, stats, dy);
        this.checkFlight(player, stats, dy, horizontalPerSecond);
        this.checkBoatFly(player, stats);
        this.checkAura(player, stats);
        stats.lastX = x;
        stats.lastY = y;
        stats.lastZ = z;
    }

    private void checkSpeed(class_1657 player, PlayerStats stats, double horizontalPerSecond) {
        class_1297 vehicle;
        if (!this.detectSpeed.isChecked()) {
            return;
        }
        if (player.method_5799() || player.method_5681()) {
            return;
        }
        double allowed = this.speedThreshold.getValue() * this.bufferMultiplier.getValue();
        if (this.isUsingElytra(player)) {
            allowed *= this.elytraGlidingMultiplier.getValue();
        }
        if ((vehicle = player.method_5854()) != null) {
            allowed *= this.vehicleSpeedMultiplier.getValue();
            try {
                int bx = class_3532.method_15357((double)vehicle.method_23317());
                int bz = class_3532.method_15357((double)vehicle.method_23321());
                int by = class_3532.method_15357((double)vehicle.method_23318()) - 1;
                class_2680 under = ((class_638)vehicle.method_73183()).method_8320(new class_2338(bx, by, bz));
                String id = under.method_26204().toString().toLowerCase(Locale.ROOT);
                if (id.contains("ice")) {
                    allowed *= this.vehicleIceSpeedMultiplier.getValue();
                }
            }
            catch (Exception bx) {
                // empty catch block
            }
        }
        if (player.method_6059(class_1294.field_5904)) {
            allowed *= 1.2;
        }
        int ping = this.getPlayerPing(player);
        if (this.latencyCompensationEnabled.isChecked() && ping >= 0) {
            allowed *= this.getLatencyFactorForPing(ping);
        }
        if (horizontalPerSecond <= allowed) {
            stats.speedViolationCount = 0;
            return;
        }
        ++stats.speedViolationCount;
        int allowedBurst = this.getBurstToleranceForPing(ping);
        if (stats.speedViolationCount < allowedBurst) {
            return;
        }
        if (this.tickCounter - stats.lastSpeedAlertTick < 200L) {
            return;
        }
        stats.lastSpeedAlertTick = this.tickCounter;
        this.sendAlert(player, String.format(Locale.ROOT, "suspected of speed (%.1f blocks/s) [allowed %.1f]", horizontalPerSecond, allowed));
        stats.speedViolationCount = 0;
    }

    private void updateFlightPattern(class_1657 player, PlayerStats stats, double dy) {
        double clearance = this.getClearanceAboveGround((class_1297)player, 16);
        if (!(player.method_24828() || player.method_5799() || player.method_5854() != null || player.method_6101())) {
            if (clearance >= this.flightClearanceThreshold.getValue()) {
                stats.sustainedAltitudeTicks = Math.min(stats.sustainedAltitudeTicks + 1, 1000);
            } else if (stats.sustainedAltitudeTicks > 0) {
                --stats.sustainedAltitudeTicks;
            }
            if (dy > this.flightAscendRate.getValue()) {
                stats.ascendedDistance += dy;
            } else if (dy < -0.05 && stats.ascendedDistance > 0.0) {
                stats.ascendedDistance = Math.max(0.0, stats.ascendedDistance + dy);
            }
        } else {
            stats.sustainedAltitudeTicks = 0;
            stats.ascendedDistance = 0.0;
        }
        stats.lastClearance = clearance;
    }

    private void checkFlight(class_1657 player, PlayerStats stats, double dy, double horizontalPerSecond) {
        boolean meetsPattern;
        boolean airborne;
        if (!this.detectFlight.isChecked()) {
            stats.airborneTicks = 0;
            return;
        }
        if (this.isUsingElytra(player)) {
            stats.airborneTicks = 0;
            return;
        }
        boolean bl = airborne = !player.method_24828() && !player.method_5799() && player.method_5854() == null && !player.method_6101() && !player.method_6059(class_1294.field_5906) && !player.method_6059(class_1294.field_5902);
        if (airborne) {
            ++stats.airborneTicks;
            stats.groundBufferTicks = 0;
        } else if (stats.airborneTicks > 0) {
            ++stats.groundBufferTicks;
            stats.airborneTicks = stats.groundBufferTicks <= 8 ? Math.max(0, stats.airborneTicks - 1) : 0;
        } else {
            stats.airborneTicks = 0;
            stats.groundBufferTicks = 0;
        }
        if ((double)stats.airborneTicks < this.flightAirTicks.getValue()) {
            return;
        }
        if (Math.abs(dy) > 0.08 && stats.sustainedAltitudeTicks < this.flightPatternTicks.getValueI()) {
            return;
        }
        boolean meetsHorizontal = horizontalPerSecond >= this.flightHorizontalSpeed.getValue();
        boolean bl2 = meetsPattern = stats.sustainedAltitudeTicks >= this.flightPatternTicks.getValueI() || stats.ascendedDistance >= this.flightAscendDistance.getValue();
        if (!meetsHorizontal && !meetsPattern) {
            return;
        }
        if (this.tickCounter - stats.lastFlightAlertTick < 200L) {
            return;
        }
        stats.lastFlightAlertTick = this.tickCounter;
        this.sendAlert(player, "suspected of flying");
    }

    private void checkBoatFly(class_1657 player, PlayerStats stats) {
        boolean meetsAltitude;
        if (!this.detectBoatFly.isChecked()) {
            stats.boatAirTicks = 0;
            return;
        }
        class_1297 vehicle = player.method_5854();
        if (!(vehicle instanceof class_1690)) {
            stats.boatAirTicks = 0;
            return;
        }
        class_1690 boat = (class_1690)vehicle;
        boolean supported = this.isBoatSupported(boat);
        if (!supported) {
            ++stats.boatAirTicks;
        } else {
            stats.boatAirTicks = 0;
            stats.boatAltitudeTicks = 0;
        }
        double clearance = this.getClearanceAboveGround((class_1297)boat, 16);
        if (!supported && clearance >= this.boatClearanceThreshold.getValue()) {
            stats.boatAltitudeTicks = Math.min(stats.boatAltitudeTicks + 1, 1000);
        } else if (stats.boatAltitudeTicks > 0) {
            --stats.boatAltitudeTicks;
        }
        if ((double)stats.boatAirTicks < this.boatAirTicks.getValue()) {
            return;
        }
        class_243 vel = boat.method_18798();
        double horizontalSpeed = Math.sqrt(vel.field_1352 * vel.field_1352 + vel.field_1350 * vel.field_1350);
        boolean meetsHorizontal = horizontalSpeed >= this.boatHorizontalSpeed.getValue();
        boolean bl = meetsAltitude = stats.boatAltitudeTicks >= this.boatPatternTicks.getValueI() || clearance >= this.boatClearanceThreshold.getValue();
        if (!meetsHorizontal && !meetsAltitude && Math.abs(vel.field_1351) < 0.05) {
            return;
        }
        if (this.tickCounter - stats.lastBoatAlertTick < 200L) {
            return;
        }
        stats.lastBoatAlertTick = this.tickCounter;
        this.sendAlert(player, "suspected of boat-flying");
    }

    private void checkAura(class_1657 player, PlayerStats stats) {
        if (!this.detectAura.isChecked()) {
            stats.swingTicks.clear();
            stats.swingIntervals.clear();
            stats.lastSwingTick = 0L;
            stats.lastSwingProgress = player.method_6055(1.0f);
            return;
        }
        float swingProgress = player.method_6055(1.0f);
        if (stats.lastSwingProgress > 0.6f && swingProgress < 0.2f) {
            stats.swingTicks.addLast(this.tickCounter);
            if (stats.lastSwingTick != 0L) {
                long interval = this.tickCounter - stats.lastSwingTick;
                stats.swingIntervals.addLast(interval);
                while (stats.swingIntervals.size() > 12) {
                    stats.swingIntervals.removeFirst();
                }
            }
            stats.lastSwingTick = this.tickCounter;
        }
        stats.lastSwingProgress = swingProgress;
        while (!stats.swingTicks.isEmpty() && this.tickCounter - stats.swingTicks.peekFirst() > 40L) {
            stats.swingTicks.removeFirst();
        }
        if (this.isUsingElytra(player)) {
            stats.swingTicks.clear();
            stats.swingIntervals.clear();
            stats.lastSwingTick = 0L;
            return;
        }
        if (stats.swingTicks.size() < 2) {
            return;
        }
        long first = stats.swingTicks.peekFirst();
        long last = stats.swingTicks.peekLast();
        long span = Math.max(1L, last - first);
        double swingsPerSecond = (double)(stats.swingTicks.size() - 1) * 20.0 / (double)span;
        if (stats.swingIntervals.size() >= 3) {
            double sum = 0.0;
            for (long interval : stats.swingIntervals) {
                sum += (double)interval;
            }
            if (sum > 0.0) {
                double average = sum / (double)stats.swingIntervals.size();
                double cpsFromIntervals = 20.0 / average;
                swingsPerSecond = Math.max(swingsPerSecond, cpsFromIntervals);
            }
        }
        if (swingsPerSecond <= this.auraThreshold.getValue()) {
            return;
        }
        if (this.tickCounter - stats.lastAuraAlertTick < 200L) {
            return;
        }
        stats.lastAuraAlertTick = this.tickCounter;
        this.sendAlert(player, String.format(Locale.ROOT, "suspected of killaura (%.1f swings/s)", swingsPerSecond));
    }

    private void sendAlert(class_1657 player, String reason) {
        String name = player.method_5477().getString();
        ChatUtils.message("CheatDetector: " + name + " " + reason);
    }

    private String formatDouble(double value) {
        return String.format(Locale.ROOT, "%.1f", value);
    }

    private int getPlayerPing(class_1657 player) {
        try {
            Object o;
            Method m2;
            class_634 handler = MC.method_1562();
            if (handler == null) {
                return -1;
            }
            class_640 entry = handler.method_2871(player.method_5667());
            if (entry == null) {
                return -1;
            }
            try {
                m2 = entry.getClass().getMethod("getLatency", new Class[0]);
                o = m2.invoke((Object)entry, new Object[0]);
                if (o instanceof Integer) {
                    return (Integer)o;
                }
                if (o instanceof Long) {
                    return ((Long)o).intValue();
                }
            }
            catch (NoSuchMethodException m2) {
                // empty catch block
            }
            try {
                m2 = entry.getClass().getMethod("getLatencyMs", new Class[0]);
                o = m2.invoke((Object)entry, new Object[0]);
                if (o instanceof Integer) {
                    return (Integer)o;
                }
                if (o instanceof Long) {
                    return ((Long)o).intValue();
                }
            }
            catch (NoSuchMethodException m3) {
                // empty catch block
            }
            try {
                Field f = entry.getClass().getDeclaredField("latency");
                f.setAccessible(true);
                o = f.get(entry);
                if (o instanceof Integer) {
                    return (Integer)o;
                }
                if (o instanceof Long) {
                    return ((Long)o).intValue();
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }

    private double getLatencyFactorForPing(int pingMs) {
        if (pingMs < 0) {
            return 1.0;
        }
        if (pingMs <= 50) {
            return this.latencyVeryLowFactor.getValue();
        }
        if (pingMs <= 100) {
            return this.latencyLowFactor.getValue();
        }
        if (pingMs <= 200) {
            return this.latencyMediumFactor.getValue();
        }
        if (pingMs <= 300) {
            return this.latencyHighFactor.getValue();
        }
        if (pingMs <= 500) {
            return this.latencyVeryHighFactor.getValue();
        }
        if (pingMs <= 750) {
            return this.latencyExtremeFactor.getValue();
        }
        if (pingMs <= 1000) {
            return this.latencyUltraFactor.getValue();
        }
        return this.latencyInsaneFactor.getValue();
    }

    private int getBurstToleranceForPing(int pingMs) {
        if (pingMs < 0) {
            return this.burstDefault.getValueI();
        }
        if (pingMs <= 50) {
            return this.burstVeryLow.getValueI();
        }
        if (pingMs <= 100) {
            return this.burstLow.getValueI();
        }
        if (pingMs <= 200) {
            return this.burstMedium.getValueI();
        }
        if (pingMs <= 300) {
            return this.burstHigh.getValueI();
        }
        if (pingMs <= 500) {
            return this.burstVeryHigh.getValueI();
        }
        if (pingMs <= 750) {
            return this.burstExtreme.getValueI();
        }
        if (pingMs <= 1000) {
            return this.burstUltra.getValueI();
        }
        return this.burstInsane.getValueI();
    }

    private double getClearanceAboveGround(class_1297 entity, int maxDepth) {
        class_638 world = (class_638)entity.method_73183();
        class_238 box = entity.method_5829();
        double entityBottom = box.field_1322;
        int minX = class_3532.method_15357((double)box.field_1323);
        int maxX = class_3532.method_15384((double)box.field_1320);
        int minZ = class_3532.method_15357((double)box.field_1321);
        int maxZ = class_3532.method_15384((double)box.field_1324);
        int maxY = class_3532.method_15357((double)entityBottom);
        int minY = Math.max(world.method_31607(), class_3532.method_15357((double)(entityBottom - (double)maxDepth)));
        for (int y = maxY; y >= minY; --y) {
            boolean foundSupport = false;
            for (int x = minX; x <= maxX && !foundSupport; ++x) {
                for (int z = minZ; z <= maxZ && !foundSupport; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    class_2680 state = world.method_8320(pos);
                    if (!state.method_26220((class_1922)world, pos).method_1110()) {
                        foundSupport = true;
                        continue;
                    }
                    class_3610 fluid = world.method_8316(pos);
                    if (fluid.method_15769() || !fluid.method_15767(class_3486.field_15517) && !fluid.method_15767(class_3486.field_15518)) continue;
                    foundSupport = true;
                }
            }
            if (!foundSupport) continue;
            double blockTop = (double)y + 1.0;
            return Math.max(0.0, entityBottom - blockTop);
        }
        return maxDepth;
    }

    private boolean isBoatSupported(class_1690 boat) {
        class_638 world = (class_638)boat.method_73183();
        class_238 box = boat.method_5829();
        double sampleMinY = box.field_1322 - 0.2;
        double sampleMaxY = box.field_1322 - 0.05;
        int minX = class_3532.method_15357((double)box.field_1323);
        int maxX = class_3532.method_15357((double)box.field_1320);
        int minY = class_3532.method_15357((double)sampleMinY);
        int maxY = class_3532.method_15357((double)sampleMaxY);
        int minZ = class_3532.method_15357((double)box.field_1321);
        int maxZ = class_3532.method_15357((double)box.field_1324);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    class_2680 state = world.method_8320(pos);
                    if (!state.method_26220((class_1922)world, pos).method_1110()) {
                        return true;
                    }
                    class_3610 fluid = world.method_8316(pos);
                    if (fluid.method_15769() || !fluid.method_15767(class_3486.field_15517)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isUsingElytra(class_1657 player) {
        if (player.method_6128()) {
            return true;
        }
        if (player.method_24828()) {
            return false;
        }
        class_1799 chest = player.method_6118(class_1304.field_6174);
        return !chest.method_7960() && chest.method_31574(class_1802.field_8833);
    }

    private static final class PlayerStats {
        private double lastX;
        private double lastY;
        private double lastZ;
        private boolean hasLastPosition;
        private int ignoreMovementTicks;
        private int airborneTicks;
        private int groundBufferTicks;
        private int boatAirTicks;
        private int boatAltitudeTicks;
        private int sustainedAltitudeTicks;
        private double ascendedDistance;
        private double lastClearance;
        private float lastSwingProgress;
        private final ArrayDeque<Long> swingTicks = new ArrayDeque();
        private final ArrayDeque<Long> swingIntervals = new ArrayDeque();
        private long lastSwingTick;
        private long lastSpeedAlertTick;
        private long lastFlightAlertTick;
        private long lastBoatAlertTick;
        private long lastAuraAlertTick;
        private int speedViolationCount;

        private PlayerStats() {
        }

        private void resetPosition(class_1657 player) {
            this.lastX = player.method_23317();
            this.lastY = player.method_23318();
            this.lastZ = player.method_23321();
            this.hasLastPosition = true;
            this.ignoreMovementTicks = 0;
            this.airborneTicks = 0;
            this.groundBufferTicks = 0;
            this.boatAirTicks = 0;
            this.boatAltitudeTicks = 0;
            this.sustainedAltitudeTicks = 0;
            this.ascendedDistance = 0.0;
            this.lastClearance = 0.0;
            this.swingTicks.clear();
            this.swingIntervals.clear();
            this.lastSwingTick = 0L;
            this.lastSwingProgress = player.method_6055(1.0f);
            this.speedViolationCount = 0;
        }
    }
}

