/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.util.Map;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.AboveGroundFilterManager;
import net.wurstclient.hack.CheckboxOverrideManager;
import net.wurstclient.hack.Hack;
import net.wurstclient.hack.HackList;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.ChatUtils;

@SearchTags(value={"global toggle", "render global toggle"})
public final class GlobalToggleHack
extends Hack
implements UpdateListener {
    private final CheckboxSetting stickyForceOn = new CheckboxSetting("Sticky area on", "Forces sticky area on for all supported hacks.", false);
    private final CheckboxSetting stickyForceOff = new CheckboxSetting("Sticky area off", "Forces sticky area off for all supported hacks.", false);
    private final CheckboxSetting yLimitForceOn = new CheckboxSetting("Y limit on", "Forces the above-ground filter on for all supported hacks.", false);
    private final CheckboxSetting yLimitForceOff = new CheckboxSetting("Y limit off", "Forces the above-ground filter off for all supported hacks.", false);
    private final SliderSetting yLimitValue = new SliderSetting("Global Y limit", 62.0, 0.0, 255.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private Map<CheckboxSetting, Boolean> stickySnapshot = Map.of();
    private Map<CheckboxSetting, Boolean> yLimitSnapshot = Map.of();
    private OverrideState lastStickyState = OverrideState.NONE;
    private OverrideState lastYState = OverrideState.NONE;
    private int lastYLimitValue = 62;
    private boolean stickyAnnouncementsReady;
    private boolean yLimitAnnouncementsReady;

    public GlobalToggleHack() {
        super("GlobalToggle");
        this.setCategory(Category.OTHER);
        this.addSetting(this.stickyForceOn);
        this.addSetting(this.stickyForceOff);
        this.addSetting(this.yLimitForceOn);
        this.addSetting(this.yLimitForceOff);
        this.addSetting(this.yLimitValue);
        this.lastYLimitValue = this.yLimitValue.getValueI();
        EVENTS.add(UpdateListener.class, this);
    }

    @Override
    protected void onEnable() {
        this.setEnabled(false);
    }

    @Override
    public void onUpdate() {
        HackList hacks = WURST.getHax();
        if (this.stickyForceOn.isChecked() && this.stickyForceOff.isChecked()) {
            if (this.lastStickyState == OverrideState.FORCE_ON) {
                this.stickyForceOff.setChecked(false);
            } else {
                this.stickyForceOn.setChecked(false);
            }
            this.stickyAnnouncementsReady = true;
            return;
        }
        OverrideState stickyState = this.getOverrideState(this.stickyForceOn, this.stickyForceOff);
        if (stickyState != this.lastStickyState) {
            if (this.lastStickyState != OverrideState.NONE) {
                CheckboxOverrideManager.restore(this.stickySnapshot);
            }
            if (stickyState == OverrideState.NONE) {
                this.stickySnapshot = Map.of();
                ChatUtils.message("Global sticky area override disabled.");
            } else {
                if (this.lastStickyState == OverrideState.NONE) {
                    this.stickySnapshot = CheckboxOverrideManager.capture(hacks, "stickyArea");
                }
                CheckboxOverrideManager.apply(hacks, "stickyArea", stickyState == OverrideState.FORCE_ON);
                if (this.stickyAnnouncementsReady) {
                    this.announceSticky(stickyState == OverrideState.FORCE_ON);
                }
            }
            this.lastStickyState = stickyState;
            this.stickyAnnouncementsReady = true;
        }
        if (this.yLimitForceOn.isChecked() && this.yLimitForceOff.isChecked()) {
            if (this.lastYState == OverrideState.FORCE_ON) {
                this.yLimitForceOff.setChecked(false);
            } else {
                this.yLimitForceOn.setChecked(false);
            }
            this.yLimitAnnouncementsReady = true;
            return;
        }
        OverrideState yState = this.getOverrideState(this.yLimitForceOn, this.yLimitForceOff);
        int yValue = this.yLimitValue.getValueI();
        if (yState != this.lastYState) {
            if (this.lastYState != OverrideState.NONE) {
                CheckboxOverrideManager.restore(this.yLimitSnapshot);
                if (this.lastYState == OverrideState.FORCE_ON) {
                    AboveGroundFilterManager.setY(hacks, this.lastYLimitValue);
                }
            } else {
                this.lastYLimitValue = yValue;
            }
            if (yState == OverrideState.NONE) {
                this.yLimitSnapshot = Map.of();
                ChatUtils.message("Global Y limit override disabled.");
            } else {
                if (this.lastYState == OverrideState.NONE) {
                    this.yLimitSnapshot = CheckboxOverrideManager.capture(hacks, "onlyAboveGround");
                }
                CheckboxOverrideManager.apply(hacks, "onlyAboveGround", yState == OverrideState.FORCE_ON);
                if (yState == OverrideState.FORCE_ON) {
                    AboveGroundFilterManager.setY(hacks, yValue);
                }
                if (this.yLimitAnnouncementsReady) {
                    this.announceYLimit(yState == OverrideState.FORCE_ON);
                }
            }
            this.lastYState = yState;
            this.yLimitAnnouncementsReady = true;
        }
        if (yState == OverrideState.FORCE_ON && yValue != this.lastYLimitValue) {
            AboveGroundFilterManager.setY(hacks, yValue);
            this.lastYLimitValue = yValue;
        } else if (yValue != this.lastYLimitValue) {
            this.lastYLimitValue = yValue;
        }
        if (!this.stickyAnnouncementsReady) {
            this.stickyAnnouncementsReady = true;
        }
        if (!this.yLimitAnnouncementsReady) {
            this.yLimitAnnouncementsReady = true;
        }
    }

    private void announceSticky(boolean forcingOn) {
        if (forcingOn) {
            ChatUtils.message("Global sticky area override forcing ON.");
        } else {
            ChatUtils.message("Global sticky area override forcing OFF.");
        }
    }

    private void announceYLimit(boolean forcingOn) {
        if (forcingOn) {
            ChatUtils.message("Global Y limit override forcing ON.");
        } else {
            ChatUtils.message("Global Y limit override forcing OFF.");
        }
    }

    private OverrideState getOverrideState(CheckboxSetting forceOn, CheckboxSetting forceOff) {
        if (forceOn.isChecked()) {
            return OverrideState.FORCE_ON;
        }
        if (forceOff.isChecked()) {
            return OverrideState.FORCE_OFF;
        }
        return OverrideState.NONE;
    }

    private static enum OverrideState {
        NONE,
        FORCE_ON,
        FORCE_OFF;

    }
}

