/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1533;
import net.minecraft.class_1542;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_7923;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.WurstClient;
import net.wurstclient.events.CameraTransformViewBobbingListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.hacks.itemhandler.ItemHandlerHack;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.EnumSetting;
import net.wurstclient.settings.EspBoxSizeSetting;
import net.wurstclient.settings.EspStyleSetting;
import net.wurstclient.settings.ItemListSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.settings.TextFieldSetting;
import net.wurstclient.util.EntityUtils;
import net.wurstclient.util.ItemUtils;
import net.wurstclient.util.RenderUtils;

@SearchTags(value={"item esp", "ItemTracers", "item tracers"})
public final class ItemEspHack
extends Hack
implements UpdateListener,
CameraTransformViewBobbingListener,
RenderListener {
    private static final int MAX_SPECIAL_TEXT_LENGTH = 256;
    private final EspStyleSetting style = new EspStyleSetting();
    private final EspBoxSizeSetting boxSize = new EspBoxSizeSetting("\u00a7lAccurate\u00a7r mode shows the exact hitbox of each item.\n\u00a7lFancy\u00a7r mode shows larger boxes that look better.");
    private final ColorSetting color = new ColorSetting("Color", "Items will be highlighted in this color.", Color.YELLOW);
    private final EnumSetting<SpecialMode> specialMode = new EnumSetting("Special mode", (Enum[])SpecialMode.values(), (Enum)SpecialMode.LIST);
    private final ItemListSetting specialList = new ItemListSetting("Special items", "Blocks/items to highlight with a different color.", "minecraft:player_head", "minecraft:skeleton_skull", "minecraft:wither_skeleton_skull", "minecraft:zombie_head", "minecraft:creeper_head", "minecraft:dragon_head", "minecraft:piglin_head");
    private final TextFieldSetting specialItemId = new TextFieldSetting("Item ID", "Exact item ID when Special mode is Item_ID.", "minecraft:player_head", v -> v.length() <= 256);
    private final TextFieldSetting specialQuery = new TextFieldSetting("Query", "Enter text to match item IDs or names by keyword. Separate multiple terms with commas.", "", v -> v.length() <= 256);
    private final CheckboxSetting specialRainbow = new CheckboxSetting("Special rainbow", "If enabled, selected items will cycle through rainbow colors.", false);
    private final ColorSetting specialColor = new ColorSetting("Special color", "Color for selected items when not using rainbow.", new Color(0xFF00FF));
    private final CheckboxSetting outlineOnly = new CheckboxSetting("Outline-only for special", "If enabled, selected items keep the normal box fill color and only the outline changes to the special color.", false);
    private final CheckboxSetting useIgnoredItems = new CheckboxSetting("Toggle ignoring items", "When enabled, items from the ignored list will not be highlighted.", false);
    private final ItemListSetting ignoredList = new ItemListSetting("Ignored items", "Blocks/items that should never be highlighted.", new String[0]);
    private final CheckboxSetting linesOnlyForSpecial = new CheckboxSetting("Lines only for special", "When enabled, tracers (lines) are drawn only for special items.", false);
    private final CheckboxSetting includeEquippedSpecial = new CheckboxSetting("Highlight equipped special", "Also highlight when a special item is held or worn on the head by a player/mob.", true);
    private final CheckboxSetting ignoreArmorStands = new CheckboxSetting("Ignore armor stands", "Won't highlight equipped special items on armor stands.", false);
    private final CheckboxSetting ignoreOtherPlayers = new CheckboxSetting("Ignore other players", "Won't highlight equipped special items on other players.", false);
    private final CheckboxSetting ignoreVillagers = new CheckboxSetting("Ignore villagers", "Won't highlight equipped special items on villagers.", false);
    private final EnumSetting<XpMode> xpMode = new EnumSetting("XP orb mode", (Enum[])XpMode.values(), (Enum)XpMode.NORMAL);
    private final CheckboxSetting includeItemFrames = new CheckboxSetting("Highlight frames with special", "Also highlight item frames if the item inside is special.", true);
    private final CheckboxSetting showCountInHackList = new CheckboxSetting("HackList count", "Appends the number of detected items to this hack's entry in the HackList.", false);
    private final ArrayList<class_1542> items = new ArrayList();
    private final ArrayList<class_1303> xpOrbs = new ArrayList();
    private final CheckboxSetting onlyAboveGround = new CheckboxSetting("Above ground only", "Only show items at or above the configured Y level.", false);
    private final SliderSetting aboveGroundY = new SliderSetting("Set ESP Y limit", 62.0, -65.0, 255.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private Set<String> specialExactIds;
    private String[] specialKeywords;
    private int lastSpecialListHash;
    private Set<String> ignoredExactIds;
    private int lastIgnoredListHash;
    private int foundCount;

    public ItemEspHack() {
        super("ItemESP");
        this.setCategory(Category.RENDER);
        this.addSetting(this.style);
        this.addSetting(this.boxSize);
        this.addSetting(this.color);
        this.addSetting(this.specialMode);
        this.addSetting(this.specialList);
        this.addSetting(this.specialItemId);
        this.addSetting(this.specialQuery);
        this.addSetting(this.specialRainbow);
        this.addSetting(this.specialColor);
        this.addSetting(this.outlineOnly);
        this.addSetting(this.xpMode);
        this.addSetting(this.useIgnoredItems);
        this.addSetting(this.ignoredList);
        this.addSetting(this.linesOnlyForSpecial);
        this.addSetting(this.includeEquippedSpecial);
        this.addSetting(this.ignoreArmorStands);
        this.addSetting(this.ignoreOtherPlayers);
        this.addSetting(this.ignoreVillagers);
        this.addSetting(this.includeItemFrames);
        this.addSetting(this.onlyAboveGround);
        this.addSetting(this.aboveGroundY);
        this.addSetting(this.showCountInHackList);
    }

    @Override
    protected void onEnable() {
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(CameraTransformViewBobbingListener.class, this);
        EVENTS.add(RenderListener.class, this);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(CameraTransformViewBobbingListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        this.foundCount = 0;
    }

    public boolean shouldUseIgnoredItems() {
        return this.useIgnoredItems.isChecked();
    }

    public ItemListSetting getIgnoredListSetting() {
        return this.ignoredList;
    }

    public boolean isIgnoredId(String id) {
        if (id == null) {
            return false;
        }
        for (String s : this.ignoredList.getItemNames()) {
            if (!id.equalsIgnoreCase(s.trim())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onUpdate() {
        this.items.clear();
        this.xpOrbs.clear();
        for (class_1297 entity : ItemEspHack.MC.field_1687.method_18112()) {
            if (entity instanceof class_1542) {
                class_1542 ie = (class_1542)entity;
                this.items.add(ie);
                continue;
            }
            if (!(entity instanceof class_1303)) continue;
            class_1303 xo = (class_1303)entity;
            this.xpOrbs.add(xo);
        }
        this.foundCount = Math.min(this.items.size() + this.xpOrbs.size(), 999);
    }

    @Override
    public void onCameraTransformViewBobbing(CameraTransformViewBobbingListener.CameraTransformViewBobbingEvent event) {
        if (this.style.hasLines()) {
            event.cancel();
        }
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        float[] rf;
        class_1799 stack;
        HashSet<String> exact;
        int h;
        int baseLines = this.color.getColorI(128);
        int baseQuads = this.color.getColorI(64);
        int specialLines = this.getSpecialARGB(128);
        int specialQuads = this.getSpecialARGB(64);
        if (this.specialMode.getSelected() == SpecialMode.LIST && ((h = this.specialList.getItemNames().hashCode()) != this.lastSpecialListHash || this.specialExactIds == null)) {
            this.lastSpecialListHash = h;
            exact = new HashSet<String>();
            ArrayList kw = new ArrayList();
            for (String s : this.specialList.getItemNames()) {
                String raw;
                if (s == null || (raw = s.trim()).isEmpty()) continue;
                class_2960 id = class_2960.method_12829((String)raw);
                if (id != null && class_7923.field_41178.method_10250(id)) {
                    exact.add(id.toString());
                    continue;
                }
                kw.add(raw.toLowerCase(Locale.ROOT));
            }
            this.specialExactIds = exact;
            this.specialKeywords = kw.toArray(new String[0]);
        }
        if (this.useIgnoredItems.isChecked()) {
            h = this.ignoredList.getItemNames().hashCode();
            if (h != this.lastIgnoredListHash || this.ignoredExactIds == null) {
                this.lastIgnoredListHash = h;
                exact = new HashSet();
                for (String s : this.ignoredList.getItemNames()) {
                    class_2960 id;
                    String raw;
                    if (s == null || (raw = s.trim()).isEmpty() || (id = class_2960.method_12829((String)raw)) == null || !class_7923.field_41178.method_10250(id)) continue;
                    exact.add(id.toString());
                }
                this.ignoredExactIds = exact;
            }
        } else {
            this.ignoredExactIds = null;
            this.lastIgnoredListHash = 0;
        }
        ArrayList<class_238> normalBoxes = new ArrayList<class_238>();
        ArrayList<class_238> specialBoxes = new ArrayList<class_238>();
        ArrayList<class_243> normalEnds = new ArrayList<class_243>();
        ArrayList<class_243> specialEnds = new ArrayList<class_243>();
        ArrayList<class_238> tracedBoxes = new ArrayList<class_238>();
        ArrayList<class_243> tracedEnds = new ArrayList<class_243>();
        double extraSize = this.boxSize.getExtraSize() / 2.0f;
        int visibleDrops = 0;
        for (class_1542 e : this.items) {
            if (this.onlyAboveGround.isChecked() && e.method_23318() < this.aboveGroundY.getValue() || (stack = e.method_6983()) == null || stack.method_7960() || this.isIgnored(stack)) continue;
            class_238 box = EntityUtils.getLerpedBox((class_1297)e, partialTicks).method_989(0.0, extraSize, 0.0).method_1014(extraSize);
            boolean isSpecial = this.isSpecial(stack);
            String id = ItemUtils.getStackId(stack);
            ItemHandlerHack ih = WurstClient.INSTANCE.getHax().itemHandlerHack;
            boolean isTraced = false;
            if (ih != null && id != null && !(isTraced = ih.isTraced(id)) && ItemUtils.isSyntheticXp(stack)) {
                int xp = ItemUtils.getXpAmount(stack);
                isTraced = ih.isTraced(id + ":xp:" + xp);
            }
            ++visibleDrops;
            if (isTraced) {
                tracedBoxes.add(box);
                tracedEnds.add(EntityUtils.getLerpedBox((class_1297)e, partialTicks).method_1005());
                continue;
            }
            if (isSpecial) {
                specialBoxes.add(box);
                specialEnds.add(EntityUtils.getLerpedBox((class_1297)e, partialTicks).method_1005());
                continue;
            }
            normalBoxes.add(box);
            normalEnds.add(EntityUtils.getLerpedBox((class_1297)e, partialTicks).method_1005());
        }
        this.foundCount = Math.min(visibleDrops, 999);
        block7: for (class_1303 orb : this.xpOrbs) {
            if (this.onlyAboveGround.isChecked() && orb.method_23318() < this.aboveGroundY.getValue() || this.isIgnored(stack = ItemUtils.createSyntheticXpStack(orb))) continue;
            class_243 center = EntityUtils.getLerpedBox((class_1297)orb, partialTicks).method_1005();
            class_238 box = this.smallBoxAt(center);
            XpMode mode = this.xpMode.getSelected();
            if (mode == XpMode.OFF) continue;
            String id = "minecraft:experience_orb";
            ItemHandlerHack ih = WurstClient.INSTANCE.getHax().itemHandlerHack;
            boolean isTraced = false;
            if (ih != null) {
                isTraced = ih.isTraced(id);
                int xp = ItemUtils.getXpAmount(stack);
                if (!isTraced) {
                    isTraced = ih.isTraced(id + ":xp:" + xp);
                }
            }
            ++visibleDrops;
            if (isTraced) {
                tracedBoxes.add(box);
                tracedEnds.add(center);
                continue;
            }
            switch (mode.ordinal()) {
                case 3: {
                    tracedBoxes.add(box);
                    tracedEnds.add(center);
                    continue block7;
                }
                case 2: {
                    specialBoxes.add(box);
                    specialEnds.add(center);
                    continue block7;
                }
            }
            normalBoxes.add(box);
            normalEnds.add(center);
        }
        if (this.includeItemFrames.isChecked()) {
            for (class_1297 ent : ItemEspHack.MC.field_1687.method_18112()) {
                class_1533 frame;
                class_1799 fs;
                if (!(ent instanceof class_1533) || (fs = (frame = (class_1533)ent).method_6940()) == null || fs.method_7960() || this.isIgnored(fs) || !this.isSpecial(fs) || this.onlyAboveGround.isChecked() && frame.method_23318() < this.aboveGroundY.getValue()) continue;
                class_238 fbox = EntityUtils.getLerpedBox((class_1297)frame, partialTicks).method_989(0.0, extraSize, 0.0).method_1014(extraSize);
                specialBoxes.add(fbox);
                specialEnds.add(fbox.method_1005());
            }
        }
        if (this.includeEquippedSpecial.isChecked()) {
            for (class_1297 ent : ItemEspHack.MC.field_1687.method_18112()) {
                class_243 hp;
                class_1799 head;
                class_1799 off;
                if (!(ent instanceof class_1309)) continue;
                class_1309 le = (class_1309)ent;
                if (this.ignoreArmorStands.isChecked() && le instanceof class_1531) continue;
                boolean isPlayer = le instanceof class_1657;
                if (this.ignoreVillagers.isChecked() && le instanceof class_1646 || this.ignoreOtherPlayers.isChecked() && isPlayer && le != ItemEspHack.MC.field_1724 || le == ItemEspHack.MC.field_1724) continue;
                class_1799 main = le.method_6047();
                if (main != null && !main.method_7960() && !this.isIgnored(main) && this.isSpecial(main)) {
                    class_243 pos = this.getHeldItemPos(le, class_1268.field_5808, partialTicks);
                    if (this.onlyAboveGround.isChecked() && pos != null && pos.field_1351 < this.aboveGroundY.getValue()) continue;
                    class_238 b = this.smallBoxAt(pos);
                    if (b != null) {
                        specialBoxes.add(b);
                        specialEnds.add(b.method_1005());
                    }
                }
                if ((off = le.method_6079()) != null && !off.method_7960() && !this.isIgnored(off) && this.isSpecial(off)) {
                    class_243 pos = this.getHeldItemPos(le, class_1268.field_5810, partialTicks);
                    if (this.onlyAboveGround.isChecked() && pos != null && pos.field_1351 < this.aboveGroundY.getValue()) continue;
                    class_238 b = this.smallBoxAt(pos);
                    if (b != null) {
                        specialBoxes.add(b);
                        specialEnds.add(b.method_1005());
                    }
                }
                if ((head = le.method_6118(class_1304.field_6169)) == null || head.method_7960() || this.isIgnored(head) || !this.isSpecial(head) || (hp = this.getHeadPos(le, partialTicks)) == null || this.onlyAboveGround.isChecked() && hp.field_1351 < this.aboveGroundY.getValue()) continue;
                class_238 b = this.smallBoxAt(hp);
                specialBoxes.add(b);
                specialEnds.add(hp);
            }
        }
        if (this.style.hasBoxes()) {
            if (!normalBoxes.isEmpty()) {
                RenderUtils.drawSolidBoxes(matrixStack, normalBoxes, baseQuads, false);
                RenderUtils.drawOutlinedBoxes(matrixStack, normalBoxes, baseLines, false);
            }
            if (!specialBoxes.isEmpty()) {
                if (this.outlineOnly.isChecked()) {
                    RenderUtils.drawSolidBoxes(matrixStack, specialBoxes, baseQuads, false);
                    RenderUtils.drawOutlinedBoxes(matrixStack, specialBoxes, specialLines, false);
                } else {
                    RenderUtils.drawSolidBoxes(matrixStack, specialBoxes, specialQuads, false);
                    RenderUtils.drawOutlinedBoxes(matrixStack, specialBoxes, specialLines, false);
                }
            }
            if (!tracedBoxes.isEmpty()) {
                rf = RenderUtils.getRainbowColor();
                int tracedLines = RenderUtils.toIntColor(rf, 0.5019608f);
                int tracedQuads = RenderUtils.toIntColor(rf, 0.4f);
                RenderUtils.drawSolidBoxes(matrixStack, tracedBoxes, tracedQuads, false);
                RenderUtils.drawOutlinedBoxes(matrixStack, tracedBoxes, tracedLines, false);
            }
        }
        if (this.style.hasLines()) {
            if (!this.linesOnlyForSpecial.isChecked() && !normalEnds.isEmpty()) {
                RenderUtils.drawTracers(matrixStack, partialTicks, normalEnds, baseLines, false);
            }
            if (!specialEnds.isEmpty()) {
                RenderUtils.drawTracers(matrixStack, partialTicks, specialEnds, specialLines, false);
            }
            if (!tracedEnds.isEmpty()) {
                rf = RenderUtils.getRainbowColor();
                int tracedLines = RenderUtils.toIntColor(rf, 0.5019608f);
                RenderUtils.drawTracers(matrixStack, partialTicks, tracedEnds, tracedLines, false);
            }
        }
    }

    private int getSpecialARGB(int alpha) {
        float[] rgb = this.specialRainbow.isChecked() ? RenderUtils.getRainbowColor() : this.specialColor.getColorF();
        return RenderUtils.toIntColor(rgb, (float)alpha / 255.0f);
    }

    public boolean rendersTracerLines() {
        return this.style.hasLines();
    }

    private boolean isIgnored(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        if (!this.useIgnoredItems.isChecked()) {
            return false;
        }
        if (this.ignoredExactIds == null || this.ignoredExactIds.isEmpty()) {
            return false;
        }
        String id = ItemUtils.getStackId(stack);
        if (id == null) {
            return false;
        }
        if (this.ignoredExactIds != null && this.ignoredExactIds.contains(id)) {
            return true;
        }
        for (String s : this.ignoredList.getItemNames()) {
            if (!id.equalsIgnoreCase(s.trim())) continue;
            return true;
        }
        return false;
    }

    private boolean isSpecial(class_1799 stack) {
        class_1792 item = stack.method_7909();
        String stackId = ItemUtils.getStackId(stack);
        switch (this.specialMode.getSelected().ordinal()) {
            case 0: {
                String id;
                String string = id = stackId != null ? stackId : class_7923.field_41178.method_10221((Object)item).toString();
                if (this.specialExactIds != null && this.specialExactIds.contains(id)) {
                    return true;
                }
                String localId = id.contains(":") ? id.substring(id.indexOf(":") + 1) : id;
                String localSpaced = localId.replace('_', ' ');
                String transKey = item.method_7876();
                String display = item.method_63680().getString();
                String stackDisplay = stack.method_7964().getString();
                if (this.specialKeywords != null) {
                    for (String term : this.specialKeywords) {
                        if (!this.containsNormalized(id, term) && !this.containsNormalized(localId, term) && !this.containsNormalized(localSpaced, term) && !this.containsNormalized(transKey, term) && !this.containsNormalized(display, term) && !this.containsNormalized(stackDisplay, term)) continue;
                        return true;
                    }
                }
                return false;
            }
            case 1: {
                if (stackId != null && this.specialItemId.getValue() != null && stackId.equalsIgnoreCase(this.specialItemId.getValue().trim())) {
                    return true;
                }
                return this.itemMatchesId(item, this.specialItemId.getValue());
            }
            case 2: {
                return this.itemOrStackMatchesQuery(item, stack, this.normalizeQuery(this.specialQuery.getValue()));
            }
        }
        return false;
    }

    private boolean itemMatchesId(class_1792 item, String idStr) {
        if (idStr == null || idStr.isBlank()) {
            return false;
        }
        try {
            class_2960 id = class_2960.method_60654((String)idStr.trim());
            class_1792 target = (class_1792)class_7923.field_41178.method_63535(id);
            return target != null && target == item;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private String normalizeQuery(String raw) {
        if (raw == null) {
            return "";
        }
        return raw.trim().toLowerCase(Locale.ROOT);
    }

    private boolean itemOrStackMatchesQuery(class_1792 item, class_1799 stack, String normalizedQuery) {
        if (normalizedQuery.isEmpty()) {
            return false;
        }
        String stackId = ItemUtils.getStackId(stack);
        String fullId = stackId != null ? stackId : class_7923.field_41178.method_10221((Object)item).toString();
        String localId = fullId.contains(":") ? fullId.substring(fullId.indexOf(":") + 1) : fullId;
        String localSpaced = localId.replace('_', ' ');
        String transKey = item.method_7876();
        String display = item.method_63680().getString();
        String stackDisplay = stack != null ? stack.method_7964().getString() : "";
        String[] terms = (String[])Arrays.stream(normalizedQuery.split(",")).map(String::trim).filter(s -> !s.isEmpty()).toArray(String[]::new);
        if (terms.length == 0) {
            terms = new String[]{normalizedQuery};
        }
        for (String term : terms) {
            if (!this.containsNormalized(fullId, term) && !this.containsNormalized(localId, term) && !this.containsNormalized(localSpaced, term) && !this.containsNormalized(transKey, term) && !this.containsNormalized(display, term) && !this.containsNormalized(stackDisplay, term)) continue;
            return true;
        }
        return false;
    }

    private boolean containsNormalized(String haystack, String needle) {
        return haystack != null && haystack.toLowerCase(Locale.ROOT).contains(needle);
    }

    private class_243 getHeldItemPos(class_1309 e, class_1268 hand, float partialTicks) {
        if (hand == null) {
            return null;
        }
        class_243 base = EntityUtils.getLerpedPos((class_1297)e, partialTicks);
        double yawRad = Math.toRadians(e.method_36454());
        class_1306 mainArm = class_1306.field_6183;
        if (e instanceof class_1657) {
            class_1657 pe = (class_1657)e;
            mainArm = pe.method_6068();
        }
        boolean rightSide = mainArm == class_1306.field_6183 && hand == class_1268.field_5808 || mainArm == class_1306.field_6182 && hand == class_1268.field_5810;
        double side = rightSide ? -1.0 : 1.0;
        double eyeH = e.method_18381(e.method_18376());
        double offX = Math.cos(yawRad) * 0.16 * side;
        double offY = eyeH - 0.1;
        double offZ = Math.sin(yawRad) * 0.16 * side;
        return base.method_1031(offX, offY, offZ);
    }

    private class_243 getHeadPos(class_1309 e, float partialTicks) {
        class_243 base = EntityUtils.getLerpedPos((class_1297)e, partialTicks);
        double eyeH = e.method_18381(e.method_18376());
        return base.method_1031(0.0, eyeH + 0.05, 0.0);
    }

    private class_238 smallBoxAt(class_243 c) {
        if (c == null) {
            return null;
        }
        double r = 0.18;
        return new class_238(c.field_1352 - r, c.field_1351 - r, c.field_1350 - r, c.field_1352 + r, c.field_1351 + r, c.field_1350 + r);
    }

    @Override
    public String getRenderName() {
        String base = this.getName();
        if (this.showCountInHackList.isChecked() && this.foundCount > 0) {
            return base + " [" + this.foundCount + "]";
        }
        return base;
    }

    private static enum SpecialMode {
        LIST,
        ITEM_ID,
        QUERY;

    }

    private static enum XpMode {
        OFF,
        NORMAL,
        SPECIAL,
        RAINBOW;

    }
}

