/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.awt.Color;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.events.CameraTransformViewBobbingListener;
import net.wurstclient.events.PacketInputListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.hacks.portalesp.LiquidEspBlockGroup;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ChunkAreaSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.EspStyleSetting;
import net.wurstclient.settings.Setting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.RotationUtils;
import net.wurstclient.util.chunk.ChunkSearcher;
import net.wurstclient.util.chunk.ChunkSearcherCoordinator;

@SearchTags(value={"lavaesp", "wateresp", "lava water", "LavaWaterESP"})
public final class LavaWaterEspHack
extends Hack
implements UpdateListener,
CameraTransformViewBobbingListener,
RenderListener {
    private final EspStyleSetting style = new EspStyleSetting();
    private final CheckboxSetting stickyArea = new CheckboxSetting("Sticky area", "Off: Re-centers every chunk to match ESP drop-off.\nOn: Keeps results anchored so you can path back to them.", false);
    private final ChunkAreaSetting area = new ChunkAreaSetting("Area", "The area around the player to search in.\nHigher values require a faster computer.", ChunkAreaSetting.ChunkArea.A3);
    private final LiquidEspBlockGroup lavaGroup = new LiquidEspBlockGroup(class_2246.field_10164, new ColorSetting("Lava color", "Lava will be highlighted in this color.", new Color(16747520)), new CheckboxSetting("Include lava", true));
    private final LiquidEspBlockGroup waterGroup = new LiquidEspBlockGroup(class_2246.field_10382, new ColorSetting("Water color", "Water will be highlighted in this color.", new Color(4159204)), new CheckboxSetting("Include water", true));
    private final List<LiquidEspBlockGroup> groups = Arrays.asList(this.lavaGroup, this.waterGroup);
    private final SliderSetting lavaAlpha = new SliderSetting("Lava transparency", "Transparency for lava (0 = fully transparent, 255 = opaque).", 64.0, 0.0, 255.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting waterAlpha = new SliderSetting("Water transparency", "Transparency for water (0 = fully transparent, 255 = opaque).", 64.0, 0.0, 255.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting renderAmount = new SliderSetting("Render amount", "Maximum number of blocks to render at once.", 100.0, 100.0, 1000.0, 10.0, SliderSetting.ValueDisplay.INTEGER);
    private final BiPredicate<class_2338, class_2680> query = (pos, state) -> this.isTargetBlock(state.method_26204());
    private final ChunkSearcherCoordinator coordinator = new ChunkSearcherCoordinator(this.query, this.area);
    private boolean groupsUpToDate;
    private ChunkAreaSetting.ChunkArea lastAreaSelection;
    private class_1923 lastPlayerChunk;
    private int lastMatchesVersion;

    public LavaWaterEspHack() {
        super("LavaWaterESP");
        this.setCategory(Category.RENDER);
        this.addSetting(this.style);
        this.groups.stream().flatMap(LiquidEspBlockGroup::getSettings).forEach(x$0 -> this.addSetting((Setting)x$0));
        this.addSetting(this.area);
        this.addSetting(this.stickyArea);
        this.addSetting(this.lavaAlpha);
        this.addSetting(this.waterAlpha);
        this.addSetting(this.renderAmount);
    }

    private boolean isTargetBlock(class_2248 b) {
        for (LiquidEspBlockGroup g : this.groups) {
            if (g.getBlock() != b) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void onEnable() {
        this.groupsUpToDate = false;
        this.lastAreaSelection = (ChunkAreaSetting.ChunkArea)((Object)this.area.getSelected());
        this.lastPlayerChunk = new class_1923(LavaWaterEspHack.MC.field_1724.method_24515());
        this.lastMatchesVersion = this.coordinator.getMatchesVersion();
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(CameraTransformViewBobbingListener.class, this);
        EVENTS.add(RenderListener.class, this);
        EVENTS.add(PacketInputListener.class, this.coordinator);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(CameraTransformViewBobbingListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        EVENTS.remove(PacketInputListener.class, this.coordinator);
        this.coordinator.reset();
        this.lastMatchesVersion = this.coordinator.getMatchesVersion();
        this.groups.forEach(LiquidEspBlockGroup::clear);
    }

    @Override
    public void onUpdate() {
        int matchesVersion;
        boolean searchersChanged;
        ChunkAreaSetting.ChunkArea currentArea = (ChunkAreaSetting.ChunkArea)((Object)this.area.getSelected());
        if (currentArea != this.lastAreaSelection) {
            this.lastAreaSelection = currentArea;
            this.coordinator.reset();
            this.groupsUpToDate = false;
        }
        class_1923 currentChunk = new class_1923(LavaWaterEspHack.MC.field_1724.method_24515());
        if (!this.stickyArea.isChecked() && !currentChunk.equals((Object)this.lastPlayerChunk)) {
            this.lastPlayerChunk = currentChunk;
            this.coordinator.reset();
            this.groupsUpToDate = false;
        }
        if (searchersChanged = this.coordinator.update()) {
            this.groupsUpToDate = false;
        }
        if ((matchesVersion = this.coordinator.getMatchesVersion()) != this.lastMatchesVersion) {
            this.lastMatchesVersion = matchesVersion;
            this.groupsUpToDate = false;
        }
        if (!this.groupsUpToDate && this.coordinator.isDone()) {
            this.updateGroupBoxes();
        }
    }

    @Override
    public void onCameraTransformViewBobbing(CameraTransformViewBobbingListener.CameraTransformViewBobbingEvent event) {
        if (((EspStyleSetting.EspStyle)((Object)this.style.getSelected())).hasLines()) {
            event.cancel();
        }
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        if (((EspStyleSetting.EspStyle)((Object)this.style.getSelected())).hasBoxes()) {
            this.renderBoxes(matrixStack);
        }
        if (((EspStyleSetting.EspStyle)((Object)this.style.getSelected())).hasLines()) {
            this.renderTracers(matrixStack, partialTicks);
        }
    }

    private void renderBoxes(class_4587 matrixStack) {
        for (LiquidEspBlockGroup group : this.groups) {
            if (!group.isEnabled()) continue;
            List<class_238> boxes = group.getBoxes();
            int alpha = group == this.lavaGroup ? this.lavaAlpha.getValueI() : this.waterAlpha.getValueI();
            int quadsColor = group.getColorI(alpha);
            int linesColor = group.getColorI(alpha);
            RenderUtils.drawSolidBoxes(matrixStack, boxes, quadsColor, false);
            RenderUtils.drawOutlinedBoxes(matrixStack, boxes, linesColor, false);
        }
    }

    private void renderTracers(class_4587 matrixStack, float partialTicks) {
        for (LiquidEspBlockGroup group : this.groups) {
            if (!group.isEnabled()) continue;
            List<class_238> boxes = group.getBoxes();
            List<class_243> ends = boxes.stream().map(class_238::method_1005).toList();
            int alpha = group == this.lavaGroup ? this.lavaAlpha.getValueI() : this.waterAlpha.getValueI();
            int color = group.getColorI(alpha);
            RenderUtils.drawTracers(matrixStack, partialTicks, ends, color, false);
        }
    }

    private void updateGroupBoxes() {
        this.groups.forEach(LiquidEspBlockGroup::clear);
        int limit = this.renderAmount.getValueI();
        List<ChunkSearcher.Result> matches = this.coordinator.getMatches().sorted(Comparator.comparingDouble(r -> r.pos().method_19770((class_2374)RotationUtils.getEyesPos()))).limit(limit).collect(Collectors.toList());
        matches.forEach(this::addToGroupBoxes);
        this.groupsUpToDate = true;
    }

    private void addToGroupBoxes(ChunkSearcher.Result result) {
        for (LiquidEspBlockGroup group : this.groups) {
            if (result.state().method_26204() != group.getBlock()) continue;
            group.add(result.pos());
            break;
        }
    }
}

