/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.awt.Color;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1678;
import net.minecraft.class_238;
import net.minecraft.class_4587;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.events.CameraTransformViewBobbingListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.EnumSetting;
import net.wurstclient.settings.EspBoxSizeSetting;
import net.wurstclient.settings.Setting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.settings.filterlists.EntityFilterList;
import net.wurstclient.settings.filters.AttackDetectingEntityFilter;
import net.wurstclient.settings.filters.FilterAllaysSetting;
import net.wurstclient.settings.filters.FilterArmorStandsSetting;
import net.wurstclient.settings.filters.FilterBatsSetting;
import net.wurstclient.settings.filters.FilterEndermenSetting;
import net.wurstclient.settings.filters.FilterGolemsSetting;
import net.wurstclient.settings.filters.FilterHostileSetting;
import net.wurstclient.settings.filters.FilterInvisibleSetting;
import net.wurstclient.settings.filters.FilterNamedSetting;
import net.wurstclient.settings.filters.FilterNeutralSetting;
import net.wurstclient.settings.filters.FilterPassiveSetting;
import net.wurstclient.settings.filters.FilterPassiveWaterSetting;
import net.wurstclient.settings.filters.FilterPetsSetting;
import net.wurstclient.settings.filters.FilterPiglinsSetting;
import net.wurstclient.settings.filters.FilterShulkersSetting;
import net.wurstclient.settings.filters.FilterSlimesSetting;
import net.wurstclient.settings.filters.FilterVillagersSetting;
import net.wurstclient.settings.filters.FilterZombiePiglinsSetting;
import net.wurstclient.settings.filters.FilterZombieVillagersSetting;
import net.wurstclient.util.EntityUtils;
import net.wurstclient.util.RenderUtils;

@SearchTags(value={"mob esp", "MobTracers", "mob tracers"})
public final class MobEspHack
extends Hack
implements UpdateListener,
CameraTransformViewBobbingListener,
RenderListener {
    private final MobEspStyleSetting style = new MobEspStyleSetting();
    private final EspBoxSizeSetting boxSize = new EspBoxSizeSetting("Box size", "\u00a7lAccurate\u00a7r mode shows the exact hitbox of each mob.\n\u00a7lFancy\u00a7r mode shows slightly larger boxes that look better.", EspBoxSizeSetting.BoxSize.ACCURATE);
    private final CheckboxSetting fillShapes = new CheckboxSetting("Fill shapes", "Render filled versions of the ESP shapes.", true);
    private final CheckboxSetting useRainbow = new CheckboxSetting("Rainbow colors", "Use a rainbow color instead of the fixed color.", false);
    private final ColorSetting color = new ColorSetting("Color", "Fixed color used when Rainbow colors is disabled.", Color.RED);
    private final EntityFilterList entityFilters = new EntityFilterList(FilterHostileSetting.genericVision(false), FilterNeutralSetting.genericVision(AttackDetectingEntityFilter.Mode.OFF), FilterPassiveSetting.genericVision(false), FilterPassiveWaterSetting.genericVision(false), FilterBatsSetting.genericVision(false), FilterSlimesSetting.genericVision(false), FilterPetsSetting.genericVision(false), FilterVillagersSetting.genericVision(false), FilterZombieVillagersSetting.genericVision(false), FilterGolemsSetting.genericVision(false), FilterPiglinsSetting.genericVision(AttackDetectingEntityFilter.Mode.OFF), FilterZombiePiglinsSetting.genericVision(AttackDetectingEntityFilter.Mode.OFF), FilterEndermenSetting.genericVision(AttackDetectingEntityFilter.Mode.OFF), FilterShulkersSetting.genericVision(false), FilterAllaysSetting.genericVision(false), FilterInvisibleSetting.genericVision(false), FilterNamedSetting.genericVision(false), FilterArmorStandsSetting.genericVision(true));
    private final ArrayList<class_1309> mobs = new ArrayList();
    private final ArrayList<class_1678> shulkerBullets = new ArrayList();
    private final CheckboxSetting showCountInHackList = new CheckboxSetting("HackList count", "Appends the number of detected mobs to this hack's entry in the HackList.", false);
    private final CheckboxSetting onlyAboveGround = new CheckboxSetting("Above ground only", "Only show mobs at or above the configured Y level.", false);
    private final SliderSetting aboveGroundY = new SliderSetting("Set ESP Y limit", 62.0, -65.0, 255.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final CheckboxSetting highlightShulkerProjectiles = new CheckboxSetting("Highlight shulker projectiles", "Also outline the tracking projectiles fired by shulkers.", false);
    private int foundCount;

    public MobEspHack() {
        super("MobESP");
        this.setCategory(Category.RENDER);
        this.addSetting(this.style);
        this.addSetting(this.boxSize);
        this.addSetting(this.fillShapes);
        this.addSetting(this.useRainbow);
        this.addSetting(this.color);
        this.entityFilters.forEach(x$0 -> this.addSetting((Setting)x$0));
        this.addSetting(this.onlyAboveGround);
        this.addSetting(this.aboveGroundY);
        this.addSetting(this.highlightShulkerProjectiles);
        this.addSetting(this.showCountInHackList);
    }

    @Override
    protected void onEnable() {
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(CameraTransformViewBobbingListener.class, this);
        EVENTS.add(RenderListener.class, this);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(CameraTransformViewBobbingListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        this.foundCount = 0;
        this.shulkerBullets.clear();
    }

    @Override
    public void onUpdate() {
        this.mobs.clear();
        this.shulkerBullets.clear();
        Stream<class_1309> stream = StreamSupport.stream(MobEspHack.MC.field_1687.method_18112().spliterator(), false).filter(class_1309.class::isInstance).map(e -> (class_1309)e).filter(e -> !(e instanceof class_1657)).filter(e -> !e.method_31481() && e.method_6032() > 0.0f);
        if (this.onlyAboveGround.isChecked()) {
            stream = stream.filter(e -> e.method_23318() >= this.aboveGroundY.getValue());
        }
        stream = this.entityFilters.applyTo(stream);
        this.mobs.addAll(stream.collect(Collectors.toList()));
        if (this.highlightShulkerProjectiles.isChecked()) {
            for (class_1297 entity : MobEspHack.MC.field_1687.method_18112()) {
                class_1678 bullet;
                if (!(entity instanceof class_1678) || (bullet = (class_1678)entity).method_31481()) continue;
                this.shulkerBullets.add(bullet);
            }
        }
        int highlighted = this.mobs.size();
        if (this.highlightShulkerProjectiles.isChecked()) {
            highlighted += this.shulkerBullets.size();
        }
        this.foundCount = Math.min(highlighted, 999);
    }

    @Override
    public String getRenderName() {
        String base = this.getName();
        if (this.showCountInHackList.isChecked() && this.foundCount > 0) {
            return base + " [" + this.foundCount + "]";
        }
        return base;
    }

    @Override
    public void onCameraTransformViewBobbing(CameraTransformViewBobbingListener.CameraTransformViewBobbingEvent event) {
        if (this.style.hasLines()) {
            event.cancel();
        }
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        ArrayList<RenderUtils.ColoredPoint> ends;
        MobEspStyleSetting.Shape shape = this.style.getShape();
        boolean glowMode = shape == MobEspStyleSetting.Shape.GLOW;
        boolean drawShape = !glowMode && shape != MobEspStyleSetting.Shape.NONE;
        boolean drawLines = this.style.hasLines();
        boolean drawFill = drawShape && this.fillShapes.isChecked();
        int anticipatedSize = this.mobs.size();
        if (this.highlightShulkerProjectiles.isChecked()) {
            anticipatedSize += this.shulkerBullets.size();
        }
        ArrayList<RenderUtils.ColoredBox> outlineShapes = drawShape ? new ArrayList<RenderUtils.ColoredBox>(anticipatedSize) : null;
        ArrayList<RenderUtils.ColoredBox> filledShapes = drawFill ? new ArrayList<RenderUtils.ColoredBox>(anticipatedSize) : null;
        ArrayList<RenderUtils.ColoredPoint> arrayList = ends = drawLines ? new ArrayList<RenderUtils.ColoredPoint>(anticipatedSize) : null;
        if (drawShape || drawLines) {
            int fillColor;
            class_238 box;
            int outlineColor;
            float[] rgb;
            class_238 lerpedBox;
            double extraSize = drawShape ? (double)this.boxSize.getExtraSize() / 2.0 : 0.0;
            for (class_1309 e : this.mobs) {
                lerpedBox = EntityUtils.getLerpedBox((class_1297)e, partialTicks);
                rgb = this.getColorRgb();
                outlineColor = RenderUtils.toIntColor(rgb, 0.5f);
                if (drawShape) {
                    box = lerpedBox.method_989(0.0, extraSize, 0.0).method_1014(extraSize);
                    outlineShapes.add(new RenderUtils.ColoredBox(box, outlineColor));
                    if (filledShapes != null) {
                        fillColor = RenderUtils.toIntColor(rgb, 0.15f);
                        filledShapes.add(new RenderUtils.ColoredBox(box, fillColor));
                    }
                }
                if (!drawLines || ends == null) continue;
                ends.add(new RenderUtils.ColoredPoint(lerpedBox.method_1005(), outlineColor));
            }
            if (this.highlightShulkerProjectiles.isChecked()) {
                for (class_1678 bullet : this.shulkerBullets) {
                    lerpedBox = EntityUtils.getLerpedBox((class_1297)bullet, partialTicks);
                    rgb = this.getColorRgb();
                    outlineColor = RenderUtils.toIntColor(rgb, 0.5f);
                    if (drawShape) {
                        box = lerpedBox.method_989(0.0, extraSize, 0.0).method_1014(extraSize);
                        outlineShapes.add(new RenderUtils.ColoredBox(box, outlineColor));
                        if (filledShapes != null) {
                            fillColor = RenderUtils.toIntColor(rgb, 0.15f);
                            filledShapes.add(new RenderUtils.ColoredBox(box, fillColor));
                        }
                    }
                    if (!drawLines || ends == null) continue;
                    ends.add(new RenderUtils.ColoredPoint(lerpedBox.method_1005(), outlineColor));
                }
            }
        }
        if (!glowMode) {
            if (filledShapes != null && !filledShapes.isEmpty()) {
                switch (shape.ordinal()) {
                    case 1: {
                        RenderUtils.drawSolidBoxes(matrixStack, filledShapes, false);
                        break;
                    }
                    case 2: {
                        RenderUtils.drawSolidOctahedrons(matrixStack, filledShapes, false);
                        break;
                    }
                }
            }
            if (outlineShapes != null && !outlineShapes.isEmpty()) {
                switch (shape.ordinal()) {
                    case 1: {
                        RenderUtils.drawOutlinedBoxes(matrixStack, outlineShapes, false);
                        break;
                    }
                    case 2: {
                        RenderUtils.drawOutlinedOctahedrons(matrixStack, outlineShapes, false);
                        break;
                    }
                }
            }
        }
        if (ends != null && !ends.isEmpty()) {
            RenderUtils.drawTracers(matrixStack, partialTicks, ends, false);
        }
        if (glowMode && this.highlightShulkerProjectiles.isChecked() && !this.shulkerBullets.isEmpty()) {
            this.renderShulkerProjectileFallback(matrixStack, partialTicks);
        }
    }

    private void renderShulkerProjectileFallback(class_4587 matrixStack, float partialTicks) {
        ArrayList<RenderUtils.ColoredBox> filledShapes = new ArrayList<RenderUtils.ColoredBox>(this.shulkerBullets.size());
        double extraSize = (double)this.boxSize.getExtraSize() / 2.0;
        int fillColor = RenderUtils.toIntColor(this.getColorRgb(), 0.35f);
        for (class_1678 bullet : this.shulkerBullets) {
            class_238 box = EntityUtils.getLerpedBox((class_1297)bullet, partialTicks).method_989(0.0, extraSize, 0.0).method_1014(extraSize);
            filledShapes.add(new RenderUtils.ColoredBox(box, fillColor));
        }
        RenderUtils.drawSolidBoxes(matrixStack, filledShapes, false);
    }

    private float[] getColorRgb() {
        if (this.useRainbow.isChecked()) {
            return RenderUtils.getRainbowColor();
        }
        return this.color.getColorF();
    }

    public Integer getGlowColor(class_1309 entity) {
        if (!this.isEnabled()) {
            return null;
        }
        if (this.style.getShape() != MobEspStyleSetting.Shape.GLOW) {
            return null;
        }
        if (!this.mobs.contains(entity)) {
            return null;
        }
        return RenderUtils.toIntColor(this.getColorRgb(), 1.0f);
    }

    private static final class MobEspStyleSetting
    extends EnumSetting<Style> {
        private MobEspStyleSetting() {
            super("Style", (Enum[])Style.values(), (Enum)Style.GLOW);
        }

        public Shape getShape() {
            return ((Style)((Object)this.getSelected())).shape;
        }

        public boolean hasLines() {
            return ((Style)((Object)this.getSelected())).lines;
        }

        private static enum Style {
            BOXES("Boxes only", Shape.BOX, false),
            OCTAHEDRONS("Octahedrons only", Shape.OCTAHEDRON, false),
            LINES("Lines only", Shape.NONE, true),
            LINES_AND_BOXES("Lines and boxes", Shape.BOX, true),
            LINES_AND_OCTAHEDRONS("Lines and octahedrons", Shape.OCTAHEDRON, true),
            GLOW("Glow only", Shape.GLOW, false),
            LINES_AND_GLOW("Lines and glow", Shape.GLOW, true);

            private final String name;
            private final Shape shape;
            private final boolean lines;

            private Style(String name, Shape shape, boolean lines) {
                this.name = name;
                this.shape = shape;
                this.lines = lines;
            }

            public String toString() {
                return this.name;
            }
        }

        static enum Shape {
            NONE,
            BOX,
            OCTAHEDRON,
            GLOW;

        }
    }
}

