/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import com.mojang.authlib.GameProfile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import net.minecraft.class_412;
import net.minecraft.class_437;
import net.minecraft.class_4844;
import net.minecraft.class_639;
import net.minecraft.class_640;
import net.minecraft.class_642;
import net.minecraft.class_746;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.altmanager.AltManager;
import net.wurstclient.altmanager.CrackedAlt;
import net.wurstclient.altmanager.LoginManager;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.ButtonSetting;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.StringDropdownSetting;
import net.wurstclient.settings.TextFieldSetting;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.LastServerRememberer;
import net.wurstclient.util.text.WText;

@SearchTags(value={"offlinesettings", "offline reconnect", "random name", "instant reconnect"})
public final class OfflineSettingsHack
extends Hack
implements UpdateListener {
    private static final String LOGIN_REASON = "You logged in from another location";
    private static final String NAME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final int LOGOUT_PROBE_CONNECT_TIMEOUT_MS = 5000;
    private static final int LOGOUT_PROBE_READ_TIMEOUT_MS = 5000;
    private static final int LOGOUT_PROBE_DURATION_MS = 10000;
    private static final long AUTO_LOGOUT_COOLDOWN_MS = 5000L;
    private static final Method PROFILE_NAME_METHOD = OfflineSettingsHack.discoverProfileNameMethod();
    private static final Method PROFILE_ID_METHOD = OfflineSettingsHack.discoverProfileIdMethod();
    private final CheckboxSetting autoReconnect = new CheckboxSetting("Quick reconnect", WText.literal("Immediately reconnect when you are kicked for logging in elsewhere."), true);
    private final CheckboxSetting autoLogout = new CheckboxSetting("Auto logout", WText.literal("Automatically re-run the logout probe whenever the selected player rejoins."), false);
    private final CheckboxSetting randomName = new CheckboxSetting("Random name on reconnect", WText.literal("Generate a temporary, random offline name (\u2264 8 chars) before reconnecting."), false);
    private final CheckboxSetting crackedDetection = new CheckboxSetting("Cracked server detection", WText.literal("Detect cracked servers and announce them in chat."), true){

        @Override
        public void update() {
            super.update();
            OfflineSettingsHack.this.updateCrackedDetectionSubscription();
        }
    };
    private final TextFieldSetting specifiedName = new TextFieldSetting("Specified name", WText.literal("Force reconnects to use this offline name."), "", s -> s.isEmpty() || OfflineSettingsHack.isValidOfflineNameFormat(s));
    private final StringDropdownSetting otherPlayerName = new StringDropdownSetting("Player select", WText.literal("Pick another player's name from the last server."));
    private final ButtonSetting logoutButton = new ButtonSetting("Logout other player", WText.literal("Attempt to log in as the selected player in a background probe."), this::startLogoutProbe);
    private final ButtonSetting reconnectButton = new ButtonSetting("Reconnect to server", WText.literal("Reconnect with the chosen, specified, or random name."), this::reconnectWithSelectedName);
    private final TextFieldSetting reconnectCommand = new TextFieldSetting("Reconnect command", WText.literal("Command to send immediately after reconnecting (optional)."), "", s -> true);
    private final ButtonSetting reconnectCommandButton = new ButtonSetting("Reconnect & run command", WText.literal("Reconnect and run the command once chat is available."), this::reconnectAndRunCommand);
    private final Random random = new Random();
    private CrackedAlt trackedAlt;
    private int playerListTicks;
    private final AtomicBoolean autoReconnectInProgress = new AtomicBoolean(false);
    private final AtomicBoolean autoReconnectRequested = new AtomicBoolean(false);
    private final AtomicBoolean logoutProbeRunning = new AtomicBoolean(false);
    private volatile class_642 pendingServer;
    private volatile boolean pendingForceRandom;
    private volatile boolean pendingAllowRandomFallback;
    private volatile String pendingReconnectCommand;
    private int reconnectCommandDelayTicks;
    private final UpdateListener crackedDetectionUpdate = this::runCrackedDetectionUpdate;
    private boolean crackedDetectionRegistered;
    private int crackedDetectionTicks;
    private volatile long autoLogoutLastAttempt;
    private volatile String autoLogoutTarget;
    private volatile boolean autoLogoutWaitingForLeave;
    private final Map<String, Boolean> crackedServers = new ConcurrentHashMap<String, Boolean>();
    private final Set<String> announcedCrackedServers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final UpdateListener reconnectCommandRunner = new UpdateListener(){

        @Override
        public void onUpdate() {
            OfflineSettingsHack.this.tryRunPendingReconnectCommand();
        }
    };
    private boolean reconnectCommandRunnerRegistered;

    public static boolean isValidOfflineNameFormat(String name) {
        if (name == null) {
            return false;
        }
        return name.length() <= 16 && name.matches("[A-Za-z0-9_]+");
    }

    private static Method discoverProfileNameMethod() {
        try {
            Class<?> profileClass = Class.forName("com.mojang.authlib.GameProfile");
            Method method = profileClass.getMethod("getName", new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Method discoverProfileIdMethod() {
        try {
            Class<?> profileClass = Class.forName("com.mojang.authlib.GameProfile");
            Method method = profileClass.getMethod("getId", new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public OfflineSettingsHack() {
        super("OfflineSettings");
        this.setCategory(Category.OTHER);
        this.addSetting(this.crackedDetection);
        this.addSetting(this.autoReconnect);
        this.addSetting(this.randomName);
        this.addSetting(this.specifiedName);
        this.addSetting(this.otherPlayerName);
        this.addSetting(this.autoLogout);
        this.addSetting(this.reconnectCommand);
        this.addSetting(this.reconnectCommandButton);
        this.addSetting(this.reconnectButton);
        this.addSetting(this.logoutButton);
        this.updateCrackedDetectionSubscription();
    }

    public boolean isAutoReconnectEnabled() {
        return this.autoReconnect.isChecked();
    }

    public void toggleAutoReconnect() {
        this.autoReconnect.setChecked(!this.autoReconnect.isChecked());
        if (this.autoReconnect.isChecked()) {
            this.reconnectWithSelectedName();
        }
    }

    public void setAutoReconnectEnabled(boolean enabled) {
        this.autoReconnect.setChecked(enabled);
    }

    @Override
    protected void onEnable() {
        EVENTS.add(UpdateListener.class, this);
        this.updateCrackedDetectionSubscription();
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        this.unregisterReconnectCommandRunner();
        this.cleanupTemporaryAlt();
        this.pendingReconnectCommand = null;
        this.reconnectCommandDelayTicks = 0;
        this.clearAutoLogoutState();
        this.updateCrackedDetectionSubscription();
    }

    public void handleDisconnect(class_2561 reason) {
        boolean preferRandom;
        class_310 client = class_310.method_1551();
        if (client == null || !this.isEnabled()) {
            this.cleanupTemporaryAlt();
            this.autoReconnectRequested.set(false);
            this.pendingServer = null;
            return;
        }
        this.captureOnlinePlayers(client);
        if (!this.shouldReconnect(reason)) {
            this.cleanupTemporaryAlt();
            this.autoReconnectRequested.set(false);
            this.pendingServer = null;
            return;
        }
        class_642 lastServer = LastServerRememberer.getLastServer();
        if (lastServer == null) {
            lastServer = client.method_1558();
        }
        if (lastServer == null) {
            return;
        }
        this.pendingServer = lastServer;
        this.pendingForceRandom = preferRandom = this.randomName.isChecked();
        this.pendingAllowRandomFallback = preferRandom;
        this.autoReconnectRequested.set(true);
    }

    public boolean consumeAutoReconnectRequest() {
        return this.autoReconnectRequested.getAndSet(false);
    }

    public void performAutoReconnect(class_437 prevScreen) {
        class_310 client = class_310.method_1551();
        class_642 server = this.pendingServer;
        if (server == null) {
            server = LastServerRememberer.getLastServer();
        }
        if (server == null || client == null) {
            return;
        }
        class_642 targetServer = server;
        boolean forceRandom = this.pendingForceRandom;
        boolean allowRandom = this.pendingAllowRandomFallback;
        this.pendingServer = null;
        class_437 resolvedPrev = this.resolvePrevScreen(prevScreen, client);
        if (resolvedPrev == null) {
            resolvedPrev = client != null ? client.field_1755 : null;
        }
        class_437 prev = resolvedPrev;
        if (!this.autoReconnectInProgress.compareAndSet(false, true)) {
            return;
        }
        client.execute(() -> {
            try {
                this.reconnect(client, prev, targetServer, forceRandom, allowRandom);
            }
            finally {
                this.autoReconnectInProgress.set(false);
            }
        });
    }

    public void reconnectWithRandomName() {
        this.reconnectWithRandomName(null);
    }

    public void reconnectWithRandomName(class_437 prevScreen) {
        class_642 lastServer = LastServerRememberer.getLastServer();
        class_310 client = class_310.method_1551();
        if (lastServer == null || client == null) {
            return;
        }
        class_437 prev = this.resolvePrevScreen(prevScreen, client);
        client.execute(() -> this.reconnect(client, prev, lastServer, true, true));
    }

    public void reconnectWithSelectedName() {
        this.reconnectWithSelectedName(null);
    }

    public void reconnectWithSelectedName(class_437 prevScreen) {
        class_642 lastServer = LastServerRememberer.getLastServer();
        class_310 client = class_310.method_1551();
        if (lastServer == null || client == null) {
            return;
        }
        boolean allowRandom = this.randomName.isChecked();
        class_437 prev = this.resolvePrevScreen(prevScreen, client);
        client.execute(() -> this.reconnect(client, prev, lastServer, false, allowRandom));
    }

    @Override
    public void onUpdate() {
        this.tryRunPendingReconnectCommand();
        if (this.playerListTicks-- > 0) {
            return;
        }
        this.playerListTicks = 40;
        this.captureOnlinePlayers(class_310.method_1551());
    }

    private boolean shouldReconnect(class_2561 reason) {
        if (reason == null || !this.autoReconnect.isChecked()) {
            return false;
        }
        String text = class_3544.method_15440((String)reason.getString()).trim();
        return text.contains(LOGIN_REASON);
    }

    private void reconnect(class_310 client, class_437 prevScreen, class_642 server, boolean forceRandomName, boolean allowRandomFallback) {
        String nameToUse = forceRandomName ? this.generateRandomName() : this.determineName(allowRandomFallback);
        if (nameToUse != null) {
            this.applyName(nameToUse);
        } else {
            this.cleanupTemporaryAlt();
        }
        this.startConnection(client, prevScreen, server);
    }

    public void reconnectWithCustomName(String name) {
        this.reconnectWithCustomName(name, null);
    }

    public void reconnectWithCustomName(String name, class_437 prevScreen) {
        if (name == null) {
            return;
        }
        String trimmed = name.trim();
        if (trimmed.isEmpty() || !OfflineSettingsHack.isValidOfflineNameFormat(trimmed)) {
            return;
        }
        class_642 lastServer = LastServerRememberer.getLastServer();
        class_310 client = class_310.method_1551();
        if (lastServer == null || client == null) {
            return;
        }
        class_437 prev = this.resolvePrevScreen(prevScreen, client);
        client.execute(() -> this.reconnectWithProvidedName(client, prev, lastServer, trimmed));
    }

    private void reconnectWithProvidedName(class_310 client, class_437 prevScreen, class_642 server, String providedName) {
        this.applyName(providedName);
        this.startConnection(client, prevScreen, server);
    }

    private class_437 resolvePrevScreen(class_437 requested, class_310 client) {
        if (requested != null) {
            return requested;
        }
        return client != null ? client.field_1755 : null;
    }

    private void startConnection(class_310 client, class_437 prevScreen, class_642 server) {
        class_639 address = class_639.method_2950((String)server.field_3761);
        class_437 previous = this.resolvePrevScreen(prevScreen, client);
        class_412.method_36877((class_437)previous, (class_310)client, (class_639)address, (class_642)server, (boolean)false, null);
    }

    private String determineName(boolean allowRandomFallback) {
        String selectedPlayer = this.otherPlayerName.getSelected();
        if (selectedPlayer != null && !selectedPlayer.isEmpty()) {
            return selectedPlayer;
        }
        String customName = this.specifiedName.getValue();
        if (customName != null && !customName.isBlank()) {
            return customName;
        }
        if (allowRandomFallback && this.randomName.isChecked()) {
            return this.generateRandomName();
        }
        return null;
    }

    private void applyName(String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        this.cleanupTemporaryAlt();
        AltManager altManager = WURST.getAltManager();
        if (!altManager.contains(name)) {
            CrackedAlt alt = new CrackedAlt(name);
            altManager.add(alt);
            this.trackedAlt = alt;
        }
        LoginManager.changeCrackedName(name);
    }

    private String generateRandomName() {
        int length = this.random.nextInt(8) + 1;
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append(NAME_CHARS.charAt(this.random.nextInt(NAME_CHARS.length())));
        }
        return builder.toString();
    }

    private void cleanupTemporaryAlt() {
        if (this.trackedAlt == null) {
            return;
        }
        WURST.getAltManager().remove(this.trackedAlt);
        this.trackedAlt = null;
    }

    private void captureOnlinePlayers(class_310 client) {
        if (client == null) {
            return;
        }
        class_746 player = client.field_1724;
        if (player == null || player.field_3944 == null) {
            return;
        }
        LinkedHashSet<String> players = new LinkedHashSet<String>();
        String self = client.method_1548() != null ? client.method_1548().method_1676() : "";
        class_642 server = this.getCurrentOrLastServer();
        for (class_640 entry : player.field_3944.method_2880()) {
            String name = class_3544.method_15440((String)OfflineSettingsHack.extractProfileName(entry.method_2966()));
            if (name.isEmpty() || name.equalsIgnoreCase(self)) continue;
            players.add(name);
        }
        if (player != null) {
            this.detectCrackedServerFromPlayerList(player, server);
            this.detectCrackedServerFromSelf(player, server);
        }
        LinkedHashSet<String> dropdownOptions = new LinkedHashSet<String>(players);
        String selected = this.otherPlayerName.getSelected();
        if (selected != null && !selected.isEmpty() && !this.containsIgnoreCase(dropdownOptions, selected)) {
            dropdownOptions.add(selected);
        }
        this.otherPlayerName.setOptions(dropdownOptions);
        this.checkAutoLogout(players, server);
    }

    public List<String> getCapturedPlayerNames() {
        return this.otherPlayerName.getValues().stream().filter(name -> name != null && !name.trim().isEmpty()).collect(Collectors.toList());
    }

    private void checkAutoLogout(Set<String> players, class_642 server) {
        boolean isOnline;
        if (!this.autoLogout.isChecked()) {
            this.clearAutoLogoutState();
            return;
        }
        String selected = this.otherPlayerName.getSelected();
        if (selected == null || selected.isEmpty()) {
            this.clearAutoLogoutState();
            return;
        }
        if (this.autoLogoutTarget == null || !this.autoLogoutTarget.equalsIgnoreCase(selected)) {
            this.autoLogoutTarget = selected;
            this.autoLogoutLastAttempt = 0L;
            this.autoLogoutWaitingForLeave = false;
        }
        boolean bl = isOnline = server != null && this.containsIgnoreCase(players, selected);
        if (!isOnline) {
            this.autoLogoutWaitingForLeave = false;
            this.autoLogoutLastAttempt = 0L;
            return;
        }
        if (this.autoLogoutWaitingForLeave) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.autoLogoutLastAttempt < 5000L) {
            return;
        }
        if (this.triggerLogoutProbe(selected, server, true, true)) {
            this.autoLogoutLastAttempt = now;
            this.autoLogoutWaitingForLeave = true;
        }
    }

    private void clearAutoLogoutState() {
        this.autoLogoutTarget = null;
        this.autoLogoutLastAttempt = 0L;
        this.autoLogoutWaitingForLeave = false;
    }

    private boolean containsIgnoreCase(Iterable<String> names, String target) {
        if (names == null || target == null) {
            return false;
        }
        for (String name : names) {
            if (!name.equalsIgnoreCase(target)) continue;
            return true;
        }
        return false;
    }

    private void detectCrackedServerFromPlayerList(class_746 player, class_642 server) {
        if (player == null || player.field_3944 == null || !this.crackedDetection.isChecked()) {
            return;
        }
        if (server == null) {
            return;
        }
        for (class_640 entry : player.field_3944.method_2880()) {
            UUID uuid;
            String name;
            GameProfile profile = entry.method_2966();
            if (profile == null || (name = OfflineSettingsHack.extractProfileName(profile)).isEmpty() || (uuid = OfflineSettingsHack.extractProfileUuid(profile)) == null || !class_4844.method_43344((String)name).equals(uuid)) continue;
            this.markServerCracked(server, "player " + name + " uses offline UUID");
            break;
        }
    }

    private void detectCrackedServerFromSelf(class_746 player, class_642 server) {
        if (player == null || server == null || !this.crackedDetection.isChecked()) {
            return;
        }
        UUID actualUuid = player.method_5667();
        if (actualUuid == null) {
            return;
        }
        String name = player.method_5477().getString();
        if (name == null || name.isBlank()) {
            return;
        }
        UUID offlineUuid = class_4844.method_43344((String)name.trim());
        if (actualUuid.equals(offlineUuid)) {
            this.markServerCracked(server, "your session uses offline UUID");
        }
    }

    private static String extractProfileName(Object profile) {
        String marker;
        String asString;
        int index;
        if (profile == null) {
            return "";
        }
        if (PROFILE_NAME_METHOD != null) {
            try {
                return (String)PROFILE_NAME_METHOD.invoke(profile, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((index = (asString = profile.toString()).indexOf(marker = "name=")) >= 0) {
            int start = index + marker.length();
            int end = asString.indexOf(44, start);
            if (end < 0) {
                end = asString.length();
            }
            return asString.substring(start, end).trim();
        }
        return asString;
    }

    private static UUID extractProfileUuid(Object profile) {
        String marker;
        String asString;
        int index;
        if (profile == null) {
            return null;
        }
        if (PROFILE_ID_METHOD != null) {
            try {
                return (UUID)PROFILE_ID_METHOD.invoke(profile, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((index = (asString = profile.toString()).indexOf(marker = "id=")) >= 0) {
            int start = index + marker.length();
            int end = asString.indexOf(44, start);
            if (end < 0) {
                end = asString.length();
            }
            try {
                return UUID.fromString(asString.substring(start, end).trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private void tryRunPendingReconnectCommand() {
        String command = this.pendingReconnectCommand;
        if (command == null || command.isEmpty()) {
            this.unregisterReconnectCommandRunner();
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null || client.method_1562() == null) {
            return;
        }
        class_746 player = client.field_1724;
        if (player == null || player.field_6012 < 5) {
            return;
        }
        if (this.reconnectCommandDelayTicks-- > 0) {
            return;
        }
        if (command.startsWith("/")) {
            client.method_1562().method_45730(command.substring(1));
        } else {
            client.method_1562().method_45729(command);
        }
        ChatUtils.message("[OfflineSettings] Ran reconnect command: " + command);
        this.pendingReconnectCommand = null;
        this.reconnectCommandDelayTicks = 0;
        this.unregisterReconnectCommandRunner();
    }

    public void reconnectAndRunCommand() {
        this.reconnectAndRunCommand(null);
    }

    public void reconnectAndRunCommand(class_437 prevScreen) {
        String command = this.reconnectCommand.getValue().trim();
        if (command.isEmpty()) {
            ChatUtils.error("OfflineSettings: command cannot be empty.");
            return;
        }
        this.queueReconnectCommand(command);
        this.reconnectWithSelectedName(prevScreen);
    }

    public void queueReconnectCommand(String command) {
        String trimmed = command.trim();
        if (trimmed.isEmpty()) {
            return;
        }
        this.pendingReconnectCommand = trimmed;
        this.reconnectCommandDelayTicks = 40;
        ChatUtils.message("[OfflineSettings] Queued reconnect command: " + trimmed);
        this.registerReconnectCommandRunner();
    }

    private void registerReconnectCommandRunner() {
        if (this.reconnectCommandRunnerRegistered) {
            return;
        }
        EVENTS.add(UpdateListener.class, this.reconnectCommandRunner);
        this.reconnectCommandRunnerRegistered = true;
    }

    private void unregisterReconnectCommandRunner() {
        if (!this.reconnectCommandRunnerRegistered) {
            return;
        }
        EVENTS.remove(UpdateListener.class, this.reconnectCommandRunner);
        this.reconnectCommandRunnerRegistered = false;
    }

    public boolean wasLastServerCracked() {
        class_642 last = LastServerRememberer.getLastServer();
        if (last == null) {
            return false;
        }
        String key = this.serverKey(last);
        if (key.isEmpty()) {
            return false;
        }
        return this.crackedServers.getOrDefault(key, Boolean.FALSE);
    }

    public void recordHandshakeEncryption(boolean encryptionUsed) {
        if (encryptionUsed || !this.crackedDetection.isChecked()) {
            return;
        }
        class_642 server = this.getCurrentOrLastServer();
        if (server == null) {
            return;
        }
        this.markServerCracked(server, "login skipped encryption");
    }

    private class_642 getCurrentOrLastServer() {
        class_310 client = class_310.method_1551();
        if (client != null && client.method_1558() != null) {
            return client.method_1558();
        }
        return LastServerRememberer.getLastServer();
    }

    private String serverKey(class_642 server) {
        if (server == null || server.field_3761 == null) {
            return "";
        }
        return server.field_3761.trim().toLowerCase(Locale.ROOT);
    }

    private void markServerCracked(class_642 server, String reason) {
        if (server == null || reason == null || reason.isEmpty()) {
            return;
        }
        String key = this.serverKey(server);
        if (key.isEmpty()) {
            return;
        }
        Boolean previous = this.crackedServers.put(key, Boolean.TRUE);
        boolean already = previous != null && previous != false;
        String announceKey = key;
        if (!already && this.crackedDetection.isChecked() && this.announcedCrackedServers.add(announceKey)) {
            class_310 client = class_310.method_1551();
            Runnable messageTask = () -> ChatUtils.message("[OfflineSettings] Detected cracked server: " + server.field_3761 + " (" + reason + ").");
            if (client != null) {
                client.execute(messageTask);
            } else {
                messageTask.run();
            }
        }
    }

    private void runCrackedDetectionUpdate() {
        if (this.isEnabled() || !this.crackedDetection.isChecked()) {
            return;
        }
        if (this.crackedDetectionTicks-- > 0) {
            return;
        }
        this.crackedDetectionTicks = 40;
        this.captureOnlinePlayers(class_310.method_1551());
    }

    private void updateCrackedDetectionSubscription() {
        boolean shouldListen;
        boolean bl = shouldListen = this.crackedDetection.isChecked() && !this.isEnabled();
        if (shouldListen == this.crackedDetectionRegistered) {
            return;
        }
        if (shouldListen) {
            EVENTS.add(UpdateListener.class, this.crackedDetectionUpdate);
            this.crackedDetectionRegistered = true;
            this.crackedDetectionTicks = 0;
        } else {
            EVENTS.remove(UpdateListener.class, this.crackedDetectionUpdate);
            this.crackedDetectionRegistered = false;
        }
    }

    private void startLogoutProbe() {
        this.triggerLogoutProbe(this.otherPlayerName.getSelected(), null, false, false);
    }

    private void runLogoutProbe(String host, int port, String username) {
        try (Socket socket = new Socket();){
            byte[] body;
            socket.connect(new InetSocketAddress(host, port), 5000);
            socket.setSoTimeout(5000);
            DataInputStream input = new DataInputStream(socket.getInputStream());
            OutputStream output = socket.getOutputStream();
            byte[] handshakePayload = this.buildHandshakePayload(host, port);
            byte[] loginPayload = this.buildLoginPayload(username);
            this.sendProbePacket(output, 0, handshakePayload);
            this.sendProbePacket(output, 0, loginPayload);
            long deadline = System.currentTimeMillis() + 10000L;
            int compressionThreshold = -1;
            while (System.currentTimeMillis() < deadline && (body = this.readProbePacket(input, compressionThreshold)) != null) {
                ByteArrayInputStream packetIn = new ByteArrayInputStream(body);
                int packetId = OfflineSettingsHack.readVarInt(packetIn);
                byte[] payload = packetIn.readAllBytes();
                if (packetId == 0) {
                    String reason = OfflineSettingsHack.readString(new ByteArrayInputStream(payload));
                    this.sendLogoutMessage("Server disconnected login attempt: " + reason);
                    return;
                }
                if (packetId == 1) {
                    this.sendLogoutMessage("Server requested encryption/auth information.");
                    continue;
                }
                if (packetId == 2) {
                    this.sendLogoutMessage("Server accepted the login for " + username + ".");
                    return;
                }
                if (packetId == 3) {
                    int threshold;
                    compressionThreshold = threshold = OfflineSettingsHack.readVarInt(new ByteArrayInputStream(payload));
                    this.sendLogoutMessage("Server enabled compression (threshold " + threshold + ").");
                    continue;
                }
                this.sendLogoutMessage(String.format(Locale.ROOT, "Unhandled login packet 0x%02X (%d bytes).", packetId, payload.length));
            }
            this.sendLogoutMessage("Login probe timed out without a clear server response.");
        }
        catch (IOException | DataFormatException e) {
            this.sendLogoutError("Logout probe failed: " + e.getMessage());
        }
    }

    private boolean triggerLogoutProbe(String username, class_642 server, boolean silentErrors, boolean autoTriggered) {
        if (username == null || username.isEmpty()) {
            if (!silentErrors) {
                this.sendLogoutError("Select another player's name before using logout.");
            }
            return false;
        }
        if (server == null) {
            server = this.getCurrentOrLastServer();
        }
        if (server == null) {
            if (!silentErrors) {
                this.sendLogoutError("No recent server to probe.");
            }
            return false;
        }
        class_639 address = class_639.method_2950((String)server.field_3761);
        String host = address.method_2952();
        int port = address.method_2954();
        if (host == null || host.isBlank()) {
            if (!silentErrors) {
                this.sendLogoutError("Invalid server address.");
            }
            return false;
        }
        if (!this.logoutProbeRunning.compareAndSet(false, true)) {
            if (!silentErrors) {
                this.sendLogoutError("Another logout probe is already running.");
            }
            return false;
        }
        String message = autoTriggered ? String.format(Locale.ROOT, "Auto-logging out %s on %s:%d...", username, host, port) : String.format(Locale.ROOT, "Probing %s:%d as %s...", host, port, username);
        this.sendLogoutMessage(message);
        Thread thread = new Thread(() -> {
            try {
                this.runLogoutProbe(host, port, username);
            }
            finally {
                this.logoutProbeRunning.set(false);
            }
        }, "OfflineSettings-LogoutProbe");
        thread.setDaemon(true);
        thread.start();
        return true;
    }

    private byte[] readProbePacket(DataInputStream input, int compressionThreshold) throws IOException, DataFormatException {
        int length = OfflineSettingsHack.readVarInt(input);
        if (length <= 0) {
            return null;
        }
        byte[] data = new byte[length];
        input.readFully(data);
        if (compressionThreshold < 0) {
            return data;
        }
        ByteArrayInputStream packetStream = new ByteArrayInputStream(data);
        int dataLength = OfflineSettingsHack.readVarInt(packetStream);
        if (dataLength == 0) {
            return packetStream.readAllBytes();
        }
        byte[] compressed = packetStream.readAllBytes();
        Inflater inflater = new Inflater();
        inflater.setInput(compressed);
        byte[] buffer = new byte[dataLength];
        int read = inflater.inflate(buffer);
        inflater.end();
        if (read < dataLength) {
            return Arrays.copyOf(buffer, read);
        }
        return buffer;
    }

    private byte[] buildHandshakePayload(String host, int port) {
        ByteArrayOutputStream payload = new ByteArrayOutputStream();
        payload.writeBytes(OfflineSettingsHack.encodeVarInt(class_155.method_16673().comp_4027()));
        OfflineSettingsHack.writeString(payload, host);
        payload.write(port >> 8 & 0xFF);
        payload.write(port & 0xFF);
        payload.writeBytes(OfflineSettingsHack.encodeVarInt(2));
        return payload.toByteArray();
    }

    private byte[] buildLoginPayload(String username) {
        ByteArrayOutputStream payload = new ByteArrayOutputStream();
        OfflineSettingsHack.writeString(payload, username);
        UUID uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(StandardCharsets.UTF_8));
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        payload.writeBytes(buffer.array());
        return payload.toByteArray();
    }

    private void sendProbePacket(OutputStream output, int packetId, byte[] payload) throws IOException {
        ByteArrayOutputStream packet = new ByteArrayOutputStream();
        packet.writeBytes(OfflineSettingsHack.encodeVarInt(packetId));
        packet.writeBytes(payload);
        byte[] body = packet.toByteArray();
        output.write(OfflineSettingsHack.encodeVarInt(body.length));
        output.write(body);
        output.flush();
    }

    private static byte[] encodeVarInt(int value) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int v = value;
        do {
            int temp = v & 0x7F;
            if ((v >>>= 7) != 0) {
                temp |= 0x80;
            }
            out.write(temp);
        } while (v != 0);
        return out.toByteArray();
    }

    private static int readVarInt(InputStream in) throws IOException {
        int read;
        int numRead = 0;
        int result = 0;
        do {
            if ((read = in.read()) == -1) {
                throw new IOException("Unexpected end of stream");
            }
            int value = read & 0x7F;
            result |= value << 7 * numRead;
            if (++numRead <= 5) continue;
            throw new IOException("VarInt is too large");
        } while ((read & 0x80) != 0);
        return result;
    }

    private static void writeString(ByteArrayOutputStream out, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        out.writeBytes(OfflineSettingsHack.encodeVarInt(bytes.length));
        out.writeBytes(bytes);
    }

    private static String readString(ByteArrayInputStream in) {
        try {
            int length = OfflineSettingsHack.readVarInt(in);
            if (length <= 0) {
                return "";
            }
            byte[] bytes = in.readNBytes(length);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return "(invalid disconnect message)";
        }
    }

    private void sendLogoutMessage(String text) {
        class_310 client = class_310.method_1551();
        Runnable task = () -> ChatUtils.message("[OfflineSettings] " + text);
        if (client != null) {
            client.execute(task);
        } else {
            task.run();
        }
    }

    private void sendLogoutError(String text) {
        class_310 client = class_310.method_1551();
        Runnable task = () -> ChatUtils.error("OfflineSettings: " + text);
        if (client != null) {
            client.execute(task);
        } else {
            task.run();
        }
    }
}

