/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.Set;
import net.wurstclient.Category;
import net.wurstclient.DontBlock;
import net.wurstclient.SearchTags;
import net.wurstclient.hack.Hack;
import net.wurstclient.hack.HackList;
import net.wurstclient.settings.ButtonSetting;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.json.WsonArray;
import net.wurstclient.util.text.WText;

@SearchTags(value={"legit", "disable"})
@DontBlock
public final class PanicHack
extends Hack {
    private final Set<String> savedHackNames = new LinkedHashSet<String>();
    private final Path snapshotFile = WURST.getWurstFolder().resolve("panic-snapshot.json");
    private boolean startupRestorePending;
    private final ButtonSetting restoreButton = new ButtonSetting("Restore saved hacks", WText.literal("Re-enables the hacks that were active when Panic was triggered."), this::restoreSavedHacks);

    public PanicHack() {
        super("Panic");
        this.setCategory(Category.OTHER);
        this.addSetting(this.restoreButton);
        this.addPossibleKeybind("panic restore", "Restore hacks saved by Panic");
        this.loadSnapshotFromDisk();
    }

    @Override
    protected void onEnable() {
        int saved = this.snapshotEnabledHacks();
        this.disableOtherHacks();
        this.setEnabled(false);
        if (saved > 0) {
            ChatUtils.message("Disabled " + saved + " hack" + (saved == 1 ? "" : "s") + ". Use \"Restore saved hacks\" to re-enable them.");
        } else {
            ChatUtils.message("No other hacks were enabled.");
        }
    }

    private int snapshotEnabledHacks() {
        this.savedHackNames.clear();
        for (Hack hack : WURST.getHax().getAllHax()) {
            if (!hack.isEnabled() || hack == this) continue;
            this.savedHackNames.add(hack.getName());
        }
        this.persistSavedHacks();
        this.startupRestorePending = false;
        return this.savedHackNames.size();
    }

    private void disableOtherHacks() {
        for (Hack hack : WURST.getHax().getAllHax()) {
            if (!hack.isEnabled() || hack == this) continue;
            hack.setEnabled(false);
        }
    }

    public void restoreSavedHacks() {
        if (this.savedHackNames.isEmpty()) {
            ChatUtils.error("There is no saved Panic state to restore.");
            return;
        }
        HackList hax = WURST.getHax();
        LinkedHashSet<String> missing = new LinkedHashSet<String>();
        LinkedHashSet<String> blocked = new LinkedHashSet<String>();
        int restored = 0;
        for (String name : new LinkedHashSet<String>(this.savedHackNames)) {
            Hack hack = hax.getHackByName(name);
            if (hack == null || hack == this) {
                missing.add(name);
                continue;
            }
            boolean wasEnabled = hack.isEnabled();
            hack.setEnabled(true);
            if (!hack.isEnabled()) {
                blocked.add(name);
                continue;
            }
            if (wasEnabled || !hack.isEnabled()) continue;
            ++restored;
        }
        this.savedHackNames.clear();
        this.savedHackNames.addAll(blocked);
        if (restored > 0) {
            ChatUtils.message("Restored " + restored + " hack" + (restored == 1 ? "" : "s") + " from Panic.");
        } else if (this.savedHackNames.isEmpty()) {
            ChatUtils.message("All saved Panic hacks are already enabled.");
        }
        if (!missing.isEmpty()) {
            ChatUtils.warning("Missing Panic hacks: " + String.join((CharSequence)", ", missing));
        }
        if (!this.savedHackNames.isEmpty()) {
            ChatUtils.warning("Still blocked: " + String.join((CharSequence)", ", this.savedHackNames));
        }
        this.persistSavedHacks();
    }

    public void handleStartupRestore() {
        if (!this.startupRestorePending) {
            return;
        }
        this.startupRestorePending = false;
        if (this.savedHackNames.isEmpty()) {
            this.deleteSnapshotFile();
            return;
        }
        this.restoreSavedHacks();
    }

    private void loadSnapshotFromDisk() {
        this.startupRestorePending = false;
        this.savedHackNames.clear();
        if (!Files.exists(this.snapshotFile, new LinkOption[0])) {
            return;
        }
        try {
            WsonArray wson = JsonUtils.parseFileToArray(this.snapshotFile);
            this.savedHackNames.addAll(wson.getAllStrings());
            if (this.savedHackNames.isEmpty()) {
                this.deleteSnapshotFile();
            } else {
                this.startupRestorePending = true;
            }
        }
        catch (IOException | JsonException e) {
            System.out.println("Couldn't load panic snapshot");
            e.printStackTrace();
            this.deleteSnapshotFile();
        }
    }

    private void persistSavedHacks() {
        if (this.savedHackNames.isEmpty()) {
            this.deleteSnapshotFile();
            return;
        }
        JsonArray json = new JsonArray();
        this.savedHackNames.forEach(arg_0 -> ((JsonArray)json).add(arg_0));
        try {
            Files.createDirectories(this.snapshotFile.getParent(), new FileAttribute[0]);
            JsonUtils.toJson((JsonElement)json, this.snapshotFile);
        }
        catch (IOException | JsonException e) {
            System.out.println("Couldn't save panic snapshot");
            e.printStackTrace();
        }
    }

    private void deleteSnapshotFile() {
        try {
            Files.deleteIfExists(this.snapshotFile);
        }
        catch (IOException e) {
            System.out.println("Couldn't delete panic snapshot");
            e.printStackTrace();
        }
    }
}

