/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1733;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2680;
import net.minecraft.class_3489;
import net.minecraft.class_3965;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.WurstClient;
import net.wurstclient.hack.Hack;
import net.wurstclient.mixinterface.IMinecraftClient;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.EnumSetting;
import net.wurstclient.settings.ItemListSetting;
import net.wurstclient.util.BlockBreaker;
import net.wurstclient.util.BlockPlacer;
import net.wurstclient.util.BlockUtils;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.InventoryUtils;

@SearchTags(value={"quick shulker", "quickshulker", "auto shulker"})
public final class QuickShulkerHack
extends Hack {
    private final EnumSetting<TransferMode> modeSetting = new EnumSetting("Items to move", "description.wurst.setting.quickshulker.mode", (Enum[])TransferMode.values(), (Enum)TransferMode.ALL);
    private final CheckboxSetting useBlacklist = new CheckboxSetting("Use blacklist", "description.wurst.setting.quickshulker.use_blacklist", true);
    private final CheckboxSetting useWhitelist = new CheckboxSetting("Use whitelist", "description.wurst.setting.quickshulker.use_whitelist", true);
    private final ItemListSetting blacklist = new ItemListSetting("Blacklist", "description.wurst.setting.quickshulker.blacklist", new String[0]);
    private final ItemListSetting whitelist = new ItemListSetting("Whitelist", "description.wurst.setting.quickshulker.whitelist", new String[0]);
    private final CheckboxSetting continueToNextShulker = new CheckboxSetting("Continue to next shulker", "description.wurst.setting.quickshulker.continue_to_next_shulker", false);
    private final Object workerLock = new Object();
    private Thread worker;

    public QuickShulkerHack() {
        super("QuickShulker");
        this.setCategory(Category.ITEMS);
        this.addSetting(this.modeSetting);
        this.addSetting(this.useBlacklist);
        this.addSetting(this.useWhitelist);
        this.addSetting(this.blacklist);
        this.addSetting(this.whitelist);
        this.addSetting(this.continueToNextShulker);
    }

    @Override
    protected void onDisable() {
        this.cancelWorker();
    }

    public boolean isBusy() {
        Thread current = this.worker;
        return current != null && current.isAlive();
    }

    public void triggerFromGui() {
        if (!this.isEnabled()) {
            ChatUtils.warning("QuickShulker needs to be enabled.");
            return;
        }
        if (this.isBusy()) {
            ChatUtils.warning("QuickShulker is already running.");
            return;
        }
        this.startWorker();
    }

    public boolean hasUsableShulker() {
        class_746 player = QuickShulkerHack.MC.field_1724;
        if (player == null) {
            return false;
        }
        return this.findShulkerSlot(player.method_31548()) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWorker() {
        Object object = this.workerLock;
        synchronized (object) {
            if (this.isBusy()) {
                return;
            }
            this.worker = Thread.ofPlatform().name("QuickShulker").uncaughtExceptionHandler((t, e) -> e.printStackTrace()).start(this::runTaskSafe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelWorker() {
        Thread current;
        Object object = this.workerLock;
        synchronized (object) {
            current = this.worker;
            this.worker = null;
        }
        if (current != null) {
            current.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTaskSafe() {
        try {
            this.runTask();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            ChatUtils.error("QuickShulker failed: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            Object ignored = this.workerLock;
            synchronized (ignored) {
                this.worker = null;
            }
        }
    }

    private void runTask() throws InterruptedException {
        block15: {
            HashSet<Integer> remainingSlots;
            class_2338 placePos;
            boolean hadOpenContainer;
            class_746 player = QuickShulkerHack.MC.field_1724;
            if (player == null || QuickShulkerHack.MC.field_1687 == null) {
                ChatUtils.error("Player not available.");
                return;
            }
            class_1661 inv = player.method_31548();
            int originalSlot = inv.method_67532();
            int shulkerSlot = this.findShulkerSlot(inv);
            if (shulkerSlot == -1) {
                ChatUtils.error("No non-full shulker box found.");
                return;
            }
            class_1703 openHandler = player.field_7512;
            int[] chestOriginSnapshot = null;
            int[] chestAfterSnapshot = null;
            Set<Integer> slotsFromChest = null;
            boolean bl = hadOpenContainer = openHandler != null && openHandler != player.field_7498 && this.hasExternalSlots(openHandler, inv);
            if (hadOpenContainer) {
                chestOriginSnapshot = this.snapshotInventory(inv);
                this.moveItemsFromOpenContainerToPlayer(player, openHandler, this.modeSetting.getSelected(), this.blacklist.getItemNames(), this.whitelist.getItemNames(), this.useBlacklist.isChecked(), this.useWhitelist.isChecked());
                chestAfterSnapshot = this.snapshotInventory(inv);
                slotsFromChest = this.computeIncreasedSlots(chestOriginSnapshot, chestAfterSnapshot);
                this.closeCurrentScreen(player);
                this.safeSleep(50L);
            }
            if ((placePos = this.findPlacementPos(player)) == null) {
                ChatUtils.error("No safe space to place a shulker nearby.");
                return;
            }
            this.closeCurrentScreen(player);
            this.safeSleep(50L);
            HashSet<String> blacklistSet = new HashSet<String>(this.blacklist.getItemNames());
            HashSet<String> whitelistSet = new HashSet<String>(this.whitelist.getItemNames());
            TransferMode mode = this.modeSetting.getSelected();
            boolean keepGoing = this.continueToNextShulker.isChecked();
            HashSet<Integer> hashSet = remainingSlots = slotsFromChest == null ? null : new HashSet<Integer>(slotsFromChest);
            do {
                ItemSwap shulkerSwap;
                if (!(shulkerSwap = this.bringSlotToHand(inv, shulkerSlot, originalSlot)).success()) {
                    return;
                }
                if (!this.placeShulker(placePos)) {
                    ChatUtils.error("Failed to place shulker.");
                    this.restoreSwap(inv, shulkerSwap);
                    return;
                }
                WurstClient.MC.execute(() -> {
                    try {
                        WurstClient.INSTANCE.getRotationFaker().faceVectorClient(class_243.method_24953((class_2382)placePos));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
                this.safeSleep(80L);
                if (!this.openShulker(placePos)) {
                    ChatUtils.error("Failed to open shulker.");
                    this.restoreSwap(inv, shulkerSwap);
                    return;
                }
                class_1703 handler = this.waitForShulkerHandler(player, 3000L);
                if (handler == null) {
                    ChatUtils.error("Timed out waiting for shulker UI.");
                    this.closeCurrentScreen(player);
                    this.restoreSwap(inv, shulkerSwap);
                    return;
                }
                int pickaxeSlot = this.findPickaxeSlot(inv);
                HashSet<Integer> protectedSlots = new HashSet<Integer>();
                if (shulkerSwap.storageSlot >= 0 && shulkerSwap.storageSlot < 36) {
                    protectedSlots.add(shulkerSwap.storageSlot);
                }
                if (pickaxeSlot >= 0 && pickaxeSlot < 36) {
                    protectedSlots.add(pickaxeSlot);
                }
                if (remainingSlots != null && !remainingSlots.isEmpty()) {
                    this.transferItemsFromSlots(player, handler, blacklistSet, whitelistSet, mode, protectedSlots, remainingSlots);
                } else {
                    this.transferItems(player, handler, blacklistSet, whitelistSet, mode, protectedSlots);
                }
                this.safeSleep(120L);
                this.closeCurrentScreen(player);
                boolean anyLeft = false;
                if (remainingSlots != null && !remainingSlots.isEmpty()) {
                    Iterator iterator = remainingSlots.iterator();
                    while (iterator.hasNext()) {
                        int s = (Integer)iterator.next();
                        if (s < 0 || s >= 36 || inv.method_5438(s).method_7960()) continue;
                        anyLeft = true;
                        break;
                    }
                }
                ItemSwap pickaxeSwap = pickaxeSlot == -1 ? ItemSwap.keepSelection(originalSlot) : this.bringSlotToHand(inv, pickaxeSlot, originalSlot);
                this.breakPlacedShulker(placePos);
                this.safeSleep(160L);
                this.restoreSwap(inv, pickaxeSwap);
                this.restoreSwap(inv, shulkerSwap);
                if (!anyLeft || !keepGoing) break block15;
            } while ((shulkerSlot = this.findShulkerSlot(inv)) != -1);
            ChatUtils.error("No non-full shulker box found to continue.");
        }
        ChatUtils.message("QuickShulker finished.");
    }

    private void transferItems(class_746 player, class_1703 handler, Set<String> blacklistSet, Set<String> whitelistSet, TransferMode mode, Set<Integer> protectedSlots) throws InterruptedException {
        class_1661 inv = player.method_31548();
        boolean useBl = this.useBlacklist.isChecked();
        boolean useWl = this.useWhitelist.isChecked();
        for (int slot = 0; slot < 36; ++slot) {
            int handlerSlot;
            class_1799 stack;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (protectedSlots.contains(slot) || (stack = inv.method_5438(slot)).method_7960() || this.isShulkerItem(stack) || mode == TransferMode.STACKABLE && !stack.method_7946() || mode == TransferMode.NON_STACKABLE && stack.method_7946()) continue;
            String id = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
            if (useBl && blacklistSet.contains(id) || useWl && !whitelistSet.isEmpty() && !whitelistSet.contains(id) || (handlerSlot = this.toHandlerSlot(handler, inv, slot)) == -1) continue;
            int before = stack.method_7947();
            QuickShulkerHack.MC.field_1761.method_2906(handler.field_7763, handlerSlot, 0, class_1713.field_7794, (class_1657)player);
            this.safeSleep(70L);
            class_1799 after = inv.method_5438(slot);
            if (after.method_7947() == before || this.hasContainerSpace(handler, inv)) continue;
            return;
        }
    }

    private void transferItemsFromSlots(class_746 player, class_1703 handler, Set<String> blacklistSet, Set<String> whitelistSet, TransferMode mode, Set<Integer> protectedSlots, Set<Integer> slotsToTransfer) throws InterruptedException {
        class_1661 inv = player.method_31548();
        boolean useBl = this.useBlacklist.isChecked();
        boolean useWl = this.useWhitelist.isChecked();
        for (int slot : slotsToTransfer) {
            int handlerSlot;
            class_1799 stack;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (protectedSlots.contains(slot) || slot < 0 || slot >= 36 || (stack = inv.method_5438(slot)).method_7960() || this.isShulkerItem(stack) || mode == TransferMode.STACKABLE && !stack.method_7946() || mode == TransferMode.NON_STACKABLE && stack.method_7946()) continue;
            String id = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
            if (useBl && blacklistSet.contains(id) || useWl && !whitelistSet.isEmpty() && !whitelistSet.contains(id) || (handlerSlot = this.toHandlerSlot(handler, inv, slot)) == -1) continue;
            int before = stack.method_7947();
            QuickShulkerHack.MC.field_1761.method_2906(handler.field_7763, handlerSlot, 0, class_1713.field_7794, (class_1657)player);
            this.safeSleep(70L);
            class_1799 after = inv.method_5438(slot);
            if (after.method_7947() == before || this.hasContainerSpace(handler, inv)) continue;
            return;
        }
    }

    private boolean hasExternalSlots(class_1703 handler, class_1661 inv) {
        for (class_1735 slot : handler.field_7761) {
            if (slot.field_7871 == inv) continue;
            return true;
        }
        return false;
    }

    private int[] snapshotInventory(class_1661 inv) {
        int[] arr = new int[36];
        for (int i = 0; i < 36; ++i) {
            class_1799 s = inv.method_5438(i);
            arr[i] = s == null ? 0 : s.method_7947();
        }
        return arr;
    }

    private Set<Integer> computeIncreasedSlots(int[] before, int[] after) {
        HashSet<Integer> set = new HashSet<Integer>();
        if (before == null || after == null) {
            return set;
        }
        int len = Math.min(before.length, after.length);
        for (int i = 0; i < len; ++i) {
            if (after[i] <= before[i]) continue;
            set.add(i);
        }
        return set;
    }

    private void moveItemsFromOpenContainerToPlayer(class_746 player, class_1703 handler, TransferMode mode, List<String> bl, List<String> wl, boolean useBl, boolean useWl) throws InterruptedException {
        class_1661 inv = player.method_31548();
        HashSet<String> blacklistSet = new HashSet<String>(bl);
        HashSet<String> whitelistSet = new HashSet<String>(wl);
        for (int i = 0; i < handler.field_7761.size(); ++i) {
            class_1799 stack;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            class_1735 slot = (class_1735)handler.field_7761.get(i);
            if (slot.field_7871 == inv || (stack = slot.method_7677()).method_7960() || this.isShulkerItem(stack) || mode == TransferMode.STACKABLE && !stack.method_7946() || mode == TransferMode.NON_STACKABLE && stack.method_7946()) continue;
            String id = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
            if (useBl && blacklistSet.contains(id) || useWl && !whitelistSet.isEmpty() && !whitelistSet.contains(id)) continue;
            QuickShulkerHack.MC.field_1761.method_2906(handler.field_7763, i, 0, class_1713.field_7794, (class_1657)player);
            this.safeSleep(70L);
        }
    }

    private boolean hasContainerSpace(class_1703 handler, class_1661 playerInventory) {
        for (class_1735 slot : handler.field_7761) {
            if (slot.field_7871 == playerInventory || slot.method_7681()) continue;
            return true;
        }
        return false;
    }

    private int toHandlerSlot(class_1703 handler, class_1661 inv, int playerSlot) {
        for (int i = 0; i < handler.field_7761.size(); ++i) {
            class_1735 slot = (class_1735)handler.field_7761.get(i);
            if (slot.field_7871 != inv || slot.method_34266() != playerSlot) continue;
            return i;
        }
        return -1;
    }

    private class_1703 waitForShulkerHandler(class_746 player, long timeoutMs) throws InterruptedException {
        long deadline = System.currentTimeMillis() + timeoutMs;
        while (System.currentTimeMillis() < deadline) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            class_1703 current = player.field_7512;
            if (current instanceof class_1733) {
                class_1733 handler = (class_1733)current;
                if (current != player.field_7498) {
                    return handler;
                }
            }
            this.safeSleep(50L);
        }
        return null;
    }

    private boolean openShulker(class_2338 pos) throws InterruptedException {
        for (int attempt = 0; attempt < 3; ++attempt) {
            boolean[] accepted = new boolean[1];
            class_2338 fpos = pos;
            WurstClient.MC.execute(() -> {
                try {
                    class_3965 hit = new class_3965(class_243.method_24953((class_2382)fpos), class_2350.field_11036, fpos, false);
                    class_1269 result = WurstClient.MC.field_1761.method_2896(WurstClient.MC.field_1724, class_1268.field_5808, hit);
                    accepted[0] = result.method_23665();
                }
                catch (Throwable ignored) {
                    accepted[0] = false;
                }
            });
            this.safeSleep(100L);
            if (!accepted[0]) continue;
            return true;
        }
        return false;
    }

    private boolean breakPlacedShulker(class_2338 pos) throws InterruptedException {
        for (int attempt = 0; attempt < 40; ++attempt) {
            if (BlockUtils.getState(pos).method_26215()) {
                return true;
            }
            class_2338 fpos = pos;
            boolean[] started = new boolean[1];
            WurstClient.MC.execute(() -> {
                try {
                    started[0] = BlockBreaker.breakOneBlock(fpos);
                }
                catch (Throwable ignored) {
                    started[0] = false;
                }
            });
            if (!started[0]) {
                this.safeSleep(50L);
            }
            this.safeSleep(60L);
        }
        return BlockUtils.getState(pos).method_26215();
    }

    private boolean placeShulker(class_2338 pos) throws InterruptedException {
        for (int attempt = 0; attempt < 3; ++attempt) {
            class_2338 fpos = pos;
            boolean[] placed = new boolean[1];
            WurstClient.MC.execute(() -> {
                try {
                    placed[0] = BlockPlacer.placeOneBlock(fpos);
                }
                catch (Throwable ignored) {
                    placed[0] = false;
                }
            });
            this.safeSleep(80L);
            if (!placed[0]) continue;
            return true;
        }
        return BlockUtils.getBlock(pos) instanceof class_2480;
    }

    private void closeCurrentScreen(class_746 player) {
        if (WurstClient.MC == null) {
            return;
        }
        if (WurstClient.MC.field_1755 == null) {
            return;
        }
        WurstClient.MC.execute(() -> {
            try {
                if (WurstClient.MC.field_1724 != null) {
                    WurstClient.MC.field_1724.method_7346();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        long deadline = System.currentTimeMillis() + 2000L;
        while (System.currentTimeMillis() < deadline) {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                return;
            }
            if (WurstClient.MC.field_1755 == null) {
                return;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    private ItemSwap bringSlotToHand(class_1661 inv, int sourceSlot, int targetHotbarSlot) {
        if (sourceSlot == -1) {
            return ItemSwap.failure(targetHotbarSlot);
        }
        if (sourceSlot == targetHotbarSlot) {
            inv.method_61496(targetHotbarSlot);
            return ItemSwap.keepSelection(targetHotbarSlot);
        }
        IMinecraftClient imc = WurstClient.IMC;
        imc.getInteractionManager().windowClick_SWAP(InventoryUtils.toNetworkSlot(sourceSlot), targetHotbarSlot);
        inv.method_61496(targetHotbarSlot);
        return new ItemSwap(targetHotbarSlot, sourceSlot, true);
    }

    private void restoreSwap(class_1661 inv, ItemSwap swap) {
        if (!swap.success()) {
            return;
        }
        if (swap.storageSlot >= 0) {
            WurstClient.IMC.getInteractionManager().windowClick_SWAP(InventoryUtils.toNetworkSlot(swap.storageSlot), swap.restoreSlot);
        }
        inv.method_61496(swap.restoreSlot);
    }

    private class_2338 findPlacementPos(class_746 player) {
        class_2338 base = player.method_24515();
        class_2350 facing = player.method_5735();
        class_2338[] candidates = new class_2338[]{base.method_10093(facing), base.method_10093(facing.method_10170()), base.method_10093(facing.method_10160()), base.method_10093(facing.method_10153()), base.method_10084(), base.method_10074()};
        class_238 playerBox = player.method_5829();
        for (class_2338 pos : candidates) {
            class_238 blockBox;
            class_2680 below;
            class_2680 state = BlockUtils.getState(pos);
            if (!state.method_45474() || (below = BlockUtils.getState(pos.method_10074())).method_26215() || (blockBox = new class_238(pos)).method_994(playerBox)) continue;
            return pos;
        }
        return null;
    }

    private int findShulkerSlot(class_1661 inv) {
        for (int slot = 0; slot < inv.method_5439(); ++slot) {
            class_1799 stack = inv.method_5438(slot);
            if (stack.method_7960() || !this.isShulkerItem(stack) || this.isShulkerFull(stack)) continue;
            return slot;
        }
        return -1;
    }

    private int findPickaxeSlot(class_1661 inv) {
        int bestSlot = -1;
        int bestPriority = -1;
        for (int slot = 0; slot < inv.method_5439(); ++slot) {
            int priority;
            class_1799 stack = inv.method_5438(slot);
            if (stack.method_7960() || !stack.method_31573(class_3489.field_42614) || (priority = this.getPickaxePriority(stack.method_7909())) <= bestPriority) continue;
            bestPriority = priority;
            bestSlot = slot;
        }
        return bestSlot;
    }

    private int getPickaxePriority(class_1792 item) {
        if (item == class_1802.field_22024) {
            return 4;
        }
        if (item == class_1802.field_8377) {
            return 3;
        }
        if (item == class_1802.field_8403) {
            return 2;
        }
        if (item == class_1802.field_8387) {
            return 1;
        }
        return 0;
    }

    private boolean isShulkerItem(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (!(item instanceof class_1747)) {
            return false;
        }
        class_1747 blockItem = (class_1747)item;
        return blockItem.method_7711() instanceof class_2480;
    }

    private boolean isShulkerFull(class_1799 shulker) {
        class_9288 container = (class_9288)shulker.method_58694(class_9334.field_49622);
        if (container == null) {
            return false;
        }
        int occupied = 0;
        for (class_1799 stack : container.method_59714()) {
            if (stack.method_7960() || ++occupied < 27) continue;
            return true;
        }
        return false;
    }

    private void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    private void safeSleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    private static enum TransferMode {
        ALL("All items"),
        STACKABLE("Stackable"),
        NON_STACKABLE("Non-stackable");

        private final String label;

        private TransferMode(String label) {
            this.label = Objects.requireNonNull(label);
        }

        public String toString() {
            return this.label;
        }
    }

    private static final class ItemSwap {
        private final int restoreSlot;
        private final int storageSlot;
        private final boolean success;

        private ItemSwap(int restoreSlot, int storageSlot, boolean success) {
            this.restoreSlot = restoreSlot;
            this.storageSlot = storageSlot;
            this.success = success;
        }

        private static ItemSwap failure(int restoreSlot) {
            return new ItemSwap(restoreSlot, -1, false);
        }

        private static ItemSwap keepSelection(int slot) {
            return new ItemSwap(slot, -1, true);
        }

        private boolean success() {
            return this.success;
        }
    }
}

