/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.events.CameraTransformViewBobbingListener;
import net.wurstclient.events.PacketInputListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.hacks.portalesp.PortalEspBlockGroup;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ChunkAreaSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.EspStyleSetting;
import net.wurstclient.settings.Setting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.BlockUtils;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.chunk.ChunkSearcher;
import net.wurstclient.util.chunk.ChunkSearcherCoordinator;

@SearchTags(value={"redstone esp", "RedstoneESP"})
public final class RedstoneEspHack
extends Hack
implements UpdateListener,
CameraTransformViewBobbingListener,
RenderListener {
    private final EspStyleSetting style = new EspStyleSetting();
    private final CheckboxSetting stickyArea = new CheckboxSetting("Sticky area", "Off: Re-centers every chunk to match ESP drop-off.\nOn: Keeps results anchored so you can path back to them.", false);
    private final ChunkAreaSetting area = new ChunkAreaSetting("Area", "The area around the player to search in.\nHigher values require a faster computer.", ChunkAreaSetting.ChunkArea.A33);
    private final Color defaultColor = Color.RED;
    private final MultiBlockEspGroup buttonsGroup = new MultiBlockEspGroup(RedstoneEspHack.blocks(class_2246.field_10057, class_2246.field_10066, class_2246.field_10417, class_2246.field_10553, class_2246.field_10278, class_2246.field_10493, class_2246.field_37559, class_2246.field_40286, class_2246.field_42743, class_2246.field_22100, class_2246.field_22101, class_2246.field_10494, class_2246.field_23864), new ColorSetting("Buttons color", "All button types will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include buttons", true));
    private final MultiBlockEspGroup platesGroup = new MultiBlockEspGroup(RedstoneEspHack.blocks(class_2246.field_10484, class_2246.field_10332, class_2246.field_10592, class_2246.field_10026, class_2246.field_10397, class_2246.field_10470, class_2246.field_37553, class_2246.field_40284, class_2246.field_42737, class_2246.field_22130, class_2246.field_22131, class_2246.field_10158, class_2246.field_23863, class_2246.field_10224, class_2246.field_10582), new ColorSetting("Pressure plates color", "All pressure plate types will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include pressure plates", true));
    private final PortalEspBlockGroup redstoneTorch = new PortalEspBlockGroup(class_2246.field_10523, new ColorSetting("Redstone torch color", "Redstone torches will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include redstone torches", true));
    private final PortalEspBlockGroup redstoneBlock = new PortalEspBlockGroup(class_2246.field_10002, new ColorSetting("Redstone block color", "Redstone blocks will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include redstone blocks", true));
    private final PortalEspBlockGroup lever = new PortalEspBlockGroup(class_2246.field_10363, new ColorSetting("Lever color", "Levers will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include levers", true));
    private final PortalEspBlockGroup tripwireHook = new PortalEspBlockGroup(class_2246.field_10348, new ColorSetting("Tripwire hook color", "", this.defaultColor), new CheckboxSetting("Include tripwire hooks", true));
    private final PortalEspBlockGroup target = new PortalEspBlockGroup(class_2246.field_22422, new ColorSetting("Target block color", "", this.defaultColor), new CheckboxSetting("Include target blocks", true));
    private final PortalEspBlockGroup dust = new PortalEspBlockGroup(class_2246.field_10091, new ColorSetting("Redstone dust color", "", this.defaultColor), new CheckboxSetting("Include redstone dust", true));
    private final PortalEspBlockGroup repeater = new PortalEspBlockGroup(class_2246.field_10450, new ColorSetting("Repeater color", "", this.defaultColor), new CheckboxSetting("Include repeaters", true));
    private final PortalEspBlockGroup comparator = new PortalEspBlockGroup(class_2246.field_10377, new ColorSetting("Comparator color", "", this.defaultColor), new CheckboxSetting("Include comparators", true));
    private final PortalEspBlockGroup observer = new PortalEspBlockGroup(class_2246.field_10282, new ColorSetting("Observer color", "", this.defaultColor), new CheckboxSetting("Include observers", true));
    private final PortalEspBlockGroup daylight = new PortalEspBlockGroup(class_2246.field_10429, new ColorSetting("Daylight detector color", "", this.defaultColor), new CheckboxSetting("Include daylight detectors", true));
    private final PortalEspBlockGroup sculk = new PortalEspBlockGroup(class_2246.field_28108, new ColorSetting("Sculk sensor color", "", this.defaultColor), new CheckboxSetting("Include sculk sensors", true));
    private final PortalEspBlockGroup cSculk = new PortalEspBlockGroup(class_2246.field_43231, new ColorSetting("Calibrated sculk sensor color", "", this.defaultColor), new CheckboxSetting("Include calibrated sculk sensors", true));
    private final PortalEspBlockGroup piston = new PortalEspBlockGroup(class_2246.field_10560, new ColorSetting("Piston color", "", this.defaultColor), new CheckboxSetting("Include pistons", true));
    private final PortalEspBlockGroup stickyPiston = new PortalEspBlockGroup(class_2246.field_10615, new ColorSetting("Sticky piston color", "", this.defaultColor), new CheckboxSetting("Include sticky pistons", true));
    private final PortalEspBlockGroup dispenser = new PortalEspBlockGroup(class_2246.field_10200, new ColorSetting("Dispenser color", "", this.defaultColor), new CheckboxSetting("Include dispensers", true));
    private final PortalEspBlockGroup dropper = new PortalEspBlockGroup(class_2246.field_10228, new ColorSetting("Dropper color", "", this.defaultColor), new CheckboxSetting("Include droppers", true));
    private final PortalEspBlockGroup hopper = new PortalEspBlockGroup(class_2246.field_10312, new ColorSetting("Hopper color", "", this.defaultColor), new CheckboxSetting("Include hoppers", true));
    private final PortalEspBlockGroup trappedChest = new PortalEspBlockGroup(class_2246.field_10380, new ColorSetting("Trapped chest color", "", this.defaultColor), new CheckboxSetting("Include trapped chests", true));
    private final PortalEspBlockGroup noteBlock = new PortalEspBlockGroup(class_2246.field_10179, new ColorSetting("Note block color", "", this.defaultColor), new CheckboxSetting("Include note blocks", true));
    private final PortalEspBlockGroup jukebox = new PortalEspBlockGroup(class_2246.field_10223, new ColorSetting("Jukebox color", "", this.defaultColor), new CheckboxSetting("Include jukeboxes", true));
    private final PortalEspBlockGroup bell = new PortalEspBlockGroup(class_2246.field_16332, new ColorSetting("Bell color", "", this.defaultColor), new CheckboxSetting("Include bells", true));
    private final PortalEspBlockGroup lectern = new PortalEspBlockGroup(class_2246.field_16330, new ColorSetting("Lectern (redstone) color", "", this.defaultColor), new CheckboxSetting("Include lecterns (redstone)", true));
    private final PortalEspBlockGroup poweredRail = new PortalEspBlockGroup(class_2246.field_10425, new ColorSetting("Powered rail color", "", this.defaultColor), new CheckboxSetting("Include powered rails", true));
    private final PortalEspBlockGroup detectorRail = new PortalEspBlockGroup(class_2246.field_10025, new ColorSetting("Detector rail color", "", this.defaultColor), new CheckboxSetting("Include detector rails", true));
    private final PortalEspBlockGroup activatorRail = new PortalEspBlockGroup(class_2246.field_10546, new ColorSetting("Activator rail color", "", this.defaultColor), new CheckboxSetting("Include activator rails", true));
    private final List<RenderGroup> renderGroups = Arrays.asList(this.buttonsGroup, this.platesGroup, RedstoneEspHack.wrap(this.redstoneTorch), RedstoneEspHack.wrap(this.redstoneBlock), RedstoneEspHack.wrap(this.lever), RedstoneEspHack.wrap(this.tripwireHook), RedstoneEspHack.wrap(this.target), RedstoneEspHack.wrap(this.dust), RedstoneEspHack.wrap(this.repeater), RedstoneEspHack.wrap(this.comparator), RedstoneEspHack.wrap(this.observer), RedstoneEspHack.wrap(this.daylight), RedstoneEspHack.wrap(this.sculk), RedstoneEspHack.wrap(this.cSculk), RedstoneEspHack.wrap(this.piston), RedstoneEspHack.wrap(this.stickyPiston), RedstoneEspHack.wrap(this.dispenser), RedstoneEspHack.wrap(this.dropper), RedstoneEspHack.wrap(this.hopper), RedstoneEspHack.wrap(this.trappedChest), RedstoneEspHack.wrap(this.noteBlock), RedstoneEspHack.wrap(this.jukebox), RedstoneEspHack.wrap(this.bell), RedstoneEspHack.wrap(this.lectern), RedstoneEspHack.wrap(this.poweredRail), RedstoneEspHack.wrap(this.detectorRail), RedstoneEspHack.wrap(this.activatorRail));
    private final BiPredicate<class_2338, class_2680> query = (pos, state) -> this.isEnabledTarget(state.method_26204());
    private final ChunkSearcherCoordinator coordinator = new ChunkSearcherCoordinator(this.query, this.area);
    private boolean groupsUpToDate;
    private ChunkAreaSetting.ChunkArea lastAreaSelection;
    private class_1923 lastPlayerChunk;
    private int foundCount;
    private int lastMatchesVersion;
    private final CheckboxSetting showCountInHackList = new CheckboxSetting("HackList count", "Appends the number of found redstone components to this hack's entry in the HackList.", false);
    private final CheckboxSetting onlyAboveGround = new CheckboxSetting("Above ground only", "Only show redstone components at or above the configured Y level.", false);
    private final SliderSetting aboveGroundY = new SliderSetting("Set ESP Y limit", 62.0, -65.0, 255.0, 1.0, SliderSetting.ValueDisplay.INTEGER);

    public RedstoneEspHack() {
        super("RedstoneESP");
        this.setCategory(Category.RENDER);
        this.addSetting(this.style);
        this.renderGroups.stream().flatMap(RenderGroup::getSettings).forEach(x$0 -> this.addSetting((Setting)x$0));
        this.addSetting(this.showCountInHackList);
        this.addSetting(this.onlyAboveGround);
        this.addSetting(this.aboveGroundY);
        this.addSetting(this.area);
        this.addSetting(this.stickyArea);
    }

    private static Set<class_2248> blocks(class_2248 ... bs) {
        return new HashSet<class_2248>(Arrays.asList(bs));
    }

    private boolean isEnabledTarget(class_2248 b) {
        for (RenderGroup g : this.renderGroups) {
            if (!g.isEnabled() || !g.matches(b)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void onEnable() {
        this.groupsUpToDate = false;
        this.lastAreaSelection = (ChunkAreaSetting.ChunkArea)((Object)this.area.getSelected());
        this.lastPlayerChunk = new class_1923(RedstoneEspHack.MC.field_1724.method_24515());
        this.lastMatchesVersion = this.coordinator.getMatchesVersion();
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(CameraTransformViewBobbingListener.class, this);
        EVENTS.add(RenderListener.class, this);
        EVENTS.add(PacketInputListener.class, this.coordinator);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(CameraTransformViewBobbingListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        EVENTS.remove(PacketInputListener.class, this.coordinator);
        this.coordinator.reset();
        this.lastMatchesVersion = this.coordinator.getMatchesVersion();
        this.renderGroups.forEach(RenderGroup::clear);
        this.foundCount = 0;
    }

    @Override
    public void onUpdate() {
        int matchesVersion;
        boolean searchersChanged;
        ChunkAreaSetting.ChunkArea currentArea = (ChunkAreaSetting.ChunkArea)((Object)this.area.getSelected());
        if (currentArea != this.lastAreaSelection) {
            this.lastAreaSelection = currentArea;
            this.coordinator.reset();
            this.groupsUpToDate = false;
        }
        class_1923 currentChunk = new class_1923(RedstoneEspHack.MC.field_1724.method_24515());
        if (!this.stickyArea.isChecked() && !currentChunk.equals((Object)this.lastPlayerChunk)) {
            this.lastPlayerChunk = currentChunk;
            this.coordinator.reset();
            this.groupsUpToDate = false;
        }
        if (searchersChanged = this.coordinator.update()) {
            this.groupsUpToDate = false;
        }
        if ((matchesVersion = this.coordinator.getMatchesVersion()) != this.lastMatchesVersion) {
            this.lastMatchesVersion = matchesVersion;
            this.groupsUpToDate = false;
        }
        if (!this.groupsUpToDate && this.coordinator.isDone()) {
            this.updateGroupBoxes();
        }
    }

    @Override
    public void onCameraTransformViewBobbing(CameraTransformViewBobbingListener.CameraTransformViewBobbingEvent event) {
        if (((EspStyleSetting.EspStyle)((Object)this.style.getSelected())).hasLines()) {
            event.cancel();
        }
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        if (((EspStyleSetting.EspStyle)((Object)this.style.getSelected())).hasBoxes()) {
            this.renderBoxes(matrixStack);
        }
        if (((EspStyleSetting.EspStyle)((Object)this.style.getSelected())).hasLines()) {
            this.renderTracers(matrixStack, partialTicks);
        }
    }

    private void renderBoxes(class_4587 matrixStack) {
        for (RenderGroup group : this.renderGroups) {
            if (!group.isEnabled()) continue;
            List<class_238> boxes = group.getBoxes();
            int quadsColor = group.getColorI(64);
            int linesColor = group.getColorI(128);
            RenderUtils.drawSolidBoxes(matrixStack, boxes, quadsColor, false);
            RenderUtils.drawOutlinedBoxes(matrixStack, boxes, linesColor, false);
        }
    }

    private void renderTracers(class_4587 matrixStack, float partialTicks) {
        for (RenderGroup group : this.renderGroups) {
            if (!group.isEnabled()) continue;
            List<class_238> boxes = group.getBoxes();
            List<class_243> ends = boxes.stream().map(class_238::method_1005).toList();
            int color = group.getColorI(128);
            RenderUtils.drawTracers(matrixStack, partialTicks, ends, color, false);
        }
    }

    private void updateGroupBoxes() {
        this.renderGroups.forEach(RenderGroup::clear);
        this.coordinator.getMatches().forEach(this::addToGroupBoxes);
        this.groupsUpToDate = true;
        int total = this.renderGroups.stream().mapToInt(g -> g.getBoxes().size()).sum();
        this.foundCount = Math.min(total, 999);
    }

    private void addToGroupBoxes(ChunkSearcher.Result result) {
        if (this.onlyAboveGround.isChecked() && (double)result.pos().method_10264() < this.aboveGroundY.getValue()) {
            return;
        }
        class_2248 b = result.state().method_26204();
        for (RenderGroup group : this.renderGroups) {
            if (!group.matches(b)) continue;
            group.add(result.pos());
            break;
        }
    }

    @Override
    public String getRenderName() {
        String base = this.getName();
        if (this.showCountInHackList.isChecked() && this.foundCount > 0) {
            return base + " [" + this.foundCount + "]";
        }
        return base;
    }

    private static RenderGroup wrap(final PortalEspBlockGroup g) {
        return new RenderGroup(){

            @Override
            public boolean isEnabled() {
                return g.isEnabled();
            }

            @Override
            public boolean matches(class_2248 b) {
                return g.getBlock() == b;
            }

            @Override
            public void add(class_2338 pos) {
                g.add(pos);
            }

            @Override
            public void clear() {
                g.clear();
            }

            @Override
            public List<class_238> getBoxes() {
                return g.getBoxes();
            }

            @Override
            public int getColorI(int alpha) {
                return g.getColorI(alpha);
            }

            @Override
            public Stream<Setting> getSettings() {
                return g.getSettings();
            }
        };
    }

    private static final class MultiBlockEspGroup
    implements RenderGroup {
        private final ArrayList<class_238> boxes = new ArrayList();
        private final Set<class_2248> blocks;
        private final ColorSetting color;
        private final CheckboxSetting enabled;

        private MultiBlockEspGroup(Set<class_2248> blocks, ColorSetting color, CheckboxSetting enabled) {
            this.blocks = new HashSet<class_2248>(blocks);
            this.color = Objects.requireNonNull(color);
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled == null || this.enabled.isChecked();
        }

        @Override
        public boolean matches(class_2248 b) {
            return this.blocks.contains(b);
        }

        @Override
        public void add(class_2338 pos) {
            if (!this.isEnabled()) {
                return;
            }
            if (!BlockUtils.canBeClicked(pos)) {
                return;
            }
            class_238 box = BlockUtils.getBoundingBox(pos);
            if (box.method_995() == 0.0) {
                return;
            }
            this.boxes.add(box);
        }

        @Override
        public void clear() {
            this.boxes.clear();
        }

        @Override
        public List<class_238> getBoxes() {
            return Collections.unmodifiableList(this.boxes);
        }

        @Override
        public int getColorI(int alpha) {
            return this.color.getColorI(alpha);
        }

        @Override
        public Stream<Setting> getSettings() {
            return Stream.of(this.enabled, this.color).filter(Objects::nonNull);
        }
    }

    private static interface RenderGroup {
        public boolean isEnabled();

        public boolean matches(class_2248 var1);

        public void add(class_2338 var1);

        public void clear();

        public List<class_238> getBoxes();

        public int getColorI(int var1);

        public Stream<Setting> getSettings();
    }
}

