/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.events.ChatInputListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.DontSaveState;
import net.wurstclient.hack.Hack;
import net.wurstclient.seedmapper.SeedMapperData;
import net.wurstclient.seedmapper.VendorSeedMapperLoader;
import net.wurstclient.settings.ButtonSetting;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.EnumSetting;
import net.wurstclient.settings.Setting;
import net.wurstclient.settings.SettingGroup;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.settings.SpacerSetting;
import net.wurstclient.settings.StringDropdownSetting;
import net.wurstclient.settings.TextFieldSetting;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.text.WText;

@DontSaveState
@SearchTags(value={"SeedMapper", "seed mapper", "seedmap", "Seed Mapper Helper"})
public final class SeedMapperHelperHack
extends Hack
implements ChatInputListener,
UpdateListener {
    private static final Predicate<String> SEED_VALIDATOR = value -> value == null || value.isEmpty() || value.matches("-?\\d+");
    private static final Predicate<String> AMOUNT_VALIDATOR = value -> value == null || value.isEmpty() || value.matches("\\d+");
    private static final Predicate<String> ENCHANT_LEVEL_VALIDATOR = value -> {
        if (value == null || value.isEmpty()) {
            return true;
        }
        if (value.equals("*")) {
            return true;
        }
        return value.matches("\\d+");
    };
    private static final Predicate<String> COORDINATE_VALIDATOR = value -> {
        if (value == null || value.isEmpty()) {
            return true;
        }
        return value.matches("^[~^]?$") || value.matches("^[~^]?-?\\d+(?:\\.\\d+)?$") || value.matches("-?\\d+(?:\\.\\d+)?");
    };
    private static final Predicate<String> ROTATION_VALIDATOR = value -> value == null || value.isEmpty() || value.matches("-?\\d+(?:\\.\\d+)?");
    private static final Pattern CSV_SPLIT = Pattern.compile("\\s*,\\s*");
    private static final Pattern SEED_RESPONSE_PATTERN = Pattern.compile("(?i)seed(?:\\s+is)?(?:\\s+currently)?(?:\\s+set)?(?:\\s+to)?\\s*(-?\\d+)");
    private final SeedMapperData data = VendorSeedMapperLoader.getData();
    private final ButtonSetting statusButton = new ButtonSetting("Check SeedMapper status", this::reportStatus);
    private final ButtonSetting seedMapButton = new ButtonSetting("Open Seed Map UI", this::openSeedMapUi);
    private final ButtonSetting minimapButton = new ButtonSetting("Open SeedMap minimap", this::openSeedMapMinimap);
    private final ButtonSetting enableMinimapButton = new ButtonSetting("Show SeedMap minimap", () -> this.setMinimapEnabled(true));
    private final ButtonSetting disableMinimapButton = new ButtonSetting("Hide SeedMap minimap", () -> this.setMinimapEnabled(false));
    private final ButtonSetting clearOverlaysButton = new ButtonSetting("Clear overlays", this::clearOverlays);
    private final ButtonSetting checkSeedButton = new ButtonSetting("Check current seed", () -> this.runSimpleCommand("sm:checkseed", "check SeedMapper seed"));
    private final ButtonSetting stopTaskButton = new ButtonSetting("Stop locator threads", () -> this.runSimpleCommand("sm:stoptask", "cancel SeedMapper locator tasks"));
    private final CheckboxSetting showCommandFeedbackSetting = new CheckboxSetting("Show command feedback", true);
    private final TextFieldSetting seedCheckInputSetting = new TextFieldSetting("Seed set", "", SEED_VALIDATOR);
    private final ButtonSetting applySeedInputButton = new ButtonSetting("Set seed", this::applySeedInput);
    private final TextFieldSetting savedSeedValueSetting = new TextFieldSetting("Saved seed value", "", SEED_VALIDATOR);
    private final ButtonSetting addSavedSeedButton = new ButtonSetting("Add saved seed", this::addSavedSeed);
    private final TextFieldSetting seedResolutionOrderSetting = new TextFieldSetting("Seed resolution order", "COMMAND_SOURCE,SEED_CONFIG,SAVED_SEEDS_CONFIG");
    private final ButtonSetting applySeedResolutionOrderButton = new ButtonSetting("Apply resolution order", this::applySeedResolutionOrder);
    private final CheckboxSetting oreAirCheckSetting = new CheckboxSetting("Ore air check enabled", false);
    private final ButtonSetting applyOreAirCheckButton = new ButtonSetting("Apply OreAirCheck", this::applyOreAirCheck);
    private final CheckboxSetting clearSeedMapCachesSetting = new CheckboxSetting("Clear SeedMap caches on close", false);
    private final ButtonSetting applyClearSeedMapCachesButton = new ButtonSetting("Apply ClearSeedMapCachesOnClose", this::applyClearSeedMapCaches);
    private final SliderSetting seedMapThreadsSetting = new SliderSetting("Seed map threads", 4.0, 1.0, 32.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final ButtonSetting applySeedMapThreadsButton = new ButtonSetting("Apply SeedMapThreads", this::applySeedMapThreads);
    private final SliderSetting minimapOffsetXSetting = new SliderSetting("Minimap X offset", 4.0, 0.0, 512.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final ButtonSetting applyMinimapOffsetXButton = new ButtonSetting("Apply SeedMapMinimapOffsetX", this::applyMinimapOffsetX);
    private final SliderSetting minimapOffsetYSetting = new SliderSetting("Minimap Y offset", 4.0, 0.0, 512.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final ButtonSetting applyMinimapOffsetYButton = new ButtonSetting("Apply SeedMapMinimapOffsetY", this::applyMinimapOffsetY);
    private final SliderSetting minimapWidthSetting = new SliderSetting("Minimap width", 205.0, 64.0, 512.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final ButtonSetting applyMinimapWidthButton = new ButtonSetting("Apply SeedMapMinimapWidth", this::applyMinimapWidth);
    private final SliderSetting minimapHeightSetting = new SliderSetting("Minimap height", 205.0, 64.0, 512.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final ButtonSetting applyMinimapHeightButton = new ButtonSetting("Apply SeedMapMinimapHeight", this::applyMinimapHeight);
    private final CheckboxSetting minimapRotateSetting = new CheckboxSetting("Rotate minimap with player", true);
    private final ButtonSetting applyMinimapRotateButton = new ButtonSetting("Apply SeedMapMinimapRotateWithPlayer", this::applyMinimapRotateWithPlayer);
    private final SliderSetting minimapPixelsPerBiomeSetting = new SliderSetting("Minimap pixels per biome", 4.0, 0.05, 150.0, 0.05, SliderSetting.ValueDisplay.DECIMAL);
    private final ButtonSetting applyMinimapPixelsPerBiomeButton = new ButtonSetting("Apply SeedMapMinimapPixelsPerBiome", this::applyMinimapPixelsPerBiome);
    private final SliderSetting minimapIconScaleSetting = new SliderSetting("Minimap icon scale", 1.0, 0.25, 4.0, 0.05, SliderSetting.ValueDisplay.DECIMAL);
    private final ButtonSetting applyMinimapIconScaleButton = new ButtonSetting("Apply SeedMapMinimapIconScale", this::applyMinimapIconScale);
    private final SliderSetting minimapOpacitySetting = new SliderSetting("Minimap opacity", 1.0, 0.05, 1.0, 0.01, SliderSetting.ValueDisplay.DECIMAL);
    private final ButtonSetting applyMinimapOpacityButton = new ButtonSetting("Apply SeedMapMinimapOpacity", this::applyMinimapOpacity);
    private final SliderSetting pixelsPerBiomeSetting = new SliderSetting("Pixels per biome", 6.0, 1.0, 32.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final ButtonSetting applyPixelsPerBiomeButton = new ButtonSetting("Apply PixelsPerBiome", this::applyPixelsPerBiome);
    private final TextFieldSetting toggledFeaturesSetting = new TextFieldSetting("Toggled features", "");
    private final ButtonSetting applyToggledFeaturesButton = new ButtonSetting("Apply ToggledFeatures", this::applyToggledFeatures);
    private final CheckboxSetting devModeSetting = new CheckboxSetting("Dev mode enabled", false);
    private final ButtonSetting applyDevModeButton = new ButtonSetting("Apply DevMode", this::applyDevMode);
    private final SliderSetting espTimeoutMinutesSetting = new SliderSetting("ESP timeout minutes", 10.0, 1.0, 180.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final ButtonSetting applyEspTimeoutMinutesButton = new ButtonSetting("Apply EspTimeoutMinutes", this::applyEspTimeoutMinutes);
    private final List<EspProfile> espProfiles = new ArrayList<EspProfile>();
    private boolean connectionPreviouslyNull = true;
    private final EnumSetting<HighlightMode> highlightModeSetting = new EnumSetting("Highlight type", (Enum[])HighlightMode.values(), (Enum)HighlightMode.BLOCK);
    private final StringDropdownSetting highlightBlockSetting = new StringDropdownSetting("Highlight block", WText.literal("Used by /sm:highlight block."));
    private final SliderSetting highlightChunksSetting = new SliderSetting("Highlight chunk range", 4.0, 0.0, 20.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final ButtonSetting runHighlightButton = new ButtonSetting("Run highlight", this::runConfiguredHighlight);
    private final ButtonSetting clearHighlightButton = new ButtonSetting("Clear highlight", this::clearHighlight);
    private final StringDropdownSetting locateBiomeSetting = new StringDropdownSetting("Biome target", WText.literal("Biome keys for /sm:locate biome."));
    private final ButtonSetting runLocateBiomeButton = new ButtonSetting("Locate biome", this::runLocateBiome);
    private final StringDropdownSetting locateStructureSetting = new StringDropdownSetting("Structure target", WText.literal("Structure key for /sm:locate feature."));
    private final TextFieldSetting structurePieceFiltersField = new TextFieldSetting("Piece filters", "");
    private final TextFieldSetting structureVariantFiltersField = new TextFieldSetting("Variant filters", "");
    private final StringDropdownSetting structurePiecePicker = new StringDropdownSetting("Piece presets", WText.literal("Pieces applicable to fortress & end_city."));
    private final StringDropdownSetting structureVariantPicker = new StringDropdownSetting("Variant presets", WText.literal("Variants for structures plus biome/rotation/mirrored."));
    private final EnumSetting<VariantDataMode> variantDataSetting = new EnumSetting("Variant data", (Enum[])VariantDataMode.values(), (Enum)VariantDataMode.AUTO);
    private final ButtonSetting addPieceFilterButton = new ButtonSetting("Add piece filter", this::addStructurePiece);
    private final ButtonSetting clearPieceFiltersButton = new ButtonSetting("Clear piece filters", () -> this.structurePieceFiltersField.setValue(""));
    private final ButtonSetting addVariantFilterButton = new ButtonSetting("Add variant filter", this::addStructureVariant);
    private final ButtonSetting clearVariantFiltersButton = new ButtonSetting("Clear variant filters", () -> this.structureVariantFiltersField.setValue(""));
    private final ButtonSetting runLocateStructureButton = new ButtonSetting("Locate structure", this::runLocateStructure);
    private final TextFieldSetting locateLootAmountSetting = new TextFieldSetting("Loot amount", "1", AMOUNT_VALIDATOR);
    private final StringDropdownSetting locateLootItemSetting = new StringDropdownSetting("Loot item predicate", WText.literal("Keys from ItemAndEnchantmentsPredicateArgument."));
    private final EnumSetting<LootClauseType> lootClauseTypeSetting = new EnumSetting("Enchant clause", (Enum[])LootClauseType.values(), (Enum)LootClauseType.NONE);
    private final StringDropdownSetting lootEnchantPicker = new StringDropdownSetting("Enchant key", WText.literal("Keys from ENCHANTMENTS."));
    private final TextFieldSetting lootEnchantLevelSetting = new TextFieldSetting("Enchant level", "*", ENCHANT_LEVEL_VALIDATOR);
    private final ButtonSetting runLocateLootButton = new ButtonSetting("Locate loot", this::runLocateLoot);
    private final StringDropdownSetting locateOreVeinSetting = new StringDropdownSetting("Ore vein target", WText.literal("Choices for /sm:locate orevein."));
    private final ButtonSetting runLocateOreVeinButton = new ButtonSetting("Locate ore vein", this::runLocateOreVein);
    private final ButtonSetting runLocateSlimeChunkButton = new ButtonSetting("Locate slime chunk", () -> this.runLocateSimple("sm:locate slimechunk", "locate a slime chunk"));
    private final ButtonSetting runLocateSpawnButton = new ButtonSetting("Locate spawn", () -> this.runLocateSimple("sm:locate spawn", "locate spawn chunks"));
    private final ButtonSetting runLocateCanyonButton = new ButtonSetting("Locate canyon", () -> this.runLocateSimple("sm:locate canyon", "locate canyon carvers"));
    private final TextFieldSetting sourceSeedSetting = new TextFieldSetting("Source seed override", "", SEED_VALIDATOR);
    private final StringDropdownSetting sourceDimensionSetting = new StringDropdownSetting("Source dimension", WText.literal("Optional /sm:source in <dimension>."));
    private final StringDropdownSetting sourceVersionPresetSetting = new StringDropdownSetting("Source version presets", WText.literal("Available /sm:source versioned keys."));
    private final StringDropdownSetting worldPresetSetting = new StringDropdownSetting("World preset", WText.literal("World generation presets for /sm:preset set."));
    private final ButtonSetting listWorldPresetsButton = new ButtonSetting("List presets", () -> this.runSimpleCommand("sm:preset list", "list presets"));
    private final ButtonSetting applyWorldPresetButton = new ButtonSetting("Set selected preset", this::applyWorldPreset);
    private final TextFieldSetting sourceVersionSetting = new TextFieldSetting("Source version override", "");
    private final TextFieldSetting sourceSelectorSetting = new TextFieldSetting("Source selector (as ...)", "");
    private final TextFieldSetting sourcePosXSetting = new TextFieldSetting("Source pos X", "", COORDINATE_VALIDATOR);
    private final TextFieldSetting sourcePosYSetting = new TextFieldSetting("Source pos Y", "", COORDINATE_VALIDATOR);
    private final TextFieldSetting sourcePosZSetting = new TextFieldSetting("Source pos Z", "", COORDINATE_VALIDATOR);
    private final TextFieldSetting sourceYawSetting = new TextFieldSetting("Rotate yaw", "", ROTATION_VALIDATOR);
    private final TextFieldSetting sourcePitchSetting = new TextFieldSetting("Rotate pitch", "", ROTATION_VALIDATOR);
    private final TextFieldSetting sourceCommandSetting = new TextFieldSetting("Command for sm:source run", "");
    private final ButtonSetting applyVersionPresetButton = new ButtonSetting("Use selected version preset", this::applyVersionPreset);
    private final ButtonSetting runSourceButton = new ButtonSetting("Run source", this::runSourceCommand);
    private final ButtonSetting resetSourceFormButton = new ButtonSetting("Reset source builder", this::resetSourceForm);

    public SeedMapperHelperHack() {
        super("SeedMapperHelper");
        this.setCategory(Category.OTHER);
        this.addPossibleKeybind(".say /sm:clear", "SeedMapper: Clear overlays");
        this.addPossibleKeybind(".say /sm:stoptask", "SeedMapper: Stop locator tasks");
        this.addPossibleKeybind(".say /sm:seedmap", "SeedMapper: Open Seed Map UI");
        this.addPossibleKeybind(".say /sm:minimap on", "SeedMapper: Show minimap overlay");
        this.addPossibleKeybind(".say /sm:minimap off", "SeedMapper: Hide minimap overlay");
        this.addPossibleKeybind(".say /sm:seedcheck", "SeedMapper: Check current seed");
        this.addPossibleKeybind(".seedmapperhelper map", "SeedMapper: Open Seed Map UI");
        this.addPossibleKeybind(".seedmapperhelper highlight", "SeedMapper: Run highlight");
        this.addPossibleKeybind(".seedmapperhelper clearhighlight", "SeedMapper: Clear highlight");
        this.highlightBlockSetting.setOptions(this.data.getHighlightBlocks());
        this.autoSelectFirst(this.highlightBlockSetting, this.data.getHighlightBlocks());
        this.locateBiomeSetting.setOptions(this.data.getBiomeKeys());
        this.autoSelectFirst(this.locateBiomeSetting, this.data.getBiomeKeys());
        List<String> structures = this.data.getStructureKeys();
        this.locateStructureSetting.setOptions(structures);
        this.autoSelectFirst(this.locateStructureSetting, structures);
        this.structurePiecePicker.setOptions(this.flattenOptionUnion(this.data, true));
        this.structureVariantPicker.setOptions(this.flattenOptionUnion(this.data, false));
        this.autoSelectFirst(this.structureVariantPicker, this.data.getVariantKeyUnion());
        this.locateLootItemSetting.setOptions(this.data.getLootItems());
        this.autoSelectFirst(this.locateLootItemSetting, this.data.getLootItems());
        this.lootEnchantPicker.setOptions(this.data.getLootEnchantments());
        this.autoSelectFirst(this.lootEnchantPicker, this.data.getLootEnchantments());
        this.locateOreVeinSetting.setOptions(this.data.getOreVeinTargets());
        this.autoSelectFirst(this.locateOreVeinSetting, this.data.getOreVeinTargets());
        this.sourceDimensionSetting.setOptions(this.data.getDimensionShortcuts());
        this.sourceVersionPresetSetting.setOptions(this.data.getVersionShortcuts());
        this.worldPresetSetting.setOptions(this.data.getWorldPresets());
        this.autoSelectFirst(this.worldPresetSetting, this.data.getWorldPresets());
        this.addSetting(this.statusButton);
        this.addSetting(this.seedMapButton);
        this.addSetting(this.minimapButton);
        this.addSetting(this.enableMinimapButton);
        this.addSetting(this.disableMinimapButton);
        this.addSetting(this.clearOverlaysButton);
        this.addSetting(this.checkSeedButton);
        this.addSetting(this.seedCheckInputSetting);
        this.addSetting(this.applySeedInputButton);
        this.addSetting(this.stopTaskButton);
        this.addSetting(this.showCommandFeedbackSetting);
        this.addSetting(this.savedSeedValueSetting);
        this.addSetting(this.addSavedSeedButton);
        this.addSetting(this.seedResolutionOrderSetting);
        this.addSetting(this.applySeedResolutionOrderButton);
        this.addSetting(this.oreAirCheckSetting);
        this.addSetting(this.applyOreAirCheckButton);
        this.addSetting(this.clearSeedMapCachesSetting);
        this.addSetting(this.applyClearSeedMapCachesButton);
        this.addSetting(this.listWorldPresetsButton);
        this.addSetting(this.worldPresetSetting);
        this.addSetting(this.applyWorldPresetButton);
        this.addSetting(this.seedMapThreadsSetting);
        this.addSetting(this.applySeedMapThreadsButton);
        this.addSetting(this.minimapOffsetXSetting);
        this.addSetting(this.applyMinimapOffsetXButton);
        this.addSetting(this.minimapOffsetYSetting);
        this.addSetting(this.applyMinimapOffsetYButton);
        this.addSetting(this.minimapWidthSetting);
        this.addSetting(this.applyMinimapWidthButton);
        this.addSetting(this.minimapHeightSetting);
        this.addSetting(this.applyMinimapHeightButton);
        this.addSetting(this.minimapRotateSetting);
        this.addSetting(this.applyMinimapRotateButton);
        this.addSetting(this.minimapPixelsPerBiomeSetting);
        this.addSetting(this.applyMinimapPixelsPerBiomeButton);
        this.addSetting(this.minimapIconScaleSetting);
        this.addSetting(this.applyMinimapIconScaleButton);
        this.addSetting(this.minimapOpacitySetting);
        this.addSetting(this.applyMinimapOpacityButton);
        this.addSetting(this.pixelsPerBiomeSetting);
        this.addSetting(this.applyPixelsPerBiomeButton);
        this.addSetting(this.toggledFeaturesSetting);
        this.addSetting(this.applyToggledFeaturesButton);
        this.addSetting(this.devModeSetting);
        this.addSetting(this.applyDevModeButton);
        this.addSetting(this.espTimeoutMinutesSetting);
        this.addSetting(this.applyEspTimeoutMinutesButton);
        this.addSection("SeedMapper commands", "General-purpose SeedMapper actions.", this.statusButton, this.seedMapButton, this.minimapButton, this.enableMinimapButton, this.disableMinimapButton, this.clearOverlaysButton, this.checkSeedButton, this.seedCheckInputSetting, this.applySeedInputButton, this.stopTaskButton, this.showCommandFeedbackSetting);
        this.addSection("SeedMapper config", "Convenience controls for /sm:config.", this.savedSeedValueSetting, this.addSavedSeedButton, this.seedResolutionOrderSetting, this.applySeedResolutionOrderButton, this.oreAirCheckSetting, this.applyOreAirCheckButton, this.clearSeedMapCachesSetting, this.applyClearSeedMapCachesButton, this.listWorldPresetsButton, this.worldPresetSetting, this.applyWorldPresetButton, this.seedMapThreadsSetting, this.applySeedMapThreadsButton, this.pixelsPerBiomeSetting, this.applyPixelsPerBiomeButton, this.toggledFeaturesSetting, this.applyToggledFeaturesButton, this.devModeSetting, this.applyDevModeButton, this.espTimeoutMinutesSetting, this.applyEspTimeoutMinutesButton);
        this.addSection("SeedMap minimap", "Configure the in-game minimap overlay.", this.minimapOffsetXSetting, this.applyMinimapOffsetXButton, this.minimapOffsetYSetting, this.applyMinimapOffsetYButton, this.minimapWidthSetting, this.applyMinimapWidthButton, this.minimapHeightSetting, this.applyMinimapHeightButton, this.minimapRotateSetting, this.applyMinimapRotateButton, this.minimapPixelsPerBiomeSetting, this.applyMinimapPixelsPerBiomeButton, this.minimapIconScaleSetting, this.applyMinimapIconScaleButton, this.minimapOpacitySetting, this.applyMinimapOpacityButton);
        this.addSetting(this.highlightModeSetting);
        this.addSetting(this.highlightBlockSetting);
        this.addSetting(this.highlightChunksSetting);
        this.addSetting(this.runHighlightButton);
        this.addSetting(this.clearHighlightButton);
        this.addSection("Highlighting", "Configure /sm:highlight.", this.highlightModeSetting, this.highlightBlockSetting, this.highlightChunksSetting, this.runHighlightButton, this.clearHighlightButton);
        this.addSetting(this.locateBiomeSetting);
        this.addSetting(this.runLocateBiomeButton);
        this.addSection("Biome locator", "Locate specific biome keys.", this.locateBiomeSetting, this.runLocateBiomeButton);
        this.addSetting(this.locateStructureSetting);
        this.addSetting(this.structurePieceFiltersField);
        this.addSetting(this.structurePiecePicker);
        this.addSetting(this.addPieceFilterButton);
        this.addSetting(this.clearPieceFiltersButton);
        this.addSetting(this.structureVariantFiltersField);
        this.addSetting(this.structureVariantPicker);
        this.addSetting(this.addVariantFilterButton);
        this.addSetting(this.clearVariantFiltersButton);
        this.addSetting(this.variantDataSetting);
        this.addSetting(this.runLocateStructureButton);
        this.addSection("Structure locator", "Compose /sm:locate feature commands.", this.locateStructureSetting, this.structurePieceFiltersField, this.structurePiecePicker, this.addPieceFilterButton, this.clearPieceFiltersButton, this.structureVariantFiltersField, this.structureVariantPicker, this.addVariantFilterButton, this.clearVariantFiltersButton, this.variantDataSetting, this.runLocateStructureButton);
        this.addSetting(this.locateLootAmountSetting);
        this.addSetting(this.locateLootItemSetting);
        this.addSetting(this.lootClauseTypeSetting);
        this.addSetting(this.lootEnchantPicker);
        this.addSetting(this.lootEnchantLevelSetting);
        this.addSetting(this.runLocateLootButton);
        this.addSection("Loot locator", "Search loot tables and enchantments.", this.locateLootAmountSetting, this.locateLootItemSetting, this.lootClauseTypeSetting, this.lootEnchantPicker, this.lootEnchantLevelSetting, this.runLocateLootButton);
        this.addSetting(this.locateOreVeinSetting);
        this.addSetting(this.runLocateOreVeinButton);
        this.addSetting(this.runLocateSlimeChunkButton);
        this.addSetting(this.runLocateSpawnButton);
        this.addSetting(this.runLocateCanyonButton);
        this.addSection("Other locators", "Extra /sm:locate helpers.", this.locateOreVeinSetting, this.runLocateOreVeinButton, this.runLocateSlimeChunkButton, this.runLocateSpawnButton, this.runLocateCanyonButton);
        this.addSetting(this.sourceSeedSetting);
        this.addSetting(this.sourceDimensionSetting);
        this.addSetting(this.sourceVersionPresetSetting);
        this.addSetting(this.sourceVersionSetting);
        this.addSetting(this.sourceSelectorSetting);
        this.addSetting(this.sourcePosXSetting);
        this.addSetting(this.sourcePosYSetting);
        this.addSetting(this.sourcePosZSetting);
        this.addSetting(this.sourceYawSetting);
        this.addSetting(this.sourcePitchSetting);
        this.addSetting(this.sourceCommandSetting);
        this.addSetting(this.applyVersionPresetButton);
        this.addSetting(this.runSourceButton);
        this.addSetting(this.resetSourceFormButton);
        this.addSection("Source builder", "Build /sm:source commands.", this.sourceSeedSetting, this.sourceDimensionSetting, this.sourceVersionPresetSetting, this.sourceVersionSetting, this.sourceSelectorSetting, this.sourcePosXSetting, this.sourcePosYSetting, this.sourcePosZSetting, this.sourceYawSetting, this.sourcePitchSetting, this.sourceCommandSetting, this.applyVersionPresetButton, this.runSourceButton, this.resetSourceFormButton);
        this.initEspProfiles();
        EVENTS.add(ChatInputListener.class, this);
        EVENTS.add(UpdateListener.class, this);
    }

    @Override
    protected void onEnable() {
        this.reportStatus();
        this.setEnabled(false);
    }

    private void reportStatus() {
        boolean available = VendorSeedMapperLoader.isSeedMapperPresent();
        Optional<String> version = VendorSeedMapperLoader.getDetectedVersion();
        if (available) {
            ChatUtils.message("SeedMapper detected (version " + version.orElse("unknown") + ").");
        } else {
            ChatUtils.warning("SeedMapper isn't installed or failed to load. Commands will be blocked.");
        }
    }

    @Override
    public void onReceivedMessage(ChatInputListener.ChatInputEvent event) {
        if (event.getComponent() == null) {
            return;
        }
        String message = event.getComponent().getString();
        if (message == null || message.isEmpty()) {
            return;
        }
        String trimmed = message.trim();
        if (trimmed.isEmpty()) {
            return;
        }
        this.handleSeedCheckFeedback(trimmed);
        for (EspProfile profile : this.espProfiles) {
            if (!profile.handleChatFeedback(trimmed)) continue;
            event.cancel();
            break;
        }
    }

    @Override
    public void onUpdate() {
        boolean connected;
        boolean bl = connected = MC.method_1562() != null;
        if (connected && this.connectionPreviouslyNull) {
            this.connectionPreviouslyNull = false;
            if (VendorSeedMapperLoader.isSeedMapperPresent()) {
                this.requestAllEspStates(true);
            }
        } else if (!connected) {
            this.connectionPreviouslyNull = true;
        }
    }

    public void openSeedMapUi() {
        this.runSimpleCommand("sm:seedmap", "open the Seed Mapper UI");
    }

    public void openSeedMapMinimap() {
        this.runSimpleCommand("sm:minimap", "open the SeedMap minimap");
    }

    private void setMinimapEnabled(boolean enabled) {
        this.runSimpleCommand("sm:minimap " + (enabled ? "on" : "off"), (enabled ? "enable" : "disable") + " the SeedMap minimap");
    }

    public void clearOverlays() {
        this.runSimpleCommand("sm:clear", "clear SeedMapper overlays");
    }

    public void runConfiguredHighlight() {
        this.runHighlightCommand();
    }

    public void clearHighlight() {
        this.sendSeedMapperCommand("sm:highlight clear", "clear highlights", false, this.showCommandFeedbackSetting.isChecked());
    }

    private void runHighlightCommand() {
        String command;
        HighlightMode mode = this.highlightModeSetting.getSelected();
        int chunks = Math.min(mode.maxChunks, this.highlightChunksSetting.getValueI());
        switch (mode.ordinal()) {
            case 0: {
                String block = this.highlightBlockSetting.getSelected();
                if (block.isEmpty()) {
                    ChatUtils.error("Select a block to highlight.");
                    return;
                }
                command = "sm:highlight block " + block + " " + chunks;
                break;
            }
            case 1: {
                command = "sm:highlight orevein " + chunks;
                break;
            }
            default: {
                return;
            }
        }
        this.runSimpleCommand(command, "run sm:highlight");
    }

    private void runLocateBiome() {
        String biome = this.locateBiomeSetting.getSelected();
        if (biome.isEmpty()) {
            ChatUtils.error("Select a biome to locate.");
            return;
        }
        this.runSimpleCommand("sm:locate biome " + biome, "locate biome " + biome);
    }

    private void addStructurePiece() {
        String structure = this.locateStructureSetting.getSelected();
        if (structure.isEmpty()) {
            ChatUtils.error("Select a structure before adding pieces.");
            return;
        }
        if (!this.data.supportsPieceFilters(structure)) {
            ChatUtils.warning("The selected structure does not support piece filters.");
            return;
        }
        String piece = this.structurePiecePicker.getSelected();
        if (piece.isEmpty()) {
            ChatUtils.error("Pick a piece to add.");
            return;
        }
        List<String> validPieces = this.data.getStructurePieces(structure);
        if (!validPieces.contains(piece)) {
            ChatUtils.error("\"" + piece + "\" isn't valid for " + structure + ".");
            return;
        }
        LinkedHashSet<String> values = this.parseCsv(this.structurePieceFiltersField.getValue());
        if (values.add(piece)) {
            this.structurePieceFiltersField.setValue(this.joinCsv(values));
        }
    }

    private void addStructureVariant() {
        boolean supported;
        String structure = this.locateStructureSetting.getSelected();
        if (structure.isEmpty()) {
            ChatUtils.error("Select a structure before adding variants.");
            return;
        }
        String variant = this.structureVariantPicker.getSelected();
        if (variant.isEmpty()) {
            ChatUtils.error("Pick a variant to add.");
            return;
        }
        boolean isGeneric = this.data.getGenericVariantKeys().contains(variant);
        boolean bl = supported = this.data.supportsVariantFilters(structure) || isGeneric;
        if (!supported) {
            ChatUtils.warning("Variants are not supported for " + structure + ".");
            return;
        }
        if (!isGeneric && !this.data.getStructureVariants(structure).contains(variant)) {
            ChatUtils.error("\"" + variant + "\" isn't valid for " + structure + ".");
            return;
        }
        LinkedHashSet<String> values = this.parseCsv(this.structureVariantFiltersField.getValue());
        if (values.add(variant)) {
            this.structureVariantFiltersField.setValue(this.joinCsv(values));
        }
    }

    private void runLocateStructure() {
        String structure = this.locateStructureSetting.getSelected();
        if (structure.isEmpty()) {
            ChatUtils.error("Select a structure to locate.");
            return;
        }
        StringBuilder builder = new StringBuilder("sm:locate feature ").append(structure);
        String filter = this.buildBracketFilters(this.structurePieceFiltersField, this.structureVariantFiltersField);
        if (!filter.isEmpty()) {
            builder.append(filter);
        }
        switch (this.variantDataSetting.getSelected().ordinal()) {
            case 1: {
                builder.append(" variantdata true");
                break;
            }
            case 2: {
                builder.append(" variantdata false");
                break;
            }
        }
        this.runSimpleCommand(builder.toString(), "locate feature " + structure);
    }

    private void runLocateLoot() {
        String item = this.locateLootItemSetting.getSelected();
        if (item.isEmpty()) {
            ChatUtils.error("Select an item predicate.");
            return;
        }
        int amount = this.parsePositiveInt(this.locateLootAmountSetting.getValue(), 1);
        if (amount <= 0) {
            ChatUtils.error("Loot amount must be greater than zero.");
            return;
        }
        StringBuilder predicate = new StringBuilder(item);
        LootClauseType clause = this.lootClauseTypeSetting.getSelected();
        if (clause != LootClauseType.NONE) {
            String enchant = this.lootEnchantPicker.getSelected();
            if (enchant.isEmpty()) {
                ChatUtils.error("Select an enchantment to use.");
                return;
            }
            String level = this.lootEnchantLevelSetting.getValue().trim();
            if (level.isEmpty()) {
                level = "*";
            }
            if (!ENCHANT_LEVEL_VALIDATOR.test(level)) {
                ChatUtils.error("Invalid enchantment level. Use digits or *.");
                return;
            }
            predicate.append(" ").append(clause.keyword).append(" ").append(enchant).append(" ").append(level);
        }
        String command = "sm:locate loot " + amount + " " + String.valueOf(predicate);
        this.runSimpleCommand(command, "locate loot " + item);
    }

    private void runLocateOreVein() {
        String target = this.locateOreVeinSetting.getSelected();
        if (target.isEmpty()) {
            ChatUtils.error("Select an ore vein type.");
            return;
        }
        this.runSimpleCommand("sm:locate orevein " + target, "locate " + target + " vein");
    }

    private void runLocateSimple(String command, String label) {
        this.runSimpleCommand(command, label);
    }

    private void applySeedInput() {
        String seed = this.seedCheckInputSetting.getValue().trim();
        if (seed.isEmpty()) {
            ChatUtils.error("Enter a seed to set.");
            return;
        }
        if (!SEED_VALIDATOR.test(seed)) {
            ChatUtils.error("Invalid seed value.");
            return;
        }
        this.runSimpleCommand("sm:config Seed set " + seed, "set seed to " + seed);
    }

    private void addSavedSeed() {
        String seed = this.savedSeedValueSetting.getValue().trim();
        if (seed.isEmpty()) {
            ChatUtils.error("Enter a seed to save.");
            return;
        }
        if (!SEED_VALIDATOR.test(seed)) {
            ChatUtils.error("Invalid seed value.");
            return;
        }
        this.runSimpleCommand("sm:config SavedSeeds add " + seed, "add saved seed " + seed);
    }

    private void applySeedResolutionOrder() {
        String order = this.seedResolutionOrderSetting.getValue().trim();
        if (order.isEmpty()) {
            ChatUtils.error("Enter a comma-separated resolution order.");
            return;
        }
        String normalized = order.replace(" ", "");
        this.runSimpleCommand("sm:config SeedResolutionOrder set " + normalized, "set SeedResolutionOrder");
    }

    private void applyOreAirCheck() {
        this.runSimpleCommand("sm:config OreAirCheck set " + this.oreAirCheckSetting.isChecked(), "set OreAirCheck");
    }

    private void applyClearSeedMapCaches() {
        this.runSimpleCommand("sm:config ClearSeedMapCachesOnClose set " + this.clearSeedMapCachesSetting.isChecked(), "set ClearSeedMapCachesOnClose");
    }

    private void applySeedMapThreads() {
        int threads = Math.max(1, this.seedMapThreadsSetting.getValueI());
        this.runSimpleCommand("sm:config SeedMapThreads set " + threads, "set SeedMapThreads");
    }

    private void applyMinimapOffsetX() {
        int offset = this.minimapOffsetXSetting.getValueI();
        this.runSimpleCommand("sm:config SeedMapMinimapOffsetX set " + offset, "set SeedMapMinimapOffsetX");
    }

    private void applyMinimapOffsetY() {
        int offset = this.minimapOffsetYSetting.getValueI();
        this.runSimpleCommand("sm:config SeedMapMinimapOffsetY set " + offset, "set SeedMapMinimapOffsetY");
    }

    private void applyMinimapWidth() {
        int width = this.minimapWidthSetting.getValueI();
        this.runSimpleCommand("sm:config SeedMapMinimapWidth set " + width, "set SeedMapMinimapWidth");
    }

    private void applyMinimapHeight() {
        int height = this.minimapHeightSetting.getValueI();
        this.runSimpleCommand("sm:config SeedMapMinimapHeight set " + height, "set SeedMapMinimapHeight");
    }

    private void applyMinimapRotateWithPlayer() {
        this.runSimpleCommand("sm:config SeedMapMinimapRotateWithPlayer set " + this.minimapRotateSetting.isChecked(), "set SeedMapMinimapRotateWithPlayer");
    }

    private void applyMinimapPixelsPerBiome() {
        double pixels = this.minimapPixelsPerBiomeSetting.getValue();
        this.runSimpleCommand("sm:config SeedMapMinimapPixelsPerBiome set " + SeedMapperHelperHack.formatDouble(pixels), "set SeedMapMinimapPixelsPerBiome");
    }

    private void applyMinimapIconScale() {
        double scale = this.minimapIconScaleSetting.getValue();
        this.runSimpleCommand("sm:config SeedMapMinimapIconScale set " + SeedMapperHelperHack.formatDouble(scale), "set SeedMapMinimapIconScale");
    }

    private void applyMinimapOpacity() {
        double opacity = this.minimapOpacitySetting.getValue();
        this.runSimpleCommand("sm:config SeedMapMinimapOpacity set " + SeedMapperHelperHack.formatDouble(opacity), "set SeedMapMinimapOpacity");
    }

    private void applyPixelsPerBiome() {
        double pixels = this.pixelsPerBiomeSetting.getValue();
        this.runSimpleCommand("sm:config PixelsPerBiome set " + SeedMapperHelperHack.formatDouble(pixels), "set PixelsPerBiome");
    }

    private void applyToggledFeatures() {
        String features = this.toggledFeaturesSetting.getValue().trim();
        if (features.isEmpty()) {
            ChatUtils.error("Enter at least one feature name.");
            return;
        }
        String normalized = features.replace(" ", "");
        this.runSimpleCommand("sm:config ToggledFeatures set " + normalized, "set ToggledFeatures");
    }

    private void applyDevMode() {
        this.runSimpleCommand("sm:config DevMode set " + this.devModeSetting.isChecked(), "set DevMode");
    }

    private void applyEspTimeoutMinutes() {
        int minutes = Math.max(1, this.espTimeoutMinutesSetting.getValueI());
        this.runSimpleCommand("sm:config EspTimeoutMinutes set " + minutes, "set EspTimeoutMinutes");
    }

    private void handleSeedCheckFeedback(String message) {
        boolean related;
        if (message == null || message.isEmpty()) {
            return;
        }
        String lower = message.toLowerCase(Locale.ROOT);
        if (!lower.contains("seed")) {
            return;
        }
        boolean bl = related = lower.contains("seedmapper") || lower.contains("sm:seedcheck") || lower.startsWith("seed ") || lower.startsWith("seed:") || lower.startsWith("current seed");
        if (!related) {
            return;
        }
        Matcher matcher = SEED_RESPONSE_PATTERN.matcher(message);
        if (matcher.find()) {
            this.seedCheckInputSetting.setValue(matcher.group(1));
            return;
        }
        if (lower.contains("no seed") || lower.contains("not set")) {
            this.seedCheckInputSetting.setValue("");
        }
    }

    private void applyVersionPreset() {
        String preset = this.sourceVersionPresetSetting.getSelected();
        if (preset.isEmpty()) {
            ChatUtils.error("Pick a version preset first.");
            return;
        }
        this.sourceVersionSetting.setValue(preset);
    }

    private void applyWorldPreset() {
        String preset = this.worldPresetSetting.getSelected();
        if (preset.isEmpty()) {
            ChatUtils.error("Pick a world preset first.");
            return;
        }
        this.runSimpleCommand("sm:preset set " + preset, "set world preset");
        this.worldPresetSetting.setSelected("");
    }

    private void resetSourceForm() {
        this.sourceSeedSetting.setValue("");
        this.sourceDimensionSetting.setSelected("");
        this.sourceVersionPresetSetting.setSelected("");
        this.sourceVersionSetting.setValue("");
        this.sourceSelectorSetting.setValue("");
        this.sourcePosXSetting.setValue("");
        this.sourcePosYSetting.setValue("");
        this.sourcePosZSetting.setValue("");
        this.sourceYawSetting.setValue("");
        this.sourcePitchSetting.setValue("");
        this.sourceCommandSetting.setValue("");
    }

    private void runSourceCommand() {
        String run;
        String rotated;
        String positioned;
        String selector;
        String dimension;
        String version;
        StringBuilder builder = new StringBuilder("sm:source");
        String seed = this.sourceSeedSetting.getValue().trim();
        if (!seed.isEmpty()) {
            if (!SEED_VALIDATOR.test(seed)) {
                ChatUtils.error("Invalid seed value.");
                return;
            }
            builder.append(" seeded ").append(seed);
        }
        if ((version = this.sourceVersionSetting.getValue().trim()).isEmpty()) {
            version = this.sourceVersionPresetSetting.getSelected();
        }
        if (version != null && !version.isEmpty()) {
            builder.append(" versioned ").append(version);
        }
        if (!(dimension = this.sourceDimensionSetting.getSelected()).isEmpty()) {
            builder.append(" in ").append(dimension);
        }
        if (!(selector = this.sourceSelectorSetting.getValue().trim()).isEmpty()) {
            builder.append(" as ").append(selector);
        }
        if ((positioned = this.buildCoordinateSegment(this.sourcePosXSetting, this.sourcePosYSetting, this.sourcePosZSetting)) == null) {
            return;
        }
        if (!positioned.isEmpty()) {
            builder.append(" positioned ").append(positioned);
        }
        if ((rotated = this.buildRotationSegment(this.sourceYawSetting, this.sourcePitchSetting)) == null) {
            return;
        }
        if (!rotated.isEmpty()) {
            builder.append(" rotated ").append(rotated);
        }
        if (!(run = this.sourceCommandSetting.getValue().trim()).isEmpty()) {
            builder.append(" run ").append(run);
        }
        this.runSimpleCommand(builder.toString(), "run sm:source");
    }

    private String buildCoordinateSegment(TextFieldSetting x, TextFieldSetting y, TextFieldSetting z) {
        boolean empty;
        String sx = x.getValue().trim();
        String sy = y.getValue().trim();
        String sz = z.getValue().trim();
        boolean bl = empty = sx.isEmpty() && sy.isEmpty() && sz.isEmpty();
        if (empty) {
            return "";
        }
        if (sx.isEmpty() || sy.isEmpty() || sz.isEmpty()) {
            ChatUtils.error("Fill out all coordinate fields or leave them blank.");
            return null;
        }
        if (!(COORDINATE_VALIDATOR.test(sx) && COORDINATE_VALIDATOR.test(sy) && COORDINATE_VALIDATOR.test(sz))) {
            ChatUtils.error("Coordinates can contain numbers with optional '~' or '^'.");
            return null;
        }
        return sx + " " + sy + " " + sz;
    }

    private String buildRotationSegment(TextFieldSetting yawSetting, TextFieldSetting pitchSetting) {
        boolean empty;
        String yaw = yawSetting.getValue().trim();
        String pitch = pitchSetting.getValue().trim();
        boolean bl = empty = yaw.isEmpty() && pitch.isEmpty();
        if (empty) {
            return "";
        }
        if (yaw.isEmpty() || pitch.isEmpty()) {
            ChatUtils.error("Provide both yaw and pitch for rotation or leave them blank.");
            return null;
        }
        if (!ROTATION_VALIDATOR.test(yaw) || !ROTATION_VALIDATOR.test(pitch)) {
            ChatUtils.error("Yaw and pitch must be numeric.");
            return null;
        }
        return yaw + " " + pitch;
    }

    private void runSimpleCommand(String command, String label) {
        this.sendSeedMapperCommand(command, label, false, this.showCommandFeedbackSetting.isChecked());
    }

    private boolean sendSeedMapperCommand(String command, String label, boolean silentErrors, boolean showFeedback) {
        if (!VendorSeedMapperLoader.isSeedMapperPresent()) {
            if (!silentErrors) {
                if (label == null || label.isEmpty()) {
                    ChatUtils.error("SeedMapper mod not detected. Cannot perform this action.");
                } else {
                    ChatUtils.error("SeedMapper mod not detected. Cannot " + label + ".");
                }
            }
            return false;
        }
        if (MC.method_1562() == null) {
            if (!silentErrors) {
                ChatUtils.error("Join a world before sending SeedMapper commands.");
            }
            return false;
        }
        MC.method_1562().method_45730(command);
        if (showFeedback) {
            ChatUtils.message("SeedMapperHelper sent: /" + command);
        }
        return true;
    }

    private int parsePositiveInt(String value, int fallback) {
        if (value == null || value.isEmpty()) {
            return fallback;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    private String buildBracketFilters(TextFieldSetting piecesField, TextFieldSetting variantsField) {
        LinkedHashSet<String> filters = new LinkedHashSet<String>();
        filters.addAll(this.parseCsv(piecesField.getValue()));
        filters.addAll(this.parseCsv(variantsField.getValue()));
        if (filters.isEmpty()) {
            return "";
        }
        return "[" + String.join((CharSequence)",", filters) + "]";
    }

    private LinkedHashSet<String> parseCsv(String text) {
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        if (text == null || text.isBlank()) {
            return values;
        }
        for (String token : CSV_SPLIT.split(text)) {
            String trimmed = token.trim();
            if (trimmed.isEmpty()) continue;
            values.add(trimmed);
        }
        return values;
    }

    private String joinCsv(Set<String> values) {
        return values.stream().collect(Collectors.joining(","));
    }

    private List<String> flattenOptionUnion(SeedMapperData seedData, boolean pieces) {
        ArrayList<String> options = new ArrayList<String>();
        if (pieces) {
            for (String structure : seedData.getStructureKeys()) {
                options.addAll(seedData.getStructurePieces(structure));
            }
        } else {
            options.addAll(seedData.getVariantKeyUnion());
        }
        return options.stream().distinct().sorted().toList();
    }

    private void autoSelectFirst(StringDropdownSetting setting, List<String> options) {
        if (options == null || options.isEmpty()) {
            return;
        }
        setting.setSelected(options.get(0));
    }

    private void initEspProfiles() {
        for (EspBucket bucket : EspBucket.values()) {
            EspProfile profile = new EspProfile(bucket);
            this.espProfiles.add(profile);
            profile.registerSettings();
        }
    }

    private void requestAllEspStates(boolean silent) {
        for (EspProfile profile : this.espProfiles) {
            profile.requestRefresh(silent);
        }
    }

    private void addSection(String title, String description, Setting ... settings) {
        if (settings == null || settings.length == 0) {
            return;
        }
        WText desc = description == null || description.isEmpty() ? WText.empty() : WText.literal(description);
        SettingGroup group = new SettingGroup(title, desc, false, true);
        group.addChildren(settings);
        this.addSetting(group);
        this.addSpacer();
    }

    private void addSpacer() {
        this.addSetting(new SpacerSetting());
    }

    private String extractJsonPayload(String message, String literal) {
        String[] connectors;
        if (message == null || literal == null || literal.isEmpty()) {
            return null;
        }
        String sanitized = message.trim();
        String literalPattern = Pattern.quote(literal);
        for (String connector : connectors = new String[]{"is currently set to", "has been set to", "has been reset to"}) {
            String payload;
            Pattern pattern = Pattern.compile("(?i)" + literalPattern + "\\s*(?:[:>\\-]\\s*)?" + Pattern.quote(connector) + "\\s*(\\{.*?\\})(?:\\.|\\s|$)");
            Matcher matcher = pattern.matcher(sanitized);
            if (!matcher.find() || (payload = matcher.group(1).trim()).isEmpty()) continue;
            return payload;
        }
        return null;
    }

    private static String toHexColor(Color color) {
        return String.format(Locale.ROOT, "#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    private static String formatDouble(double value) {
        String formatted = String.format(Locale.ROOT, "%.3f", value);
        if (formatted.indexOf(46) >= 0) {
            while (formatted.endsWith("0")) {
                formatted = formatted.substring(0, formatted.length() - 1);
            }
            if (formatted.endsWith(".")) {
                formatted = formatted.substring(0, formatted.length() - 1);
            }
        }
        return formatted.isEmpty() ? "0" : formatted;
    }

    private static Color parseColor(JsonElement element) {
        if (element == null || !element.isJsonPrimitive()) {
            return null;
        }
        return SeedMapperHelperHack.parseColor(element.getAsString());
    }

    private static Color parseColor(String value) {
        if (value == null) {
            return null;
        }
        String normalized = value.trim();
        if (normalized.isEmpty()) {
            return null;
        }
        if (normalized.startsWith("#")) {
            normalized = normalized.substring(1);
        } else if (normalized.startsWith("0x") || normalized.startsWith("0X")) {
            normalized = normalized.substring(2);
        }
        if (normalized.length() == 8) {
            normalized = normalized.substring(2);
        }
        if (normalized.length() != 6) {
            return null;
        }
        try {
            int rgb = Integer.parseInt(normalized, 16);
            return new Color(rgb);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static enum HighlightMode {
        BLOCK(20),
        ORE_VEIN(20);

        private final int maxChunks;

        private HighlightMode(int maxChunks) {
            this.maxChunks = maxChunks;
        }
    }

    private static enum VariantDataMode {
        AUTO,
        FORCE_TRUE,
        FORCE_FALSE;

    }

    private static enum LootClauseType {
        NONE(""),
        WITH("with"),
        WITHOUT("without");

        private final String keyword;

        private LootClauseType(String keyword) {
            this.keyword = keyword;
        }
    }

    private final class EspProfile {
        private final EspBucket bucket;
        private final ColorSetting outlineColorSetting;
        private final SliderSetting outlineAlphaSetting;
        private final CheckboxSetting useCommandColorSetting;
        private final CheckboxSetting fillEnabledSetting;
        private final ColorSetting fillColorSetting;
        private final SliderSetting fillAlphaSetting;
        private final CheckboxSetting rainbowSetting;
        private final SliderSetting rainbowSpeedSetting;
        private final ButtonSetting applyButton;
        private final ButtonSetting refreshButton;
        private final ButtonSetting resetButton;
        private boolean suppressNextResponse;
        private int suppressedLinesRemaining;
        private static final int SILENT_REFRESH_LINES = 12;

        private EspProfile(EspBucket bucket) {
            this.bucket = bucket;
            String prefix = bucket.label + " ";
            this.outlineColorSetting = new ColorSetting(prefix + "outline color", WText.literal("Outline color used by " + bucket.label + "."), Color.WHITE);
            this.outlineAlphaSetting = new SliderSetting(prefix + "outline alpha", 0.8, 0.0, 1.0, 0.01, SliderSetting.ValueDisplay.DECIMAL);
            this.useCommandColorSetting = new CheckboxSetting(prefix + "use command color", false);
            this.fillEnabledSetting = new CheckboxSetting(prefix + "fill enabled", true);
            this.fillColorSetting = new ColorSetting(prefix + "fill color", WText.literal("Fill color used by " + bucket.label + "."), new Color(5636052));
            this.fillAlphaSetting = new SliderSetting(prefix + "fill alpha", 0.3, 0.0, 1.0, 0.01, SliderSetting.ValueDisplay.DECIMAL);
            this.rainbowSetting = new CheckboxSetting(prefix + "rainbow mode", false);
            this.rainbowSpeedSetting = new SliderSetting(prefix + "rainbow speed", 0.5, 0.05, 5.0, 0.05, SliderSetting.ValueDisplay.DECIMAL);
            this.applyButton = new ButtonSetting(prefix + "apply", this::applyToServer);
            this.refreshButton = new ButtonSetting(prefix + "refresh", () -> this.requestRefresh(false));
            this.resetButton = new ButtonSetting(prefix + "reset", this::resetOnServer);
        }

        private void registerSettings() {
            SeedMapperHelperHack.this.addSetting(this.outlineColorSetting);
            SeedMapperHelperHack.this.addSetting(this.outlineAlphaSetting);
            SeedMapperHelperHack.this.addSetting(this.useCommandColorSetting);
            SeedMapperHelperHack.this.addSetting(this.fillEnabledSetting);
            SeedMapperHelperHack.this.addSetting(this.fillColorSetting);
            SeedMapperHelperHack.this.addSetting(this.fillAlphaSetting);
            SeedMapperHelperHack.this.addSetting(this.rainbowSetting);
            SeedMapperHelperHack.this.addSetting(this.rainbowSpeedSetting);
            SeedMapperHelperHack.this.addSetting(this.applyButton);
            SeedMapperHelperHack.this.addSetting(this.refreshButton);
            SeedMapperHelperHack.this.addSetting(this.resetButton);
            SeedMapperHelperHack.this.addSection(this.bucket.label, "Configure " + this.bucket.label + ".", this.outlineColorSetting, this.outlineAlphaSetting, this.useCommandColorSetting, this.fillEnabledSetting, this.fillColorSetting, this.fillAlphaSetting, this.rainbowSetting, this.rainbowSpeedSetting, this.applyButton, this.refreshButton, this.resetButton);
        }

        private void applyToServer() {
            String command = this.buildSetCommand();
            SeedMapperHelperHack.this.sendSeedMapperCommand(command, "configure " + this.bucket.label, false, SeedMapperHelperHack.this.showCommandFeedbackSetting.isChecked());
        }

        private void resetOnServer() {
            SeedMapperHelperHack.this.sendSeedMapperCommand("sm:config " + this.bucket.literal + " reset", "reset " + this.bucket.label, false, SeedMapperHelperHack.this.showCommandFeedbackSetting.isChecked());
        }

        private void requestRefresh(boolean silentErrors) {
            this.suppressNextResponse = silentErrors;
            this.suppressedLinesRemaining = silentErrors ? 12 : 0;
            SeedMapperHelperHack.this.sendSeedMapperCommand("sm:config " + this.bucket.literal + " get", silentErrors ? null : "refresh " + this.bucket.label, silentErrors, false);
        }

        private String buildSetCommand() {
            StringBuilder builder = new StringBuilder("sm:config ").append(this.bucket.literal).append(" set ");
            this.appendProperty(builder, "outlineColor", SeedMapperHelperHack.toHexColor(this.outlineColorSetting.getColor()));
            this.appendProperty(builder, "outlineAlpha", SeedMapperHelperHack.formatDouble(this.outlineAlphaSetting.getValue()));
            this.appendProperty(builder, "useCommandColor", String.valueOf(this.useCommandColorSetting.isChecked()));
            this.appendProperty(builder, "fillEnabled", String.valueOf(this.fillEnabledSetting.isChecked()));
            this.appendProperty(builder, "fillColor", SeedMapperHelperHack.toHexColor(this.fillColorSetting.getColor()));
            this.appendProperty(builder, "fillAlpha", SeedMapperHelperHack.formatDouble(this.fillAlphaSetting.getValue()));
            this.appendProperty(builder, "rainbow", String.valueOf(this.rainbowSetting.isChecked()));
            this.appendProperty(builder, "rainbowSpeed", SeedMapperHelperHack.formatDouble(this.rainbowSpeedSetting.getValue()));
            return builder.toString().trim();
        }

        private void appendProperty(StringBuilder builder, String property, String value) {
            builder.append(property).append(' ').append(value).append(' ');
        }

        private boolean handleChatFeedback(String message) {
            String lower;
            String json = SeedMapperHelperHack.this.extractJsonPayload(message, this.bucket.literal);
            boolean consumed = false;
            if (json != null) {
                try {
                    JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
                    this.loadFromJson(root);
                }
                catch (Exception root) {
                    // empty catch block
                }
                consumed = true;
                this.suppressNextResponse = false;
                this.suppressedLinesRemaining = 0;
            } else if (this.suppressNextResponse && this.suppressedLinesRemaining > 0 && (lower = message.toLowerCase(Locale.ROOT)).contains(this.bucket.literal.toLowerCase(Locale.ROOT))) {
                consumed = true;
                --this.suppressedLinesRemaining;
                if (this.suppressedLinesRemaining <= 0) {
                    this.suppressNextResponse = false;
                }
            }
            return consumed;
        }

        private void loadFromJson(JsonObject json) {
            this.updateColor(this.outlineColorSetting, json.get("outlineColor"));
            this.updateSlider(this.outlineAlphaSetting, json.get("outlineAlpha"));
            this.updateCheckbox(this.useCommandColorSetting, json.get("useCommandColor"));
            this.updateCheckbox(this.fillEnabledSetting, json.get("fillEnabled"));
            this.updateColor(this.fillColorSetting, json.get("fillColor"));
            this.updateSlider(this.fillAlphaSetting, json.get("fillAlpha"));
            this.updateCheckbox(this.rainbowSetting, json.get("rainbow"));
            this.updateSlider(this.rainbowSpeedSetting, json.get("rainbowSpeed"));
        }

        private void updateColor(ColorSetting setting, JsonElement element) {
            Color parsed = SeedMapperHelperHack.parseColor(element);
            if (parsed != null) {
                setting.setColor(parsed);
            }
        }

        private void updateSlider(SliderSetting setting, JsonElement element) {
            if (element == null) {
                return;
            }
            try {
                setting.setValue(element.getAsDouble());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void updateCheckbox(CheckboxSetting setting, JsonElement element) {
            if (element == null) {
                return;
            }
            try {
                setting.setChecked(element.getAsBoolean());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static enum EspBucket {
        BLOCK("Block highlight ESP", "blockhighlightesp"),
        ORE_VEIN("Ore vein ESP", "oreveinesp"),
        TERRAIN("Terrain ESP", "terrainesp"),
        CANYON("Canyon ESP", "canyonesp"),
        CAVE("Cave ESP", "caveesp");

        private final String label;
        private final String literal;

        private EspBucket(String label, String literal) {
            this.label = label;
            this.literal = literal;
        }
    }
}

