/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2478;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_5915;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.WurstClient;
import net.wurstclient.events.CameraTransformViewBobbingListener;
import net.wurstclient.events.PacketInputListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ChunkAreaSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.EspStyleSetting;
import net.wurstclient.settings.Setting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.BlockUtils;
import net.wurstclient.util.EntityUtils;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.chunk.ChunkSearcher;
import net.wurstclient.util.chunk.ChunkSearcherCoordinator;

@SearchTags(value={"sign esp", "SignESP"})
public final class SignEspHack
extends Hack
implements UpdateListener,
CameraTransformViewBobbingListener,
RenderListener {
    private final EspStyleSetting style = new EspStyleSetting();
    private final CheckboxSetting stickyArea = new CheckboxSetting("Sticky area", "Off: Re-centers every chunk to match ESP drop-off.\nOn: Keeps results anchored so you can path back to them.", false);
    private final SignEspGroup signs = new SignEspGroup(new ColorSetting("Sign color", "Signs will be highlighted in this color.", Color.ORANGE), null);
    private final List<SignEspGroup> groups = Arrays.asList(this.signs);
    private final CheckboxSetting framesEnabled = new CheckboxSetting("Include frames", false);
    private final FrameEspEntityGroup frames = new FrameEspEntityGroup(new ColorSetting("Frame color", "Item frames (including glow frames) will be highlighted in this color.", Color.YELLOW), this.framesEnabled);
    private final List<FrameEspEntityGroup> entityGroups = Arrays.asList(this.frames);
    private final ChunkAreaSetting area = new ChunkAreaSetting("Area", "The area around the player to search in.\nHigher values require a faster computer.");
    private final CheckboxSetting showCountInHackList = new CheckboxSetting("HackList count", "Appends the number of found signs/frames to this hack's entry in the HackList.", false);
    private final BiPredicate<class_2338, class_2680> query = (pos, state) -> state.method_26204() instanceof class_2478;
    private final ChunkSearcherCoordinator coordinator = new ChunkSearcherCoordinator(this.query, this.area);
    private boolean groupsUpToDate;
    private ChunkAreaSetting.ChunkArea lastAreaSelection;
    private class_1923 lastPlayerChunk;
    private int foundCount;
    private int lastMatchesVersion;
    private final CheckboxSetting onlyAboveGround = new CheckboxSetting("Above ground only", "Only show signs/frames at or above the configured Y level.", false);
    private final SliderSetting aboveGroundY = new SliderSetting("Set ESP Y limit", 62.0, -65.0, 255.0, 1.0, SliderSetting.ValueDisplay.INTEGER);

    public SignEspHack() {
        super("SignESP");
        this.setCategory(Category.RENDER);
        this.addSetting(this.style);
        this.groups.stream().flatMap(SignEspGroup::getSettings).forEach(x$0 -> this.addSetting((Setting)x$0));
        this.entityGroups.stream().flatMap(FrameEspEntityGroup::getSettings).forEach(x$0 -> this.addSetting((Setting)x$0));
        this.addSetting(this.showCountInHackList);
        this.addSetting(this.area);
        this.addSetting(this.stickyArea);
        this.addSetting(this.onlyAboveGround);
        this.addSetting(this.aboveGroundY);
    }

    @Override
    protected void onEnable() {
        this.groupsUpToDate = false;
        this.lastAreaSelection = (ChunkAreaSetting.ChunkArea)((Object)this.area.getSelected());
        this.lastPlayerChunk = new class_1923(SignEspHack.MC.field_1724.method_24515());
        this.lastMatchesVersion = this.coordinator.getMatchesVersion();
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(CameraTransformViewBobbingListener.class, this);
        EVENTS.add(RenderListener.class, this);
        EVENTS.add(PacketInputListener.class, this.coordinator);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(CameraTransformViewBobbingListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        EVENTS.remove(PacketInputListener.class, this.coordinator);
        this.coordinator.reset();
        this.lastMatchesVersion = this.coordinator.getMatchesVersion();
        this.groups.forEach(SignEspGroup::clear);
        this.entityGroups.forEach(FrameEspEntityGroup::clear);
        this.foundCount = 0;
    }

    @Override
    public void onUpdate() {
        int matchesVersion;
        boolean searchersChanged;
        ChunkAreaSetting.ChunkArea currentArea = (ChunkAreaSetting.ChunkArea)((Object)this.area.getSelected());
        if (currentArea != this.lastAreaSelection) {
            this.lastAreaSelection = currentArea;
            this.coordinator.reset();
            this.groupsUpToDate = false;
        }
        class_1923 currentChunk = new class_1923(SignEspHack.MC.field_1724.method_24515());
        if (!this.stickyArea.isChecked() && !currentChunk.equals((Object)this.lastPlayerChunk)) {
            this.lastPlayerChunk = currentChunk;
            this.coordinator.reset();
            this.groupsUpToDate = false;
        }
        if (searchersChanged = this.coordinator.update()) {
            this.groupsUpToDate = false;
        }
        if ((matchesVersion = this.coordinator.getMatchesVersion()) != this.lastMatchesVersion) {
            this.lastMatchesVersion = matchesVersion;
            this.groupsUpToDate = false;
        }
        if (!this.groupsUpToDate && this.coordinator.isDone()) {
            this.updateGroupBoxes();
        }
    }

    @Override
    public void onCameraTransformViewBobbing(CameraTransformViewBobbingListener.CameraTransformViewBobbingEvent event) {
        if (((EspStyleSetting.EspStyle)((Object)this.style.getSelected())).hasLines()) {
            event.cancel();
        }
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        this.entityGroups.stream().filter(FrameEspEntityGroup::isEnabled).forEach(g -> g.updateBoxes(partialTicks));
        if (((EspStyleSetting.EspStyle)((Object)this.style.getSelected())).hasBoxes()) {
            this.renderBoxes(matrixStack);
        }
        if (((EspStyleSetting.EspStyle)((Object)this.style.getSelected())).hasLines()) {
            this.renderTracers(matrixStack, partialTicks);
        }
    }

    private void renderBoxes(class_4587 matrixStack) {
        int linesColor;
        int quadsColor;
        List<class_238> boxes;
        for (SignEspGroup signEspGroup : this.groups) {
            if (!signEspGroup.isEnabled()) continue;
            boxes = signEspGroup.getBoxes();
            quadsColor = signEspGroup.getColorI(64);
            linesColor = signEspGroup.getColorI(128);
            RenderUtils.drawSolidBoxes(matrixStack, boxes, quadsColor, false);
            RenderUtils.drawOutlinedBoxes(matrixStack, boxes, linesColor, false);
        }
        for (FrameEspEntityGroup frameEspEntityGroup : this.entityGroups) {
            if (!frameEspEntityGroup.isEnabled()) continue;
            boxes = frameEspEntityGroup.getBoxes();
            quadsColor = frameEspEntityGroup.getColorI(64);
            linesColor = frameEspEntityGroup.getColorI(128);
            RenderUtils.drawSolidBoxes(matrixStack, boxes, quadsColor, false);
            RenderUtils.drawOutlinedBoxes(matrixStack, boxes, linesColor, false);
        }
    }

    private void renderTracers(class_4587 matrixStack, float partialTicks) {
        int color;
        List<class_243> ends;
        List<class_238> boxes;
        for (SignEspGroup signEspGroup : this.groups) {
            if (!signEspGroup.isEnabled()) continue;
            boxes = signEspGroup.getBoxes();
            ends = boxes.stream().map(class_238::method_1005).toList();
            color = signEspGroup.getColorI(128);
            RenderUtils.drawTracers(matrixStack, partialTicks, ends, color, false);
        }
        for (FrameEspEntityGroup frameEspEntityGroup : this.entityGroups) {
            if (!frameEspEntityGroup.isEnabled()) continue;
            boxes = frameEspEntityGroup.getBoxes();
            ends = boxes.stream().map(class_238::method_1005).toList();
            color = frameEspEntityGroup.getColorI(128);
            RenderUtils.drawTracers(matrixStack, partialTicks, ends, color, false);
        }
    }

    private void updateGroupBoxes() {
        this.groups.forEach(SignEspGroup::clear);
        this.coordinator.getMatches().forEach(this::addToGroupBoxes);
        this.groupsUpToDate = true;
        int signs = this.groups.stream().mapToInt(g -> g.getBoxes().size()).sum();
        int framesCount = this.entityGroups.stream().mapToInt(g -> g.getBoxes().size()).sum();
        this.foundCount = Math.min(signs + framesCount, 999);
    }

    private void addToGroupBoxes(ChunkSearcher.Result result) {
        block1: {
            if (this.onlyAboveGround.isChecked() && (double)result.pos().method_10264() < this.aboveGroundY.getValue()) {
                return;
            }
            Iterator<SignEspGroup> iterator = this.groups.iterator();
            if (!iterator.hasNext()) break block1;
            SignEspGroup group = iterator.next();
            group.add(result.pos());
        }
    }

    @Override
    public String getRenderName() {
        String base = this.getName();
        if (this.showCountInHackList.isChecked() && this.foundCount > 0) {
            return base + " [" + this.foundCount + "]";
        }
        return base;
    }

    private static final class SignEspGroup {
        private final ArrayList<class_238> boxes = new ArrayList();
        private final ColorSetting color;
        private final CheckboxSetting enabled;

        private SignEspGroup(ColorSetting color, CheckboxSetting enabled) {
            this.color = Objects.requireNonNull(color);
            this.enabled = enabled;
        }

        public void add(class_2338 pos) {
            if (!this.isEnabled()) {
                return;
            }
            if (!BlockUtils.canBeClicked(pos)) {
                return;
            }
            class_238 box = BlockUtils.getBoundingBox(pos);
            if (box.method_995() == 0.0) {
                return;
            }
            this.boxes.add(box);
        }

        public void clear() {
            this.boxes.clear();
        }

        public boolean isEnabled() {
            return this.enabled == null || this.enabled.isChecked();
        }

        public Stream<Setting> getSettings() {
            return Stream.of(this.enabled, this.color).filter(Objects::nonNull);
        }

        public int getColorI(int alpha) {
            return this.color.getColorI(alpha);
        }

        public List<class_238> getBoxes() {
            return Collections.unmodifiableList(this.boxes);
        }
    }

    private final class FrameEspEntityGroup {
        private final ArrayList<class_238> boxes = new ArrayList();
        private final ColorSetting color;
        private final CheckboxSetting enabled;

        private FrameEspEntityGroup(ColorSetting color, CheckboxSetting enabled) {
            this.color = Objects.requireNonNull(color);
            this.enabled = enabled;
        }

        public void updateBoxes(float partialTicks) {
            this.boxes.clear();
            if (!this.isEnabled()) {
                return;
            }
            for (class_1297 e : WurstClient.MC.field_1687.method_18112()) {
                if (!(e instanceof class_1533) && !(e instanceof class_5915) || SignEspHack.this.onlyAboveGround.isChecked() && e.method_23318() < SignEspHack.this.aboveGroundY.getValue()) continue;
                class_238 b = EntityUtils.getLerpedBox(e, partialTicks);
                this.boxes.add(b);
            }
        }

        public void clear() {
            this.boxes.clear();
        }

        public boolean isEnabled() {
            return this.enabled == null || this.enabled.isChecked();
        }

        public Stream<Setting> getSettings() {
            return Stream.of(this.enabled, this.color).filter(Objects::nonNull);
        }

        public int getColorI(int alpha) {
            return this.color.getColorI(alpha);
        }

        public List<class_238> getBoxes() {
            return Collections.unmodifiableList(this.boxes);
        }
    }
}

