/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import net.minecraft.class_1041;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2596;
import net.minecraft.class_2828;
import net.minecraft.class_3675;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.settings.TextFieldSetting;

@SearchTags(value={"wind charge", "auto wind charge", "windcharge"})
public final class WindChargeKeyHack
extends Hack
implements UpdateListener {
    private final TextFieldSetting keybind = new TextFieldSetting("Keybind", "Determines the activation key.\n\nUse translation keys such as \u00a7lkey.keyboard.g\u00a7r.\nYou can find these by looking at the F3 debug screen or by\nchecking vanilla keybind configuration files.", "key.keyboard.g", this::isValidKey);
    private final SliderSetting switchDelayMs = new SliderSetting("Switch delay", 50.0, 0.0, 500.0, 5.0, SliderSetting.ValueDisplay.INTEGER.withSuffix("ms"));
    private final SliderSetting throwDelayMs = new SliderSetting("Throw delay", 200.0, 0.0, 1000.0, 25.0, SliderSetting.ValueDisplay.INTEGER.withSuffix("ms"));
    private final CheckboxSetting silentMode = new CheckboxSetting("Silent", "Switches to the wind charge, uses it, and immediately switches back within the same tick.", false);
    private final CheckboxSetting autoJump = new CheckboxSetting("Auto jump", "Automatically jumps before throwing if you are on the ground.", true);
    private final CheckboxSetting lookDownBeforeThrow = new CheckboxSetting("Look down", "Faces straight down before throwing to maximize launch height.", true);
    private final SliderSetting jumpDelayMs = new SliderSetting("Jump delay", 10.0, 0.0, 200.0, 5.0, SliderSetting.ValueDisplay.INTEGER.withSuffix("ms"));
    private boolean keyPressed;
    private int originalSlot = -1;
    private boolean needsSlotRestore;
    private boolean firstThrow = true;
    private boolean jumpScheduled;
    private long lastThrowTime;
    private long switchBackTime;
    private long jumpStartTime;
    private boolean awaitingLaunch;
    private int pendingSlot = -1;
    private boolean pendingSilent;
    private boolean pendingLookDown;
    private long launchDeadline;
    private boolean restorePitch;
    private float savedPitch;
    private long restorePitchAt;

    public WindChargeKeyHack() {
        super("WindChargeKey");
        this.setCategory(Category.COMBAT);
        this.addSetting(this.keybind);
        this.addSetting(this.switchDelayMs);
        this.addSetting(this.throwDelayMs);
        this.addSetting(this.silentMode);
        this.addSetting(this.autoJump);
        this.addSetting(this.lookDownBeforeThrow);
        this.addSetting(this.jumpDelayMs);
    }

    @Override
    protected void onEnable() {
        this.resetState();
        EVENTS.add(UpdateListener.class, this);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        if (this.needsSlotRestore && this.originalSlot != -1 && WindChargeKeyHack.MC.field_1724 != null) {
            WindChargeKeyHack.MC.field_1724.method_31548().method_61496(this.originalSlot);
        }
        this.resetState();
    }

    @Override
    public void onUpdate() {
        if (WindChargeKeyHack.MC.field_1724 == null || WindChargeKeyHack.MC.field_1687 == null) {
            return;
        }
        if (WindChargeKeyHack.MC.field_1755 != null) {
            this.keyPressed = false;
            return;
        }
        class_3675.class_306 key = this.getBoundKey();
        if (key == null) {
            return;
        }
        boolean currentlyPressed = class_3675.method_15987((class_1041)MC.method_22683(), (int)key.method_1444());
        if (currentlyPressed && !this.keyPressed) {
            this.handleWindChargeThrow();
        }
        long now = System.currentTimeMillis();
        if (this.jumpScheduled && this.autoJump.isChecked() && now - this.jumpStartTime >= this.getJumpDelay()) {
            this.jumpScheduled = false;
            if (WindChargeKeyHack.MC.field_1724.method_24828()) {
                WindChargeKeyHack.MC.field_1724.method_6043();
            }
        }
        if (this.awaitingLaunch) {
            boolean ready;
            boolean airborne = !WindChargeKeyHack.MC.field_1724.method_24828();
            boolean upward = WindChargeKeyHack.MC.field_1724.method_18798().field_1351 > 0.08;
            boolean bl = ready = upward || !this.autoJump.isChecked() && airborne || now >= this.launchDeadline;
            if (ready) {
                this.awaitingLaunch = false;
                int slot = this.pendingSlot;
                boolean silent = this.pendingSilent;
                boolean lookDown = this.pendingLookDown;
                this.clearPending();
                this.performThrow(slot, silent, lookDown);
            }
        }
        if (this.restorePitch && now >= this.restorePitchAt) {
            this.restorePitchImmediate(this.savedPitch);
        }
        if (this.needsSlotRestore && now - this.switchBackTime >= this.getSwitchDelay()) {
            if (this.originalSlot != -1 && this.originalSlot != WindChargeKeyHack.MC.field_1724.method_31548().method_67532()) {
                WindChargeKeyHack.MC.field_1724.method_31548().method_61496(this.originalSlot);
            }
            this.needsSlotRestore = false;
            this.originalSlot = -1;
        }
        this.keyPressed = currentlyPressed;
    }

    private void handleWindChargeThrow() {
        long now = System.currentTimeMillis();
        if (this.awaitingLaunch) {
            return;
        }
        if (!this.firstThrow && now - this.lastThrowTime < this.getThrowDelay()) {
            return;
        }
        int windChargeSlot = this.findWindChargeInHotbar();
        if (windChargeSlot == -1) {
            return;
        }
        boolean silent = this.silentMode.isChecked();
        boolean lookDown = this.lookDownBeforeThrow.isChecked();
        if (this.autoJump.isChecked() && WindChargeKeyHack.MC.field_1724.method_24828()) {
            this.clearPending();
            this.pendingSlot = windChargeSlot;
            this.pendingSilent = silent;
            this.pendingLookDown = lookDown;
            this.launchDeadline = now + Math.max(250L, this.getJumpDelay() + 200L);
            this.awaitingLaunch = true;
            this.scheduleJump(now);
            return;
        }
        this.performThrow(windChargeSlot, silent, lookDown);
    }

    private void scheduleJump(long now) {
        long delay = this.getJumpDelay();
        if (delay <= 0L) {
            if (WindChargeKeyHack.MC.field_1724.method_24828()) {
                WindChargeKeyHack.MC.field_1724.method_6043();
            }
            return;
        }
        this.jumpScheduled = true;
        this.jumpStartTime = now;
    }

    private void performThrow(int preferredSlot, boolean silent, boolean lookDown) {
        boolean success;
        boolean appliedLookDown;
        this.clearPending();
        int slot = this.resolveWindChargeSlot(preferredSlot);
        if (slot == -1) {
            return;
        }
        float previousPitch = 0.0f;
        boolean bl = appliedLookDown = lookDown && this.lookDownBeforeThrow.isChecked();
        if (appliedLookDown) {
            previousPitch = this.applyLookDown();
        }
        long now = System.currentTimeMillis();
        boolean bl2 = success = silent ? this.throwWindChargeSilently(slot) : this.throwWindChargeNormally(slot, now);
        if (!success) {
            if (appliedLookDown) {
                this.restorePitchImmediate(previousPitch);
            }
            return;
        }
        if (appliedLookDown) {
            this.savedPitch = previousPitch;
            this.restorePitch = true;
            this.restorePitchAt = now + 150L;
        } else {
            this.restorePitch = false;
            this.restorePitchAt = 0L;
        }
        this.firstThrow = false;
        this.lastThrowTime = now;
    }

    private int resolveWindChargeSlot(int preferredSlot) {
        class_1799 stack;
        if (preferredSlot >= 0 && preferredSlot < 9 && (stack = WindChargeKeyHack.MC.field_1724.method_31548().method_5438(preferredSlot)).method_31574(class_1802.field_49098)) {
            return preferredSlot;
        }
        return this.findWindChargeInHotbar();
    }

    private float applyLookDown() {
        float oldPitch = WindChargeKeyHack.MC.field_1724.method_36455();
        float downwardPitch = 90.0f;
        WindChargeKeyHack.MC.field_1724.method_36457(downwardPitch);
        WindChargeKeyHack.MC.field_1724.field_3944.method_52787((class_2596)new class_2828.class_2831(WindChargeKeyHack.MC.field_1724.method_36454(), downwardPitch, WindChargeKeyHack.MC.field_1724.method_24828(), WindChargeKeyHack.MC.field_1724.field_5976));
        return oldPitch;
    }

    private void restorePitchImmediate(float pitch) {
        if (WindChargeKeyHack.MC.field_1724 == null) {
            return;
        }
        WindChargeKeyHack.MC.field_1724.method_36457(pitch);
        WindChargeKeyHack.MC.field_1724.field_3944.method_52787((class_2596)new class_2828.class_2831(WindChargeKeyHack.MC.field_1724.method_36454(), pitch, WindChargeKeyHack.MC.field_1724.method_24828(), WindChargeKeyHack.MC.field_1724.field_5976));
        this.restorePitch = false;
        this.restorePitchAt = 0L;
    }

    private void clearPending() {
        this.awaitingLaunch = false;
        this.pendingSlot = -1;
        this.pendingSilent = false;
        this.pendingLookDown = false;
        this.launchDeadline = 0L;
        this.jumpScheduled = false;
        this.jumpStartTime = 0L;
    }

    private boolean throwWindChargeSilently(int slot) {
        int currentSlot = WindChargeKeyHack.MC.field_1724.method_31548().method_67532();
        WindChargeKeyHack.MC.field_1724.method_31548().method_61496(slot);
        boolean success = this.useSelectedItem();
        WindChargeKeyHack.MC.field_1724.method_31548().method_61496(currentSlot);
        return success;
    }

    private boolean throwWindChargeNormally(int slot, long now) {
        this.originalSlot = WindChargeKeyHack.MC.field_1724.method_31548().method_67532();
        WindChargeKeyHack.MC.field_1724.method_31548().method_61496(slot);
        boolean success = this.useSelectedItem();
        if (success) {
            this.needsSlotRestore = true;
            this.switchBackTime = now;
            return true;
        }
        WindChargeKeyHack.MC.field_1724.method_31548().method_61496(this.originalSlot);
        this.originalSlot = -1;
        return false;
    }

    private boolean useSelectedItem() {
        if (WindChargeKeyHack.MC.field_1724 == null || WindChargeKeyHack.MC.field_1761 == null) {
            return false;
        }
        class_1799 stack = WindChargeKeyHack.MC.field_1724.method_6047();
        if (stack.method_7960()) {
            return false;
        }
        class_1269 result = WindChargeKeyHack.MC.field_1761.method_2919((class_1657)WindChargeKeyHack.MC.field_1724, class_1268.field_5808);
        if (result.method_23665()) {
            WindChargeKeyHack.MC.field_1724.method_6104(class_1268.field_5808);
        }
        return result.method_23665();
    }

    private int findWindChargeInHotbar() {
        for (int i = 0; i < 9; ++i) {
            class_1799 stack = WindChargeKeyHack.MC.field_1724.method_31548().method_5438(i);
            if (!stack.method_31574(class_1802.field_49098)) continue;
            return i;
        }
        return -1;
    }

    private class_3675.class_306 getBoundKey() {
        try {
            return class_3675.method_15981((String)this.keybind.getValue());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private long getSwitchDelay() {
        return Math.max(0L, Math.round(this.switchDelayMs.getValue()));
    }

    private long getThrowDelay() {
        return Math.max(0L, Math.round(this.throwDelayMs.getValue()));
    }

    private long getJumpDelay() {
        return Math.max(0L, Math.round(this.jumpDelayMs.getValue()));
    }

    private boolean isValidKey(String translationKey) {
        try {
            return class_3675.method_15981((String)translationKey) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private void resetState() {
        this.clearPending();
        if (this.restorePitch && WindChargeKeyHack.MC.field_1724 != null) {
            this.restorePitchImmediate(this.savedPitch);
        }
        this.keyPressed = false;
        this.originalSlot = -1;
        this.needsSlotRestore = false;
        this.firstThrow = true;
        this.lastThrowTime = 0L;
        this.switchBackTime = 0L;
        this.restorePitch = false;
        this.restorePitchAt = 0L;
        this.savedPitch = 0.0f;
    }
}

