/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.events.CameraTransformViewBobbingListener;
import net.wurstclient.events.PacketInputListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.hacks.portalesp.PortalEspBlockGroup;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ChunkAreaSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.EspStyleSetting;
import net.wurstclient.settings.Setting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.chunk.ChunkSearcher;
import net.wurstclient.util.chunk.ChunkSearcherCoordinator;

@SearchTags(value={"workstation esp", "WorkstationESP"})
public final class WorkstationEspHack
extends Hack
implements UpdateListener,
CameraTransformViewBobbingListener,
RenderListener {
    private final EspStyleSetting style = new EspStyleSetting();
    private final CheckboxSetting stickyArea = new CheckboxSetting("Sticky area", "Off: Re-centers every chunk to match ESP drop-off.\nOn: Keeps results anchored so you can path back to them.", false);
    private final ChunkAreaSetting area = new ChunkAreaSetting("Area", "The area around the player to search in.\nHigher values require a faster computer.");
    private final Color defaultColor = new Color(8374655);
    private final PortalEspBlockGroup craftingTable = new PortalEspBlockGroup(class_2246.field_9980, new ColorSetting("Crafting table color", "Crafting tables will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include crafting tables", true));
    private final PortalEspBlockGroup smithingTable = new PortalEspBlockGroup(class_2246.field_16329, new ColorSetting("Smithing table color", "Smithing tables will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include smithing tables", true));
    private final PortalEspBlockGroup anvils = new PortalEspBlockGroup(class_2246.field_10535, new ColorSetting("Anvil color", "Anvils (all states) will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include anvils", true));
    private final PortalEspBlockGroup chippedAnvils = new PortalEspBlockGroup(class_2246.field_10105, new ColorSetting("Chipped anvil color", "Chipped anvils will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include chipped anvils", true));
    private final PortalEspBlockGroup damagedAnvils = new PortalEspBlockGroup(class_2246.field_10414, new ColorSetting("Damaged anvil color", "Damaged anvils will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include damaged anvils", true));
    private final PortalEspBlockGroup grindstone = new PortalEspBlockGroup(class_2246.field_16337, new ColorSetting("Grindstone color", "Grindstones will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include grindstones", true));
    private final PortalEspBlockGroup enchanting = new PortalEspBlockGroup(class_2246.field_10485, new ColorSetting("Enchanting table color", "Enchanting tables will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include enchanting tables", true));
    private final PortalEspBlockGroup cartography = new PortalEspBlockGroup(class_2246.field_16336, new ColorSetting("Cartography table color", "Cartography tables will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include cartography tables", true));
    private final PortalEspBlockGroup stonecutter = new PortalEspBlockGroup(class_2246.field_16335, new ColorSetting("Stonecutter color", "Stonecutters will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include stonecutters", true));
    private final PortalEspBlockGroup loom = new PortalEspBlockGroup(class_2246.field_10083, new ColorSetting("Loom color", "Looms will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include looms", true));
    private final PortalEspBlockGroup furnace = new PortalEspBlockGroup(class_2246.field_10181, new ColorSetting("Furnace color", "Furnaces will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include furnaces", true));
    private final PortalEspBlockGroup blastFurnace = new PortalEspBlockGroup(class_2246.field_16333, new ColorSetting("Blast furnace color", "Blast furnaces will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include blast furnaces", true));
    private final PortalEspBlockGroup smoker = new PortalEspBlockGroup(class_2246.field_16334, new ColorSetting("Smoker color", "Smokers will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include smokers", true));
    private final PortalEspBlockGroup campfire = new PortalEspBlockGroup(class_2246.field_17350, new ColorSetting("Campfire color", "Campfires will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include campfires", true));
    private final PortalEspBlockGroup soulCampfire = new PortalEspBlockGroup(class_2246.field_23860, new ColorSetting("Soul campfire color", "Soul campfires will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include soul campfires", true));
    private final PortalEspBlockGroup brewingStand = new PortalEspBlockGroup(class_2246.field_10333, new ColorSetting("Brewing stand color", "Brewing stands will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include brewing stands", true));
    private final PortalEspBlockGroup cauldron = new PortalEspBlockGroup(class_2246.field_10593, new ColorSetting("Cauldron color", "Cauldrons will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include cauldrons", true));
    private final PortalEspBlockGroup barrel = new PortalEspBlockGroup(class_2246.field_16328, new ColorSetting("Barrel color", "Barrels will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include barrels", true));
    private final PortalEspBlockGroup composter = new PortalEspBlockGroup(class_2246.field_17563, new ColorSetting("Composter color", "Composters will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include composters", true));
    private final PortalEspBlockGroup lectern = new PortalEspBlockGroup(class_2246.field_16330, new ColorSetting("Lectern color", "Lecterns will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include lecterns", true));
    private final PortalEspBlockGroup fletchingTable = new PortalEspBlockGroup(class_2246.field_16331, new ColorSetting("Fletching table color", "Fletching tables will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include fletching tables", true));
    private final PortalEspBlockGroup beacon = new PortalEspBlockGroup(class_2246.field_10327, new ColorSetting("Beacon color", "Beacons will be highlighted in this color.", this.defaultColor), new CheckboxSetting("Include beacons", true));
    private final List<PortalEspBlockGroup> groups = Arrays.asList(this.craftingTable, this.smithingTable, this.anvils, this.chippedAnvils, this.damagedAnvils, this.grindstone, this.enchanting, this.cartography, this.stonecutter, this.loom, this.furnace, this.blastFurnace, this.smoker, this.campfire, this.soulCampfire, this.brewingStand, this.cauldron, this.barrel, this.composter, this.lectern, this.fletchingTable, this.beacon);
    private final BiPredicate<class_2338, class_2680> query = (pos, state) -> this.isTargetBlock(state.method_26204());
    private final ChunkSearcherCoordinator coordinator = new ChunkSearcherCoordinator(this.query, this.area);
    private boolean groupsUpToDate;
    private ChunkAreaSetting.ChunkArea lastAreaSelection;
    private class_1923 lastPlayerChunk;
    private int foundCount;
    private int lastMatchesVersion;
    private final CheckboxSetting showCountInHackList = new CheckboxSetting("HackList count", "Appends the number of found workstation blocks to this hack's entry in the HackList.", false);
    private final CheckboxSetting onlyAboveGround = new CheckboxSetting("Above ground only", "Only show workstations at or above the configured Y level.", false);
    private final SliderSetting aboveGroundY = new SliderSetting("Set ESP Y limit", 62.0, -65.0, 255.0, 1.0, SliderSetting.ValueDisplay.INTEGER);

    public WorkstationEspHack() {
        super("WorkstationESP");
        this.setCategory(Category.RENDER);
        this.addSetting(this.style);
        this.groups.stream().flatMap(PortalEspBlockGroup::getSettings).forEach(x$0 -> this.addSetting((Setting)x$0));
        this.addSetting(this.showCountInHackList);
        this.addSetting(this.onlyAboveGround);
        this.addSetting(this.aboveGroundY);
        this.addSetting(this.area);
        this.addSetting(this.stickyArea);
    }

    private boolean isTargetBlock(class_2248 b) {
        for (PortalEspBlockGroup g : this.groups) {
            if (g.getBlock() != b) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void onEnable() {
        this.groupsUpToDate = false;
        this.lastAreaSelection = (ChunkAreaSetting.ChunkArea)((Object)this.area.getSelected());
        this.lastPlayerChunk = new class_1923(WorkstationEspHack.MC.field_1724.method_24515());
        this.lastMatchesVersion = this.coordinator.getMatchesVersion();
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(CameraTransformViewBobbingListener.class, this);
        EVENTS.add(RenderListener.class, this);
        EVENTS.add(PacketInputListener.class, this.coordinator);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(CameraTransformViewBobbingListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        EVENTS.remove(PacketInputListener.class, this.coordinator);
        this.coordinator.reset();
        this.lastMatchesVersion = this.coordinator.getMatchesVersion();
        this.groups.forEach(PortalEspBlockGroup::clear);
        this.foundCount = 0;
    }

    @Override
    public void onUpdate() {
        int matchesVersion;
        boolean searchersChanged;
        ChunkAreaSetting.ChunkArea currentArea = (ChunkAreaSetting.ChunkArea)((Object)this.area.getSelected());
        if (currentArea != this.lastAreaSelection) {
            this.lastAreaSelection = currentArea;
            this.coordinator.reset();
            this.groupsUpToDate = false;
        }
        class_1923 currentChunk = new class_1923(WorkstationEspHack.MC.field_1724.method_24515());
        if (!this.stickyArea.isChecked() && !currentChunk.equals((Object)this.lastPlayerChunk)) {
            this.lastPlayerChunk = currentChunk;
            this.coordinator.reset();
            this.groupsUpToDate = false;
        }
        if (searchersChanged = this.coordinator.update()) {
            this.groupsUpToDate = false;
        }
        if ((matchesVersion = this.coordinator.getMatchesVersion()) != this.lastMatchesVersion) {
            this.lastMatchesVersion = matchesVersion;
            this.groupsUpToDate = false;
        }
        if (!this.groupsUpToDate && this.coordinator.isDone()) {
            this.updateGroupBoxes();
        }
    }

    @Override
    public void onCameraTransformViewBobbing(CameraTransformViewBobbingListener.CameraTransformViewBobbingEvent event) {
        if (((EspStyleSetting.EspStyle)((Object)this.style.getSelected())).hasLines()) {
            event.cancel();
        }
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        if (((EspStyleSetting.EspStyle)((Object)this.style.getSelected())).hasBoxes()) {
            this.renderBoxes(matrixStack);
        }
        if (((EspStyleSetting.EspStyle)((Object)this.style.getSelected())).hasLines()) {
            this.renderTracers(matrixStack, partialTicks);
        }
    }

    private void renderBoxes(class_4587 matrixStack) {
        for (PortalEspBlockGroup group : this.groups) {
            if (!group.isEnabled()) continue;
            List<class_238> boxes = group.getBoxes();
            int quadsColor = group.getColorI(64);
            int linesColor = group.getColorI(128);
            RenderUtils.drawSolidBoxes(matrixStack, boxes, quadsColor, false);
            RenderUtils.drawOutlinedBoxes(matrixStack, boxes, linesColor, false);
        }
    }

    private void renderTracers(class_4587 matrixStack, float partialTicks) {
        for (PortalEspBlockGroup group : this.groups) {
            if (!group.isEnabled()) continue;
            List<class_238> boxes = group.getBoxes();
            List<class_243> ends = boxes.stream().map(class_238::method_1005).toList();
            int color = group.getColorI(128);
            RenderUtils.drawTracers(matrixStack, partialTicks, ends, color, false);
        }
    }

    private void updateGroupBoxes() {
        this.groups.forEach(PortalEspBlockGroup::clear);
        this.coordinator.getMatches().forEach(this::addToGroupBoxes);
        this.groupsUpToDate = true;
        int total = this.groups.stream().mapToInt(g -> g.getBoxes().size()).sum();
        this.foundCount = Math.min(total, 999);
    }

    private void addToGroupBoxes(ChunkSearcher.Result result) {
        if (this.onlyAboveGround.isChecked() && (double)result.pos().method_10264() < this.aboveGroundY.getValue()) {
            return;
        }
        for (PortalEspBlockGroup group : this.groups) {
            if (result.state().method_26204() != group.getBlock()) continue;
            group.add(result.pos());
            break;
        }
    }

    @Override
    public String getRenderName() {
        String base = this.getName();
        if (this.showCountInHackList.isChecked() && this.foundCount > 0) {
            return base + " [" + this.foundCount + "]";
        }
        return base;
    }
}

