/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2596;
import net.minecraft.class_2815;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.events.PacketOutputListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.util.ChatUtils;

@SearchTags(value={"xcarry", "extra inventory", "crafting carry"})
public final class XCarryHack
extends Hack
implements PacketOutputListener,
UpdateListener {
    private static final int CRAFTING_SLOT_START = 1;
    private static final int CRAFTING_SLOT_COUNT = 4;
    private final CheckboxSetting dangerousMode = new CheckboxSetting("Ignore safety checks", "NOT RECOMMENDED TO ENABLE!!\nWill disable following checks:\n1. Is in inventory screen (allows to get out of sync for other containers\n2. Disable general sync check.", false);
    private final CheckboxSetting disableInCreative = new CheckboxSetting("Disable in Creative", "Turns off XCarry in Creative mode, since there is no 2x2 crafting grid.", false);
    private final class_1799[] trackedCraftingStacks = new class_1799[4];
    private List<class_1799> lastInventorySnapshot = Collections.emptyList();

    public XCarryHack() {
        super("XCarry");
        this.setCategory(Category.ITEMS);
        this.addSetting(this.dangerousMode);
        this.addSetting(this.disableInCreative);
        this.resetTracking();
    }

    @Override
    protected void onEnable() {
        EVENTS.add(PacketOutputListener.class, this);
        EVENTS.add(UpdateListener.class, this);
        this.resetTracking();
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(PacketOutputListener.class, this);
        EVENTS.remove(UpdateListener.class, this);
        this.resetTracking();
    }

    @Override
    public void onSentPacket(PacketOutputListener.PacketOutputEvent event) {
        class_2596<?> class_25962 = event.getPacket();
        if (!(class_25962 instanceof class_2815)) {
            return;
        }
        class_2815 closeScreenPacket = (class_2815)class_25962;
        if (XCarryHack.MC.field_1724 == null) {
            return;
        }
        if (this.disableInCreative.isChecked() && XCarryHack.MC.field_1724.method_31549().field_7477) {
            return;
        }
        if (this.dangerousMode.isChecked()) {
            event.cancel();
            return;
        }
        if (XCarryHack.MC.field_1724.field_7498 != null && closeScreenPacket.method_36168() == XCarryHack.MC.field_1724.field_7498.field_7763) {
            event.cancel();
        }
    }

    @Override
    public void onUpdate() {
        if (XCarryHack.MC.field_1724 == null || XCarryHack.MC.field_1687 == null) {
            this.resetTracking();
            return;
        }
        List<class_1799> previousInventory = this.lastInventorySnapshot;
        List<class_1799> currentInventory = this.captureInventorySnapshot();
        this.lastInventorySnapshot = currentInventory;
        this.monitorCraftingGrid(previousInventory, currentInventory);
    }

    private void monitorCraftingGrid(List<class_1799> previousInventory, List<class_1799> currentInventory) {
        if (XCarryHack.MC.field_1724 == null || XCarryHack.MC.field_1724.field_7498 == null) {
            return;
        }
        ArrayList<class_1799> removedStacks = new ArrayList<class_1799>();
        for (int i = 0; i < 4; ++i) {
            class_1799 current = this.getCraftingSlotStack(i);
            class_1799 previous = this.trackedCraftingStacks[i];
            this.trackedCraftingStacks[i] = current.method_7972();
            if (XCarryHack.MC.field_1755 != null || previous.method_7960() || !current.method_7960()) continue;
            removedStacks.add(previous);
        }
        if (removedStacks.isEmpty()) {
            return;
        }
        this.handleCraftingEjection(removedStacks, previousInventory, currentInventory);
    }

    private void handleCraftingEjection(List<class_1799> removedStacks, List<class_1799> previousInventory, List<class_1799> currentInventory) {
        if (previousInventory.isEmpty() || currentInventory.isEmpty()) {
            ChatUtils.message("[XCarry] Crafting grid items vanished (unable to determine destination).");
            return;
        }
        List<ItemCounter> inventoryDelta = this.buildInventoryDelta(previousInventory, currentInventory);
        ArrayList<String> returned = new ArrayList<String>();
        ArrayList<String> dropped = new ArrayList<String>();
        for (class_1799 removed : removedStacks) {
            int restored = XCarryHack.consumeFromDelta(inventoryDelta, removed, removed.method_7947());
            if (restored > 0) {
                returned.add(XCarryHack.formatStack(removed, restored));
            }
            if (restored >= removed.method_7947()) continue;
            dropped.add(XCarryHack.formatStack(removed, removed.method_7947() - restored));
        }
        if (!returned.isEmpty()) {
            ChatUtils.message("[XCarry] Crafting items moved to inventory: " + String.join((CharSequence)", ", returned));
        }
        if (!dropped.isEmpty()) {
            ChatUtils.message("[XCarry] Crafting items dropped on ground: " + String.join((CharSequence)", ", dropped));
        }
    }

    private class_1799 getCraftingSlotStack(int offset) {
        if (XCarryHack.MC.field_1724 == null || XCarryHack.MC.field_1724.field_7498 == null) {
            return class_1799.field_8037;
        }
        class_2371 slots = XCarryHack.MC.field_1724.field_7498.field_7761;
        int index = 1 + offset;
        if (index < 0 || index >= slots.size()) {
            return class_1799.field_8037;
        }
        return ((class_1735)slots.get(index)).method_7677();
    }

    private List<class_1799> captureInventorySnapshot() {
        if (XCarryHack.MC.field_1724 == null) {
            return Collections.emptyList();
        }
        class_1661 inv = XCarryHack.MC.field_1724.method_31548();
        ArrayList<class_1799> snapshot = new ArrayList<class_1799>(inv.method_5439());
        for (int i = 0; i < inv.method_5439(); ++i) {
            snapshot.add(inv.method_5438(i).method_7972());
        }
        return snapshot;
    }

    private List<ItemCounter> buildInventoryDelta(List<class_1799> before, List<class_1799> after) {
        ArrayList<ItemCounter> delta = new ArrayList<ItemCounter>();
        for (class_1799 stack : after) {
            XCarryHack.addToCounters(delta, stack);
        }
        for (class_1799 stack : before) {
            if (stack.method_7960()) continue;
            ItemCounter counter2 = XCarryHack.findCounter(delta, stack);
            if (counter2 == null) {
                class_1799 sample = stack.method_7972();
                sample.method_7939(1);
                counter2 = new ItemCounter(sample, 0);
                delta.add(counter2);
            }
            counter2.count -= stack.method_7947();
        }
        delta.removeIf(counter -> counter.count == 0);
        return delta;
    }

    private static void addToCounters(List<ItemCounter> counters, class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        ItemCounter counter = XCarryHack.findCounter(counters, stack);
        if (counter == null) {
            class_1799 sample = stack.method_7972();
            sample.method_7939(1);
            counters.add(new ItemCounter(sample, stack.method_7947()));
            return;
        }
        counter.count += stack.method_7947();
    }

    private static ItemCounter findCounter(List<ItemCounter> counters, class_1799 stack) {
        for (ItemCounter counter : counters) {
            if (!XCarryHack.stacksMatch(counter.sample, stack)) continue;
            return counter;
        }
        return null;
    }

    private static int consumeFromDelta(List<ItemCounter> deltas, class_1799 stack, int needed) {
        ItemCounter counter = XCarryHack.findCounter(deltas, stack);
        if (counter == null || counter.count <= 0 || needed <= 0) {
            return 0;
        }
        int used = Math.min(needed, counter.count);
        counter.count -= used;
        if (counter.count == 0) {
            deltas.remove(counter);
        }
        return used;
    }

    private static String formatStack(class_1799 stack, int count) {
        return count + "x " + stack.method_7964().getString();
    }

    private void resetTracking() {
        Arrays.fill(this.trackedCraftingStacks, class_1799.field_8037);
        this.lastInventorySnapshot = Collections.emptyList();
    }

    private static boolean stacksMatch(class_1799 a, class_1799 b) {
        if (a.method_7960() || b.method_7960()) {
            return a.method_7960() && b.method_7960();
        }
        return a.method_7909() == b.method_7909();
    }

    private static final class ItemCounter {
        private final class_1799 sample;
        private int count;

        private ItemCounter(class_1799 sample, int count) {
            this.sample = sample;
            this.count = count;
        }
    }
}

