/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.clickgui.screens.EditBlockListScreen;
import net.wurstclient.events.GetAmbientOcclusionLightLevelListener;
import net.wurstclient.events.PacketInputListener;
import net.wurstclient.events.RenderBlockEntityListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.SetOpaqueCubeListener;
import net.wurstclient.events.ShouldDrawSideListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.hacks.FullbrightHack;
import net.wurstclient.mixinterface.ISimpleOption;
import net.wurstclient.settings.BlockListSetting;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ChunkAreaSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.EnumSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.settings.TextFieldSetting;
import net.wurstclient.util.BlockUtils;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.chunk.ChunkSearcherCoordinator;

@SearchTags(value={"XRay", "x ray", "OreFinder", "ore finder"})
public final class XRayHack
extends Hack
implements UpdateListener,
SetOpaqueCubeListener,
GetAmbientOcclusionLightLevelListener,
ShouldDrawSideListener,
RenderBlockEntityListener,
RenderListener {
    private final BlockListSetting ores = new BlockListSetting("Ores", "A list of blocks that X-Ray will show. They don't have to be just ores - you can add any block you want.\n\nRemember to restart X-Ray when changing this setting.", "minecraft:amethyst_cluster", "minecraft:ancient_debris", "minecraft:anvil", "minecraft:beacon", "minecraft:bone_block", "minecraft:bookshelf", "minecraft:brewing_stand", "minecraft:budding_amethyst", "minecraft:chain_command_block", "minecraft:chest", "minecraft:coal_block", "minecraft:coal_ore", "minecraft:command_block", "minecraft:copper_ore", "minecraft:crafter", "minecraft:crafting_table", "minecraft:creaking_heart", "minecraft:decorated_pot", "minecraft:deepslate_coal_ore", "minecraft:deepslate_copper_ore", "minecraft:deepslate_diamond_ore", "minecraft:deepslate_emerald_ore", "minecraft:deepslate_gold_ore", "minecraft:deepslate_iron_ore", "minecraft:deepslate_lapis_ore", "minecraft:deepslate_redstone_ore", "minecraft:diamond_block", "minecraft:diamond_ore", "minecraft:dispenser", "minecraft:dropper", "minecraft:emerald_block", "minecraft:emerald_ore", "minecraft:enchanting_table", "minecraft:end_portal", "minecraft:end_portal_frame", "minecraft:ender_chest", "minecraft:furnace", "minecraft:glowstone", "minecraft:gold_block", "minecraft:gold_ore", "minecraft:hopper", "minecraft:iron_block", "minecraft:iron_ore", "minecraft:ladder", "minecraft:lapis_block", "minecraft:lapis_ore", "minecraft:lava", "minecraft:lodestone", "minecraft:mossy_cobblestone", "minecraft:nether_gold_ore", "minecraft:nether_portal", "minecraft:nether_quartz_ore", "minecraft:raw_copper_block", "minecraft:raw_gold_block", "minecraft:raw_iron_block", "minecraft:redstone_block", "minecraft:redstone_ore", "minecraft:repeating_command_block", "minecraft:sculk_catalyst", "minecraft:sculk_sensor", "minecraft:sculk_shrieker", "minecraft:spawner", "minecraft:suspicious_gravel", "minecraft:suspicious_sand", "minecraft:tnt", "minecraft:torch", "minecraft:trapped_chest", "minecraft:trial_spawner", "minecraft:vault", "minecraft:wall_torch", "minecraft:water");
    private final CheckboxSetting onlyExposed = new CheckboxSetting("Only show exposed", "Only shows ores that would be visible in caves. This can help against anti-X-Ray plugins.\n\nRemember to restart X-Ray when changing this setting.", false);
    private final SliderSetting opacity = new SliderSetting("Opacity", "Opacity of non-ore blocks when X-Ray is enabled.\n\nRemember to restart X-Ray when changing this setting.", 0.0, 0.0, 0.99, 0.01, SliderSetting.ValueDisplay.PERCENTAGE.withLabel(0.0, "off"));
    private final String optiFineWarning;
    private final String renderName = Math.random() < 0.01 ? "X-Wurst" : this.getName();
    private ArrayList<String> oreNamesCache;
    private Set<String> oreExactIds;
    private String[] oreKeywords;
    private double lastOpacityVal;
    private int lastOresHash;
    private final ThreadLocal<class_2338.class_2339> mutablePosForExposedCheck = ThreadLocal.withInitial(class_2338.class_2339::new);
    private Mode lastMode = null;
    private boolean lastOnlyExposed = false;
    private final EnumSetting<Mode> mode = new EnumSetting("Mode", (Enum[])new Mode[]{Mode.LIST, Mode.QUERY}, (Enum)Mode.LIST);
    private final TextFieldSetting query = new TextFieldSetting("Query", "Enter text to match block IDs or names by keyword. Separate multiple terms with commas.", "");
    private final CheckboxSetting highlightCorners = new CheckboxSetting("Highlight corners", "Partial ESP for blocks, will cause lag if there are too many!", false);
    private final CheckboxSetting highlightFill = new CheckboxSetting("Fill blocks (outline + fill)", "Full ESP for blocks, will cause lag if there are too many!", false);
    private final ColorSetting highlightColor = new ColorSetting("Highlight color", new Color(0xFFFF00));
    private final SliderSetting highlightAlpha = new SliderSetting("Highlight transparency", 80.0, 1.0, 100.0, 1.0, SliderSetting.ValueDisplay.INTEGER.withSuffix("%"));
    private final SliderSetting renderAmount = new SliderSetting("Render amount", "The maximum number of blocks to render.", 3.0, 2.0, 6.0, 1.0, SliderSetting.ValueDisplay.LOGARITHMIC);
    private final ChunkAreaSetting area = new ChunkAreaSetting("Area", "The area around the player to search in. Higher values require a faster computer.");
    private final ChunkSearcherCoordinator coordinator;
    private boolean highlightPositionsUpToDate = false;
    private List<class_2338> highlightPositions = new ArrayList<class_2338>();
    private boolean visibleBoxesUpToDate = false;
    private List<class_238> visibleBoxes = new ArrayList<class_238>();
    private int lastMatchesVersion;
    private static final long COORDINATOR_DEBOUNCE_MS = 200L;
    private long lastCoordinatorChangeMs = 0L;

    public XRayHack() {
        super("X-Ray");
        this.setCategory(Category.RENDER);
        this.addSetting(this.ores);
        this.addSetting(this.onlyExposed);
        this.addSetting(this.opacity);
        this.addSetting(this.mode);
        this.addSetting(this.query);
        this.addSetting(this.highlightCorners);
        this.addSetting(this.highlightFill);
        this.addSetting(this.highlightColor);
        this.addSetting(this.highlightAlpha);
        this.addSetting(this.renderAmount);
        this.optiFineWarning = this.checkOptiFine();
        this.coordinator = new ChunkSearcherCoordinator((pos, state) -> {
            String idFull = BlockUtils.getName(state.method_26204());
            if (this.mode.getSelected() == Mode.LIST) {
                if (this.oreExactIds != null && this.oreExactIds.contains(idFull)) {
                    return true;
                }
                return this.oreExactIds == null && this.oreNamesCache != null && this.oreNamesCache.contains(idFull);
            }
            if (this.oreKeywords == null || this.oreKeywords.length == 0) {
                return false;
            }
            String localId = idFull.contains(":") ? idFull.substring(idFull.indexOf(":") + 1) : idFull;
            String localSpaced = localId.replace('_', ' ');
            for (String term : this.oreKeywords) {
                if (!idFull.toLowerCase(Locale.ROOT).contains(term) && !localId.toLowerCase(Locale.ROOT).contains(term) && !localSpaced.toLowerCase(Locale.ROOT).contains(term)) continue;
                return true;
            }
            return false;
        }, this.area);
    }

    @Override
    public String getRenderName() {
        return this.renderName;
    }

    @Override
    protected void onEnable() {
        this.lastMode = this.mode.getSelected();
        if (this.lastMode == Mode.LIST) {
            this.oreNamesCache = new ArrayList<String>(this.ores.getBlockNames());
            this.lastOresHash = this.ores.getBlockNames().hashCode();
            this.lastOpacityVal = this.opacity.getValue();
            this.rebuildOreCaches();
        } else {
            String q = this.query.getValue();
            this.oreExactIds = null;
            this.oreKeywords = q == null || q.isBlank() ? new String[0] : (String[])Stream.of(q.split(",")).map(s -> s.trim().toLowerCase(Locale.ROOT)).filter(s -> !s.isEmpty()).toArray(String[]::new);
            this.lastOpacityVal = this.opacity.getValue();
        }
        this.lastOnlyExposed = this.onlyExposed.isChecked();
        this.coordinator.reset();
        this.lastMatchesVersion = this.coordinator.getMatchesVersion();
        this.highlightPositionsUpToDate = false;
        this.visibleBoxesUpToDate = false;
        this.lastCoordinatorChangeMs = System.currentTimeMillis();
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(PacketInputListener.class, this.coordinator);
        EVENTS.add(RenderListener.class, this);
        EVENTS.add(SetOpaqueCubeListener.class, this);
        EVENTS.add(GetAmbientOcclusionLightLevelListener.class, this);
        EVENTS.add(ShouldDrawSideListener.class, this);
        EVENTS.add(RenderBlockEntityListener.class, this);
        XRayHack.MC.field_1769.method_3279();
        if (this.optiFineWarning != null) {
            ChatUtils.warning(this.optiFineWarning);
        }
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(PacketInputListener.class, this.coordinator);
        EVENTS.remove(RenderListener.class, this);
        EVENTS.remove(SetOpaqueCubeListener.class, this);
        EVENTS.remove(GetAmbientOcclusionLightLevelListener.class, this);
        EVENTS.remove(ShouldDrawSideListener.class, this);
        EVENTS.remove(RenderBlockEntityListener.class, this);
        XRayHack.MC.field_1769.method_3279();
        FullbrightHack fullbright = XRayHack.WURST.getHax().fullbrightHack;
        if (!fullbright.isChangingGamma()) {
            ISimpleOption.get(XRayHack.MC.field_1690.method_42473()).forceSetValue(fullbright.getDefaultGamma());
        }
    }

    @Override
    public void onUpdate() {
        boolean curOnly;
        String q;
        boolean resultsChanged;
        boolean changed = this.coordinator.update();
        int matchesVersion = this.coordinator.getMatchesVersion();
        boolean bl = resultsChanged = matchesVersion != this.lastMatchesVersion;
        if (resultsChanged) {
            this.lastMatchesVersion = matchesVersion;
        }
        if (changed || resultsChanged) {
            this.highlightPositionsUpToDate = false;
            this.visibleBoxesUpToDate = false;
            this.lastCoordinatorChangeMs = System.currentTimeMillis();
        }
        ISimpleOption.get(XRayHack.MC.field_1690.method_42473()).forceSetValue(16.0);
        Mode curMode = this.mode.getSelected();
        if (curMode != this.lastMode) {
            this.lastMode = curMode;
            if (curMode == Mode.LIST) {
                this.oreNamesCache = new ArrayList<String>(this.ores.getBlockNames());
                this.lastOresHash = this.ores.getBlockNames().hashCode();
                this.rebuildOreCaches();
                this.resetCoordinatorAndHighlights();
                XRayHack.MC.field_1769.method_3279();
            } else {
                this.oreNamesCache = null;
                this.oreExactIds = null;
                q = this.query.getValue();
                this.oreKeywords = q == null || q.isBlank() ? new String[0] : (String[])Stream.of(q.split(",")).map(s -> s.trim().toLowerCase(Locale.ROOT)).filter(s -> !s.isEmpty()).toArray(String[]::new);
                this.resetCoordinatorAndHighlights();
                XRayHack.MC.field_1769.method_3279();
            }
        }
        if (curMode == Mode.LIST) {
            int currentHash = this.ores.getBlockNames().hashCode();
            if (currentHash != this.lastOresHash) {
                this.lastOresHash = currentHash;
                this.oreNamesCache = new ArrayList<String>(this.ores.getBlockNames());
                this.rebuildOreCaches();
                this.resetCoordinatorAndHighlights();
                XRayHack.MC.field_1769.method_3279();
            } else if (this.oreExactIds == null || this.oreKeywords == null) {
                this.rebuildOreCaches();
            }
        } else {
            q = this.query.getValue();
            if (q == null) {
                q = "";
            }
            String[] newKw = (String[])Stream.of(q.split(",")).map(s -> s.trim().toLowerCase(Locale.ROOT)).filter(s -> !s.isEmpty()).toArray(String[]::new);
            boolean kwChanged = false;
            if (this.oreKeywords == null || this.oreKeywords.length != newKw.length) {
                kwChanged = true;
            } else {
                for (int i = 0; i < newKw.length; ++i) {
                    if (this.oreKeywords[i].equals(newKw[i])) continue;
                    kwChanged = true;
                    break;
                }
            }
            if (kwChanged) {
                this.oreKeywords = newKw;
                this.oreExactIds = null;
                this.resetCoordinatorAndHighlights();
                XRayHack.MC.field_1769.method_3279();
            }
        }
        double currentOpacity = this.opacity.getValue();
        if (currentOpacity != this.lastOpacityVal) {
            this.lastOpacityVal = currentOpacity;
            XRayHack.MC.field_1769.method_3279();
        }
        if ((curOnly = this.onlyExposed.isChecked()) != this.lastOnlyExposed) {
            this.lastOnlyExposed = curOnly;
            this.rebuildVisibleBoxes();
            XRayHack.MC.field_1769.method_3279();
        }
    }

    @Override
    public void onRender(class_4587 matrices, float partialTicks) {
        long now = System.currentTimeMillis();
        if (!this.highlightPositionsUpToDate && this.coordinator.isDone()) {
            this.highlightPositions.clear();
            class_2338 playerPos = XRayHack.MC.field_1724.method_24515();
            Comparator<class_2338> comparator = Comparator.comparingInt(p -> playerPos.method_19455((class_2382)p));
            this.coordinator.getMatches().map(r -> r.pos()).sorted(comparator).limit(this.renderAmount.getValueLog()).forEach(this.highlightPositions::add);
            this.highlightPositionsUpToDate = true;
            this.visibleBoxesUpToDate = false;
        }
        if (!this.visibleBoxesUpToDate) {
            ArrayList<class_238> newBoxes = new ArrayList<class_238>();
            for (class_2338 p2 : this.highlightPositions) {
                if (this.onlyExposed.isChecked() && !this.isExposed(p2)) continue;
                newBoxes.add(new class_238(p2));
            }
            if (!newBoxes.isEmpty() || now - this.lastCoordinatorChangeMs >= 200L) {
                this.visibleBoxes = newBoxes;
                this.visibleBoxesUpToDate = true;
            }
        }
        if (this.visibleBoxes.isEmpty()) {
            return;
        }
        int color = this.getHighlightColorWithAlpha();
        if (this.highlightFill.isChecked()) {
            int fullAlpha = color >>> 24 & 0xFF;
            int halfAlpha = Math.max(1, fullAlpha / 2);
            int rgb = color & 0xFFFFFF;
            int solidColor = halfAlpha << 24 | rgb;
            RenderUtils.drawSolidBoxes(matrices, this.visibleBoxes, solidColor, false);
        }
        if (this.highlightCorners.isChecked()) {
            RenderUtils.drawOutlinedBoxes(matrices, this.visibleBoxes, color, false);
        }
    }

    private void rebuildVisibleBoxes() {
        this.visibleBoxes.clear();
        for (class_2338 p : this.highlightPositions) {
            if (this.onlyExposed.isChecked() && !this.isExposed(p)) continue;
            this.visibleBoxes.add(new class_238(p));
        }
        this.visibleBoxesUpToDate = true;
    }

    @Override
    public void onSetOpaqueCube(SetOpaqueCubeListener.SetOpaqueCubeEvent event) {
        event.cancel();
    }

    @Override
    public void onGetAmbientOcclusionLightLevel(GetAmbientOcclusionLightLevelListener.GetAmbientOcclusionLightLevelEvent event) {
        event.setLightLevel(1.0f);
    }

    @Override
    public void onShouldDrawSide(ShouldDrawSideListener.ShouldDrawSideEvent event) {
        boolean visible = this.isVisible(event.getState().method_26204(), event.getPos());
        if (!visible && this.opacity.getValue() > 0.0) {
            return;
        }
        event.setRendered(visible);
    }

    @Override
    public void onRenderBlockEntity(RenderBlockEntityListener.RenderBlockEntityEvent event) {
        class_2338 pos = event.getState().field_62673;
        if (!this.isVisible(BlockUtils.getBlock(pos), pos)) {
            event.cancel();
        }
    }

    public boolean isVisible(class_2248 block, class_2338 pos) {
        boolean visible;
        block5: {
            String idFull;
            block4: {
                idFull = BlockUtils.getName(block);
                visible = false;
                Mode cur = this.mode.getSelected();
                if (cur != Mode.LIST) break block4;
                if (this.oreExactIds != null) {
                    visible = this.oreExactIds.contains(idFull);
                }
                if (visible || this.oreExactIds != null || this.oreNamesCache == null) break block5;
                visible = this.oreNamesCache.contains(idFull);
                break block5;
            }
            if (this.oreKeywords != null && this.oreKeywords.length > 0) {
                String localId = idFull.contains(":") ? idFull.substring(idFull.indexOf(":") + 1) : idFull;
                String localSpaced = localId.replace('_', ' ');
                String transKey = block.method_63499();
                String display = block.method_9518().getString();
                for (String term : this.oreKeywords) {
                    if (!XRayHack.containsNormalized(idFull, term) && !XRayHack.containsNormalized(localId, term) && !XRayHack.containsNormalized(localSpaced, term) && !XRayHack.containsNormalized(transKey, term) && !XRayHack.containsNormalized(display, term)) continue;
                    visible = true;
                    break;
                }
            }
        }
        if (visible && this.onlyExposed.isChecked() && pos != null) {
            return this.isExposed(pos);
        }
        return visible;
    }

    private boolean isExposed(class_2338 pos) {
        class_2338.class_2339 mutablePos = this.mutablePosForExposedCheck.get();
        for (class_2350 direction : class_2350.values()) {
            if (BlockUtils.isOpaqueFullCube((class_2338)mutablePos.method_25505((class_2382)pos, direction))) continue;
            return true;
        }
        return false;
    }

    private void rebuildOreCaches() {
        HashSet<String> exact = new HashSet<String>();
        ArrayList<String> kw = new ArrayList<String>();
        for (String s : this.oreNamesCache) {
            class_2960 id = class_2960.method_12829((String)s);
            if (id != null) {
                exact.add(id.toString());
                continue;
            }
            if (s == null || s.isBlank()) continue;
            kw.add(s.toLowerCase(Locale.ROOT));
        }
        this.oreExactIds = exact;
        this.oreKeywords = kw.toArray(new String[0]);
    }

    private static boolean containsNormalized(String haystack, String needle) {
        return haystack != null && haystack.toLowerCase(Locale.ROOT).contains(needle);
    }

    public boolean isOpacityMode() {
        return this.isEnabled() && this.opacity.getValue() > 0.0;
    }

    public int getOpacityColorMask() {
        int a = Math.max(0, Math.min(255, (int)Math.round(this.opacity.getValue() * 255.0)));
        if (a == 0) {
            a = 1;
        }
        return a << 24 | 0xFFFFFF;
    }

    public float getOpacityFloat() {
        return this.opacity.getValueF();
    }

    public boolean isHighlightCornersEnabled() {
        return this.isEnabled() && this.highlightCorners.isChecked();
    }

    public int getHighlightColorWithAlpha() {
        int v = (int)Math.round(this.highlightAlpha.getValue());
        v = Math.max(0, Math.min(100, v));
        int alpha = (int)Math.round((double)v / 100.0 * 255.0);
        int rgb = this.highlightColor.getColorI() & 0xFFFFFF;
        return alpha << 24 | rgb;
    }

    public float getHighlightAlphaFloat() {
        return (float)((double)Math.max(1, Math.min(100, (int)Math.round(this.highlightAlpha.getValue()))) / 100.0);
    }

    private String checkOptiFine() {
        Pattern optifine;
        Stream<String> mods = FabricLoader.getInstance().getAllMods().stream().map(ModContainer::getMetadata).map(ModMetadata::getId);
        if (mods.anyMatch((optifine = Pattern.compile("opti(?:fine|fabric).*")).asPredicate())) {
            return "OptiFine is installed. X-Ray will not work properly!";
        }
        return null;
    }

    public void openBlockListEditor(class_437 prevScreen) {
        MC.method_1507((class_437)new EditBlockListScreen(prevScreen, this.ores));
    }

    private void resetCoordinatorAndHighlights() {
        this.coordinator.reset();
        this.lastMatchesVersion = this.coordinator.getMatchesVersion();
        this.highlightPositions.clear();
        this.visibleBoxes.clear();
        this.highlightPositionsUpToDate = false;
        this.visibleBoxesUpToDate = false;
        this.lastCoordinatorChangeMs = System.currentTimeMillis();
    }

    private static enum Mode {
        LIST,
        QUERY;

    }
}

