/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks.itemhandler;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.wurstclient.Category;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.components.ItemListEditButton;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.hacks.ItemEspHack;
import net.wurstclient.hacks.itemhandler.ItemHandlerScreen;
import net.wurstclient.keybinds.PossibleKeybind;
import net.wurstclient.mixinterface.IKeyBinding;
import net.wurstclient.settings.ButtonSetting;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ItemListSetting;
import net.wurstclient.settings.Setting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.InventoryUtils;
import net.wurstclient.util.ItemUtils;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.text.WText;

public class ItemHandlerHack
extends Hack
implements UpdateListener,
RenderListener {
    private static final double SCAN_RADIUS = 2.5;
    private static final double INFINITE_SCAN_RADIUS = 1024.0;
    private static final int WHITELIST_TICKS = 3;
    private final List<GroundItem> trackedItems = new ArrayList<GroundItem>();
    private final Int2IntOpenHashMap pickupWhitelist = new Int2IntOpenHashMap();
    private final Deque<Integer> pickupQueue = new ArrayDeque<Integer>();
    private boolean autoWalking;
    private final List<RejectedRule> rejectedRules = new ArrayList<RejectedRule>();
    private final Map<String, Integer> prevInventoryCounts = new HashMap<String, Integer>();
    private final Set<String> tracedItems = new LinkedHashSet<String>();
    private final SliderSetting rejectRadius = new SliderSetting("Reject radius", 3.0, 0.5, 8.0, 0.25, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting rejectExpiry = new SliderSetting("Pickup/Drop timeout (s)", 15.0, 5.0, 120.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final CheckboxSetting hudEnabled = new CheckboxSetting("Show item popup HUD", true);
    private final CheckboxSetting showRegistryName = new CheckboxSetting("Show registry names", false);
    private final SliderSetting popupMaxItems = new SliderSetting("Popup HUD max items", 8.0, 1.0, 10.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting popupRange = new SliderSetting("Item detection range", 6.0, 1.0, 1024.0, 0.5, SliderSetting.ValueDisplay.DECIMAL.withLabel(1024.0, "\u221e"));
    private final SliderSetting popupScale = new SliderSetting("Popup HUD font scale", 0.75, 0.5, 1.5, 0.05, SliderSetting.ValueDisplay.DECIMAL);
    private final CheckboxSetting respectItemEspIgnores = new CheckboxSetting("Respect ItemESP ignored items", true);
    private final SliderSetting hudOffsetX = new SliderSetting("Popup HUD offset X", -105.0, -300.0, 300.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting hudOffsetY = new SliderSetting("Popup HUD offset Y", -15.0, -200.0, 200.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private boolean pickFilterActive;
    private final Set<String> pickFilterIds = new HashSet<String>();
    private long pickFilterStartMs;
    private long pickFilterTimeoutMs;
    private final Setting itemEspIgnoredListSetting = new Setting(this, "Ignored items", WText.empty()){

        @Override
        public Component getComponent() {
            ItemEspHack esp = WurstClient.INSTANCE.getHax().itemEspHack;
            if (esp == null) {
                return new ItemListEditButton(new ItemListSetting("Ignored items", WText.empty(), new String[0]));
            }
            return new ItemListEditButton(esp.getIgnoredListSetting());
        }

        @Override
        public void fromJson(JsonElement json) {
        }

        @Override
        public JsonElement toJson() {
            return JsonNull.INSTANCE;
        }

        @Override
        public JsonObject exportWikiData() {
            JsonObject json = new JsonObject();
            json.addProperty("name", this.getName());
            json.addProperty("description", this.getDescription());
            json.addProperty("type", "ItemList");
            return json;
        }

        @Override
        public Set<PossibleKeybind> getPossibleKeybinds(String featureName) {
            return Collections.emptySet();
        }
    };

    public ItemHandlerHack() {
        super("ItemHandler");
        this.setCategory(Category.ITEMS);
        this.addPossibleKeybind("itemhandler gui", "ItemHandler GUI (open manual pickup screen)");
        this.addSetting(new ButtonSetting("Open ItemHandler GUI", this::openScreen));
        this.addSetting(this.rejectRadius);
        this.addSetting(this.rejectExpiry);
        this.addSetting(this.hudEnabled);
        this.addSetting(this.showRegistryName);
        this.addSetting(this.popupRange);
        this.addSetting(this.popupScale);
        this.addSetting(this.popupMaxItems);
        this.addSetting(this.respectItemEspIgnores);
        this.addSetting(this.itemEspIgnoredListSetting);
        this.addSetting(this.hudOffsetX);
        this.addSetting(this.hudOffsetY);
    }

    @Override
    protected void onEnable() {
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(RenderListener.class, this);
        this.trackedItems.clear();
        this.pickupWhitelist.clear();
        this.pickupQueue.clear();
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        this.trackedItems.clear();
        this.pickupWhitelist.clear();
        this.pickupQueue.clear();
        this.stopAutoWalk();
        this.rejectedRules.clear();
        this.endPickFilterSession();
        if (ItemHandlerHack.MC.field_1755 instanceof ItemHandlerScreen) {
            MC.method_1507(null);
        }
    }

    @Override
    public void onUpdate() {
        if (ItemHandlerHack.MC.field_1687 == null || ItemHandlerHack.MC.field_1724 == null) {
            this.trackedItems.clear();
            this.pickupWhitelist.clear();
            this.pickupQueue.clear();
            this.stopAutoWalk();
            return;
        }
        this.updateWhitelist();
        this.scanNearbyItems();
        this.updateRejectedRules();
        this.updatePickFilterTimeout();
        this.processRejectedPickup();
        this.processPickupQueue();
    }

    private void updatePickFilterTimeout() {
        if (!this.pickFilterActive) {
            return;
        }
        if (this.pickFilterTimeoutMs <= 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.pickFilterStartMs > this.pickFilterTimeoutMs) {
            this.endPickFilterSession();
            ChatUtils.message("Pick filter: timeout reached, stopping.");
        }
    }

    private void updateRejectedRules() {
        if (this.rejectedRules.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        this.rejectedRules.removeIf(r -> r.expiryMillis > 0L && now > r.createdAt + r.expiryMillis);
    }

    private void processRejectedPickup() {
        String id;
        if (ItemHandlerHack.MC.field_1724 == null) {
            return;
        }
        HashMap<String, Integer> cur = new HashMap<String, Integer>();
        class_1661 inventory = ItemHandlerHack.MC.field_1724.method_31548();
        int maxSlots = 45;
        for (int slot = 0; slot < maxSlots; ++slot) {
            class_1799 stack = inventory.method_5438(slot);
            if (stack == null || stack.method_7960()) continue;
            id = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
            cur.merge(id, stack.method_7947(), Integer::sum);
        }
        if (this.prevInventoryCounts.isEmpty()) {
            this.prevInventoryCounts.putAll(cur);
            return;
        }
        block1: for (Map.Entry e : cur.entrySet()) {
            int prev;
            id = (String)e.getKey();
            int count = (Integer)e.getValue();
            if (count <= (prev = this.prevInventoryCounts.getOrDefault(id, 0).intValue())) continue;
            int gained = count - prev;
            if (gained > 0 && this.tracedItems.contains(id)) {
                this.tracedItems.remove(id);
                ChatUtils.message("Untraced " + id + " after pickup.");
            }
            if (this.pickFilterActive) {
                if (this.pickFilterIds.contains(id)) {
                    this.endPickFilterSession();
                    continue;
                }
                for (int remainingToDrop = gained; remainingToDrop > 0; --remainingToDrop) {
                    int foundSlot = -1;
                    for (int s = 0; s < 45; ++s) {
                        String sid;
                        class_1799 st = inventory.method_5438(s);
                        if (st == null || st.method_7960() || !(sid = class_7923.field_41178.method_10221((Object)st.method_7909()).toString()).equals(id)) continue;
                        foundSlot = s;
                        break;
                    }
                    if (foundSlot < 0) continue block1;
                    int networkSlot = InventoryUtils.toNetworkSlot(foundSlot);
                    IMC.getInteractionManager().windowClick_THROW(networkSlot);
                }
                continue;
            }
            int totalRejected = 0;
            for (RejectedRule r : this.rejectedRules) {
                if (!r.itemId.equals(id) || !r.matchesPosition(ItemHandlerHack.MC.field_1724.method_73189())) continue;
                totalRejected += r.amountRemaining;
            }
            int toDrop = Math.min(gained, totalRejected);
            if (toDrop <= 0) continue;
            int remainingToDrop = toDrop;
            while (remainingToDrop > 0) {
                int foundSlot = -1;
                for (int s = 0; s < maxSlots; ++s) {
                    String sid;
                    class_1799 st = inventory.method_5438(s);
                    if (st == null || st.method_7960() || !(sid = class_7923.field_41178.method_10221((Object)st.method_7909()).toString()).equals(id)) continue;
                    foundSlot = s;
                    break;
                }
                if (foundSlot < 0) continue block1;
                int networkSlot = InventoryUtils.toNetworkSlot(foundSlot);
                IMC.getInteractionManager().windowClick_THROW(networkSlot);
                --remainingToDrop;
                int dropLeft = 1;
                Iterator<RejectedRule> it = this.rejectedRules.iterator();
                while (it.hasNext() && dropLeft > 0) {
                    RejectedRule r = it.next();
                    if (!r.itemId.equals(id) || !r.matchesPosition(ItemHandlerHack.MC.field_1724.method_73189())) continue;
                    int dec = Math.min(r.amountRemaining, dropLeft);
                    r.amountRemaining -= dec;
                    dropLeft -= dec;
                    if (r.amountRemaining > 0) continue;
                    it.remove();
                }
            }
        }
        this.prevInventoryCounts.clear();
        this.prevInventoryCounts.putAll(cur);
    }

    public void beginPickFilterSession(Set<String> desiredIds) {
        this.pickFilterIds.clear();
        if (desiredIds != null) {
            this.pickFilterIds.addAll(desiredIds);
        }
        boolean bl = this.pickFilterActive = !this.pickFilterIds.isEmpty();
        if (this.pickFilterActive) {
            this.pickFilterStartMs = System.currentTimeMillis();
            this.pickFilterTimeoutMs = (long)this.rejectExpiry.getValueI() * 1000L;
            ChatUtils.message("Pick filter: dropping non-target pickups until target or timeout.");
        }
    }

    public void endPickFilterSession() {
        this.pickFilterActive = false;
        this.pickFilterIds.clear();
        this.pickFilterStartMs = 0L;
        this.pickFilterTimeoutMs = 0L;
    }

    private void updateWhitelist() {
        if (this.pickupWhitelist.isEmpty()) {
            return;
        }
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (Int2IntMap.Entry entry : this.pickupWhitelist.int2IntEntrySet()) {
            int ticks = entry.getIntValue() - 1;
            if (ticks <= 0) {
                toRemove.add(entry.getIntKey());
                continue;
            }
            entry.setValue(ticks);
        }
        Iterator iterator = toRemove.iterator();
        while (iterator.hasNext()) {
            int k = (Integer)iterator.next();
            this.pickupWhitelist.remove(k);
        }
    }

    private void scanNearbyItems() {
        class_746 player = ItemHandlerHack.MC.field_1724;
        double sliderRange = this.getPopupRange();
        double scanRadius = Math.max(2.5, sliderRange >= 1024.0 ? 1024.0 : sliderRange);
        List found = ItemHandlerHack.MC.field_1687.method_8390(class_1542.class, player.method_5829().method_1014((double)((float)scanRadius)), this::shouldTrack);
        List foundOrbs = ItemHandlerHack.MC.field_1687.method_8390(class_1303.class, player.method_5829().method_1014((double)((float)scanRadius)), o -> o != null && o.method_5805() && !o.method_31481());
        this.trackedItems.clear();
        for (class_1542 entity : found) {
            String id;
            ItemEspHack esp;
            class_1799 stack = entity.method_6983().method_7972();
            double distance = entity.method_5739((class_1297)player);
            if (this.respectItemEspIgnores.isChecked() && (esp = WurstClient.INSTANCE.getHax().itemEspHack) != null && esp.isIgnoredId(id = ItemUtils.getStackId(stack))) continue;
            this.trackedItems.add(new GroundItem(entity.method_5628(), entity.method_5667(), stack, distance, entity.method_73189()));
        }
        for (Object orb : foundOrbs) {
            double distance = orb.method_5739((class_1297)player);
            class_1799 stack = ItemUtils.createSyntheticXpStack((class_1303)orb);
            this.trackedItems.add(new GroundItem(orb.method_5628(), orb.method_5667(), stack, distance, orb.method_73189()));
        }
        try {
            HashSet<Object> present = new HashSet<Object>();
            for (GroundItem gi : this.trackedItems) {
                String baseId = ItemUtils.getStackId(gi.stack());
                if (baseId == null) {
                    baseId = class_7923.field_41178.method_10221((Object)gi.stack().method_7909()).toString();
                }
                if (ItemUtils.isSyntheticXp(gi.stack())) {
                    int xp = ItemUtils.getXpAmount(gi.stack());
                    present.add(baseId + ":xp:" + xp);
                    continue;
                }
                present.add(baseId);
            }
            Iterator<String> it = this.tracedItems.iterator();
            while (it.hasNext()) {
                String t = it.next();
                if (present.contains(t)) continue;
                it.remove();
                ChatUtils.message("Untraced " + t + " after collection.");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean shouldTrack(class_1542 entity) {
        return entity != null && entity.method_5805() && !entity.method_31481() && !entity.method_6983().method_7960();
    }

    private void processPickupQueue() {
        while (!this.pickupQueue.isEmpty()) {
            if (ItemHandlerHack.MC.field_1724 == null || ItemHandlerHack.MC.field_1687 == null) {
                this.pickupQueue.clear();
                break;
            }
            int targetId = this.pickupQueue.peek();
            class_1542 target = this.getItemEntity(targetId);
            if (target == null || target.method_31481()) {
                this.pickupQueue.poll();
                continue;
            }
            double distance = target.method_5739((class_1297)ItemHandlerHack.MC.field_1724);
            if (distance <= 2.7) {
                this.whitelist(targetId);
                this.pickupQueue.poll();
                continue;
            }
            this.driveToward(target);
            return;
        }
        this.stopAutoWalk();
    }

    private class_1542 getItemEntity(int id) {
        class_1542 item;
        class_1297 entity = ItemHandlerHack.MC.field_1687.method_8469(id);
        return entity instanceof class_1542 ? (item = (class_1542)entity) : null;
    }

    private void driveToward(class_1542 target) {
        if (!(ItemHandlerHack.MC.field_1724 instanceof class_746)) {
            return;
        }
        class_243 targetPos = target.method_73189();
        WURST.getRotationFaker().faceVectorClientIgnorePitch(targetPos);
        IKeyBinding.get(ItemHandlerHack.MC.field_1690.field_1894).simulatePress(true);
        this.autoWalking = true;
    }

    private void stopAutoWalk() {
        if (!this.autoWalking) {
            return;
        }
        IKeyBinding.get(ItemHandlerHack.MC.field_1690.field_1894).resetPressedState();
        this.autoWalking = false;
    }

    private void whitelist(int entityId) {
        this.pickupWhitelist.put(entityId, 3);
    }

    public boolean shouldAllowPickup(class_1542 entity) {
        return entity != null && this.pickupWhitelist.containsKey(entity.method_5628());
    }

    public List<GroundItem> getTrackedItems() {
        return List.copyOf(this.trackedItems);
    }

    public void openScreen() {
        if (ItemHandlerHack.MC.field_1724 == null || ItemHandlerHack.MC.field_1687 == null) {
            return;
        }
        class_437 prev = ItemHandlerHack.MC.field_1755;
        MC.method_1507((class_437)new ItemHandlerScreen(prev, this));
    }

    public void requestPickup(Collection<Integer> entityIds) {
        if (entityIds == null || entityIds.isEmpty()) {
            return;
        }
        for (int entityId : entityIds) {
            if (entityId == 0 || this.pickupQueue.contains(entityId)) {
                this.whitelist(entityId);
                continue;
            }
            this.pickupQueue.add(entityId);
        }
    }

    public void addRejectedRulesFromItems(Collection<GroundItem> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        double radius = this.rejectRadius.getValueF();
        long expiryMillis = (long)this.rejectExpiry.getValueI() * 1000L;
        for (GroundItem gi : items) {
            String itemId = class_7923.field_41178.method_10221((Object)gi.stack().method_7909()).toString();
            int amt = gi.stack().method_7947();
            this.rejectedRules.add(new RejectedRule(itemId, gi.position(), radius, expiryMillis, amt));
        }
    }

    public void toggleTracedItem(String itemId) {
        if (itemId == null) {
            return;
        }
        if (this.tracedItems.contains(itemId)) {
            this.tracedItems.remove(itemId);
        } else {
            this.tracedItems.add(itemId);
        }
    }

    public void setTraced(String itemId, boolean traced) {
        if (itemId == null) {
            return;
        }
        if (traced) {
            this.tracedItems.add(itemId);
        } else {
            this.tracedItems.remove(itemId);
        }
    }

    public boolean isTraced(String itemId) {
        return itemId != null && this.tracedItems.contains(itemId);
    }

    public Set<String> getTracedItems() {
        return Set.copyOf(this.tracedItems);
    }

    public boolean isHudEnabled() {
        return this.hudEnabled.isChecked();
    }

    public double getPopupRange() {
        return this.popupRange.getValueF();
    }

    public double getPopupScale() {
        return this.popupScale.getValueF();
    }

    public int getPopupMaxItems() {
        return this.popupMaxItems.getValueI();
    }

    public int getHudOffsetX() {
        return this.hudOffsetX.getValueI();
    }

    public int getHudOffsetY() {
        return this.hudOffsetY.getValueI();
    }

    public boolean isShowRegistryName() {
        return this.showRegistryName.isChecked();
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        boolean hasTracers;
        boolean shouldDrawTracers;
        if (this.tracedItems.isEmpty()) {
            return;
        }
        ItemEspHack esp = WurstClient.INSTANCE.getHax().itemEspHack;
        boolean espEnabled = esp != null && esp.isEnabled();
        boolean espHasTracerLines = espEnabled && esp.rendersTracerLines();
        boolean shouldDrawBoxes = !espEnabled;
        boolean bl = shouldDrawTracers = !espHasTracerLines;
        if (!shouldDrawBoxes && !shouldDrawTracers) {
            return;
        }
        ArrayList<class_238> boxes = shouldDrawBoxes ? new ArrayList<class_238>() : null;
        ArrayList<class_243> ends = shouldDrawTracers ? new ArrayList<class_243>() : null;
        for (GroundItem gi : this.trackedItems) {
            boolean traced;
            String baseId = ItemUtils.getStackId(gi.stack());
            if (baseId == null) {
                baseId = class_7923.field_41178.method_10221((Object)gi.stack().method_7909()).toString();
            }
            if (!(traced = this.isTraced(baseId)) && ItemUtils.isSyntheticXp(gi.stack())) {
                int xp = ItemUtils.getXpAmount(gi.stack());
                traced = this.isTraced(baseId + ":xp:" + xp);
            }
            if (!traced) continue;
            class_243 p = gi.position();
            if (shouldDrawBoxes) {
                boxes.add(new class_238(p.field_1352 - 0.18, p.field_1351 - 0.18, p.field_1350 - 0.18, p.field_1352 + 0.18, p.field_1351 + 0.18, p.field_1350 + 0.18));
            }
            if (!shouldDrawTracers) continue;
            ends.add(p);
        }
        boolean hasBoxes = shouldDrawBoxes && boxes != null && !boxes.isEmpty();
        boolean bl2 = hasTracers = shouldDrawTracers && ends != null && !ends.isEmpty();
        if (!hasBoxes && !hasTracers) {
            return;
        }
        float[] rf = RenderUtils.getRainbowColor();
        int traceLines = RenderUtils.toIntColor(rf, 0.5f);
        int traceQuads = RenderUtils.toIntColor(rf, 0.35f);
        if (hasBoxes) {
            RenderUtils.drawSolidBoxes(matrixStack, boxes, traceQuads, false);
            RenderUtils.drawOutlinedBoxes(matrixStack, boxes, traceLines, false);
        }
        if (hasTracers) {
            RenderUtils.drawTracers(matrixStack, partialTicks, ends, traceLines, false);
        }
    }

    private static final class RejectedRule {
        final String itemId;
        final class_243 center;
        final double radius;
        final long createdAt;
        final long expiryMillis;
        int amountRemaining;

        RejectedRule(String itemId, class_243 center, double radius, long expiryMillis, int amount) {
            this.itemId = itemId;
            this.center = center;
            this.radius = radius;
            this.createdAt = System.currentTimeMillis();
            this.expiryMillis = expiryMillis;
            this.amountRemaining = amount;
        }

        boolean matchesPosition(class_243 playerPos) {
            double dist = playerPos.method_1022(this.center);
            return dist <= this.radius;
        }
    }

    public record GroundItem(int entityId, UUID uuid, class_1799 stack, double distance, class_243 position) {
        public String key() {
            return this.uuid.toString();
        }

        public ComponentSummary summary() {
            return new ComponentSummary(this.stack.method_7964().getString(), this.stack.method_7947(), this.distance);
        }
    }

    public record ComponentSummary(String displayName, int count, double distance) {
        public String distanceText() {
            return String.format(Locale.ROOT, "%.2f m", this.distance);
        }
    }
}

