/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.locator;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_11226;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_11226.class})
public class LocatorBarMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"WurstLocator");
    private static long lastLogMs = 0L;
    private static boolean mixinAppliedLogged = false;

    @Inject(method={"method_70868(Lnet/minecraft/class_332;Lnet/minecraft/class_9779;)V"}, at={@At(value="TAIL")})
    private void onRenderAddons(class_332 ctx, class_9779 rtc, CallbackInfo ci) {
        long now;
        if (!mixinAppliedLogged) {
            mixinAppliedLogged = true;
            LOGGER.info("[WurstLocator] mixin applied");
        }
        if ((now = System.currentTimeMillis()) - lastLogMs < 5000L) {
            return;
        }
        lastLogMs = now;
        try {
            int logged = 0;
            for (Class<?> cls = this.getClass(); cls != null && cls != Object.class; cls = cls.getSuperclass()) {
                for (Field f : cls.getDeclaredFields()) {
                    try {
                        f.setAccessible(true);
                        Object v2 = f.get(this);
                        String type = f.getType().getName();
                        String summary = LocatorBarMixin.summarizeValue(v2, 4);
                        LOGGER.info("[WurstLocator] field={} type={} value={}", new Object[]{f.getName(), type, summary});
                        ++logged;
                    }
                    catch (Throwable v2) {
                        // empty catch block
                    }
                }
            }
            if (logged == 0) {
                LOGGER.info("[WurstLocator] no fields discovered via reflection");
            }
            block8: for (Field fOuter : this.getClass().getDeclaredFields()) {
                try {
                    int i;
                    fOuter.setAccessible(true);
                    Object v = fOuter.get(this);
                    if (v == null) continue;
                    int verboseLimit = 6;
                    if (v instanceof Collection) {
                        Collection col = (Collection)v;
                        i = 0;
                        for (Object e : col) {
                            if (i++ >= verboseLimit) break;
                            LOGGER.info("[WurstLocator] verbose field={} elemClass={} sample={}", new Object[]{fOuter.getName(), e == null ? "null" : e.getClass().getName(), LocatorBarMixin.pretty(e)});
                        }
                        if (col.size() <= verboseLimit) continue;
                        LOGGER.info("[WurstLocator] verbose field={} has {}+ elements", (Object)fOuter.getName(), (Object)col.size());
                        continue;
                    }
                    if (v.getClass().isArray()) {
                        int len = Array.getLength(v);
                        for (i = 0; i < Math.min(len, verboseLimit); ++i) {
                            Object e = Array.get(v, i);
                            LOGGER.info("[WurstLocator] verbose field={} elemClass={} sample={}", new Object[]{fOuter.getName(), e == null ? "null" : e.getClass().getName(), LocatorBarMixin.pretty(e)});
                        }
                        if (len <= verboseLimit) continue;
                        LOGGER.info("[WurstLocator] verbose field={} has {}+ elements", (Object)fOuter.getName(), (Object)len);
                        continue;
                    }
                    if (v instanceof Map) {
                        Map map = (Map)v;
                        i = 0;
                        for (Map.Entry entry : map.entrySet()) {
                            if (i++ >= verboseLimit) continue block8;
                            Object key = entry.getKey();
                            Object val = entry.getValue();
                            LOGGER.info("[WurstLocator] verbose field={} mapEntry keyClass={} valClass={} valSample={}", new Object[]{fOuter.getName(), key == null ? "null" : key.getClass().getName(), val == null ? "null" : val.getClass().getName(), LocatorBarMixin.pretty(val)});
                        }
                        continue;
                    }
                    String s = String.valueOf(v);
                    if (s.length() <= 0 || s.length() >= 200 && !s.toLowerCase().contains("name") && !s.toLowerCase().contains("uuid") && !s.toLowerCase().contains("distance") && !s.toLowerCase().contains("pos")) continue;
                    LOGGER.info("[WurstLocator] verbose field={} class={} toString={}", new Object[]{fOuter.getName(), v.getClass().getName(), s.length() > 400 ? s.substring(0, 400) + "..." : s});
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable t) {
            LOGGER.warn("[WurstLocator] introspect error: {}", (Object)t.toString());
        }
    }

    private static String summarizeValue(Object v, int limit) {
        if (v == null) {
            return "null";
        }
        try {
            if (v instanceof Collection) {
                Collection col = (Collection)v;
                return "Collection(size=" + col.size() + ", sample=" + LocatorBarMixin.sampleCollection(col, limit) + ")";
            }
            if (v instanceof Map) {
                Map map = (Map)v;
                return "Map(size=" + map.size() + ", sampleKeys=" + LocatorBarMixin.sampleCollection(map.keySet(), limit) + ")";
            }
            Class<?> c = v.getClass();
            if (c.isArray()) {
                int len = Array.getLength(v);
                StringBuilder sb = new StringBuilder();
                sb.append("Array(len=").append(len).append(", sample=[");
                for (int i = 0; i < Math.min(len, limit); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    Object e = Array.get(v, i);
                    sb.append(LocatorBarMixin.pretty(e));
                }
                if (len > limit) {
                    sb.append(",...");
                }
                sb.append("])");
                return sb.toString();
            }
            Object s = String.valueOf(v);
            if (((String)s).length() > 200) {
                s = ((String)s).substring(0, 200) + "...";
            }
            return s;
        }
        catch (Throwable t) {
            return v.getClass().getName();
        }
    }

    private static String sampleCollection(Collection<?> col, int limit) {
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        Iterator<?> it = col.iterator();
        while (it.hasNext() && i < limit) {
            Object e = it.next();
            if (i++ > 0) {
                sb.append(',');
            }
            sb.append(LocatorBarMixin.pretty(e));
        }
        if (col.size() > limit) {
            sb.append(",...");
        }
        sb.append(']');
        return sb.toString();
    }

    private static String pretty(Object o) {
        if (o == null) {
            return "null";
        }
        try {
            Object s = String.valueOf(o);
            if (((String)s).length() > 120) {
                s = ((String)s).substring(0, 120) + "...";
            }
            return s;
        }
        catch (Throwable t) {
            return o.getClass().getName();
        }
    }

    @Inject(method={"method_70865(Lnet/minecraft/class_332;Lnet/minecraft/class_9779;)V"}, at={@At(value="TAIL")})
    private void onRenderBar(class_332 ctx, class_9779 rtc, CallbackInfo ci) {
        try {
            Class<?> cls = Class.forName("net.wurstclient.locator.LocatorDataStore");
            Method getEntries = cls.getMethod("getEntries", new Class[0]);
            Object entries = getEntries.invoke(null, new Object[0]);
            boolean empty = true;
            if (entries instanceof Collection) {
                empty = ((Collection)entries).isEmpty();
            }
            if (!empty) {
                return;
            }
            Method clear = cls.getMethod("clear", new Class[0]);
            clear.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

