/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.lootsearch;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.wurstclient.chestsearch.ChestEntry;
import net.wurstclient.chestsearch.ChestManager;
import net.wurstclient.lootsearch.LootSearchUtil;

public class LootChestManager
extends ChestManager {
    private final List<ChestEntry> entries = new ArrayList<ChestEntry>();

    public LootChestManager(File lootFile, String serverIp) {
        if (lootFile != null && lootFile.exists()) {
            this.entries.addAll(LootSearchUtil.parseLootFile(lootFile, serverIp));
        }
    }

    @Override
    public List<ChestEntry> search(String q) {
        if (q == null || q.isBlank()) {
            return new ArrayList<ChestEntry>(this.entries);
        }
        String qq = q.toLowerCase();
        ArrayList<ChestEntry> out = new ArrayList<ChestEntry>();
        for (ChestEntry e : this.entries) {
            boolean matched = false;
            if (e.dimension != null && e.dimension.toLowerCase().contains(qq)) {
                matched = true;
            }
            if (!matched && e.items != null) {
                for (ChestEntry.ItemEntry it : e.items) {
                    if (it == null || it.itemId == null || !it.itemId.toLowerCase().contains(qq)) continue;
                    matched = true;
                    break;
                }
            }
            if (!matched) continue;
            out.add(e);
        }
        return out;
    }

    @Override
    public List<ChestEntry> all() {
        return new ArrayList<ChestEntry>(this.entries);
    }

    @Override
    public void removeChest(String serverIp, String dimension, int x, int y, int z) {
        this.entries.removeIf(e -> e.x == x && e.y == y && e.z == z);
    }
}

