/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.lootsearch;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_7923;
import net.wurstclient.WurstClient;
import net.wurstclient.chestsearch.ChestEntry;

public final class LootSearchUtil {
    private LootSearchUtil() {
    }

    public static File getSeedmapperLootDir() {
        File f;
        String appdata;
        try {
            if (WurstClient.MC != null && WurstClient.MC.field_1697 != null) {
                return new File(WurstClient.MC.field_1697, "seedmapper/loot");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win") && (appdata = System.getenv("APPDATA")) != null && !appdata.isBlank() && (f = new File(new File(appdata), ".minecraft/seedmapper/loot")).exists()) {
            return f;
        }
        String user = System.getProperty("user.home");
        return new File(new File(user, ".minecraft"), "seedmapper/loot");
    }

    public static File findFileForServer(String serverIp) {
        if (serverIp == null) {
            return null;
        }
        File dir = LootSearchUtil.getSeedmapperLootDir();
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return null;
        }
        File best = null;
        File[] files = dir.listFiles((d, name) -> name.toLowerCase().endsWith(".json"));
        if (files == null) {
            return null;
        }
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add(serverIp);
        if (serverIp.contains(":")) {
            candidates.add(serverIp.replace(':', '_'));
            String host = serverIp.split(":", 2)[0];
            candidates.add(host);
        } else {
            int u = serverIp.indexOf(95);
            if (u > 0) {
                candidates.add(serverIp.substring(0, u));
            }
        }
        block0: for (File f : files) {
            String name2 = f.getName();
            String lower = name2.toLowerCase();
            for (String cand : candidates) {
                String c;
                if (cand == null || cand.isBlank() || !lower.startsWith((c = cand.toLowerCase()) + "_") && !lower.contains(c + "_") && !lower.startsWith(c)) continue;
                if (best != null && f.lastModified() <= best.lastModified()) continue block0;
                best = f;
                continue block0;
            }
        }
        return best;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<ChestEntry> parseLootFile(File file, String serverIp) {
        ArrayList<ChestEntry> out = new ArrayList<ChestEntry>();
        if (file == null) return out;
        if (!file.exists()) {
            return out;
        }
        try (FileReader r = new FileReader(file);){
            JsonArray structs;
            JsonElement root = JsonParser.parseReader((Reader)r);
            if (root == null || !root.isJsonObject()) {
                ArrayList<ChestEntry> arrayList = out;
                return arrayList;
            }
            JsonObject obj = root.getAsJsonObject();
            String dimension = obj.has("dimension") ? obj.get("dimension").getAsString() : null;
            JsonArray jsonArray = structs = obj.has("structures") ? obj.getAsJsonArray("structures") : null;
            if (structs == null) {
                ArrayList<ChestEntry> arrayList = out;
                return arrayList;
            }
            Iterator iterator = structs.iterator();
            while (iterator.hasNext()) {
                JsonArray items;
                JsonElement se = (JsonElement)iterator.next();
                if (!se.isJsonObject()) continue;
                JsonObject s = se.getAsJsonObject();
                int x = s.has("x") ? s.get("x").getAsInt() : 0;
                int y = s.has("y") ? s.get("y").getAsInt() : 0;
                int z = s.has("z") ? s.get("z").getAsInt() : 0;
                ChestEntry ce = new ChestEntry();
                ce.serverIp = serverIp;
                ce.dimension = dimension;
                ce.x = x;
                ce.y = y;
                ce.z = z;
                ce.maxX = x;
                ce.maxY = y;
                ce.maxZ = z;
                ce.items = new ArrayList<ChestEntry.ItemEntry>();
                JsonArray jsonArray2 = items = s.has("items") ? s.getAsJsonArray("items") : null;
                if (items != null) {
                    HashMap<String, Integer> sums = new HashMap<String, Integer>();
                    for (JsonElement ie : items) {
                        int count;
                        if (!ie.isJsonObject()) continue;
                        JsonObject it = ie.getAsJsonObject();
                        String id = it.has("id") ? it.get("id").getAsString() : null;
                        int n = count = it.has("count") ? it.get("count").getAsInt() : 1;
                        if (id == null) continue;
                        sums.put(id, sums.getOrDefault(id, 0) + count);
                    }
                    int slot = 0;
                    for (Map.Entry e : sums.entrySet()) {
                        ChestEntry.ItemEntry ie = new ChestEntry.ItemEntry();
                        ie.slot = slot++;
                        ie.count = (Integer)e.getValue();
                        ie.itemId = (String)e.getKey();
                        ie.displayName = null;
                        ie.nbt = null;
                        ce.items.add(ie);
                    }
                }
                out.add(ce);
            }
            return out;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return out;
    }

    public static ChestEntry findEntryByPos(List<ChestEntry> entries, int x, int y, int z) {
        if (entries == null) {
            return null;
        }
        for (ChestEntry e : entries) {
            if (e == null || e.x != x || e.y != y || e.z != z) continue;
            return e;
        }
        return null;
    }

    public static boolean compareStacksWithLoot(String serverIp, String dimension, int x, int y, int z, List<class_1799> stacks) {
        try {
            File f = LootSearchUtil.findFileForServer(serverIp);
            if (f == null) {
                return true;
            }
            List<ChestEntry> entries = LootSearchUtil.parseLootFile(f, serverIp);
            ChestEntry expected = LootSearchUtil.findEntryByPos(entries, x, y, z);
            if (expected == null) {
                return true;
            }
            HashMap<String, Integer> exp = new HashMap<String, Integer>();
            if (expected.items != null) {
                for (ChestEntry.ItemEntry it : expected.items) {
                    if (it == null || it.itemId == null) continue;
                    exp.put(it.itemId, exp.getOrDefault(it.itemId, 0) + it.count);
                }
            }
            HashMap<String, Integer> actual = new HashMap<String, Integer>();
            if (stacks != null) {
                for (class_1799 class_17992 : stacks) {
                    String id;
                    if (class_17992 == null || class_17992.method_7960()) continue;
                    try {
                        id = class_7923.field_41178.method_10221((Object)class_17992.method_7909()).toString();
                    }
                    catch (Throwable t) {
                        id = class_17992.method_7909().toString();
                    }
                    actual.put(id, actual.getOrDefault(id, 0) + class_17992.method_7947());
                }
            }
            if (exp.size() != actual.size()) {
                return false;
            }
            for (Map.Entry entry : exp.entrySet()) {
                Integer got = (Integer)actual.get(entry.getKey());
                if (got != null && got.equals(entry.getValue())) continue;
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return true;
        }
    }
}

