/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.navigator;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.wurstclient.options.EnterProfileNameScreen;

public final class NavigatorListScreen
extends class_437 {
    private static final int ROW_HEIGHT = 20;
    private static final int CONNECT_WIDTH = 70;
    private static final int COMMAND_WIDTH = 80;
    private static final int BUTTON_HEIGHT = 16;
    private final List<String> entries;
    private final Consumer<String> connectCallback;
    private final BiConsumer<String, String> commandCallback;
    private final class_437 returnScreen;
    private final Runnable onCancel;
    private class_4185 cancelButton;
    private double scrollOffset;
    private int listLeft;
    private int listRight;
    private int listTop;
    private int listBottom;

    public NavigatorListScreen(class_2561 title, List<String> entries, Consumer<String> connectCallback, BiConsumer<String, String> commandCallback, class_437 returnScreen, Runnable onCancel) {
        super(title);
        this.entries = new ArrayList<String>(entries != null ? entries : List.of());
        this.connectCallback = connectCallback;
        this.commandCallback = commandCallback;
        this.returnScreen = returnScreen;
        this.onCancel = onCancel;
    }

    public void method_25426() {
        this.listLeft = this.field_22789 / 2 - 150;
        this.listRight = this.field_22789 / 2 + 150;
        this.listTop = 35;
        this.listBottom = this.field_22790 - 60;
        this.scrollOffset = 0.0;
        this.cancelButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), button -> this.cancelSelection()).method_46434(this.field_22789 / 2 - 50, this.field_22790 - 30, 100, 20).method_46431());
    }

    public boolean method_25404(class_11908 event) {
        if (event.comp_4795() == 256) {
            this.cancelSelection();
            return true;
        }
        return super.method_25404(event);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int maxScroll = Math.max(0, this.entries.size() * 20 - (this.listBottom - this.listTop));
        this.scrollOffset = class_3532.method_15350((double)(this.scrollOffset - verticalAmount * 20.0 / 2.0), (double)0.0, (double)maxScroll);
        return true;
    }

    public boolean method_25402(class_11909 context, boolean doubleClick) {
        double relativeY;
        int index;
        double mouseX = context.comp_4798();
        double mouseY = context.comp_4799();
        int button = context.method_74245();
        if (button == 0 && mouseX >= (double)this.listLeft && mouseX <= (double)this.listRight && mouseY >= (double)this.listTop && mouseY <= (double)this.listBottom && (index = (int)((relativeY = mouseY - (double)this.listTop + this.scrollOffset) / 20.0)) >= 0 && index < this.entries.size()) {
            int rowY = (int)((double)(this.listTop + index * 20) - this.scrollOffset);
            int connectX1 = this.listRight - 70 - 6;
            int connectY1 = rowY + 2;
            int connectX2 = connectX1 + 70;
            int connectY2 = connectY1 + 16;
            int commandX1 = connectX1 - 80 - 4;
            int commandY1 = connectY1;
            int commandX2 = commandX1 + 80;
            int commandY2 = connectY2;
            if (mouseX >= (double)connectX1 && mouseX < (double)connectX2 && mouseY >= (double)connectY1 && mouseY < (double)connectY2) {
                this.selectEntry(this.entries.get(index));
                return true;
            }
            if (mouseX >= (double)commandX1 && mouseX < (double)commandX2 && mouseY >= (double)commandY1 && mouseY < (double)commandY2) {
                this.promptCommand(this.entries.get(index));
                return true;
            }
        }
        return super.method_25402(context, doubleClick);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTicks) {
        context.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        context.method_25300(this.field_22787.field_1772, this.field_22785.getString(), this.field_22789 / 2, 15, -1);
        this.renderList(context, mouseX, mouseY);
        for (class_4068 renderable : this.field_33816) {
            renderable.method_25394(context, mouseX, mouseY, partialTicks);
        }
    }

    private void renderList(class_332 context, int mouseX, int mouseY) {
        context.method_25294(this.listLeft - 2, this.listTop - 2, this.listRight + 2, this.listBottom + 2, -16777216);
        context.method_25294(this.listLeft, this.listTop, this.listRight, this.listBottom, -16777216);
        int startIndex = Math.max(0, (int)Math.floor(this.scrollOffset / 20.0));
        int maxVisible = (int)Math.ceil((double)(this.listBottom - this.listTop) / 20.0) + 1;
        for (int i = startIndex; i < this.entries.size() && i < startIndex + maxVisible; ++i) {
            int rowY = (int)((double)(this.listTop + i * 20) - this.scrollOffset);
            if (rowY + 20 < this.listTop || rowY > this.listBottom) continue;
            String name = this.entries.get(i);
            context.method_25303(this.field_22787.field_1772, name, this.listLeft + 6, rowY + 4, -1);
            int connectX1 = this.listRight - 70 - 6;
            int connectY1 = rowY + 2;
            int connectX2 = connectX1 + 70;
            int connectY2 = connectY1 + 16;
            boolean connectHover = mouseX >= connectX1 && mouseY >= connectY1 && mouseX < connectX2 && mouseY < connectY2;
            int connectColor = connectHover ? -6250336 : -12566464;
            context.method_25294(connectX1, connectY1, connectX2, connectY2, connectColor);
            context.method_25300(this.field_22787.field_1772, "Connect", connectX1 + 35, connectY1 + 4, -1);
            int commandX1 = connectX1 - 80 - 4;
            int commandY1 = connectY1;
            int commandX2 = commandX1 + 80;
            int commandY2 = connectY2;
            boolean commandHover = mouseX >= commandX1 && mouseY >= commandY1 && mouseX < commandX2 && mouseY < commandY2;
            int commandColor = commandHover ? -6250336 : -12566464;
            context.method_25294(commandX1, commandY1, commandX2, commandY2, commandColor);
            context.method_25300(this.field_22787.field_1772, "Command", commandX1 + 40, commandY1 + 4, -1);
        }
    }

    private void selectEntry(String entry) {
        if (entry == null || entry.isEmpty()) {
            return;
        }
        if (this.connectCallback != null) {
            this.connectCallback.accept(entry);
        }
        this.close();
    }

    private void promptCommand(String entry) {
        if (this.commandCallback == null || entry == null || entry.isEmpty()) {
            return;
        }
        this.field_22787.method_1507((class_437)new EnterProfileNameScreen(this, input -> {
            if (input == null) {
                return;
            }
            String trimmed = input.trim();
            if (trimmed.isEmpty()) {
                return;
            }
            this.commandCallback.accept(entry, trimmed);
        }, (class_2561)class_2561.method_43470((String)"Enter reconnect command"), value -> value != null && !value.trim().isEmpty()));
    }

    private void cancelSelection() {
        if (this.onCancel != null) {
            this.onCancel.run();
        }
        this.close();
    }

    private void close() {
        this.field_22787.method_1507(this.returnScreen);
    }
}

