/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.seedmapper;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public final class SeedMapperData {
    private static final List<String> DEFAULT_HIGHLIGHT_BLOCKS = List.of("ancient_debris", "andesite", "basalt", "blackstone", "clay", "coal_ore", "copper_ore", "deepslate", "diamond_ore", "diorite", "dirt", "emerald_ore", "gold_ore", "granite", "gravel", "iron_ore", "lapis_ore", "magma_block", "netherrack", "nether_gold_ore", "nether_quartz_ore", "raw_copper_block", "raw_iron_block", "redstone_ore", "soul_sand", "stone", "tuff");
    private static final List<String> DEFAULT_CANYON_CARVERS = List.of("canyon", "underwater_canyon");
    private static final List<String> DEFAULT_CAVE_CARVERS = List.of("cave", "cave_extra_underground", "ocean_cave", "underwater_cave", "nether_cave");
    private static final List<String> DEFAULT_BIOMES = List.of("plains", "sunflower_plains", "desert", "savanna", "savanna_plateau", "forest", "flower_forest", "birch_forest", "dark_forest", "old_growth_spruce_taiga", "taiga", "snowy_taiga", "snowy_plains", "mushroom_fields", "swamp", "mangrove_swamp", "jungle", "bamboo_jungle", "badlands", "eroded_badlands", "cherry_grove", "windswept_forest", "windswept_hills", "frozen_peaks", "stony_peaks", "dripstone_caves", "lush_caves", "deep_dark", "nether_wastes", "crimson_forest", "warped_forest", "basalt_deltas", "soul_sand_valley", "the_end", "small_end_islands", "end_midlands", "end_highlands");
    private static final List<String> DEFAULT_ENCHANTMENTS = List.of("protection", "fire_protection", "feather_falling", "blast_protection", "projectile_protection", "respiration", "aqua_affinity", "thorns", "depth_strider", "frost_walker", "soul_speed", "swift_sneak", "sharpness", "smite", "bane_of_arthropods", "knockback", "fire_aspect", "looting", "sweeping_edge", "efficiency", "silk_touch", "unbreaking", "fortune", "power", "punch", "flame", "infinity", "luck_of_the_sea", "lure", "loyalty", "impaling", "riptide", "channeling", "multishot", "quick_charge", "piercing", "mending", "binding_curse", "vanishing_curse");
    private static final List<String> DEFAULT_STRUCTURES = List.of("feature", "ancient_city", "bastion_remnant", "buried_treasure", "canyon", "desert_pyramid", "desert_well", "end_city", "end_city_ship", "end_gateway", "end_island", "fortress", "geode", "igloo", "jungle_pyramid", "mansion", "mineshaft", "monument", "ocean_ruin", "pillager_outpost", "ruined_portal", "ruined_portal_nether", "shipwreck", "stronghold", "swamp_hut", "trail_ruins", "trial_chambers", "village");
    private static final Map<String, List<String>> DEFAULT_STRUCTURE_PIECES = SeedMapperData.createDefaultStructurePieces();
    private static final Map<String, List<String>> DEFAULT_STRUCTURE_VARIANTS = SeedMapperData.createDefaultStructureVariants();
    private static final List<String> DEFAULT_GENERIC_VARIANTS = List.of("biome", "rotation", "mirrored");
    private static final List<String> DEFAULT_DENSITY_FUNCTIONS = List.of("overworld.base_3d_noise", "overworld.caves.spaghetti_roughness_function", "overworld.caves.spaghetti_2d_thickness_modulator", "overworld.caves.spaghetti_2d", "spaghetti_3d", "cave_entrance", "overworld.caves.entrances", "cave_layer", "overworld.sloped_cheese", "cave_cheese", "overworld.caves.pillars", "overworld.caves.noodle", "underground", "final_density", "preliminary_surface_level");
    private static final List<String> DEFAULT_DIMENSIONS = List.of("overworld", "the_nether", "the_end");
    private static final List<String> DEFAULT_WORLD_PRESETS = List.of("amplified", "superflat", "large_biomes", "single_biome", "default");
    private static final List<String> DEFAULT_VERSION_SHORTCUTS = List.of("auto", "latest", "1.21.1", "1.21", "1.20.6", "1.20.4", "1.20.2", "1.20.1", "1.19.4", "1.19.2", "1.18.2", "1.17.1", "1.16.5", "1.12.2");
    private static final List<String> DEFAULT_ORE_VEINS = List.of("copper", "iron");
    private final List<String> highlightBlocks;
    private final List<String> canyonCarvers;
    private final List<String> caveCarvers;
    private final List<String> biomeKeys;
    private final List<String> structureKeys;
    private final Map<String, List<String>> structurePieces;
    private final Map<String, List<String>> structureVariants;
    private final List<String> variantKeyUnion;
    private final List<String> lootItems;
    private final List<String> lootEnchantments;
    private final List<String> densityFunctions;
    private final List<String> dimensionShortcuts;
    private final List<String> versionShortcuts;
    private final List<String> worldPresets;

    private SeedMapperData(List<String> highlightBlocks, List<String> canyonCarvers, List<String> caveCarvers, List<String> biomeKeys, List<String> structureKeys, Map<String, List<String>> structurePieces, Map<String, List<String>> structureVariants, List<String> variantKeyUnion, List<String> lootItems, List<String> lootEnchantments, List<String> densityFunctions, List<String> dimensionShortcuts, List<String> versionShortcuts, List<String> worldPresets) {
        this.highlightBlocks = highlightBlocks;
        this.canyonCarvers = canyonCarvers;
        this.caveCarvers = caveCarvers;
        this.biomeKeys = biomeKeys;
        this.structureKeys = structureKeys;
        this.structurePieces = structurePieces;
        this.structureVariants = structureVariants;
        this.variantKeyUnion = variantKeyUnion;
        this.lootItems = lootItems;
        this.lootEnchantments = lootEnchantments;
        this.densityFunctions = densityFunctions;
        this.dimensionShortcuts = dimensionShortcuts;
        this.versionShortcuts = versionShortcuts;
        this.worldPresets = worldPresets;
    }

    public List<String> getHighlightBlocks() {
        return this.highlightBlocks;
    }

    public List<String> getCanyonCarvers() {
        return this.canyonCarvers;
    }

    public List<String> getCaveCarvers() {
        return this.caveCarvers;
    }

    public List<String> getBiomeKeys() {
        return this.biomeKeys;
    }

    public List<String> getStructureKeys() {
        return this.structureKeys;
    }

    public List<String> getStructurePieces(String structure) {
        return this.structurePieces.getOrDefault(structure, Collections.emptyList());
    }

    public boolean supportsPieceFilters(String structure) {
        return this.structurePieces.containsKey(structure);
    }

    public List<String> getStructureVariants(String structure) {
        return this.structureVariants.getOrDefault(structure, Collections.emptyList());
    }

    public boolean supportsVariantFilters(String structure) {
        return this.structureVariants.containsKey(structure);
    }

    public List<String> getVariantKeyUnion() {
        return this.variantKeyUnion;
    }

    public List<String> getGenericVariantKeys() {
        return DEFAULT_GENERIC_VARIANTS;
    }

    public List<String> getLootItems() {
        return this.lootItems;
    }

    public List<String> getLootEnchantments() {
        return this.lootEnchantments;
    }

    public List<String> getDensityFunctions() {
        return this.densityFunctions;
    }

    public List<String> getDimensionShortcuts() {
        return this.dimensionShortcuts;
    }

    public List<String> getVersionShortcuts() {
        return this.versionShortcuts;
    }

    public List<String> getWorldPresets() {
        return this.worldPresets;
    }

    public List<String> getOreVeinTargets() {
        return DEFAULT_ORE_VEINS;
    }

    public static SeedMapperData createFallback() {
        List<String> biomes = SeedMapperData.fallbackBiomes();
        List<String> items = SeedMapperData.registryKeys(class_7923.field_41178);
        List<String> enchants = SeedMapperData.fallbackEnchantments();
        return new SeedMapperData(SeedMapperData.copySorted(DEFAULT_HIGHLIGHT_BLOCKS), SeedMapperData.copySorted(DEFAULT_CANYON_CARVERS), SeedMapperData.copySorted(DEFAULT_CAVE_CARVERS), biomes, SeedMapperData.copySorted(DEFAULT_STRUCTURES), SeedMapperData.copyMap(DEFAULT_STRUCTURE_PIECES), SeedMapperData.copyMap(DEFAULT_STRUCTURE_VARIANTS), SeedMapperData.buildVariantUnion(DEFAULT_STRUCTURE_VARIANTS), SeedMapperData.limitList(items, 1024), SeedMapperData.limitList(enchants, 256), SeedMapperData.copySorted(DEFAULT_DENSITY_FUNCTIONS), SeedMapperData.copySorted(DEFAULT_DIMENSIONS), SeedMapperData.copySorted(DEFAULT_VERSION_SHORTCUTS), SeedMapperData.copySorted(DEFAULT_WORLD_PRESETS));
    }

    public static SeedMapperData tryLoadFromVendor() {
        List<String> highlightBlocks = SeedMapperData.tryRead(SeedMapperData.supplyValueList("dev.xpple.seedmapper.command.arguments.BlockArgument", "BLOCKS"), DEFAULT_HIGHLIGHT_BLOCKS);
        List<String> canyonCarvers = SeedMapperData.tryRead(SeedMapperData.supplyValueList("dev.xpple.seedmapper.command.arguments.CanyonCarverArgument", "CARVERS"), DEFAULT_CANYON_CARVERS);
        List<String> caveCarvers = SeedMapperData.tryRead(SeedMapperData.supplyValueList("dev.xpple.seedmapper.command.arguments.CaveCarverArgument", "CARVERS"), DEFAULT_CAVE_CARVERS);
        List<String> biomeKeys = SeedMapperData.tryRead(SeedMapperData.supplyValueList("dev.xpple.seedmapper.command.arguments.BiomeArgument", "BIOMES"), SeedMapperData.fallbackBiomes());
        List<String> structureKeys = SeedMapperData.tryRead(SeedMapperData.supplyValueList("dev.xpple.seedmapper.command.arguments.StructurePredicateArgument", "STRUCTURES"), DEFAULT_STRUCTURES);
        Map<String, List<String>> structurePieces = SeedMapperData.tryRead(SeedMapperData.supplyMap("dev.xpple.seedmapper.command.arguments.StructurePredicateArgument", "STRUCTURE_PIECES"), DEFAULT_STRUCTURE_PIECES);
        Map<String, List<String>> structureVariants = SeedMapperData.tryRead(SeedMapperData.supplyMap("dev.xpple.seedmapper.command.arguments.StructurePredicateArgument", "STRUCTURE_VARIANTS"), DEFAULT_STRUCTURE_VARIANTS);
        List<String> lootItems = SeedMapperData.tryRead(SeedMapperData.supplyValueList("dev.xpple.seedmapper.command.arguments.ItemAndEnchantmentsPredicateArgument", "ITEMS"), SeedMapperData.registryKeys(class_7923.field_41178));
        List<String> lootEnchantments = SeedMapperData.tryRead(SeedMapperData.supplyValueList("dev.xpple.seedmapper.command.arguments.ItemAndEnchantmentsPredicateArgument", "ENCHANTMENTS"), SeedMapperData.fallbackEnchantments());
        List<String> densityFunctions = SeedMapperData.tryRead(SeedMapperData.supplyValueList("dev.xpple.seedmapper.command.arguments.DensityFunctionArgument", "DENSITY_FUNCTIONS"), DEFAULT_DENSITY_FUNCTIONS);
        List<String> dimensions = SeedMapperData.tryRead(SeedMapperData.supplyValueList("dev.xpple.seedmapper.command.arguments.DimensionArgument", "DIMENSIONS"), DEFAULT_DIMENSIONS);
        List<String> versionShortcuts = SeedMapperData.tryRead(SeedMapperData.supplyValueList("dev.xpple.seedmapper.command.arguments.VersionArgument", "VERSIONS"), DEFAULT_VERSION_SHORTCUTS);
        List<String> worldPresets = SeedMapperData.tryRead(SeedMapperData.supplyValueList("dev.xpple.seedmapper.command.arguments.PresetArgument", "PRESETS"), DEFAULT_WORLD_PRESETS);
        return new SeedMapperData(SeedMapperData.copySorted(highlightBlocks), SeedMapperData.copySorted(canyonCarvers), SeedMapperData.copySorted(caveCarvers), SeedMapperData.copySorted(biomeKeys), SeedMapperData.copySorted(structureKeys), SeedMapperData.copyMap(structurePieces), SeedMapperData.copyMap(structureVariants), SeedMapperData.buildVariantUnion(structureVariants), SeedMapperData.limitList(lootItems, 2048), SeedMapperData.limitList(lootEnchantments, 512), SeedMapperData.copySorted(densityFunctions), SeedMapperData.copySorted(dimensions), SeedMapperData.copySorted(versionShortcuts), SeedMapperData.copySorted(worldPresets));
    }

    private static List<String> fallbackBiomes() {
        List<String> reflected = SeedMapperData.fallbackResourceKeys("net.minecraft.world.level.biome.Biomes");
        if (reflected.isEmpty()) {
            return SeedMapperData.copySorted(DEFAULT_BIOMES);
        }
        return reflected;
    }

    private static List<String> fallbackEnchantments() {
        List<String> reflected = SeedMapperData.fallbackResourceKeys("net.minecraft.world.item.enchantment.Enchantments");
        if (reflected.isEmpty()) {
            return SeedMapperData.copySorted(DEFAULT_ENCHANTMENTS);
        }
        return reflected;
    }

    private static List<String> fallbackResourceKeys(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (Field field : clazz.getFields()) {
                Object value;
                if (!Modifier.isStatic(field.getModifiers()) || !class_5321.class.isAssignableFrom(field.getType()) || !((value = field.get(null)) instanceof class_5321)) continue;
                class_5321 key = (class_5321)value;
                keys.add(key.method_29177().toString());
            }
            ArrayList list = new ArrayList(keys);
            Collections.sort(list);
            return List.copyOf(list);
        }
        catch (Throwable e) {
            return List.of();
        }
    }

    private static Supplier<List<String>> supplyValueList(String className, String fieldName) {
        return () -> {
            try {
                return SeedMapperData.readValueList(className, fieldName);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static Supplier<Map<String, List<String>>> supplyMap(String className, String fieldName) {
        return () -> {
            try {
                return SeedMapperData.readMapOfLists(className, fieldName);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static List<String> buildVariantUnion(Map<String, List<String>> variants) {
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        for (List<String> value : variants.values()) {
            all.addAll(value);
        }
        all.addAll(DEFAULT_GENERIC_VARIANTS);
        return List.copyOf(all);
    }

    private static List<String> readValueList(String className, String field) throws ReflectiveOperationException {
        Class<?> clazz = Class.forName(className);
        Field f = clazz.getDeclaredField(field);
        f.setAccessible(true);
        Object value = f.get(null);
        return SeedMapperData.extractStrings(value);
    }

    private static Map<String, List<String>> readMapOfLists(String className, String field) throws ReflectiveOperationException {
        Class<?> clazz = Class.forName(className);
        Field f = clazz.getDeclaredField(field);
        f.setAccessible(true);
        Object value = f.get(null);
        if (!(value instanceof Map)) {
            return Collections.emptyMap();
        }
        Map map = (Map)value;
        LinkedHashMap<String, List<String>> copy = new LinkedHashMap<String, List<String>>();
        for (Map.Entry entry : map.entrySet()) {
            List<String> list;
            String key = SeedMapperData.stringify(entry.getKey());
            if (key.isEmpty() || (list = SeedMapperData.extractStrings(entry.getValue())).isEmpty()) continue;
            copy.put(key, SeedMapperData.copySorted(list));
        }
        return copy;
    }

    private static List<String> extractStrings(Object value) {
        Collection<Object> raw;
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            raw = map.keySet();
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            raw = collection;
        } else if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            ArrayList<Object> tmp = new ArrayList<Object>(len);
            for (int i = 0; i < len; ++i) {
                tmp.add(Array.get(value, i));
            }
            raw = tmp;
        } else {
            raw = List.of(value);
        }
        return raw.stream().map(SeedMapperData::stringify).map(String::trim).filter(s -> !s.isEmpty()).map(s -> s.toLowerCase(Locale.ROOT)).distinct().sorted().collect(Collectors.toList());
    }

    private static String stringify(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof class_2960) {
            class_2960 rl = (class_2960)value;
            return rl.toString();
        }
        return value.toString();
    }

    private static <T> T tryRead(Supplier<T> supplier, T fallback) {
        try {
            Map map;
            Collection collection;
            T value = supplier.get();
            if (value instanceof Collection && (collection = (Collection)value).isEmpty()) {
                return fallback;
            }
            if (value instanceof Map && (map = (Map)value).isEmpty()) {
                return fallback;
            }
            return Objects.requireNonNullElse(value, fallback);
        }
        catch (Throwable e) {
            return fallback;
        }
    }

    private static List<String> registryKeys(Iterable<class_2960> registry) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (class_2960 id : registry) {
            keys.add(id.toString());
        }
        ArrayList list = new ArrayList(keys);
        Collections.sort(list);
        return List.copyOf(list);
    }

    private static List<String> registryKeys(class_2378<?> registry) {
        return SeedMapperData.registryKeys(registry.method_10235());
    }

    private static List<String> copySorted(List<String> values) {
        if (values == null || values.isEmpty()) {
            return List.of();
        }
        ArrayList<String> copy = new ArrayList<String>(values);
        Collections.sort(copy);
        return List.copyOf(copy);
    }

    private static Map<String, List<String>> copyMap(Map<String, List<String>> source) {
        LinkedHashMap copy = new LinkedHashMap();
        source.forEach((key, value) -> copy.put(key, SeedMapperData.copySorted(value)));
        return Collections.unmodifiableMap(copy);
    }

    private static List<String> limitList(List<String> list, int maxSize) {
        if (list.size() <= maxSize) {
            return SeedMapperData.copySorted(list);
        }
        return SeedMapperData.copySorted(list.subList(0, maxSize));
    }

    private static Map<String, List<String>> createDefaultStructurePieces() {
        LinkedHashMap<String, List<String>> pieces = new LinkedHashMap<String, List<String>>();
        pieces.put("fortress", List.of("bridge_crossing", "bridge_end", "bridge_small", "bridge_spawner", "corridor_exit", "corridor_nether_wart", "corridor_straight", "stairs_bottom", "stairs_top"));
        pieces.put("end_city", List.of("base_floor", "bridge", "bridge_end", "end_ship", "fat_tower", "second_floor", "small_room", "tower_top"));
        return pieces;
    }

    private static Map<String, List<String>> createDefaultStructureVariants() {
        LinkedHashMap<String, List<String>> variants = new LinkedHashMap<String, List<String>>();
        variants.put("village", List.of("plains", "desert", "savanna", "snowy", "taiga"));
        variants.put("bastion_remnant", List.of("bridge", "housing", "treasure", "hoglin_stable"));
        variants.put("ruined_portal", List.of("standard", "desert", "jungle", "swamp", "mountain", "ocean", "nether", "giant", "underground", "air_pocket"));
        variants.put("igloo", List.of("basement"));
        variants.put("geode", List.of("small", "large", "mega"));
        variants.put("trial_chambers", List.of("atrium", "barracks", "corridor", "crossing", "reward_vault", "trial_spawner"));
        return variants;
    }
}

