/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.settings;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.components.BlockListEditButton;
import net.wurstclient.keybinds.PossibleKeybind;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.BlockUtils;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.text.WText;

public class BlockListSetting
extends Setting {
    private final ArrayList<String> blockNames = new ArrayList();
    private final String[] defaultNames;

    public BlockListSetting(String name, WText description, String ... blocks) {
        super(name, description);
        Arrays.stream(blocks).forEach(this::addFromString);
        this.defaultNames = this.blockNames.toArray(new String[0]);
    }

    public BlockListSetting(String name, String descriptionKey, String ... blocks) {
        this(name, WText.translated(descriptionKey, new Object[0]), blocks);
    }

    private void addFromString(String s) {
        if (s == null) {
            return;
        }
        String raw = s.trim();
        if (raw.isEmpty()) {
            return;
        }
        class_2960 id = class_2960.method_12829((String)raw);
        String name = raw;
        if (id != null && class_7923.field_41175.method_10250(id)) {
            name = id.toString();
        }
        if (Collections.binarySearch(this.blockNames, name) < 0) {
            this.blockNames.add(name);
            Collections.sort(this.blockNames);
        }
    }

    public List<String> getBlockNames() {
        return Collections.unmodifiableList(this.blockNames);
    }

    public int indexOf(String name) {
        if (name == null) {
            return -1;
        }
        return Collections.binarySearch(this.blockNames, name);
    }

    public int indexOf(class_2248 block) {
        return this.indexOf(BlockUtils.getName(block));
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public boolean contains(class_2248 block) {
        return this.indexOf(block) >= 0;
    }

    public int size() {
        return this.blockNames.size();
    }

    public void add(class_2248 block) {
        String name = BlockUtils.getName(block);
        if (Collections.binarySearch(this.blockNames, name) >= 0) {
            return;
        }
        this.blockNames.add(name);
        Collections.sort(this.blockNames);
        WurstClient.INSTANCE.saveSettings();
    }

    public void addRawName(String raw) {
        int before = this.blockNames.size();
        this.addFromString(raw);
        if (this.blockNames.size() != before) {
            WurstClient.INSTANCE.saveSettings();
        }
    }

    public void remove(int index) {
        if (index < 0 || index >= this.blockNames.size()) {
            return;
        }
        this.blockNames.remove(index);
        WurstClient.INSTANCE.saveSettings();
    }

    public void resetToDefaults() {
        this.blockNames.clear();
        this.blockNames.addAll(Arrays.asList(this.defaultNames));
        WurstClient.INSTANCE.saveSettings();
    }

    public void clear() {
        this.blockNames.clear();
        WurstClient.INSTANCE.saveSettings();
    }

    @Override
    public Component getComponent() {
        return new BlockListEditButton(this);
    }

    @Override
    public void fromJson(JsonElement json) {
        try {
            this.blockNames.clear();
            if (JsonUtils.getAsString(json, "nope").equals("default")) {
                this.blockNames.addAll(Arrays.asList(this.defaultNames));
                return;
            }
            for (String rawName : JsonUtils.getAsArray(json).getAllStrings()) {
                this.addFromString(rawName);
            }
        }
        catch (JsonException e) {
            e.printStackTrace();
            this.resetToDefaults();
        }
    }

    @Override
    public JsonElement toJson() {
        if (this.blockNames.equals(Arrays.asList(this.defaultNames))) {
            return new JsonPrimitive("default");
        }
        JsonArray json = new JsonArray();
        this.blockNames.forEach(s -> json.add(s));
        return json;
    }

    @Override
    public JsonObject exportWikiData() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.getName());
        json.addProperty("description", this.getDescription());
        json.addProperty("type", "BlockList");
        JsonArray defaultBlocksJson = new JsonArray();
        for (String blockName : this.defaultNames) {
            defaultBlocksJson.add(blockName);
        }
        json.add("defaultBlocks", (JsonElement)defaultBlocksJson);
        return json;
    }

    @Override
    public Set<PossibleKeybind> getPossibleKeybinds(String featureName) {
        String fullName = featureName + " " + this.getName();
        String command = ".blocklist " + featureName.toLowerCase() + " ";
        command = command + this.getName().toLowerCase().replace(" ", "_") + " ";
        LinkedHashSet<PossibleKeybind> pkb = new LinkedHashSet<PossibleKeybind>();
        pkb.add(new PossibleKeybind(command + "reset", "Reset " + fullName));
        return pkb;
    }

    public boolean matchesBlock(class_2248 block) {
        String idFull = BlockUtils.getName(block);
        if (this.contains(idFull)) {
            return true;
        }
        String localId = idFull.contains(":") ? idFull.substring(idFull.indexOf(":") + 1) : idFull;
        String localSpaced = localId.replace('_', ' ');
        String transKey = block.method_63499();
        String display = block.method_9518().getString();
        for (String s : this.blockNames) {
            String term;
            class_2960 id = class_2960.method_12829((String)s);
            if (id != null || !BlockListSetting.containsNormalized(idFull, term = s.toLowerCase(Locale.ROOT)) && !BlockListSetting.containsNormalized(localId, term) && !BlockListSetting.containsNormalized(localSpaced, term) && !BlockListSetting.containsNormalized(transKey, term) && !BlockListSetting.containsNormalized(display, term)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsNormalized(String haystack, String needle) {
        return haystack != null && haystack.toLowerCase(Locale.ROOT).contains(needle);
    }
}

