/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.settings;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.components.ItemListEditButton;
import net.wurstclient.keybinds.PossibleKeybind;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.text.WText;

public final class ItemListSetting
extends Setting {
    private final ArrayList<String> itemNames = new ArrayList();
    private final String[] defaultNames;

    public ItemListSetting(String name, WText description, String ... items) {
        super(name, description);
        Arrays.stream(items).forEach(this::addFromStringCanonicalizing);
        this.defaultNames = this.itemNames.toArray(new String[0]);
    }

    public ItemListSetting(String name, String descriptionKey, String ... items) {
        this(name, WText.translated(descriptionKey, new Object[0]), items);
    }

    private void addFromStringCanonicalizing(String s) {
        if (s == null) {
            return;
        }
        String raw = s.trim();
        if (raw.isEmpty()) {
            return;
        }
        class_2960 id = class_2960.method_12829((String)raw);
        String name = raw;
        if (id != null && class_7923.field_41178.method_10250(id)) {
            name = id.toString();
        }
        if (Collections.binarySearch(this.itemNames, name) < 0) {
            this.itemNames.add(name);
            Collections.sort(this.itemNames);
        }
    }

    public List<String> getItemNames() {
        return Collections.unmodifiableList(this.itemNames);
    }

    public void add(class_1792 item) {
        String name = class_7923.field_41178.method_10221((Object)item).toString();
        if (Collections.binarySearch(this.itemNames, name) >= 0) {
            return;
        }
        this.itemNames.add(name);
        Collections.sort(this.itemNames);
        WurstClient.INSTANCE.saveSettings();
    }

    public void addRawName(String raw) {
        int before = this.itemNames.size();
        this.addFromStringCanonicalizing(raw);
        if (this.itemNames.size() != before) {
            WurstClient.INSTANCE.saveSettings();
        }
    }

    public void remove(int index) {
        if (index < 0 || index >= this.itemNames.size()) {
            return;
        }
        this.itemNames.remove(index);
        WurstClient.INSTANCE.saveSettings();
    }

    public void resetToDefaults() {
        this.itemNames.clear();
        this.itemNames.addAll(Arrays.asList(this.defaultNames));
        WurstClient.INSTANCE.saveSettings();
    }

    public void clear() {
        this.itemNames.clear();
        WurstClient.INSTANCE.saveSettings();
    }

    @Override
    public Component getComponent() {
        return new ItemListEditButton(this);
    }

    @Override
    public void fromJson(JsonElement json) {
        try {
            this.itemNames.clear();
            if (JsonUtils.getAsString(json, "nope").equals("default")) {
                this.itemNames.addAll(Arrays.asList(this.defaultNames));
                return;
            }
            for (String s : JsonUtils.getAsArray(json).getAllStrings()) {
                this.addFromStringCanonicalizing(s);
            }
        }
        catch (JsonException e) {
            e.printStackTrace();
            this.resetToDefaults();
        }
    }

    @Override
    public JsonElement toJson() {
        if (this.itemNames.equals(Arrays.asList(this.defaultNames))) {
            return new JsonPrimitive("default");
        }
        JsonArray json = new JsonArray();
        this.itemNames.forEach(s -> json.add(s));
        return json;
    }

    @Override
    public JsonObject exportWikiData() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.getName());
        json.addProperty("description", this.getDescription());
        json.addProperty("type", "ItemList");
        JsonArray defaultItems = new JsonArray();
        Arrays.stream(this.defaultNames).forEachOrdered(s -> defaultItems.add(s));
        json.add("defaultItems", (JsonElement)defaultItems);
        return json;
    }

    @Override
    public Set<PossibleKeybind> getPossibleKeybinds(String featureName) {
        String fullName = featureName + " " + this.getName();
        String command = ".itemlist " + featureName.toLowerCase() + " ";
        command = command + this.getName().toLowerCase().replace(" ", "_") + " ";
        LinkedHashSet<PossibleKeybind> pkb = new LinkedHashSet<PossibleKeybind>();
        pkb.add(new PossibleKeybind(command + "reset", "Reset " + fullName));
        return pkb;
    }
}

