/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1320;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1835;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_9362;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.components.MobWeaponRuleComponent;
import net.wurstclient.keybinds.PossibleKeybind;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.ItemUtils;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.json.WsonObject;
import net.wurstclient.util.text.WText;

public final class MobWeaponRuleSetting
extends Setting {
    private static final MobOption ANY_OPTION = new MobOption("any", "Any mob", null);
    private static final List<MobOption> MOB_OPTIONS = MobWeaponRuleSetting.buildMobOptions();
    private MobOption selectedMob = ANY_OPTION;
    private WeaponCategory selectedWeapon = WeaponCategory.NONE;
    private final MobOption defaultMob = this.selectedMob;
    private final WeaponCategory defaultWeapon = this.selectedWeapon;

    public MobWeaponRuleSetting(String name) {
        super(name, WText.empty());
    }

    @Override
    public Component getComponent() {
        return new MobWeaponRuleComponent(this);
    }

    public List<MobOption> getMobOptions() {
        return MOB_OPTIONS;
    }

    public MobOption getSelectedMob() {
        return this.selectedMob;
    }

    public void setSelectedMob(MobOption option) {
        this.selectedMob = Objects.requireNonNull(option);
        WurstClient.INSTANCE.saveSettings();
    }

    public void resetMob() {
        this.setSelectedMob(this.defaultMob);
    }

    public WeaponCategory getSelectedWeapon() {
        return this.selectedWeapon;
    }

    public void setSelectedWeapon(WeaponCategory category) {
        this.selectedWeapon = Objects.requireNonNull(category);
        WurstClient.INSTANCE.saveSettings();
    }

    public void resetWeapon() {
        this.setSelectedWeapon(this.defaultWeapon);
    }

    public boolean isActiveFor(class_1297 entity) {
        if (entity == null || this.selectedWeapon == WeaponCategory.NONE) {
            return false;
        }
        if (this.selectedMob == ANY_OPTION) {
            return true;
        }
        return entity.method_5864() == this.selectedMob.type();
    }

    public int findPreferredHotbarSlot(class_746 player) {
        if (player == null) {
            return -1;
        }
        return this.selectedWeapon.findBestSlot(player.method_31548());
    }

    @Override
    public void fromJson(JsonElement json) {
        if (json == null || !json.isJsonObject()) {
            return;
        }
        try {
            WsonObject obj = JsonUtils.getAsObject(json);
            String mobId = obj.getString("mob", ANY_OPTION.id());
            String weaponName = obj.getString("weapon", WeaponCategory.NONE.name());
            this.setSelectedMob(MobWeaponRuleSetting.findMobOption(mobId));
            this.setSelectedWeapon(WeaponCategory.valueOf(weaponName));
        }
        catch (IllegalArgumentException | JsonException e) {
            this.resetMob();
            this.resetWeapon();
        }
    }

    @Override
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("mob", this.selectedMob.id());
        json.addProperty("weapon", this.selectedWeapon.name());
        return json;
    }

    @Override
    public JsonObject exportWikiData() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.getName());
        json.addProperty("description", this.getDescription());
        json.addProperty("type", "MobWeaponRule");
        json.add("defaultMob", (JsonElement)new JsonPrimitive(this.defaultMob.id()));
        json.add("defaultWeapon", (JsonElement)new JsonPrimitive(this.defaultWeapon.name().toLowerCase()));
        return json;
    }

    @Override
    public Set<PossibleKeybind> getPossibleKeybinds(String featureName) {
        return Collections.emptySet();
    }

    private static MobOption findMobOption(String id) {
        for (MobOption option : MOB_OPTIONS) {
            if (!option.id().equals(id)) continue;
            return option;
        }
        return ANY_OPTION;
    }

    private static List<MobOption> buildMobOptions() {
        ArrayList<MobOption> options = new ArrayList<MobOption>();
        options.add(ANY_OPTION);
        class_7923.field_41177.method_10235().stream().map(arg_0 -> ((class_7922)class_7923.field_41177).method_63535(arg_0)).filter(type -> type.method_5891() != class_1311.field_17715).map(type -> {
            class_2960 id = class_7923.field_41177.method_10221(type);
            String name = type.method_5897().getString();
            return new MobOption(id.toString(), name, (class_1299<?>)type);
        }).sorted(Comparator.comparing(MobOption::displayName, String.CASE_INSENSITIVE_ORDER)).forEach(options::add);
        return Collections.unmodifiableList(options);
    }

    public record MobOption(String id, String displayName, class_1299<?> type) {
        public boolean isAny() {
            return this == ANY_OPTION;
        }

        @Override
        public String toString() {
            return this.displayName;
        }
    }

    public static enum WeaponCategory {
        NONE("Do nothing"){

            @Override
            protected boolean matches(class_1799 stack) {
                return false;
            }
        }
        ,
        SWORD("Any sword"){

            @Override
            protected boolean matches(class_1799 stack) {
                return stack.method_31573(class_3489.field_42611);
            }
        }
        ,
        AXE("Any axe"){

            @Override
            protected boolean matches(class_1799 stack) {
                return stack.method_31573(class_3489.field_42612);
            }
        }
        ,
        HOE("Any hoe"){

            @Override
            protected boolean matches(class_1799 stack) {
                return stack.method_31573(class_3489.field_42613);
            }
        }
        ,
        PICKAXE("Any pickaxe"){

            @Override
            protected boolean matches(class_1799 stack) {
                return stack.method_31573(class_3489.field_42614);
            }
        }
        ,
        SHOVEL("Any shovel"){

            @Override
            protected boolean matches(class_1799 stack) {
                return stack.method_31573(class_3489.field_42615);
            }
        }
        ,
        MACE("Any mace"){

            @Override
            protected boolean matches(class_1799 stack) {
                return stack.method_7909() instanceof class_9362;
            }
        }
        ,
        TRIDENT("Any trident"){

            @Override
            protected boolean matches(class_1799 stack) {
                return stack.method_7909() instanceof class_1835;
            }
        };

        private final String displayName;

        private WeaponCategory(String displayName) {
            this.displayName = displayName;
        }

        public int findBestSlot(class_1661 inventory) {
            int bestSlot = -1;
            float bestScore = Float.NEGATIVE_INFINITY;
            for (int i = 0; i < 9; ++i) {
                float score;
                class_1799 stack = inventory.method_5438(i);
                if (stack.method_7960() || !this.matches(stack) || !((score = this.getDamageScore(stack.method_7909())) > bestScore)) continue;
                bestScore = score;
                bestSlot = i;
            }
            return bestSlot;
        }

        protected boolean matches(class_1799 stack) {
            return false;
        }

        protected float getDamageScore(class_1792 item) {
            return (float)ItemUtils.getAttribute(item, (class_6880<class_1320>)class_5134.field_23721).orElse(0.0);
        }

        public String toString() {
            return this.displayName;
        }
    }
}

