/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.Set;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.components.SpacerComponent;
import net.wurstclient.keybinds.PossibleKeybind;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.text.WText;

public final class SpacerSetting
extends Setting {
    private static int COUNTER = 0;
    private final int height;
    private final int width;

    public SpacerSetting() {
        this(8);
    }

    public SpacerSetting(int height) {
        this(height, 230);
    }

    public SpacerSetting(int height, int width) {
        this("spacer_" + COUNTER++, height, width);
    }

    private SpacerSetting(String name, int height, int width) {
        super(name, WText.empty());
        this.height = height;
        this.width = width;
    }

    @Override
    public Component getComponent() {
        return new SpacerComponent(this.height, this.width);
    }

    @Override
    public void fromJson(JsonElement json) {
    }

    @Override
    public JsonElement toJson() {
        return JsonNull.INSTANCE;
    }

    @Override
    public JsonObject exportWikiData() {
        JsonObject json = new JsonObject();
        json.addProperty("name", "Spacer");
        json.addProperty("description", "Visual spacer between settings.");
        json.addProperty("type", "Spacer");
        return json;
    }

    @Override
    public Set<PossibleKeybind> getPossibleKeybinds(String featureName) {
        return Collections.emptySet();
    }
}

