/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.components.StringDropdownComponent;
import net.wurstclient.keybinds.PossibleKeybind;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.text.WText;

public final class StringDropdownSetting
extends Setting {
    private final List<String> values = new ArrayList<String>();
    private final String defaultValue;
    private String selected = this.defaultValue = "";

    public StringDropdownSetting(String name, WText description) {
        super(name, description);
        this.values.add(this.defaultValue);
    }

    public StringDropdownSetting(String name, String descriptionKey) {
        this(name, WText.translated(descriptionKey, new Object[0]));
    }

    public List<String> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public String getSelected() {
        return this.selected;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setOptions(Collection<String> options) {
        ArrayList<String> updated = new ArrayList<String>();
        updated.add(this.defaultValue);
        if (options != null) {
            for (String option : options) {
                if (option == null || (option = option.trim()).isEmpty() || updated.contains(option)) continue;
                updated.add(option);
            }
        }
        if (this.values.equals(updated)) {
            return;
        }
        this.values.clear();
        this.values.addAll(updated);
        if (!this.values.contains(this.selected)) {
            this.selected = this.defaultValue;
        }
        WurstClient.INSTANCE.saveSettings();
    }

    public void setSelected(String selected) {
        if (selected == null) {
            return;
        }
        if (this.values.contains(selected)) {
            if (this.selected.equals(selected)) {
                return;
            }
            this.selected = selected;
            WurstClient.INSTANCE.saveSettings();
        }
    }

    public void resetToDefault() {
        this.setSelected(this.defaultValue);
    }

    @Override
    public Component getComponent() {
        return new StringDropdownComponent(this);
    }

    @Override
    public void fromJson(JsonElement json) {
        if (!JsonUtils.isString(json)) {
            return;
        }
        this.setSelected(json.getAsString());
    }

    @Override
    public JsonElement toJson() {
        return new JsonPrimitive(this.selected);
    }

    @Override
    public JsonObject exportWikiData() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.getName());
        json.addProperty("description", this.getDescription());
        json.addProperty("type", "StringDropdown");
        json.addProperty("defaultValue", this.defaultValue);
        return json;
    }

    public LinkedHashSet<PossibleKeybind> getPossibleKeybinds(String featureName) {
        return new LinkedHashSet<PossibleKeybind>();
    }
}

