/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.util.chunk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2874;
import net.wurstclient.WurstClient;
import net.wurstclient.events.PacketInputListener;
import net.wurstclient.settings.ChunkAreaSetting;
import net.wurstclient.util.chunk.ChunkSearcher;

public abstract class AbstractChunkCoordinator
implements PacketInputListener {
    protected final HashMap<class_1923, ChunkSearcher> searchers = new HashMap();
    protected final ChunkAreaSetting area;
    private BiPredicate<class_2338, class_2680> query;
    protected final Set<class_1923> chunksToUpdate = Collections.synchronizedSet(new HashSet());
    protected final ConcurrentLinkedQueue<PendingBlockUpdate> pendingBlockUpdates = new ConcurrentLinkedQueue();
    private final HashSet<class_1923> readyChunks = new HashSet();
    private final AtomicInteger matchesVersion = new AtomicInteger();

    public AbstractChunkCoordinator(BiPredicate<class_2338, class_2680> query, ChunkAreaSetting area) {
        this.query = Objects.requireNonNull(query);
        this.area = Objects.requireNonNull(area);
    }

    public boolean update() {
        class_2874 dimension = WurstClient.MC.field_1687.method_8597();
        HashSet<class_1923> chunkUpdates = this.clearChunksToUpdate();
        HashMap<class_1923, ArrayList<ChunkSearcher.BlockUpdate>> blockUpdates = this.clearBlockUpdates();
        boolean searchersChanged = false;
        boolean resultsChanged = false;
        for (ChunkSearcher chunkSearcher : new ArrayList<ChunkSearcher>(this.searchers.values())) {
            boolean remove = false;
            class_1923 searcherPos = chunkSearcher.getPos();
            if (dimension != chunkSearcher.getDimension()) {
                remove = true;
            } else if (!this.area.isInRange(searcherPos)) {
                remove = true;
            } else if (chunkUpdates.contains(searcherPos)) {
                remove = true;
            }
            if (!remove) continue;
            this.searchers.remove(searcherPos);
            this.readyChunks.remove(searcherPos);
            chunkSearcher.cancel();
            this.onRemove(chunkSearcher);
            searchersChanged = true;
            resultsChanged = true;
        }
        for (class_2791 class_27912 : this.area.getChunksInRange()) {
            class_1923 chunkPos = class_27912.method_12004();
            if (this.searchers.containsKey(chunkPos)) continue;
            ChunkSearcher searcher = new ChunkSearcher(this.query, class_27912, dimension);
            this.searchers.put(chunkPos, searcher);
            this.readyChunks.remove(chunkPos);
            searcher.start();
            searchersChanged = true;
        }
        for (Map.Entry entry : blockUpdates.entrySet()) {
            ChunkSearcher searcher = this.searchers.get(entry.getKey());
            if (searcher == null || !searcher.applyBlockUpdates((List)entry.getValue())) continue;
            this.readyChunks.add((class_1923)entry.getKey());
            this.onMatchesUpdated(searcher);
            resultsChanged = true;
        }
        for (ChunkSearcher chunkSearcher : this.searchers.values()) {
            if (!chunkSearcher.hasResultsReady() || !this.readyChunks.add(chunkSearcher.getPos())) continue;
            this.onMatchesUpdated(chunkSearcher);
            resultsChanged = true;
        }
        if (resultsChanged) {
            this.matchesVersion.incrementAndGet();
        }
        return searchersChanged;
    }

    protected void onRemove(ChunkSearcher searcher) {
    }

    public void reset() {
        for (ChunkSearcher searcher : new ArrayList<ChunkSearcher>(this.searchers.values())) {
            searcher.cancel();
            this.onRemove(searcher);
        }
        this.searchers.clear();
        this.chunksToUpdate.clear();
        this.pendingBlockUpdates.clear();
        this.readyChunks.clear();
        this.matchesVersion.incrementAndGet();
    }

    public boolean isDone() {
        return this.searchers.values().stream().allMatch(ChunkSearcher::isDone);
    }

    public void setQuery(BiPredicate<class_2338, class_2680> query) {
        this.query = Objects.requireNonNull(query);
        this.reset();
    }

    public void setTargetBlock(class_2248 block) {
        this.setQuery((pos, state) -> block == state.method_26204());
    }

    public boolean hasReadyMatches() {
        return !this.readyChunks.isEmpty();
    }

    public int getMatchesVersion() {
        return this.matchesVersion.get();
    }

    protected Stream<ChunkSearcher.Result> streamReadyMatches() {
        return this.searchers.values().stream().flatMap(ChunkSearcher::getReadyMatches);
    }

    protected void onMatchesUpdated(ChunkSearcher searcher) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashSet<class_1923> clearChunksToUpdate() {
        Set<class_1923> set = this.chunksToUpdate;
        synchronized (set) {
            HashSet<class_1923> chunks = new HashSet<class_1923>(this.chunksToUpdate);
            this.chunksToUpdate.clear();
            return chunks;
        }
    }

    protected HashMap<class_1923, ArrayList<ChunkSearcher.BlockUpdate>> clearBlockUpdates() {
        PendingBlockUpdate pending;
        HashMap<class_1923, ArrayList<ChunkSearcher.BlockUpdate>> updates = new HashMap<class_1923, ArrayList<ChunkSearcher.BlockUpdate>>();
        while ((pending = this.pendingBlockUpdates.poll()) != null) {
            updates.computeIfAbsent(pending.chunkPos(), k -> new ArrayList()).add(pending.update());
        }
        return updates;
    }

    protected void enqueueBlockUpdate(class_1923 chunkPos, class_2338 blockPos, class_2680 state) {
        this.pendingBlockUpdates.add(new PendingBlockUpdate(chunkPos, new ChunkSearcher.BlockUpdate(blockPos.method_10062(), state)));
    }

    protected record PendingBlockUpdate(class_1923 chunkPos, ChunkSearcher.BlockUpdate update) {
    }
}

