/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.util.chunk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2874;
import net.wurstclient.util.MinPriorityThreadFactory;
import net.wurstclient.util.chunk.ChunkUtils;

public final class ChunkSearcher {
    private static final ExecutorService BACKGROUND_THREAD_POOL = MinPriorityThreadFactory.newFixedThreadPool();
    private final BiPredicate<class_2338, class_2680> query;
    private final class_2791 chunk;
    private final class_2874 dimension;
    private CompletableFuture<ArrayList<Result>> future;
    private boolean interrupted;
    private volatile ArrayList<Result> results;
    private ArrayList<BlockUpdate> pendingUpdates;

    public ChunkSearcher(BiPredicate<class_2338, class_2680> query, class_2791 chunk, class_2874 dimension) {
        this.query = query;
        this.chunk = chunk;
        this.dimension = dimension;
    }

    public void start() {
        if (this.future != null || this.interrupted) {
            throw new IllegalStateException();
        }
        this.future = CompletableFuture.supplyAsync(this::searchNow, BACKGROUND_THREAD_POOL);
    }

    private ArrayList<Result> searchNow() {
        ArrayList<Result> results = new ArrayList<Result>();
        class_1923 chunkPos = this.chunk.method_12004();
        int minX = chunkPos.method_8326();
        int minY = this.chunk.method_31607();
        int minZ = chunkPos.method_8328();
        int maxX = chunkPos.method_8327();
        int maxY = ChunkUtils.getHighestNonEmptySectionYOffset(this.chunk) + 16;
        int maxZ = chunkPos.method_8329();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (this.interrupted) {
                        return results;
                    }
                    class_2338 pos = new class_2338(x, y, z);
                    class_2680 state = this.chunk.method_8320(pos);
                    if (!this.query.test(pos, state)) continue;
                    results.add(new Result(pos.method_10062(), state));
                }
            }
        }
        return results;
    }

    public void cancel() {
        if (this.future == null || this.future.isDone()) {
            return;
        }
        this.interrupted = true;
        this.future.cancel(false);
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public class_1923 getPos() {
        return this.chunk.method_12004();
    }

    public class_2874 getDimension() {
        return this.dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<Result> getMatches() {
        ArrayList<Result> snapshot;
        if (this.future == null || this.future.isCancelled()) {
            return Stream.empty();
        }
        this.ensureResultsLoaded();
        ChunkSearcher chunkSearcher = this;
        synchronized (chunkSearcher) {
            snapshot = new ArrayList<Result>(this.results);
        }
        return snapshot.stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Result> getMatchesList() {
        if (this.future == null || this.future.isCancelled()) {
            return List.of();
        }
        this.ensureResultsLoaded();
        ChunkSearcher chunkSearcher = this;
        synchronized (chunkSearcher) {
            return Collections.unmodifiableList(new ArrayList<Result>(this.results));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<Result> getReadyMatches() {
        ArrayList<Result> snapshot;
        if (!this.hasResultsReady()) {
            return Stream.empty();
        }
        ChunkSearcher chunkSearcher = this;
        synchronized (chunkSearcher) {
            snapshot = new ArrayList<Result>(this.results);
        }
        return snapshot.stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Result> getReadyMatchesList() {
        if (!this.hasResultsReady()) {
            return List.of();
        }
        ChunkSearcher chunkSearcher = this;
        synchronized (chunkSearcher) {
            return Collections.unmodifiableList(new ArrayList<Result>(this.results));
        }
    }

    public boolean isDone() {
        return this.future != null && this.future.isDone();
    }

    public boolean hasResultsReady() {
        if (this.future == null || this.future.isCancelled()) {
            return false;
        }
        if (this.results != null) {
            return true;
        }
        if (!this.future.isDone()) {
            return false;
        }
        this.ensureResultsLoaded();
        return this.results != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyBlockUpdates(List<BlockUpdate> updates) {
        if (updates == null || updates.isEmpty()) {
            return false;
        }
        ChunkSearcher chunkSearcher = this;
        synchronized (chunkSearcher) {
            if (this.future == null || this.future.isCancelled()) {
                return false;
            }
            if (!this.future.isDone()) {
                if (this.pendingUpdates == null) {
                    this.pendingUpdates = new ArrayList();
                }
                this.pendingUpdates.addAll(updates);
                return false;
            }
        }
        this.ensureResultsLoaded();
        chunkSearcher = this;
        synchronized (chunkSearcher) {
            return this.applyUpdates(this.results, updates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureResultsLoaded() {
        if (this.results != null || this.future == null || this.future.isCancelled()) {
            return;
        }
        ArrayList<Result> computed = this.future.join();
        ChunkSearcher chunkSearcher = this;
        synchronized (chunkSearcher) {
            if (this.results == null) {
                this.results = computed;
                if (this.pendingUpdates != null && !this.pendingUpdates.isEmpty()) {
                    this.applyUpdates(this.results, this.pendingUpdates);
                    this.pendingUpdates.clear();
                    this.pendingUpdates = null;
                } else {
                    this.pendingUpdates = null;
                }
            }
        }
    }

    private boolean applyUpdates(ArrayList<Result> target, List<BlockUpdate> updates) {
        boolean changed = false;
        for (BlockUpdate update : updates) {
            class_2338 pos = update.pos();
            class_2680 state = update.state();
            boolean matches = this.query.test(pos, state);
            int index = this.indexOf(target, pos);
            if (matches) {
                Result newResult = new Result(pos, state);
                if (index < 0) {
                    target.add(newResult);
                    changed = true;
                    continue;
                }
                if (target.get(index).state() == state) continue;
                target.set(index, newResult);
                changed = true;
                continue;
            }
            if (index < 0) continue;
            target.remove(index);
            changed = true;
        }
        return changed;
    }

    private int indexOf(ArrayList<Result> list, class_2338 pos) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).pos().equals((Object)pos)) continue;
            return i;
        }
        return -1;
    }

    public record Result(class_2338 pos, class_2680 state) {
    }

    public record BlockUpdate(class_2338 pos, class_2680 state) {
    }
}

