/*
 * Decompiled with CFR 0.152.
 */
package net.cevapi.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.EnumSetting;
import net.wurstclient.settings.Setting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.settings.TextFieldSetting;

public final class AntiFingerprintConfig {
    public static final AntiFingerprintConfig INSTANCE = new AntiFingerprintConfig();
    private static final int THRESHOLD_MIN = 2;
    private static final int THRESHOLD_MAX = 10;
    private static final int WINDOW_MIN = 250;
    private static final int WINDOW_MAX = 15000;
    private final EnumSetting<Policy> policy = new EnumSetting("Policy", (Enum[])Policy.values(), (Enum)Policy.OBSERVE);
    private final EnumSetting<ToastVerbosity> toastVerbosity = new EnumSetting("Toast verbosity", (Enum[])ToastVerbosity.values(), (Enum)ToastVerbosity.IMPORTANT_ONLY);
    private final CheckboxSetting auditLog = new CheckboxSetting("Audit log", false);
    private final CheckboxSetting purgeCache = new CheckboxSetting("Clear cache before download", "Deletes the local server resource-pack cache right before every request, forcing a fresh download each time.", false);
    private final CheckboxSetting isolateCache = new CheckboxSetting("Isolate cached packs", "Stores server resource packs inside a per-session directory so cached copies can't be reused for fingerprinting.", false);
    private final CheckboxSetting extractSandbox = new CheckboxSetting("Extract sandbox copy", "After sandboxing a pack, automatically extract it using Minecraft's resource-pack loader so you can inspect the contents.", false);
    private final CheckboxSetting showMultiplayerButton = new CheckboxSetting("Show multiplayer button", "Adds a shortcut to this panel to the Multiplayer screen.", true);
    private final SliderSetting fingerprintThreshold = new SliderSetting("Fingerprint threshold", "Number of packs within the window before a fingerprint attempt is assumed.", 3.0, 2.0, 10.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting fingerprintWindowMs = new SliderSetting("Fingerprint window (ms)", "Time window used to detect rapid pack requests.", 1500.0, 250.0, 15000.0, 250.0, SliderSetting.ValueDisplay.INTEGER);
    private final TextFieldSetting whitelistedHosts = new TextFieldSetting("Whitelisted hosts", "Comma separated list of hostnames or host:port entries that should bypass the protector.", "", AntiFingerprintConfig::isValidHostList);

    private AntiFingerprintConfig() {
    }

    public EnumSetting<Policy> getPolicySetting() {
        return this.policy;
    }

    public EnumSetting<ToastVerbosity> getToastVerbositySetting() {
        return this.toastVerbosity;
    }

    public CheckboxSetting getAuditLogSetting() {
        return this.auditLog;
    }

    public CheckboxSetting getPurgeCacheSetting() {
        return this.purgeCache;
    }

    public CheckboxSetting getIsolateCacheSetting() {
        return this.isolateCache;
    }

    public CheckboxSetting getExtractSandboxSetting() {
        return this.extractSandbox;
    }

    public CheckboxSetting getShowMultiplayerButtonSetting() {
        return this.showMultiplayerButton;
    }

    public SliderSetting getFingerprintThresholdSetting() {
        return this.fingerprintThreshold;
    }

    public SliderSetting getFingerprintWindowSetting() {
        return this.fingerprintWindowMs;
    }

    public TextFieldSetting getWhitelistSetting() {
        return this.whitelistedHosts;
    }

    public Policy getPolicy() {
        return this.policy.getSelected();
    }

    public ToastVerbosity getToastVerbosity() {
        return this.toastVerbosity.getSelected();
    }

    public boolean isAuditLogEnabled() {
        return this.auditLog.isChecked();
    }

    public boolean shouldClearCache() {
        return this.purgeCache.isChecked();
    }

    public boolean shouldIsolateCache() {
        return this.isolateCache.isChecked();
    }

    public boolean shouldExtractSandbox() {
        return this.extractSandbox.isChecked();
    }

    public boolean shouldShowMultiplayerButton() {
        return this.showMultiplayerButton.isChecked();
    }

    public int getFingerprintThreshold() {
        return Math.max(2, this.fingerprintThreshold.getValueI());
    }

    public long getFingerprintWindowMs() {
        return Math.max(250L, (long)this.fingerprintWindowMs.getValueI());
    }

    public int getThresholdMin() {
        return 2;
    }

    public int getThresholdMax() {
        return 10;
    }

    public int getWindowMin() {
        return 250;
    }

    public int getWindowMax() {
        return 15000;
    }

    public String getWhitelistRaw() {
        return this.whitelistedHosts.getValue();
    }

    public void setWhitelistRaw(String value) {
        this.whitelistedHosts.setValue(value);
    }

    public Set<String> getWhitelistedHosts() {
        String value = this.whitelistedHosts.getValue();
        if (value.isBlank()) {
            return Collections.emptySet();
        }
        String[] items = value.split(",");
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String item : items) {
            String trimmed = item.trim().toLowerCase(Locale.ROOT);
            if (trimmed.isEmpty()) continue;
            set.add(trimmed);
        }
        return Collections.unmodifiableSet(set);
    }

    public List<Setting> getAllSettings() {
        return Arrays.asList(this.policy, this.toastVerbosity, this.auditLog, this.purgeCache, this.isolateCache, this.extractSandbox, this.showMultiplayerButton, this.fingerprintThreshold, this.fingerprintWindowMs, this.whitelistedHosts);
    }

    private static boolean isValidHostList(String value) {
        String[] items;
        if (value == null) {
            return false;
        }
        if (value.isEmpty()) {
            return true;
        }
        for (String item : items = value.split(",")) {
            String trimmed = item.trim();
            if (trimmed.isEmpty()) {
                return false;
            }
            if (trimmed.length() > 128) {
                return false;
            }
            if (trimmed.matches("^[A-Za-z0-9\\-._:\\[\\]]+$")) continue;
            return false;
        }
        return true;
    }

    public static enum Policy {
        OBSERVE("Observe"),
        BLOCK_LOCAL("Block Local"),
        SANDBOX_ALL("Sandbox All"),
        BLOCK_ALL("Block All");

        private final String displayName;

        private Policy(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }

    public static enum ToastVerbosity {
        SILENT("Silent"){

            @Override
            public boolean allows(ToastLevel level) {
                return false;
            }
        }
        ,
        IMPORTANT_ONLY("Important"){

            @Override
            public boolean allows(ToastLevel level) {
                return level != ToastLevel.INFO;
            }
        }
        ,
        VERBOSE("Verbose"){

            @Override
            public boolean allows(ToastLevel level) {
                return true;
            }
        };

        private final String displayName;

        private ToastVerbosity(String displayName) {
            this.displayName = displayName;
        }

        public boolean allows(ToastLevel level) {
            return true;
        }

        public String toString() {
            return this.displayName;
        }
    }

    public static enum ToastLevel {
        INFO,
        WARN,
        ERROR;

    }
}

