/*
 * Decompiled with CFR 0.152.
 */
package net.cevapi.security;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.cevapi.config.AntiFingerprintConfig;
import net.minecraft.class_156;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2720;
import net.minecraft.class_2856;
import net.minecraft.class_310;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.wurstclient.WurstClient;
import net.wurstclient.util.ChatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ResourcePackProtector {
    private static final Logger LOGGER = LogManager.getLogger((String)"AntiFingerprint");
    private static final AntiFingerprintConfig CONFIG = AntiFingerprintConfig.INSTANCE;
    private static final int CACHE_LIMIT = 128;
    private static final int TOAST_LIMIT = 16;
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(\\d{1,3}\\.){3}\\d{1,3}$");
    private static final Map<String, Decision> SESSION_CACHE = ResourcePackProtector.createCache();
    private static final Map<String, PackHistory> PACK_HISTORY = new ConcurrentHashMap<String, PackHistory>();
    private static final Deque<ToastPayload> TOAST_QUEUE = new ArrayDeque<ToastPayload>();
    private static final UUID SESSION_CACHE_SALT = UUID.randomUUID();
    private static final Map<UUID, PackContext> CONTEXTS_BY_ID = new ConcurrentHashMap<UUID, PackContext>();
    private static final Set<String> PROMPT_SNAPSHOTS = ConcurrentHashMap.newKeySet();
    private static final Map<String, Path> DOWNLOAD_TARGETS = new ConcurrentHashMap<String, Path>();

    private ResourcePackProtector() {
    }

    public static AntiFingerprintConfig getConfig() {
        return CONFIG;
    }

    private static void clearServerCacheIfEnabled() {
        if (!CONFIG.shouldClearCache()) {
            return;
        }
        class_310 client = WurstClient.MC;
        if (client == null || client.field_1697 == null) {
            return;
        }
        Path cacheDir = client.field_1697.toPath().resolve("resourcepacks").resolve("server");
        if (!Files.exists(cacheDir, new LinkOption[0])) {
            return;
        }
        try {
            Files.walkFileTree(cacheDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.deleteIfExists(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc != null) {
                        throw exc;
                    }
                    Files.deleteIfExists(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOGGER.debug("Failed to clear server resource-pack cache.", (Throwable)e);
        }
    }

    public static Path remapDownloadPath(Path directory, Path original, UUID packId) {
        PackContext context = ResourcePackProtector.getContext(packId);
        if (directory == null || original == null) {
            return original;
        }
        Path target = original;
        if (CONFIG.shouldIsolateCache()) {
            class_310 mc = class_310.method_1551();
            String accountSegment = "no-account";
            if (mc != null && mc.method_1548() != null) {
                try {
                    UUID accountId = mc.method_1548().method_44717();
                    if (accountId != null) {
                        accountSegment = accountId.toString();
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to obtain session UUID for cache isolation.", (Throwable)e);
                }
            }
            String fileName = original.getFileName() == null ? (packId != null ? packId.toString() : UUID.randomUUID().toString()) : original.getFileName().toString();
            target = directory.resolve("cevapi").resolve(accountSegment).resolve(SESSION_CACHE_SALT.toString()).resolve(fileName);
        }
        ResourcePackProtector.logDownloadLocation("CACHE_PATH", context, target);
        ResourcePackProtector.registerDownloadTarget(context, target);
        return target;
    }

    private static InetSocketAddress getRemoteAddress() {
        InetSocketAddress isa;
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return null;
        }
        class_634 handler = mc.method_1562();
        if (handler == null) {
            return null;
        }
        SocketAddress address = handler.method_48296().method_10755();
        return address instanceof InetSocketAddress ? (isa = (InetSocketAddress)address) : null;
    }

    public static PolicyResult evaluate(class_2720 packet) {
        if (packet == null) {
            return new PolicyResult(Decision.ALLOW, "No packet", PackContext.empty());
        }
        try {
            Decision cached;
            ResourcePackProtector.clearServerCacheIfEnabled();
            PackContext context = PackContext.from(packet);
            if (context.cacheKey != null && (cached = SESSION_CACHE.get(context.cacheKey)) != null) {
                return new PolicyResult(cached, "Cached decision", context);
            }
            ResourcePackProtector.registerContext(context);
            PolicyResult result = ResourcePackProtector.evaluateDecision(context);
            ResourcePackProtector.cacheDecision(context.cacheKey, result.decision());
            return result;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to evaluate resource pack policy, falling back to vanilla behaviour.", (Throwable)e);
            ResourcePackProtector.pushToast(AntiFingerprintConfig.ToastLevel.WARN, "Anti-Fingerprint", "Policy evaluation failed. Allowing vanilla handling.");
            return new PolicyResult(Decision.ALLOW, "Evaluation error", PackContext.empty());
        }
    }

    public static boolean applyDecision(PolicyResult result, class_2535 connection, class_310 mcClient) {
        if (result == null) {
            return false;
        }
        PackContext context = result.context();
        switch (result.decision().ordinal()) {
            case 1: {
                class_310 target;
                class_310 class_3102 = target = mcClient != null ? mcClient : class_310.method_1551();
                if (target != null) {
                    target.method_1566().field_2240.clear();
                }
                ResourcePackProtector.sendStatus(connection, context, class_2856.class_2857.field_13018);
                ResourcePackProtector.noteHandled(context);
                return true;
            }
            case 2: {
                class_310 target;
                ResourcePackProtector.sendStatus(connection, context, class_2856.class_2857.field_13015);
                class_310 class_3103 = target = mcClient != null ? mcClient : class_310.method_1551();
                if (target != null) {
                    target.execute(() -> ResourcePackProtector.sandboxDownload(context));
                }
                return true;
            }
        }
        return false;
    }

    public static void noteHandled(PackContext context) {
        if (context == null) {
            return;
        }
        try {
            ResourcePackProtector.cacheDecision(context.cacheKey, SESSION_CACHE.getOrDefault(context.cacheKey, Decision.ALLOW));
            ResourcePackProtector.clearContext(context);
        }
        catch (Exception e) {
            LOGGER.debug("Failed to record handled resource pack.", (Throwable)e);
        }
    }

    public static void sandboxDownload(PackContext context) {
        ResourcePackProtector.sandboxDownload(context, SandboxRequest.POLICY, null);
    }

    private static void sandboxDownload(PackContext context, SandboxRequest sandboxRequest, String dedupeKey) {
        block7: {
            try {
                URI uri = null;
                if (!context.url.isBlank()) {
                    try {
                        uri = new URI(context.url);
                    }
                    catch (URISyntaxException e) {
                        ResourcePackProtector.pushToast(AntiFingerprintConfig.ToastLevel.ERROR, context, sandboxRequest.failTitle, "Invalid URL syntax.");
                        LOGGER.warn("Invalid resource pack URI {}", (Object)context.url, (Object)e);
                        ResourcePackProtector.logAudit(sandboxRequest.auditFail, context, "error=invalid_url message=" + ResourcePackProtector.shortMessage(e));
                        if (dedupeKey != null) {
                            PROMPT_SNAPSHOTS.remove(dedupeKey);
                        }
                        return;
                    }
                }
                Path sandboxFolder = WurstClient.INSTANCE.getWurstFolder().resolve("sandbox-packs");
                Files.createDirectories(sandboxFolder, new FileAttribute[0]);
                String fileName = ResourcePackProtector.buildSandboxFileName(context, uri);
                Path sandboxTarget = ResourcePackProtector.ensureUnique(sandboxFolder.resolve(fileName));
                ResourcePackProtector.pushToast(sandboxRequest.startLevel, context, sandboxRequest.startTitle, sandboxRequest.startBody);
                ResourcePackProtector.logAudit(sandboxRequest.auditStart, context, "target=" + String.valueOf(sandboxTarget.toAbsolutePath()));
                if (uri == null) {
                    ResourcePackProtector.copyCachedPack(context, sandboxTarget, sandboxRequest, dedupeKey);
                    return;
                }
                HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(15L)).build();
                HttpRequest httpRequest = HttpRequest.newBuilder(uri).timeout(Duration.ofSeconds(60L)).GET().build();
                HttpResponse.BodyHandler<Path> handler = HttpResponse.BodyHandlers.ofFile(sandboxTarget);
                client.sendAsync(httpRequest, handler).whenCompleteAsync((response, throwable) -> {
                    if (throwable != null) {
                        ResourcePackProtector.handleSandboxFailure(context, sandboxTarget, throwable, sandboxRequest, dedupeKey);
                        return;
                    }
                    int status = response.statusCode();
                    if (status >= 200 && status < 300) {
                        Path absolute = sandboxTarget.toAbsolutePath();
                        if (dedupeKey != null) {
                            PROMPT_SNAPSHOTS.remove(dedupeKey);
                        }
                        ResourcePackProtector.handleSandboxSuccess(absolute, context, sandboxRequest, "status=" + status + " path=" + String.valueOf(absolute));
                        return;
                    }
                    ResourcePackProtector.handleSandboxFailure(context, sandboxTarget, new IOException("HTTP " + status), sandboxRequest, dedupeKey);
                }, (Executor)class_156.method_27958());
            }
            catch (Exception e) {
                LOGGER.warn("Sandbox download failed unexpectedly.", (Throwable)e);
                ResourcePackProtector.pushToast(AntiFingerprintConfig.ToastLevel.ERROR, context, sandboxRequest.failTitle, "Unexpected error: " + e.getClass().getSimpleName());
                ResourcePackProtector.logAudit(sandboxRequest.auditFail, context, "error=unexpected:" + e.getClass().getSimpleName());
                if (dedupeKey == null) break block7;
                PROMPT_SNAPSHOTS.remove(dedupeKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushToasts() {
        ArrayList<ToastPayload> payloads;
        class_310 client = WurstClient.MC;
        if (client == null) {
            return;
        }
        Deque<ToastPayload> deque = TOAST_QUEUE;
        synchronized (deque) {
            if (TOAST_QUEUE.isEmpty()) {
                return;
            }
            payloads = new ArrayList<ToastPayload>(TOAST_QUEUE);
            TOAST_QUEUE.clear();
        }
        class_374 manager = client.method_1566();
        for (ToastPayload payload : payloads) {
            try {
                class_370.method_27024((class_374)manager, (class_370.class_9037)payload.type, (class_2561)payload.title, (class_2561)payload.description);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to show toast {}", (Object)payload, (Object)e);
            }
        }
    }

    private static PolicyResult evaluateDecision(PackContext context) {
        ResourcePackProtector.recordFingerprint(context);
        AntiFingerprintConfig.Policy policy = CONFIG.getPolicy();
        boolean whitelisted = ResourcePackProtector.isWhitelisted(context);
        boolean local = context.host.local;
        if (whitelisted) {
            ResourcePackProtector.logAudit("ALLOW_WHITELIST", context, "");
            ResourcePackProtector.pushToast(AntiFingerprintConfig.ToastLevel.INFO, context, "Whitelisted host", "Bypassed Anti-Fingerprint policy.");
            return new PolicyResult(Decision.ALLOW, "Whitelisted host", context);
        }
        return switch (policy) {
            default -> throw new MatchException(null, null);
            case AntiFingerprintConfig.Policy.BLOCK_ALL -> ResourcePackProtector.block(context, "Policy set to Block All");
            case AntiFingerprintConfig.Policy.SANDBOX_ALL -> ResourcePackProtector.sandbox(context, "Policy set to Sandbox All");
            case AntiFingerprintConfig.Policy.BLOCK_LOCAL -> {
                if (local) {
                    yield ResourcePackProtector.block(context, "Blocked local host request");
                }
                yield ResourcePackProtector.observe(context, "Local host allowed (policy passive)");
            }
            case AntiFingerprintConfig.Policy.OBSERVE -> ResourcePackProtector.observe(context, "");
        };
    }

    private static PolicyResult block(PackContext context, String reason) {
        ResourcePackProtector.pushToast(AntiFingerprintConfig.ToastLevel.WARN, context, "Resource pack blocked", reason);
        ResourcePackProtector.logAudit("BLOCK", context, reason);
        return new PolicyResult(Decision.BLOCK, reason, context);
    }

    private static PolicyResult sandbox(PackContext context, String reason) {
        ResourcePackProtector.pushToast(AntiFingerprintConfig.ToastLevel.WARN, context, "Resource pack sandboxed", reason);
        ResourcePackProtector.logAudit("SANDBOX", context, reason);
        return new PolicyResult(Decision.SANDBOX, reason, context);
    }

    private static PolicyResult observe(PackContext context, String extra) {
        String detail = extra == null || extra.isBlank() ? "Server requested a resource pack." : extra;
        ResourcePackProtector.pushToast(AntiFingerprintConfig.ToastLevel.INFO, context, "Resource pack request", detail);
        ResourcePackProtector.logAudit("OBSERVE", context, detail);
        if (!(context == null || context.required && context.prompt.isBlank())) {
            ResourcePackProtector.schedulePromptSandboxDownload(context);
        }
        return new PolicyResult(Decision.ALLOW, detail, context);
    }

    private static void schedulePromptSandboxDownload(PackContext context) {
        if (context == null) {
            return;
        }
        String key = context.cacheKey;
        if (key == null || key.isBlank()) {
            if (context.packId != null) {
                key = context.packId.toString();
            } else if (!context.url.isBlank()) {
                key = context.url;
            }
        }
        if (key == null || key.isBlank()) {
            key = context.url;
        }
        if (key == null || key.isBlank()) {
            return;
        }
        if (!PROMPT_SNAPSHOTS.add(key)) {
            return;
        }
        class_310 client = WurstClient.MC;
        if (client == null) {
            PROMPT_SNAPSHOTS.remove(key);
            return;
        }
        String snapshotKey = key;
        try {
            client.execute(() -> ResourcePackProtector.sandboxDownload(context, SandboxRequest.PROMPT, snapshotKey));
        }
        catch (Exception e) {
            PROMPT_SNAPSHOTS.remove(snapshotKey);
            LOGGER.warn("Failed to schedule prompt sandbox download.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recordFingerprint(PackContext context) {
        String key = context.host.canonicalOrFallback();
        long now = System.currentTimeMillis();
        PackHistory history = PACK_HISTORY.computeIfAbsent(key, unused -> new PackHistory());
        int threshold = CONFIG.getFingerprintThreshold();
        long windowMs = CONFIG.getFingerprintWindowMs();
        PackHistory packHistory = history;
        synchronized (packHistory) {
            history.timestamps.addLast(now);
            while (!history.timestamps.isEmpty() && now - history.timestamps.peekFirst() > windowMs) {
                history.timestamps.removeFirst();
            }
            if (history.timestamps.size() >= threshold && now - history.lastAlert > windowMs) {
                history.lastAlert = now;
                String message = "Possible resource-pack fingerprint attempt from " + context.host.displayName() + " (" + history.timestamps.size() + " packs / " + windowMs + "ms)";
                class_310 client = WurstClient.MC;
                if (client != null) {
                    client.execute(() -> ChatUtils.warning(message));
                }
                ResourcePackProtector.pushToast(AntiFingerprintConfig.ToastLevel.WARN, context, "Fingerprint attempt detected", message);
                ResourcePackProtector.logAudit("FINGERPRINT", context, message);
            }
        }
    }

    private static boolean isWhitelisted(PackContext context) {
        Set<String> whitelist = CONFIG.getWhitelistedHosts();
        if (whitelist.isEmpty()) {
            return false;
        }
        String canonical = context.host.canonical;
        if (!canonical.isEmpty() && whitelist.contains(canonical.toLowerCase(Locale.ROOT))) {
            return true;
        }
        String host = context.host.host;
        return !host.isEmpty() && whitelist.contains(host.toLowerCase(Locale.ROOT));
    }

    private static void handleSandboxFailure(PackContext context, Path target, Throwable throwable, SandboxRequest sandboxRequest, String dedupeKey) {
        try {
            Files.deleteIfExists(target);
        }
        catch (IOException e) {
            LOGGER.debug("Failed to delete failed sandbox file {}", (Object)target, (Object)e);
        }
        LOGGER.warn("Sandbox download failed for {}", (Object)context.url, (Object)throwable);
        ResourcePackProtector.pushToast(AntiFingerprintConfig.ToastLevel.ERROR, context, sandboxRequest.failTitle, ResourcePackProtector.shortMessage(throwable));
        ResourcePackProtector.logAudit(sandboxRequest.auditFail, context, ResourcePackProtector.shortMessage(throwable) + " target=" + String.valueOf(target.toAbsolutePath()));
        if (dedupeKey != null) {
            PROMPT_SNAPSHOTS.remove(dedupeKey);
        }
        ResourcePackProtector.noteHandled(context);
    }

    private static void handleSandboxSuccess(Path absolute, PackContext context, SandboxRequest sandboxRequest, String auditDetail) {
        ResourcePackProtector.pushToast(sandboxRequest.successLevel, context, sandboxRequest.successTitle, sandboxRequest.successBodyPrefix + ResourcePackProtector.trimToLength(absolute.toString(), 160));
        ResourcePackProtector.logAudit(sandboxRequest.auditOk, context, auditDetail);
        ResourcePackProtector.clearDownloadTarget(context);
        if (CONFIG.shouldExtractSandbox()) {
            CompletableFuture.runAsync(() -> ResourcePackProtector.extractSandboxPack(absolute, context), (Executor)class_156.method_27958()).whenComplete((unused, throwable) -> ResourcePackProtector.noteHandled(context));
        } else {
            ResourcePackProtector.noteHandled(context);
        }
    }

    private static void copyCachedPack(PackContext context, Path sandboxTarget, SandboxRequest sandboxRequest, String dedupeKey) {
        CompletableFuture.supplyAsync(() -> ResourcePackProtector.copyCachedPackSync(context, sandboxTarget), (Executor)class_156.method_27958()).whenComplete((absolute, throwable) -> {
            if (throwable != null) {
                Throwable cause = throwable;
                if (throwable instanceof CompletionException) {
                    CompletionException completion = (CompletionException)throwable;
                    cause = completion.getCause();
                }
                if (cause == null) {
                    cause = throwable;
                }
                ResourcePackProtector.handleSandboxFailure(context, sandboxTarget, cause, sandboxRequest, dedupeKey);
                return;
            }
            if (absolute == null) {
                Path cached = ResourcePackProtector.getDownloadTarget(context);
                String message = cached == null ? (context != null && context.url.isBlank() ? "Cached pack path unavailable (no URL provided)" : "Cached pack path unavailable") : "Cached pack not ready";
                ResourcePackProtector.handleSandboxFailure(context, sandboxTarget, new IOException(message), sandboxRequest, dedupeKey);
                return;
            }
            if (dedupeKey != null) {
                PROMPT_SNAPSHOTS.remove(dedupeKey);
            }
            ResourcePackProtector.handleSandboxSuccess(absolute, context, sandboxRequest, "source=CACHE path=" + String.valueOf(absolute));
        });
    }

    private static Path copyCachedPackSync(PackContext context, Path sandboxTarget) {
        if (context == null) {
            return null;
        }
        long deadline = System.currentTimeMillis() + Duration.ofSeconds(30L).toMillis();
        long lastSize = -1L;
        Path lastPath = null;
        int stableTicks = 0;
        IOException lastError = null;
        while (System.currentTimeMillis() < deadline) {
            Path cachePath = ResourcePackProtector.getDownloadTarget(context);
            if (cachePath != null && Files.exists(cachePath, new LinkOption[0])) {
                try {
                    long size;
                    if (!cachePath.equals(lastPath)) {
                        lastPath = cachePath;
                        lastSize = -1L;
                        stableTicks = 0;
                    }
                    if ((size = Files.size(cachePath)) > 0L && size == lastSize) {
                        ++stableTicks;
                    } else {
                        lastSize = size;
                        stableTicks = 0;
                    }
                    if (stableTicks >= 2 && size > 0L) {
                        Path parent = sandboxTarget.getParent();
                        if (parent != null) {
                            Files.createDirectories(parent, new FileAttribute[0]);
                        }
                        Files.copy(cachePath, sandboxTarget, StandardCopyOption.REPLACE_EXISTING);
                        return sandboxTarget.toAbsolutePath();
                    }
                }
                catch (IOException e) {
                    lastError = e;
                }
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while copying cached resource pack", e);
            }
        }
        if (lastError != null) {
            throw new UncheckedIOException(lastError);
        }
        return null;
    }

    private static String shortMessage(Throwable throwable) {
        String msg = throwable.getMessage();
        if (msg == null || msg.isBlank()) {
            return throwable.getClass().getSimpleName();
        }
        return msg;
    }

    private static void cacheDecision(String key, Decision decision) {
        if (key == null || key.isEmpty() || decision == null) {
            return;
        }
        SESSION_CACHE.put(key, decision);
    }

    private static void registerContext(PackContext context) {
        if (context == null) {
            return;
        }
        if (context.packId != null) {
            CONTEXTS_BY_ID.put(context.packId, context);
        }
    }

    private static PackContext getContext(UUID packId) {
        if (packId == null) {
            return null;
        }
        return CONTEXTS_BY_ID.get(packId);
    }

    private static void clearContext(PackContext context) {
        if (context == null) {
            return;
        }
        if (context.packId != null) {
            CONTEXTS_BY_ID.remove(context.packId);
        }
        ResourcePackProtector.clearDownloadTarget(context);
    }

    private static void logDownloadLocation(String action, PackContext context, Path path) {
        if (path == null) {
            return;
        }
        ResourcePackProtector.logAudit(action, context, "path=" + String.valueOf(path.toAbsolutePath()));
    }

    private static void registerDownloadTarget(PackContext context, Path path) {
        String key = ResourcePackProtector.contextKey(context);
        if (key == null || path == null) {
            return;
        }
        DOWNLOAD_TARGETS.put(key, path);
    }

    private static Path getDownloadTarget(PackContext context) {
        String key = ResourcePackProtector.contextKey(context);
        if (key == null) {
            return null;
        }
        return DOWNLOAD_TARGETS.get(key);
    }

    private static void clearDownloadTarget(PackContext context) {
        String key = ResourcePackProtector.contextKey(context);
        if (key == null) {
            return;
        }
        DOWNLOAD_TARGETS.remove(key);
    }

    private static String contextKey(PackContext context) {
        if (context == null) {
            return null;
        }
        if (context.packId != null) {
            return "id:" + String.valueOf(context.packId);
        }
        if (context.cacheKey != null && !context.cacheKey.isBlank()) {
            return "cache:" + context.cacheKey;
        }
        if (!context.url.isBlank()) {
            return "url:" + context.url;
        }
        return null;
    }

    private static void extractSandboxPack(Path zipPath, PackContext context) {
        Path extractDir;
        try {
            extractDir = ResourcePackProtector.createExtractionDirectory(zipPath);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to prepare extraction directory for {}", (Object)zipPath, (Object)e);
            ResourcePackProtector.logAudit("SANDBOX_EXTRACT_FAIL", context, "dir=<unprepared> error=" + e.getClass().getSimpleName() + ":" + ResourcePackProtector.shortMessage(e));
            return;
        }
        try (FileSystem fs = FileSystems.newFileSystem(zipPath, (ClassLoader)null);){
            for (Path root : fs.getRootDirectories()) {
                Stream<Path> walk = Files.walk(root, new FileVisitOption[0]);
                try {
                    walk.forEach(source -> {
                        Path relative = root.relativize((Path)source);
                        Path target = extractDir.resolve(relative.toString());
                        try {
                            if (Files.isDirectory(source, new LinkOption[0])) {
                                Files.createDirectories(target, new FileAttribute[0]);
                            } else {
                                Path parent = target.getParent();
                                if (parent != null) {
                                    Files.createDirectories(parent, new FileAttribute[0]);
                                }
                                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                            }
                        }
                        catch (IOException ex) {
                            throw new UncheckedIOException(ex);
                        }
                    });
                }
                finally {
                    if (walk == null) continue;
                    walk.close();
                }
            }
            ResourcePackProtector.logAudit("SANDBOX_EXTRACT", context, "dir=" + String.valueOf(extractDir.toAbsolutePath()));
        }
        catch (UncheckedIOException e) {
            IOException cause = e.getCause();
            LOGGER.warn("Failed while extracting sandboxed pack {}", (Object)zipPath, (Object)cause);
            ResourcePackProtector.logAudit("SANDBOX_EXTRACT_FAIL", context, "dir=" + String.valueOf(extractDir.toAbsolutePath()) + " error=" + cause.getClass().getSimpleName() + ":" + ResourcePackProtector.shortMessage(cause));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to extract sandboxed pack {}", (Object)zipPath, (Object)e);
            ResourcePackProtector.logAudit("SANDBOX_EXTRACT_FAIL", context, "dir=" + String.valueOf(extractDir.toAbsolutePath()) + " error=" + e.getClass().getSimpleName() + ":" + ResourcePackProtector.shortMessage(e));
        }
    }

    private static Path createExtractionDirectory(Path zipPath) throws IOException {
        String baseName;
        Path parent = zipPath.getParent();
        if (parent == null) {
            parent = zipPath.toAbsolutePath().getParent();
        }
        if (parent == null) {
            parent = zipPath.toAbsolutePath();
        }
        if ((baseName = ResourcePackProtector.stripExtension(zipPath.getFileName().toString())).isBlank()) {
            baseName = "resource-pack";
        }
        Path candidate = parent.resolve(baseName + "-extracted");
        int index = 1;
        while (Files.exists(candidate, new LinkOption[0])) {
            candidate = parent.resolve(baseName + "-extracted-" + index++);
        }
        Files.createDirectories(candidate, new FileAttribute[0]);
        return candidate;
    }

    private static String stripExtension(String value) {
        if (value == null) {
            return "";
        }
        int dot = value.lastIndexOf(46);
        return dot > 0 ? value.substring(0, dot) : value;
    }

    private static void sendStatus(class_2535 connection, PackContext context, class_2856.class_2857 status) {
        if (connection == null || status == null) {
            return;
        }
        try {
            connection.method_10743((class_2596)new class_2856(context.packId, status));
        }
        catch (Exception e) {
            LOGGER.debug("Failed to send resource-pack status update.", (Throwable)e);
        }
    }

    private static Map<String, Decision> createCache() {
        return Collections.synchronizedMap(new LinkedHashMap<String, Decision>(128, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Decision> eldest) {
                return this.size() > 128;
            }
        });
    }

    private static void pushToast(AntiFingerprintConfig.ToastLevel level, PackContext context, String title, String detail) {
        ResourcePackProtector.pushToast(level, title, ResourcePackProtector.composeToastDetail(context, detail));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pushToast(AntiFingerprintConfig.ToastLevel level, String title, String message) {
        if (!CONFIG.getToastVerbosity().allows(level)) {
            return;
        }
        class_5250 toastTitle = class_2561.method_43470((String)(title == null ? "" : title));
        class_5250 toastMessage = message == null || message.isBlank() ? class_2561.method_43470((String)"") : class_2561.method_43470((String)message);
        ToastPayload payload = new ToastPayload(ResourcePackProtector.toToastType(level), (class_2561)toastTitle, (class_2561)toastMessage);
        Deque<ToastPayload> deque = TOAST_QUEUE;
        synchronized (deque) {
            while (TOAST_QUEUE.size() >= 16) {
                TOAST_QUEUE.pollFirst();
            }
            TOAST_QUEUE.addLast(payload);
        }
    }

    private static String composeToastDetail(PackContext context, String detail) {
        StringBuilder sb = new StringBuilder();
        if (context != null) {
            if (context.host != null) {
                String hostDisplay = context.host.displayName();
                if (hostDisplay != null && !hostDisplay.isEmpty() && !"<unknown>".equals(hostDisplay)) {
                    sb.append("Host: ").append(hostDisplay);
                }
                if (context.host.ip() != null && !context.host.ip().isBlank()) {
                    if (sb.length() > 0) {
                        sb.append('\n');
                    }
                    sb.append("IP: ").append(context.host.ip());
                }
                if (context.host.remote() != null && !context.host.remote().isBlank()) {
                    if (sb.length() > 0) {
                        sb.append('\n');
                    }
                    sb.append("Remote: ").append(context.host.remote());
                }
            }
            if (context.packId != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append("Pack ID: ").append(context.packId);
            }
            if (context.hash != null && !context.hash.isBlank()) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append("Hash: ").append(context.hash);
            }
            if (!context.url.isBlank()) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append("URL: ").append(ResourcePackProtector.trimToLength(context.url, 200));
            }
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append("Required: ").append(context.required);
            if (detail != null && !detail.isBlank()) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(detail);
            }
            if (!context.prompt.isBlank()) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append("Prompt: ").append(ResourcePackProtector.trimToLength(context.prompt, 160));
            }
            if (sb.length() == 0) {
                return detail == null ? "" : detail;
            }
            return sb.toString();
        }
        return detail == null ? "" : detail;
    }

    private static String describeHost(HostInfo host) {
        if (host == null) {
            return "<unknown>";
        }
        String display = host.displayName();
        return display == null || display.isBlank() ? "<unknown>" : display;
    }

    private static String trimToLength(String value, int max) {
        if (value == null) {
            return "";
        }
        if (value.length() <= max) {
            return value;
        }
        return value.substring(0, Math.max(0, max - 1)) + "\u2026";
    }

    private static String sanitizeMultiline(String value) {
        if (value == null) {
            return "";
        }
        return value.replace('\r', ' ').replace('\n', ' ').trim();
    }

    private static class_370.class_9037 toToastType(AntiFingerprintConfig.ToastLevel level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case AntiFingerprintConfig.ToastLevel.INFO -> class_370.class_9037.field_47583;
            case AntiFingerprintConfig.ToastLevel.WARN -> class_370.class_9037.field_47589;
            case AntiFingerprintConfig.ToastLevel.ERROR -> class_370.class_9037.field_47585;
        };
    }

    private static String buildSandboxFileName(PackContext context, URI uri) {
        String base = !context.hash.isEmpty() ? context.hash : (!context.host.canonical.isEmpty() ? context.host.canonical.replace(':', '_') : (context.packId != null ? context.packId.toString() : "resource-pack"));
        String path = uri != null ? uri.getPath() : null;
        String extension = ".zip";
        if (path != null && path.contains(".")) {
            String candidate = path.substring(path.lastIndexOf(46));
            if (candidate.length() <= 6 && candidate.matches("\\.[A-Za-z0-9]+")) {
                extension = candidate;
            }
        } else {
            String candidate;
            String cachedName;
            int dot;
            Path cached = ResourcePackProtector.getDownloadTarget(context);
            if (cached != null && (dot = (cachedName = cached.getFileName().toString()).lastIndexOf(46)) > 0 && cachedName.length() - dot <= 6 && (candidate = cachedName.substring(dot)).matches("\\.[A-Za-z0-9]+")) {
                extension = candidate;
            }
        }
        Object fileName = (base + extension).replaceAll("[^A-Za-z0-9._-]", "_");
        if (((String)fileName).length() > 64) {
            fileName = ((String)fileName).substring(0, 64);
        }
        if (!((String)fileName).contains(".")) {
            fileName = (String)fileName + ".zip";
        }
        return fileName;
    }

    private static Path ensureUnique(Path target) {
        String fileName;
        if (!Files.exists(target, new LinkOption[0])) {
            return target;
        }
        String base = fileName = target.getFileName().toString();
        String ext = "";
        int dot = fileName.lastIndexOf(46);
        if (dot > 0) {
            base = fileName.substring(0, dot);
            ext = fileName.substring(dot);
        }
        for (int i = 1; i < 1000; ++i) {
            Path candidate = target.getParent().resolve(base + "-" + i + ext);
            if (Files.exists(candidate, new LinkOption[0])) continue;
            return candidate;
        }
        return target.getParent().resolve(base + "-" + System.currentTimeMillis() + ext);
    }

    private static void logAudit(String action, PackContext context, String extra) {
        if (!CONFIG.isAuditLogEnabled()) {
            return;
        }
        try {
            Path logDir = WurstClient.INSTANCE.getWurstFolder().resolve("logs");
            Files.createDirectories(logDir, new FileAttribute[0]);
            Path logFile = logDir.resolve("anti-fingerprint.log");
            StringBuilder line = new StringBuilder();
            line.append(Instant.now()).append(" [").append(action).append("] ");
            if (context != null) {
                line.append("host=").append(ResourcePackProtector.describeHost(context.host));
                if (context.host != null) {
                    if (context.host.ip() != null && !context.host.ip().isBlank()) {
                        line.append(" ip=").append(context.host.ip());
                    }
                    if (context.host.remote() != null && !context.host.remote().isBlank()) {
                        line.append(" remote=").append(context.host.remote());
                    }
                }
                if (context.packId != null) {
                    line.append(" packId=").append(context.packId);
                }
                if (context.cacheKey != null && !context.cacheKey.isBlank()) {
                    line.append(" cacheKey=").append(context.cacheKey);
                }
                line.append(" url=").append(context.url.isEmpty() ? "<none>" : context.url);
                line.append(" hash=").append(context.hash.isEmpty() ? "<none>" : context.hash);
                line.append(" required=").append(context.required);
                if (!context.prompt.isBlank()) {
                    line.append(" prompt=\"").append(ResourcePackProtector.sanitizeMultiline(context.prompt)).append('\"');
                }
            } else {
                line.append("host=<unknown>");
            }
            if (extra != null && !extra.isBlank()) {
                line.append(' ').append(extra);
            }
            line.append(System.lineSeparator());
            Files.writeString(logFile, (CharSequence)line.toString(), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            LOGGER.debug("Failed to write audit log entry.", (Throwable)e);
        }
    }

    private static String invokeString(Object target, String ... candidates) {
        for (String name : candidates) {
            try {
                Method method = target.getClass().getMethod(name, new Class[0]);
                method.setAccessible(true);
                Object result = method.invoke(target, new Object[0]);
                if (result == null) continue;
                if (result instanceof Optional) {
                    Optional optional = (Optional)result;
                    if (!optional.isPresent()) continue;
                    return Objects.toString(optional.get(), "");
                }
                return Objects.toString(result, "");
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return "";
    }

    /*
     * Exception decompiling
     */
    private static UUID invokeUuid(Object target, String ... candidates) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class_2561 invokeText(Object target, String ... candidates) {
        for (String name : candidates) {
            try {
                Method method = target.getClass().getMethod(name, new Class[0]);
                method.setAccessible(true);
                Object result = method.invoke(target, new Object[0]);
                if (result == null) continue;
                if (result instanceof Optional) {
                    Optional optional = (Optional)result;
                    if (!optional.isPresent()) continue;
                    Object value = optional.get();
                    if (value instanceof class_2561) {
                        class_2561 text = (class_2561)value;
                        return text;
                    }
                    return class_2561.method_43470((String)Objects.toString(value, ""));
                }
                if (result instanceof class_2561) {
                    class_2561 text = (class_2561)result;
                    return text;
                }
                return class_2561.method_43470((String)Objects.toString(result, ""));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean invokeBoolean(Object target, boolean fallback, String ... candidates) {
        for (String name : candidates) {
            try {
                Method method = target.getClass().getMethod(name, new Class[0]);
                method.setAccessible(true);
                Object result = method.invoke(target, new Object[0]);
                if (result instanceof Boolean) {
                    Boolean b = (Boolean)result;
                    return b;
                }
                if (result == null) continue;
                return Boolean.parseBoolean(result.toString());
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return fallback;
    }

    private static HostInfo parseHost(String url) {
        if (url == null || url.isBlank()) {
            return HostInfo.unknown(url);
        }
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            String host = uri.getHost();
            int port = uri.getPort();
            if (host == null) {
                if ("file".equalsIgnoreCase(scheme)) {
                    return HostInfo.local("file", url);
                }
                return HostInfo.unknown(url);
            }
            String hostLower = host.toLowerCase(Locale.ROOT);
            InetAddress resolved = null;
            try {
                resolved = InetAddress.getByName(hostLower);
            }
            catch (UnknownHostException e) {
                LOGGER.debug("Failed to resolve host {}", (Object)hostLower, (Object)e);
            }
            boolean local = ResourcePackProtector.isLikelyLocal(hostLower, scheme, port, resolved);
            String ip = resolved == null ? "" : resolved.getHostAddress();
            return HostInfo.create(hostLower, port, scheme, local, url, ip);
        }
        catch (URISyntaxException e) {
            LOGGER.debug("Unable to parse resource pack URL {}", (Object)url, (Object)e);
            return HostInfo.unknown(url);
        }
    }

    private static boolean isLikelyLocal(String host, String scheme, int port, InetAddress resolved) {
        if (host == null || host.isEmpty()) {
            return true;
        }
        if ("file".equalsIgnoreCase(scheme)) {
            return true;
        }
        if (host.equals("localhost") || host.equals("0.0.0.0") || host.equals("127.0.0.1") || host.equals("::1")) {
            return true;
        }
        if (host.endsWith(".local") || host.endsWith(".lan")) {
            return true;
        }
        if (ResourcePackProtector.isPrivateIpv4(host)) {
            return true;
        }
        return resolved != null && (resolved.isAnyLocalAddress() || resolved.isLoopbackAddress() || resolved.isLinkLocalAddress() || resolved.isSiteLocalAddress());
    }

    private static boolean isPrivateIpv4(String host) {
        if (!IPV4_PATTERN.matcher(host).matches()) {
            return false;
        }
        String[] parts = host.split("\\.");
        int p0 = Integer.parseInt(parts[0]);
        int p1 = Integer.parseInt(parts[1]);
        if (p0 == 10) {
            return true;
        }
        if (p0 == 127) {
            return true;
        }
        if (p0 == 192 && p1 == 168) {
            return true;
        }
        return p0 == 172 && p1 >= 16 && p1 <= 31;
    }

    private static PackContext buildContext(class_2720 packet) {
        Object keyCandidate;
        String prompt;
        String url = ResourcePackProtector.invokeString(packet, "getUrl", "getURL", "url");
        String hash = ResourcePackProtector.invokeString(packet, "getHash", "hash", "getHashValue");
        HostInfo hostInfo = ResourcePackProtector.parseHost(url);
        InetSocketAddress remoteAddress = ResourcePackProtector.getRemoteAddress();
        hostInfo = hostInfo.withFallback(remoteAddress);
        boolean required = ResourcePackProtector.invokeBoolean(packet, false, "isRequired", "isMandatory");
        UUID packId = ResourcePackProtector.invokeUuid(packet, "getId", "id");
        class_2561 promptText = ResourcePackProtector.invokeText(packet, "getPrompt", "prompt");
        String string = prompt = promptText == null ? "" : ResourcePackProtector.sanitizeMultiline(promptText.getString());
        Object object = packId != null ? packId.toString() : (keyCandidate = hash.isEmpty() ? url : hash);
        if (hostInfo.canonical != null && !hostInfo.canonical.isEmpty()) {
            keyCandidate = hostInfo.canonical + "|" + (String)keyCandidate;
        }
        String cacheKey = keyCandidate == null || ((String)keyCandidate).isBlank() ? null : keyCandidate;
        return new PackContext(url == null ? "" : url, hash == null ? "" : hash, hostInfo, required, cacheKey, packId, prompt);
    }

    private record PackContext(String url, String hash, HostInfo host, boolean required, String cacheKey, UUID packId, String prompt) {
        static PackContext from(class_2720 packet) {
            try {
                return ResourcePackProtector.buildContext(packet);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to build resource-pack context.", (Throwable)e);
                return PackContext.empty();
            }
        }

        static PackContext empty() {
            return new PackContext("", "", HostInfo.unknown(""), false, null, null, "");
        }
    }

    public record PolicyResult(Decision decision, String reason, PackContext context) {
    }

    public static enum Decision {
        ALLOW,
        BLOCK,
        SANDBOX;

    }

    private static enum SandboxRequest {
        POLICY("SANDBOX_START", "SANDBOX_OK", "SANDBOX_FAIL", "Sandbox download", "Fetching remote pack.", "Sandboxed resource pack", "Stored copy: ", AntiFingerprintConfig.ToastLevel.INFO, AntiFingerprintConfig.ToastLevel.WARN, "Sandbox download failed"),
        PROMPT("PROMPT_SNAPSHOT_START", "PROMPT_SNAPSHOT_OK", "PROMPT_SNAPSHOT_FAIL", "Prompt inspection copy", "Downloading pack snapshot.", "Prompt inspection copy ready", "Saved copy: ", AntiFingerprintConfig.ToastLevel.INFO, AntiFingerprintConfig.ToastLevel.INFO, "Prompt inspection copy failed");

        private final String auditStart;
        private final String auditOk;
        private final String auditFail;
        private final String startTitle;
        private final String startBody;
        private final String successTitle;
        private final String successBodyPrefix;
        private final AntiFingerprintConfig.ToastLevel startLevel;
        private final AntiFingerprintConfig.ToastLevel successLevel;
        private final String failTitle;

        private SandboxRequest(String auditStart, String auditOk, String auditFail, String startTitle, String startBody, String successTitle, String successBodyPrefix, AntiFingerprintConfig.ToastLevel startLevel, AntiFingerprintConfig.ToastLevel successLevel, String failTitle) {
            this.auditStart = auditStart;
            this.auditOk = auditOk;
            this.auditFail = auditFail;
            this.startTitle = startTitle;
            this.startBody = startBody;
            this.successTitle = successTitle;
            this.successBodyPrefix = successBodyPrefix;
            this.startLevel = startLevel;
            this.successLevel = successLevel;
            this.failTitle = failTitle;
        }
    }

    private record ToastPayload(class_370.class_9037 type, class_2561 title, class_2561 description) {
    }

    private record HostInfo(String host, int port, String scheme, boolean local, String canonical, String original, String ip, String remote) {
        static HostInfo unknown(String original) {
            return new HostInfo("", -1, "", true, "", original == null ? "" : original, "", "");
        }

        static HostInfo local(String scheme, String original) {
            return new HostInfo("", -1, scheme, true, "", original == null ? "" : original, "", "");
        }

        static HostInfo create(String host, int port, String scheme, boolean local, String original, String ip) {
            Object canonical;
            Object object = canonical = host == null ? "" : host;
            if (port > 0) {
                canonical = (String)canonical + ":" + port;
            }
            return new HostInfo(host == null ? "" : host, port, scheme == null ? "" : scheme, local, ((String)canonical).toLowerCase(Locale.ROOT), original == null ? "" : original, ip == null ? "" : ip, "");
        }

        String displayName() {
            if (!this.canonical.isEmpty()) {
                return this.canonical;
            }
            if (!this.host.isEmpty()) {
                return this.host;
            }
            if (this.original != null && !this.original.isEmpty()) {
                return this.original;
            }
            if (this.remote != null && !this.remote.isEmpty()) {
                return this.remote;
            }
            return "<unknown>";
        }

        String canonicalOrFallback() {
            if (!this.canonical.isEmpty()) {
                return this.canonical;
            }
            if (!this.host.isEmpty()) {
                return this.host;
            }
            if (this.original != null && !this.original.isEmpty()) {
                return this.original;
            }
            if (this.remote != null && !this.remote.isEmpty()) {
                return this.remote;
            }
            return "<unknown>";
        }

        HostInfo withFallback(InetSocketAddress address) {
            if (address == null) {
                return this;
            }
            String fallbackHost = address.getHostString();
            String hostLower = fallbackHost == null ? "" : fallbackHost.toLowerCase(Locale.ROOT);
            InetAddress inet = address.getAddress();
            String fallbackIp = inet == null ? "" : inet.getHostAddress();
            boolean fallbackLocal = this.local;
            if (inet != null) {
                fallbackLocal = fallbackLocal || inet.isAnyLocalAddress() || inet.isLoopbackAddress() || inet.isLinkLocalAddress() || inet.isSiteLocalAddress();
            }
            String schemeValue = this.scheme.isEmpty() ? "tcp" : this.scheme;
            int portValue = this.port >= 0 ? this.port : address.getPort();
            Object canonicalValue = this.canonical;
            if (((String)canonicalValue).isEmpty() && !hostLower.isEmpty()) {
                canonicalValue = hostLower;
                if (portValue > 0) {
                    canonicalValue = (String)canonicalValue + ":" + portValue;
                }
            }
            String hostValue = this.host.isEmpty() ? hostLower : this.host;
            String originalValue = this.original.isEmpty() && fallbackHost != null ? fallbackHost : this.original;
            String ipValue = this.ip.isEmpty() ? fallbackIp : this.ip;
            String remoteValue = address.toString();
            return new HostInfo(hostValue, portValue, schemeValue, fallbackLocal, (String)canonicalValue, originalValue, ipValue, remoteValue);
        }
    }

    private static final class PackHistory {
        private final Deque<Long> timestamps = new ArrayDeque<Long>();
        private long lastAlert;

        private PackHistory() {
        }
    }
}

