/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.chestsearch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;

public class ChestConfig {
    public boolean enabled = true;
    public boolean storeFullItemNbt = true;
    public String dbPath = "config/wurst/chest_database.json";
    public int graceTicks = 200;
    public int scanRadius = 64;
    private final transient File file;
    private final transient Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public ChestConfig(File file) {
        this.file = file;
        this.load();
    }

    public ChestConfig() {
        this(new File("config/wurst/chest_search.json"));
    }

    private ChestConfigData toData() {
        ChestConfigData data = new ChestConfigData();
        data.enabled = this.enabled;
        data.storeFullItemNbt = this.storeFullItemNbt;
        data.dbPath = this.dbPath;
        data.graceTicks = this.graceTicks;
        data.scanRadius = this.scanRadius;
        return data;
    }

    private void applyData(ChestConfigData data) {
        if (data == null) {
            return;
        }
        this.enabled = data.enabled;
        this.storeFullItemNbt = data.storeFullItemNbt;
        if (data.dbPath != null && !data.dbPath.isBlank()) {
            this.dbPath = data.dbPath;
        }
        this.graceTicks = data.graceTicks;
        this.scanRadius = data.scanRadius;
    }

    public synchronized void load() {
        try {
            if (!this.file.exists()) {
                this.file.getParentFile().mkdirs();
                this.save();
                return;
            }
            try (FileReader r = new FileReader(this.file);){
                ChestConfigData c = (ChestConfigData)this.gson.fromJson((Reader)r, ChestConfigData.class);
                this.applyData(c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void save() {
        try (FileWriter w = new FileWriter(this.file);){
            this.gson.toJson((Object)this.toData(), (Appendable)w);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class ChestConfigData {
        public boolean enabled = true;
        public boolean storeFullItemNbt = true;
        public String dbPath = "config/wurst/chest_database.json";
        public int graceTicks = 200;
        public int scanRadius = 64;

        private ChestConfigData() {
        }
    }
}

