/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.chestsearch;

import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.class_1293;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1890;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.wurstclient.chestsearch.ChestConfig;
import net.wurstclient.chestsearch.ChestEntry;
import net.wurstclient.chestsearch.ChestManager;
import net.wurstclient.clickgui.screens.ChestSearchScreen;

public class ChestRecorder {
    private final ChestManager manager;
    private final ChestConfig config;
    private final Map<Integer, List<class_1799>> buffers = new HashMap<Integer, List<class_1799>>();
    private final Map<Integer, TimerTask> pendingSnapshots = new HashMap<Integer, TimerTask>();

    public ChestRecorder(File storageFile, ChestConfig config) {
        this.manager = new ChestManager(storageFile, config);
        this.config = config;
    }

    public ChestRecorder() {
        this.config = new ChestConfig();
        this.manager = new ChestManager(new File(this.config.dbPath), this.config);
    }

    public void startListening(final String serverIp, final String dimension, final int x, final int y, final int z, final class_1703 handler, int chestSlots, List<Integer> chestSlotIndices, final Bounds bounds) {
        if (this.config != null && !this.config.enabled) {
            return;
        }
        final int syncId = handler.field_7763;
        final ArrayList<class_1799> buf = new ArrayList<class_1799>(handler.field_7761.size());
        for (int i = 0; i < handler.field_7761.size(); ++i) {
            buf.add(class_1799.field_8037);
        }
        this.buffers.put(syncId, buf);
        final ArrayList<Integer> slotOrder = new ArrayList<Integer>();
        if (chestSlotIndices != null && !chestSlotIndices.isEmpty()) {
            slotOrder.addAll(chestSlotIndices);
            Collections.sort(slotOrder);
        } else {
            int limit = Math.min(chestSlots, handler.field_7761.size());
            for (int i = 0; i < limit; ++i) {
                slotOrder.add(i);
            }
        }
        for (Integer idx : slotOrder) {
            if (idx < 0 || idx >= handler.field_7761.size()) continue;
            class_1799 st = ((class_1735)handler.field_7761.get(idx.intValue())).method_7677();
            buf.set(idx, st == null ? class_1799.field_8037 : st.method_7972());
        }
        final Runnable scheduleSnapshot = () -> {
            TimerTask old = this.pendingSnapshots.remove(syncId);
            if (old != null) {
                try {
                    old.cancel();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    try {
                        ArrayList<class_1799> snapshot = new ArrayList<class_1799>(buf.size());
                        Iterator iterator = slotOrder.iterator();
                        while (iterator.hasNext()) {
                            int idx = (Integer)iterator.next();
                            if (idx < 0 || idx >= buf.size()) {
                                snapshot.add(class_1799.field_8037);
                                continue;
                            }
                            class_1799 st = (class_1799)buf.get(idx);
                            snapshot.add(st == null ? class_1799.field_8037 : st.method_7972());
                        }
                        ChestRecorder.this.recordFromStacksWithSlotOrder(serverIp, dimension, x, y, z, snapshot, slotOrder, bounds);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            };
            this.pendingSnapshots.put(syncId, task);
            new Timer(true).schedule(task, 40L);
        };
        final class_1712 listener = new class_1712(){

            public void method_7635(class_1703 sh, int slotId, class_1799 stack) {
                if (sh != handler) {
                    return;
                }
                if (slotId >= 0 && slotId < buf.size()) {
                    buf.set(slotId, stack == null ? class_1799.field_8037 : stack.method_7972());
                    scheduleSnapshot.run();
                }
            }

            public void method_7633(class_1703 handler2, int property, int value) {
            }
        };
        try {
            handler.method_7596(listener);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        new Timer(true).schedule(new TimerTask(this){

            @Override
            public void run() {
                scheduleSnapshot.run();
            }
        }, 40L);
        new Timer(true).schedule(new TimerTask(){

            @Override
            public void run() {
                block7: {
                    try {
                        if (!ChestRecorder.this.buffers.containsKey(syncId)) break block7;
                        TimerTask pending = ChestRecorder.this.pendingSnapshots.remove(syncId);
                        if (pending != null) {
                            try {
                                pending.cancel();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        try {
                            handler.method_7603(listener);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ChestRecorder.this.buffers.remove(syncId);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }, 30000L);
    }

    public void onChestOpened(String serverIp, String dimension, int x, int y, int z, class_1703 handler, int chestSlots, Bounds bounds) {
        this.startListening(serverIp, dimension, x, y, z, handler, chestSlots, new ArrayList<Integer>(), bounds);
    }

    public void onChestOpened(String serverIp, String dimension, int x, int y, int z, class_1703 handler, int chestSlots, List<Integer> chestSlotIndices, Bounds bounds) {
        this.startListening(serverIp, dimension, x, y, z, handler, chestSlots, chestSlotIndices, bounds);
    }

    public List<ChestEntry> search(String q) {
        return this.manager.search(q);
    }

    public List<ChestEntry> all() {
        return this.manager.all();
    }

    public void removeChest(String serverIp, String dimension, int x, int y, int z) {
        this.manager.removeChest(serverIp, dimension, x, y, z);
        ChestSearchScreen.clearDecorations(dimension, new class_2338(x, y, z));
    }

    public void recordFromStacks(String serverIp, String dimension, int x, int y, int z, List<class_1799> stacks, int chestSlots) {
        this.recordFromStacksInternal(serverIp, dimension, x, y, z, stacks, null, chestSlots, null);
    }

    public void recordFromStacksWithSlotOrder(String serverIp, String dimension, int x, int y, int z, List<class_1799> stacks, List<Integer> slotOrder, Bounds bounds) {
        int maxSlots = slotOrder == null ? -1 : slotOrder.size();
        this.recordFromStacksInternal(serverIp, dimension, x, y, z, stacks, slotOrder, maxSlots, bounds);
    }

    private void recordFromStacksInternal(String serverIp, String dimension, int x, int y, int z, List<class_1799> stacks, List<Integer> slotOrder, int maxSlots, Bounds bounds) {
        if (this.config != null && !this.config.enabled) {
            return;
        }
        if (stacks == null) {
            return;
        }
        int limit = stacks.size();
        if (maxSlots >= 0 && maxSlots < limit) {
            limit = maxSlots;
        }
        ArrayList<ChestEntry.ItemEntry> items = new ArrayList<ChestEntry.ItemEntry>();
        for (int i = 0; i < limit; ++i) {
            int slotNumber;
            class_1799 st = stacks.get(i);
            if (st == null || st.method_7960()) continue;
            class_1799 copy = st.method_7972();
            ChestEntry.ItemEntry it = new ChestEntry.ItemEntry();
            it.slot = slotNumber = slotOrder != null && i < slotOrder.size() ? slotOrder.get(i) : i;
            it.count = copy.method_7947();
            try {
                it.itemId = class_7923.field_41178.method_10221((Object)copy.method_7909()).toString();
            }
            catch (Throwable t) {
                it.itemId = copy.method_7909().toString();
            }
            try {
                it.displayName = copy.method_7964().getString();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                String n = copy.toString();
                if (n != null && !n.isBlank()) {
                    it.nbt = new JsonPrimitive(n);
                    if (n.contains("Enchantments") || n.contains("StoredEnchantments")) {
                        Object ench = n;
                        if (((String)ench).length() > 80) {
                            ench = ((String)ench).substring(0, 80) + "...";
                        }
                        it.displayName = it.displayName == null ? ench : it.displayName + " " + (String)ench;
                    }
                } else if (this.config != null && this.config.storeFullItemNbt) {
                    try {
                        it.nbt = new JsonPrimitive(copy.toString());
                    }
                    catch (Throwable ignored) {
                        it.nbt = null;
                    }
                }
            }
            catch (Throwable ignored) {
                it.nbt = null;
            }
            try {
                try {
                    Set enchSet = class_1890.method_57532((class_1799)copy).method_57539();
                    if (enchSet != null && !enchSet.isEmpty()) {
                        it.enchantments = new ArrayList<String>();
                        it.enchantmentLevels = new ArrayList<Integer>();
                        for (Object2IntMap.Entry e : enchSet) {
                            class_6880 ren = (class_6880)e.getKey();
                            if (ren == null) continue;
                            class_2960 id = ren.method_40230().map(k -> k.method_29177()).orElse(null);
                            String idStr = id != null ? id.toString() : ren.method_55840();
                            int lvl = e.getIntValue();
                            if (idStr == null || idStr.isBlank()) continue;
                            it.enchantments.add(idStr);
                            it.enchantmentLevels.add(lvl);
                        }
                    }
                }
                catch (Throwable enchSet) {
                    // empty catch block
                }
                try {
                    class_1844 potionContents = (class_1844)copy.method_57353().method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
                    if (potionContents != null) {
                        Object2IntMap.Entry e;
                        ArrayList<String> pe = new ArrayList<String>();
                        e = potionContents.method_57397().iterator();
                        while (e.hasNext()) {
                            class_1293 sei = (class_1293)e.next();
                            class_6880 effEntry = sei.method_5579();
                            class_2960 id = effEntry.method_40230().map(k -> k.method_29177()).orElse(null);
                            String idStr = id != null ? id.toString() : effEntry.method_55840();
                            if (idStr == null || idStr.isBlank()) continue;
                            pe.add(idStr);
                        }
                        if (!pe.isEmpty()) {
                            it.potionEffects = pe;
                            it.primaryPotion = (String)pe.get(0);
                        } else {
                            Optional basePotion = potionContents.comp_2378();
                            if (basePotion.isPresent()) {
                                String idStr;
                                class_2960 id = ((class_6880)basePotion.get()).method_40230().map(k -> k.method_29177()).orElse(null);
                                it.primaryPotion = idStr = id != null ? id.toString() : ((class_6880)basePotion.get()).method_55840();
                            }
                        }
                    }
                }
                catch (Throwable potionContents) {}
            }
            catch (Throwable potionContents) {
                // empty catch block
            }
            items.add(it);
        }
        int minX = x;
        int minY = y;
        int minZ = z;
        int maxX = x;
        int maxY = y;
        int maxZ = z;
        String facing = null;
        if (bounds != null) {
            minX = Math.min(bounds.minX, bounds.maxX);
            minY = Math.min(bounds.minY, bounds.maxY);
            minZ = Math.min(bounds.minZ, bounds.maxZ);
            maxX = Math.max(bounds.minX, bounds.maxX);
            maxY = Math.max(bounds.minY, bounds.maxY);
            maxZ = Math.max(bounds.minZ, bounds.maxZ);
            facing = bounds.facing;
        }
        this.manager.upsertChest(serverIp, dimension, minX, minY, minZ, items, maxX, maxY, maxZ, facing, x, y, z);
    }

    private static String sanitizePath(String raw) {
        if (raw == null || raw.isEmpty()) {
            return "";
        }
        int colon = raw.indexOf(58);
        return colon >= 0 && colon + 1 < raw.length() ? raw.substring(colon + 1) : raw;
    }

    public static class Bounds {
        public final int minX;
        public final int minY;
        public final int minZ;
        public final int maxX;
        public final int maxY;
        public final int maxZ;
        public final String facing;

        public Bounds(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, String facing) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
            this.facing = facing;
        }

        public static Bounds of(class_2338 min, class_2338 max, String facing) {
            if (min == null && max == null) {
                return null;
            }
            if (min == null) {
                min = max;
            }
            if (max == null) {
                max = min;
            }
            return new Bounds(min.method_10263(), min.method_10264(), min.method_10260(), max.method_10263(), max.method_10264(), max.method_10260(), facing);
        }
    }
}

