/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.chestsearch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_4587;
import net.wurstclient.WurstClient;
import net.wurstclient.events.RenderListener;
import net.wurstclient.util.RenderUtils;

public final class TargetHighlighter
implements RenderListener {
    private static final long DEFAULT_DURATION_MS = 60000L;
    public static final TargetHighlighter INSTANCE = new TargetHighlighter();
    private final Map<String, Target> targets = new HashMap<String, Target>();
    private int quadColor = 1076035464;
    private int lineColor = -2145190008;

    private TargetHighlighter() {
    }

    public void setColors(int quadColor, int lineColor) {
        this.quadColor = quadColor;
        this.lineColor = lineColor;
    }

    public void toggle(String dimension, class_2338 pos) {
        this.toggle(dimension, pos, pos, 60000L);
    }

    public void toggle(String dimension, class_2338 min, class_2338 max) {
        this.toggle(dimension, min, max, 60000L);
    }

    public synchronized void toggle(String dimension, class_2338 min, class_2338 max, long durationMs) {
        if (min == null) {
            return;
        }
        class_2338 actualMax = max == null ? min : max;
        String key = TargetHighlighter.key(dimension, min);
        if (this.targets.containsKey(key)) {
            this.targets.remove(key);
            return;
        }
        Target target = new Target();
        target.expireAt = System.currentTimeMillis() + Math.max(1000L, durationMs);
        target.minX = Math.min(min.method_10263(), actualMax.method_10263());
        target.minY = Math.min(min.method_10264(), actualMax.method_10264());
        target.minZ = Math.min(min.method_10260(), actualMax.method_10260());
        target.maxX = Math.max(min.method_10263(), actualMax.method_10263());
        target.maxY = Math.max(min.method_10264(), actualMax.method_10264());
        target.maxZ = Math.max(min.method_10260(), actualMax.method_10260());
        this.targets.put(key, target);
    }

    public synchronized boolean has(String dimension, class_2338 pos) {
        return this.targets.containsKey(TargetHighlighter.key(dimension, pos));
    }

    public synchronized boolean clear(String dimension, class_2338 pos) {
        return this.targets.remove(TargetHighlighter.key(dimension, pos)) != null;
    }

    private static String key(String dim, class_2338 p) {
        return (dim == null ? "" : dim) + "|" + p.method_10263() + "," + p.method_10264() + "," + p.method_10260();
    }

    @Override
    public synchronized void onRender(class_4587 matrixStack, float partialTicks) {
        if (WurstClient.MC == null || WurstClient.MC.field_1687 == null) {
            return;
        }
        String dim = WurstClient.MC.field_1687.method_27983().method_29177().toString();
        long now = System.currentTimeMillis();
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        Iterator<Map.Entry<String, Target>> it = this.targets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Target> e = it.next();
            Target target = e.getValue();
            if (target == null) {
                it.remove();
                continue;
            }
            if (target.expireAt < now) {
                it.remove();
                continue;
            }
            String k = e.getKey();
            if (!k.startsWith(dim + "|")) continue;
            boxes.add(new class_238((double)target.minX, (double)target.minY, (double)target.minZ, (double)(target.maxX + 1), (double)(target.maxY + 1), (double)(target.maxZ + 1)));
        }
        if (boxes.isEmpty()) {
            return;
        }
        RenderUtils.drawSolidBoxes(matrixStack, boxes, this.quadColor, false);
        RenderUtils.drawOutlinedBoxes(matrixStack, boxes, this.lineColor, false);
    }

    private static final class Target {
        long expireAt;
        int minX;
        int minY;
        int minZ;
        int maxX;
        int maxY;
        int maxZ;

        private Target() {
        }
    }
}

