/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui.components;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.wurstclient.clickgui.ClickGui;
import net.wurstclient.clickgui.ClickGuiIcons;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.Popup;
import net.wurstclient.settings.MobWeaponRuleSetting;
import net.wurstclient.util.RenderUtils;

public final class MobWeaponRuleComponent
extends Component {
    private static final ClickGui GUI = WURST.getGui();
    private static final class_327 TR = MobWeaponRuleComponent.MC.field_1772;
    private static final int BOX_HEIGHT = 11;
    private static final int ARROW_SIZE = 11;
    private static final int BOX_GAP = 4;
    private static final int PADDING = 2;
    private final MobWeaponRuleSetting setting;
    private OptionPopup<MobWeaponRuleSetting.MobOption> mobPopup;
    private OptionPopup<MobWeaponRuleSetting.WeaponCategory> weaponPopup;

    public MobWeaponRuleComponent(MobWeaponRuleSetting setting) {
        this.setting = Objects.requireNonNull(setting);
        this.setWidth(this.getDefaultWidth());
        this.setHeight(this.getDefaultHeight());
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        Box mobBox = this.getMobBox();
        Box weaponBox = this.getWeaponBox();
        if (mouseButton == 0) {
            if (mobBox.contains(mouseX, mouseY)) {
                this.toggleMobPopup(mobBox);
            } else if (weaponBox.contains(mouseX, mouseY)) {
                this.toggleWeaponPopup(weaponBox);
            }
            return;
        }
        if (mouseButton == 1) {
            if (mobBox.contains(mouseX, mouseY)) {
                this.setting.resetMob();
            } else if (weaponBox.contains(mouseX, mouseY)) {
                this.setting.resetWeapon();
            }
        }
    }

    private void toggleMobPopup(Box mobBox) {
        if (this.mobPopup != null && !this.mobPopup.isClosing()) {
            this.mobPopup.close();
            this.mobPopup = null;
            return;
        }
        int labelWidth = this.getMaxWidth(this.setting.getMobOptions(), MobWeaponRuleSetting.MobOption::displayName);
        int popupWidth = labelWidth + 15;
        int anchorX = mobBox.x2 - this.getX() - popupWidth;
        int anchorY = mobBox.y2 - this.getY();
        this.mobPopup = new OptionPopup<MobWeaponRuleSetting.MobOption>(this, this.setting.getMobOptions(), this.setting::getSelectedMob, this.setting::setSelectedMob, MobWeaponRuleSetting.MobOption::displayName, labelWidth, anchorX, anchorY);
        GUI.addPopup(this.mobPopup);
    }

    private void toggleWeaponPopup(Box weaponBox) {
        if (this.weaponPopup != null && !this.weaponPopup.isClosing()) {
            this.weaponPopup.close();
            this.weaponPopup = null;
            return;
        }
        List<MobWeaponRuleSetting.WeaponCategory> values = List.of(MobWeaponRuleSetting.WeaponCategory.values());
        int labelWidth = this.getMaxWidth(values, MobWeaponRuleSetting.WeaponCategory::toString);
        int popupWidth = labelWidth + 15;
        int anchorX = weaponBox.x2 - this.getX() - popupWidth;
        int anchorY = weaponBox.y2 - this.getY();
        this.weaponPopup = new OptionPopup<MobWeaponRuleSetting.WeaponCategory>(this, values, this.setting::getSelectedWeapon, this.setting::setSelectedWeapon, MobWeaponRuleSetting.WeaponCategory::toString, labelWidth, anchorX, anchorY);
        GUI.addPopup(this.weaponPopup);
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float partialTicks) {
        int x1 = this.getX();
        int y1 = this.getY();
        context.method_25294(x1, y1, x1 + this.getWidth(), y1 + this.getHeight(), RenderUtils.toIntColor(GUI.getBgColor(), GUI.getOpacity()));
        int txtColor = GUI.getTxtColor();
        context.method_51433(TR, this.setting.getName(), x1, y1, txtColor, false);
        Box mobBox = this.getMobBox();
        Box weaponBox = this.getWeaponBox();
        boolean mobOpen = this.mobPopup != null && !this.mobPopup.isClosing();
        this.drawDropdown(context, mobBox, this.setting.getSelectedMob().displayName(), mouseX, mouseY, "Pick which mob should trigger this rule.", false, mobOpen);
        String weaponLabel = this.setting.getSelectedWeapon().toString();
        boolean disabled = this.setting.getSelectedWeapon() == MobWeaponRuleSetting.WeaponCategory.NONE;
        this.drawDropdown(context, weaponBox, weaponLabel, mouseX, mouseY, disabled ? "Right-click to reset. Select a tool/weapon to enable." : "Select which tool/weapon should be used when targeting.", disabled, this.weaponPopup != null && !this.weaponPopup.isClosing());
    }

    private void drawDropdown(class_332 context, Box box, String value, int mouseX, int mouseY, String tooltip, boolean dimmed, boolean expanded) {
        int arrowX1 = box.x2 - 11;
        int arrowX2 = box.x2;
        boolean hovering = box.contains(mouseX, mouseY);
        if (hovering) {
            GUI.setTooltip(tooltip);
        }
        context.method_25294(box.x1, box.y1, arrowX1, box.y1 + 11, RenderUtils.toIntColor(GUI.getBgColor(), GUI.getOpacity() * (hovering ? 1.25f : 1.0f)));
        context.method_25294(arrowX1, box.y1, arrowX2, box.y1 + 11, RenderUtils.toIntColor(GUI.getBgColor(), GUI.getOpacity() * (hovering ? 1.5f : 1.0f)));
        context.field_59826.method_71067();
        int outlineColor = RenderUtils.toIntColor(GUI.getAcColor(), 0.5f);
        RenderUtils.drawBorder2D(context, box.x1, box.y1, box.x2, box.y1 + 11, outlineColor);
        RenderUtils.drawLine2D(context, arrowX1, box.y1, arrowX1, box.y1 + 11, outlineColor);
        ClickGuiIcons.drawMinimizeArrow(context, arrowX1, (float)box.y1 + 0.5f, arrowX2, (float)(box.y1 + 11) - 0.5f, hovering, !expanded);
        int color = dimmed ? -5592406 : GUI.getTxtColor();
        context.method_51433(TR, value, box.x1 + 2, box.y1 + 2, color, false);
    }

    private Box getMobBox() {
        int width = this.getWidth() - 4 - 4;
        int boxWidth = width / 2;
        int x1 = this.getX() + 2;
        int n = this.getY();
        Objects.requireNonNull(TR);
        int y = n + 9 + 2;
        return new Box(x1, y, x1 + boxWidth, y + 11);
    }

    private Box getWeaponBox() {
        Box mobBox = this.getMobBox();
        int x1 = mobBox.x2 + 4;
        return new Box(x1, mobBox.y1, x1 + (mobBox.x2 - mobBox.x1), mobBox.y1 + 11);
    }

    private <T> int getMaxWidth(List<T> values, Function<T, String> labelGetter) {
        int max = 0;
        for (T value : values) {
            max = Math.max(max, TR.method_1727(labelGetter.apply(value)));
        }
        return max;
    }

    @Override
    public int getDefaultWidth() {
        return TR.method_1727(this.setting.getName()) + 40;
    }

    @Override
    public int getDefaultHeight() {
        Objects.requireNonNull(TR);
        return 9 + 11 + 3;
    }

    private record Box(int x1, int y1, int x2, int y2) {
        boolean contains(double x, double y) {
            return x >= (double)this.x1 && x < (double)this.x2 && y >= (double)this.y1 && y < (double)this.y2;
        }
    }

    private static final class OptionPopup<T>
    extends Popup {
        private static final int MAX_VISIBLE_ROWS = 8;
        private final List<T> options;
        private final Supplier<T> selectedSupplier;
        private final Consumer<T> onSelect;
        private final Function<T, String> labelGetter;
        private final int textWidth;
        private final int totalRows;
        private final int visibleRows;
        private int scrollOffset;

        public OptionPopup(Component owner, List<T> options, Supplier<T> selectedSupplier, Consumer<T> onSelect, Function<T, String> labelGetter, int textWidth, int anchorX, int anchorY) {
            super(owner);
            this.options = options;
            this.selectedSupplier = selectedSupplier;
            this.onSelect = onSelect;
            this.labelGetter = labelGetter;
            this.textWidth = textWidth;
            this.totalRows = Math.max(0, options.size() - 1);
            this.visibleRows = Math.min(8, this.totalRows);
            this.setWidth(textWidth + 15);
            this.setHeight(this.getDefaultHeight());
            this.setX(anchorX);
            this.setY(anchorY);
        }

        @Override
        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            if (mouseButton != 0 || this.visibleRows <= 0) {
                return;
            }
            int localX = mouseX - this.getX();
            int localY = mouseY - this.getY();
            if (localX < 0 || localX >= this.getWidth() || localY < 0 || localY >= this.getHeight()) {
                return;
            }
            int row = localY / 11;
            T option = this.getOptionAt(row + this.scrollOffset);
            if (option == null) {
                return;
            }
            this.onSelect.accept(option);
            this.close();
        }

        @Override
        public boolean handleMouseScroll(int mouseX, int mouseY, double delta) {
            if (this.totalRows <= this.visibleRows || this.visibleRows <= 0) {
                return false;
            }
            int direction = (int)Math.signum(delta);
            if (direction == 0) {
                return false;
            }
            this.scrollOffset -= direction;
            this.clampScroll();
            return true;
        }

        @Override
        public void render(class_332 context, int mouseX, int mouseY) {
            if (this.visibleRows <= 0) {
                return;
            }
            this.clampScroll();
            int x1 = this.getX();
            int x2 = x1 + this.getWidth();
            int y1 = this.getY();
            int y2 = y1 + this.getHeight();
            RenderUtils.drawBorder2D(context, x1, y1, x2, y2, RenderUtils.toIntColor(GUI.getAcColor(), 0.5f));
            int drawn = 0;
            int skipped = 0;
            for (T option : this.options) {
                if (option.equals(this.selectedSupplier.get()) || skipped++ < this.scrollOffset) continue;
                if (drawn >= this.visibleRows) break;
                int currentY = y1 + drawn * 11;
                int nextY = currentY + 11;
                boolean hovering = mouseY >= currentY && mouseY < nextY && mouseX >= x1 && mouseX < x2;
                context.method_25294(x1, currentY, x2, nextY, RenderUtils.toIntColor(GUI.getBgColor(), GUI.getOpacity() * (hovering ? 1.5f : 1.0f)));
                context.field_59826.method_71067();
                context.method_51433(TR, this.labelGetter.apply(option), x1 + 2, currentY + 2, GUI.getTxtColor(), false);
                ++drawn;
            }
        }

        private void clampScroll() {
            int maxOffset = Math.max(0, this.totalRows - this.visibleRows);
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            } else if (this.scrollOffset > maxOffset) {
                this.scrollOffset = maxOffset;
            }
        }

        private T getOptionAt(int index) {
            if (index < 0) {
                return null;
            }
            int skipped = 0;
            for (T option : this.options) {
                if (option.equals(this.selectedSupplier.get())) continue;
                if (skipped == index) {
                    return option;
                }
                ++skipped;
            }
            return null;
        }

        @Override
        public int getDefaultWidth() {
            return this.textWidth + 15;
        }

        @Override
        public int getDefaultHeight() {
            return this.visibleRows * 11;
        }
    }
}

