/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui.components;

import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.wurstclient.clickgui.ClickGui;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.KeyboardInput;
import net.wurstclient.clickgui.Window;
import net.wurstclient.settings.TextFieldSetting;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.RenderUtils;

public final class TextFieldEditButton
extends Component
implements KeyboardInput {
    private static final ClickGui GUI = WURST.getGui();
    private static final class_327 TR = TextFieldEditButton.MC.field_1772;
    private static final int TEXT_HEIGHT = 11;
    private final TextFieldSetting setting;
    private final class_342 inlineField;
    private boolean editing;
    private String originalValue = "";

    public TextFieldEditButton(TextFieldSetting setting) {
        this.setting = Objects.requireNonNull(setting);
        this.inlineField = new class_342(TR, 0, 0, 0, 11, (class_2561)class_2561.method_43470((String)""));
        this.inlineField.method_1858(false);
        this.inlineField.method_1880(Integer.MAX_VALUE);
        this.inlineField.method_1890(setting::isValidValue);
        this.inlineField.method_1852(setting.getValue());
        this.inlineField.method_1888(false);
        this.setWidth(this.getDefaultWidth());
        this.setHeight(this.getDefaultHeight());
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        double localY = mouseY - (double)this.getY();
        if (localY < 0.0 || localY >= (double)this.getHeight()) {
            return;
        }
        boolean overBox = localY >= 11.0;
        switch (mouseButton) {
            case 0: {
                if (overBox) {
                    if (!this.editing) {
                        this.startEditing();
                    }
                    this.inlineField.method_25402((double)this.toAbsoluteMouseX(mouseX), (double)this.toAbsoluteMouseY(mouseY), mouseButton);
                    break;
                }
                if (!this.editing) break;
                this.finishEditing(true);
                break;
            }
            case 1: {
                if (this.editing) {
                    this.finishEditing(false);
                }
                this.setting.resetToDefault();
                this.inlineField.method_1852(this.setting.getValue());
            }
        }
    }

    private void startEditing() {
        this.editing = true;
        this.originalValue = this.setting.getValue();
        this.inlineField.method_1852(this.originalValue);
        this.inlineField.method_1888(true);
        this.inlineField.method_25365(true);
        this.moveCaretToEnd();
        GUI.requestKeyboardInput(this);
    }

    private void moveCaretToEnd() {
        int end = this.inlineField.method_1882().length();
        this.inlineField.method_1875(end);
        this.inlineField.method_1884(end);
    }

    private void finishEditing(boolean apply) {
        if (!this.editing) {
            return;
        }
        if (apply) {
            this.setting.setValue(this.inlineField.method_1882());
        } else {
            this.inlineField.method_1852(this.originalValue);
        }
        this.inlineField.method_1888(false);
        this.inlineField.method_25365(false);
        this.editing = false;
        GUI.releaseKeyboardInput(this);
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float partialTicks) {
        boolean hBox;
        this.updateInlineFieldBounds();
        if (!this.editing) {
            this.inlineField.method_1852(this.setting.getValue());
        }
        float[] bgColor = GUI.getBgColor();
        float opacity = GUI.getOpacity();
        int x1 = this.getX();
        int x2 = x1 + this.getWidth();
        int y1 = this.getY();
        int y2 = y1 + this.getHeight();
        int boxY1 = y1 + 11;
        boolean hovering = this.isHovering(mouseX, mouseY);
        boolean hText = hovering && mouseY < boxY1;
        boolean bl = hBox = hovering && mouseY >= boxY1;
        if (hText) {
            GUI.setTooltip(ChatUtils.wrapText(this.setting.getDescription(), 200));
        } else if (hBox && !this.editing) {
            GUI.setTooltip(ChatUtils.wrapText(this.setting.getValue(), 200));
        }
        context.method_25294(x1, y1, x2, boxY1, RenderUtils.toIntColor(bgColor, opacity));
        context.method_25294(x1, boxY1, x2, y2, RenderUtils.toIntColor(bgColor, opacity * (hBox ? 1.5f : 1.0f)));
        RenderUtils.drawBorder2D(context, x1, boxY1, x2, y2, RenderUtils.toIntColor(GUI.getAcColor(), 0.5f));
        int txtColor = GUI.getTxtColor();
        context.field_59826.method_71067();
        context.method_51433(TR, this.setting.getName(), x1, y1 + 2, txtColor, false);
        this.inlineField.method_1868(txtColor);
        this.inlineField.method_1860(txtColor);
        this.inlineField.method_25394(context, this.toAbsoluteMouseX(mouseX), this.toAbsoluteMouseY(mouseY), partialTicks);
    }

    private void updateInlineFieldBounds() {
        this.inlineField.method_46421(this.getX() + 2);
        this.inlineField.method_46419(this.getY() + 11 + 2);
        this.inlineField.method_25358(Math.max(0, this.getWidth() - 4));
        this.inlineField.method_53533(Math.max(0, this.getHeight() - 11 - 4));
    }

    private int toAbsoluteMouseX(double mouseX) {
        Window parent = this.getParent();
        return parent == null ? (int)Math.round(mouseX) : (int)Math.round(mouseX + (double)parent.getX());
    }

    private int toAbsoluteMouseY(double mouseY) {
        Window parent = this.getParent();
        if (parent == null) {
            return (int)Math.round(mouseY);
        }
        return (int)Math.round(mouseY + (double)parent.getY() + 13.0 + (double)parent.getScrollOffset());
    }

    @Override
    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.editing) {
            return false;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.finishEditing(true);
            return true;
        }
        if (keyCode == 256) {
            this.finishEditing(false);
            return true;
        }
        return this.inlineField.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean onCharTyped(char chr, int modifiers) {
        return this.editing && this.inlineField.method_25400(chr, modifiers);
    }

    @Override
    public void onKeyboardFocusLost() {
        this.finishEditing(true);
    }

    @Override
    public int getDefaultWidth() {
        return TR.method_1727(this.setting.getName()) + 4;
    }

    @Override
    public int getDefaultHeight() {
        return 22;
    }
}

