/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui.screens;

import java.lang.invoke.CallSite;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2281;
import net.minecraft.class_2336;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_3708;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import net.minecraft.class_8168;
import net.wurstclient.WurstClient;
import net.wurstclient.chestsearch.ChestEntry;
import net.wurstclient.chestsearch.ChestManager;
import net.wurstclient.chestsearch.TargetHighlighter;
import net.wurstclient.hacks.ChestSearchHack;
import net.wurstclient.hacks.WaypointsHack;
import net.wurstclient.util.ItemNameUtils;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.waypoints.Waypoint;
import net.wurstclient.waypoints.WaypointDimension;

public final class ChestSearchScreen
extends class_437 {
    private final class_437 prev;
    private ChestManager chestManager = new ChestManager();
    private String screenTitle = "Chest Search";
    private class_342 searchField;
    private List<ChestEntry> results = new ArrayList<ChestEntry>();
    private final List<class_4185> rowButtons = new ArrayList<class_4185>();
    private int totalChestsLogged = 0;
    private long totalItemsLogged = 0L;
    private long totalMatchingItems = 0L;
    private int totalMatches = 0;
    private boolean radiusFilterActive = false;
    private int radiusLimitBlocks = Integer.MAX_VALUE;
    private int radiusFilteredOut = 0;
    private boolean limitedResults = false;
    private double scrollOffset = 0.0;
    private class_4185 scrollUpButton;
    private class_4185 scrollDownButton;
    private boolean draggingScrollbar = false;
    private double scrollbarDragStartY = 0.0;
    private double scrollbarStartOffset = 0.0;
    private int scrollTrackTop = 0;
    private int scrollTrackBottom = 0;
    private int scrollTrackX = 0;
    private int scrollTrackWidth = 0;
    private int scrollThumbTop = 0;
    private int scrollThumbHeight = 0;
    private double scrollMaxOffset = 0.0;
    private static final Map<String, TempWp> TEMP_WP_BY_POS = new HashMap<String, TempWp>();
    private final Map<ChestEntry, List<ChestEntry.ItemEntry>> matchCache = new HashMap<ChestEntry, List<ChestEntry.ItemEntry>>();
    private String lastMatchQuery = "";
    private String currentQuery = "";
    private final boolean openedByKeybind;
    private boolean ignoreNextSearchChange = false;

    private static String normalizeDimension(String dimension) {
        return dimension == null ? "" : dimension;
    }

    private static String canonicalDimension(String dimension) {
        String dim = ChestSearchScreen.normalizeDimension(dimension).trim();
        if (dim.isEmpty()) {
            return "";
        }
        String lower = dim.toLowerCase(Locale.ROOT);
        int colon = lower.indexOf(58);
        if (colon >= 0 && colon < lower.length() - 1) {
            return lower.substring(colon + 1);
        }
        return lower;
    }

    private static String makePosKey(String dimension, class_2338 pos) {
        String dim = ChestSearchScreen.normalizeDimension(dimension);
        return pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260() + ":" + dim;
    }

    private static String formatBlockPos(class_2338 pos) {
        if (pos == null) {
            return "null";
        }
        return pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260();
    }

    private static String makeEntryKey(ChestEntry entry) {
        if (entry == null) {
            return "";
        }
        String server = entry.serverIp == null ? "" : entry.serverIp;
        String dim = ChestSearchScreen.normalizeDimension(entry.dimension);
        class_2338 min = entry.getMinPos();
        class_2338 max = entry.getMaxPos();
        return server + "|" + dim + "|" + ChestSearchScreen.formatBlockPos(min) + ">" + ChestSearchScreen.formatBlockPos(max);
    }

    public static boolean isWaypointActive(String dimension, class_2338 pos) {
        String key = ChestSearchScreen.makePosKey(dimension, pos);
        TempWp twp = TEMP_WP_BY_POS.get(key);
        if (twp == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (twp.expiresAtMs > 0L && now >= twp.expiresAtMs) {
            TEMP_WP_BY_POS.remove(key);
            try {
                WaypointsHack wh = WurstClient.INSTANCE.getHax().waypointsHack;
                if (wh != null) {
                    wh.removeTemporaryWaypoint(twp.id);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static boolean isEspActive(String dimension, class_2338 pos) {
        return TargetHighlighter.INSTANCE.has(ChestSearchScreen.normalizeDimension(dimension), pos);
    }

    public static boolean isPinned(String dimension, class_2338 pos) {
        return ChestSearchScreen.isWaypointActive(dimension, pos) || ChestSearchScreen.isEspActive(dimension, pos);
    }

    public static boolean clearDecorations(String dimension, class_2338 pos) {
        boolean cleared;
        boolean clearedEsp = TargetHighlighter.INSTANCE.clear(ChestSearchScreen.normalizeDimension(dimension), pos);
        boolean clearedWp = ChestSearchScreen.clearWaypoint(dimension, pos);
        boolean bl = cleared = clearedEsp || clearedWp;
        if (cleared && WurstClient.MC != null) {
            try {
                WurstClient.MC.execute(() -> {
                    class_437 patt0$temp = WurstClient.MC.field_1755;
                    if (patt0$temp instanceof ChestSearchScreen) {
                        ChestSearchScreen screen = (ChestSearchScreen)patt0$temp;
                        screen.refreshPins();
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cleared;
    }

    private static boolean clearWaypoint(String dimension, class_2338 pos) {
        String key = ChestSearchScreen.makePosKey(dimension, pos);
        TempWp twp = TEMP_WP_BY_POS.remove(key);
        if (twp == null) {
            return false;
        }
        try {
            WaypointsHack hack = WurstClient.INSTANCE.getHax().waypointsHack;
            if (hack != null) {
                hack.removeTemporaryWaypoint(twp.id);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public ChestSearchScreen(class_437 prev, Object ignored) {
        super((class_2561)class_2561.method_43470((String)"Chest Search"));
        this.prev = prev;
        this.openedByKeybind = ignored instanceof Boolean && (Boolean)ignored != false;
    }

    public ChestSearchScreen(class_437 prev, ChestManager manager, boolean openedByKeybind) {
        super((class_2561)class_2561.method_43470((String)"Chest Search"));
        this.prev = prev;
        this.chestManager = manager == null ? new ChestManager() : manager;
        this.openedByKeybind = openedByKeybind;
        try {
            if (this.chestManager != null && this.chestManager.getClass().getName().equals("net.wurstclient.lootsearch.LootChestManager")) {
                this.screenTitle = "Loot Search";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void method_25426() {
        int mid = this.field_22789 / 2;
        int controlsY = 18;
        this.searchField = new class_342(this.field_22793, mid - 150, controlsY, 220, 20, (class_2561)class_2561.method_43470((String)"Search"));
        this.searchField.method_1862(true);
        this.searchField.method_1888(true);
        this.method_37063((class_364)this.searchField);
        this.searchField.method_1863(this::onSearchChanged);
        this.searchField.method_1890(s -> true);
        this.searchField.method_1880(100);
        this.searchField.method_25355((class_2561)class_2561.method_43470((String)"Type item name or id, e.g. minecraft:stone"));
        if (!this.openedByKeybind) {
            this.method_48265((class_364)this.searchField);
            this.searchField.method_25365(true);
        }
        if (this.openedByKeybind) {
            this.searchField.method_1852("");
            this.ignoreNextSearchChange = true;
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Search"), b -> {
            this.onSearchChanged(this.searchField.method_1882());
            this.rebuildRowButtons();
        }).method_46434(mid + 80, controlsY, 70, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), b -> this.field_22787.method_1507(this.prev)).method_46434(mid - 150, this.field_22790 - 28, 300, 20).method_46431());
        this.scrollOffset = 0.0;
        this.draggingScrollbar = false;
        this.onSearchChanged("");
        this.rebuildRowButtons();
        this.scrollUpButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25b2\u25b2"), b -> {
            this.scrollOffset = 0.0;
            this.clampScroll();
            this.rebuildRowButtons();
        }).method_46434(0, 0, 20, 16).method_46431());
        this.scrollDownButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25bc\u25bc"), b -> {
            this.scrollOffset = this.scrollMaxOffset;
            this.clampScroll();
            this.rebuildRowButtons();
        }).method_46434(0, 0, 20, 16).method_46431());
        this.scrollUpButton.field_22764 = false;
        this.scrollDownButton.field_22764 = false;
    }

    private void onSearchChanged(String q) {
        ArrayList<ChestEntry> raw;
        String qq;
        if (this.ignoreNextSearchChange) {
            this.ignoreNextSearchChange = false;
            if (q != null && q.length() <= 1) {
                this.searchField.method_1852("");
                q = "";
            }
        }
        this.currentQuery = qq = (q == null ? "" : q).trim();
        this.lastMatchQuery = qq.toLowerCase(Locale.ROOT);
        this.matchCache.clear();
        if (this.chestManager == null) {
            this.chestManager = new ChestManager();
        }
        ArrayList<ChestEntry> arrayList = raw = qq.isEmpty() ? new ArrayList<ChestEntry>(this.chestManager.all()) : new ArrayList<ChestEntry>(this.chestManager.search(qq));
        if (qq.isEmpty()) {
            for (ChestEntry chestEntry : this.chestManager.all()) {
                class_2338 pos = chestEntry.getClickedPos();
                if (!ChestSearchScreen.isPinned(chestEntry.dimension, pos)) continue;
                raw.add(chestEntry);
            }
        }
        LinkedHashMap<Object, ChestEntry> dedup = new LinkedHashMap<Object, ChestEntry>();
        for (ChestEntry e : raw) {
            String key = ChestSearchScreen.makeEntryKey(e);
            ChestEntry existing = (ChestEntry)dedup.get(key);
            if (existing != null && ChestSearchScreen.extractLastSeenOrder(e) <= ChestSearchScreen.extractLastSeenOrder(existing)) continue;
            dedup.put(key, e);
        }
        List<ChestEntry> list = this.chestManager.all();
        LinkedHashMap<Object, ChestEntry> canonicalAll = new LinkedHashMap<Object, ChestEntry>();
        for (ChestEntry entry : list) {
            Object key;
            ChestEntry existing;
            if (entry == null || (existing = (ChestEntry)canonicalAll.get(key = ChestSearchScreen.makeEntryKey(entry))) != null && ChestSearchScreen.extractLastSeenOrder(entry) <= ChestSearchScreen.extractLastSeenOrder(existing)) continue;
            canonicalAll.put(key, entry);
        }
        this.totalChestsLogged = canonicalAll.size();
        long totalItems = 0L;
        for (ChestEntry entry : canonicalAll.values()) {
            if (entry.items == null) continue;
            for (ChestEntry.ItemEntry item : entry.items) {
                totalItems += item != null ? (long)item.count : 0L;
            }
        }
        this.totalItemsLogged = totalItems;
        ArrayList working = new ArrayList(dedup.values());
        boolean isLootManager = false;
        try {
            isLootManager = this.chestManager != null && this.chestManager.getClass().getName().equals("net.wurstclient.lootsearch.LootChestManager");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (isLootManager) {
            class_310 mc = WurstClient.MC;
            class_243 playerPos = null;
            Object playerDim = "";
            if (mc != null && mc.field_1724 != null) {
                playerPos = new class_243(mc.field_1724.method_23317(), mc.field_1724.method_23318(), mc.field_1724.method_23321());
                try {
                    if (mc.field_1687 != null) {
                        playerDim = mc.field_1687.method_27983().method_29177().toString();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            class_243 pPos = playerPos;
            String pDimKey = ChestSearchScreen.canonicalDimension((String)playerDim);
            Comparator distComp = (a, b) -> {
                String bDim;
                if (a == null && b == null) {
                    return 0;
                }
                if (a == null) {
                    return 1;
                }
                if (b == null) {
                    return -1;
                }
                String aDim = ChestSearchScreen.canonicalDimension(a.dimension);
                if (!aDim.equals(bDim = ChestSearchScreen.canonicalDimension(b.dimension))) {
                    if (aDim.equals(pDimKey)) {
                        return -1;
                    }
                    if (bDim.equals(pDimKey)) {
                        return 1;
                    }
                    return aDim.compareTo(bDim);
                }
                if (pPos == null) {
                    return 0;
                }
                double da = class_243.method_24953((class_2382)a.getClickedPos()).method_1025(pPos);
                double db = class_243.method_24953((class_2382)b.getClickedPos()).method_1025(pPos);
                return Double.compare(da, db);
            };
            working.sort(distComp);
        } else {
            Comparator<ChestEntry> recencyComparator = Comparator.comparingLong(ChestSearchScreen::extractLastSeenOrder).reversed();
            working.sort(recencyComparator);
        }
        ArrayList<ChestEntry> pinned = new ArrayList<ChestEntry>();
        ArrayList<ChestEntry> others = new ArrayList<ChestEntry>();
        for (ChestEntry e : working) {
            class_2338 pos = e.getClickedPos();
            if (ChestSearchScreen.isPinned(e.dimension, pos)) {
                pinned.add(e);
                continue;
            }
            others.add(e);
        }
        ArrayList<ChestEntry> ordered = new ArrayList<ChestEntry>();
        ordered.addAll(pinned);
        ordered.addAll(others);
        this.results = this.applyRadiusFilter(ordered);
        this.totalMatches = this.results.size();
        boolean shouldLimit = qq.isEmpty();
        if (shouldLimit) {
            int maxResults = 50;
            try {
                maxResults = WurstClient.INSTANCE.getHax().chestSearchHack.getMaxSearchResults();
            }
            catch (Throwable distComp) {
                // empty catch block
            }
            boolean bl = this.limitedResults = this.results.size() > maxResults;
            if (this.limitedResults) {
                this.results = new ArrayList<ChestEntry>(this.results.subList(0, maxResults));
            }
        } else {
            this.limitedResults = false;
        }
        this.totalMatchingItems = 0L;
        for (ChestEntry entry : this.results) {
            for (ChestEntry.ItemEntry item : this.collectMatches(entry, qq)) {
                if (item == null) continue;
                this.totalMatchingItems += (long)item.count;
            }
        }
        this.clampScroll();
        this.rebuildRowButtons();
    }

    private static long extractLastSeenOrder(ChestEntry entry) {
        if (entry == null || entry.lastSeen == null) {
            return Long.MIN_VALUE;
        }
        try {
            return Instant.parse(entry.lastSeen).toEpochMilli();
        }
        catch (DateTimeParseException e) {}
        finally {
            return Long.MIN_VALUE;
        }
    }

    private List<ChestEntry> applyRadiusFilter(List<ChestEntry> entries) {
        ChestSearchHack hack;
        this.radiusFilterActive = false;
        this.radiusFilteredOut = 0;
        this.radiusLimitBlocks = Integer.MAX_VALUE;
        if (entries == null || entries.isEmpty()) {
            return entries;
        }
        class_310 mc = WurstClient.MC;
        if (mc == null || mc.field_1724 == null) {
            return entries;
        }
        try {
            if (this.chestManager != null && this.chestManager.getClass().getName().equals("net.wurstclient.lootsearch.LootChestManager")) {
                return entries;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            hack = WurstClient.INSTANCE.getHax().chestSearchHack;
        }
        catch (Throwable ignored) {
            hack = null;
        }
        if (hack == null || hack.isDisplayRadiusUnlimited()) {
            return entries;
        }
        int radiusBlocks = hack.getDisplayRadius();
        if (radiusBlocks <= 0 || radiusBlocks >= Integer.MAX_VALUE) {
            return entries;
        }
        this.radiusFilterActive = true;
        this.radiusLimitBlocks = radiusBlocks;
        double radiusSq = (double)radiusBlocks * (double)radiusBlocks;
        class_243 playerPos = new class_243(mc.field_1724.method_23317(), mc.field_1724.method_23318(), mc.field_1724.method_23321());
        String playerDim = "";
        try {
            if (mc.field_1687 != null) {
                playerDim = mc.field_1687.method_27983().method_29177().toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String playerDimKey = ChestSearchScreen.canonicalDimension(playerDim);
        ArrayList<ChestEntry> filtered = new ArrayList<ChestEntry>(entries.size());
        int filteredOut = 0;
        for (ChestEntry entry : entries) {
            class_2338 pos;
            class_243 chestPos;
            if (entry == null) continue;
            boolean include = true;
            String entryDimKey = ChestSearchScreen.canonicalDimension(entry.dimension);
            if (!(entryDimKey.isEmpty() || playerDimKey.isEmpty() || entryDimKey.equals(playerDimKey))) {
                include = false;
            }
            if (include && (chestPos = class_243.method_24953((class_2382)(pos = entry.getClickedPos()))).method_1025(playerPos) > radiusSq) {
                include = false;
            }
            if (include) {
                filtered.add(entry);
                continue;
            }
            ++filteredOut;
        }
        this.radiusFilteredOut = filteredOut;
        return filtered;
    }

    private void rebuildRowButtons() {
        for (class_4185 btn : this.rowButtons) {
            this.method_37066((class_364)btn);
        }
        this.rowButtons.clear();
        int x = this.field_22789 / 2 - 150;
        int resultsTop = this.getResultsTop();
        int y = resultsTop - (int)Math.round(this.scrollOffset);
        int visibleTop = resultsTop;
        int visibleBottom = this.getVisibleBottom();
        for (ChestEntry e : this.results) {
            boolean rowVisible;
            boolean hasWp;
            String dim = ChestSearchScreen.normalizeDimension(e.dimension);
            class_2338 minPos = e.getClickedPos();
            boolean waypointActive = ChestSearchScreen.isWaypointActive(dim, minPos);
            boolean espActive = ChestSearchScreen.isEspActive(dim, minPos);
            boolean pinnedEntry = waypointActive || espActive;
            String query = this.searchField.method_1882() == null ? "" : this.searchField.method_1882();
            List<ChestEntry.ItemEntry> matches = this.collectMatches(e, query);
            boolean isLootManager = false;
            try {
                isLootManager = this.chestManager != null && this.chestManager.getClass().getName().equals("net.wurstclient.lootsearch.LootChestManager");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int matchLines = matches.isEmpty() ? 1 : matches.size();
            int boxHeight = ChestSearchScreen.computeBoxHeight(pinnedEntry, matchLines);
            if (y + boxHeight < visibleTop) {
                y += boxHeight + 6;
                continue;
            }
            if (y > visibleBottom) break;
            int btnY = y + 6;
            class_5250 espLabel = espActive ? class_2561.method_43470((String)"ESP*").method_27694(style -> style.method_10977(class_124.field_1065)) : class_2561.method_43470((String)"ESP");
            class_4185 espBtn = null;
            if (!isLootManager) {
                espBtn = class_4185.method_46430((class_2561)espLabel, b -> {
                    try {
                        String dimLocal = ChestSearchScreen.normalizeDimension(e.dimension);
                        class_2338 useMin = e.getClickedPos();
                        boolean exists = false;
                        if (WurstClient.MC != null && WurstClient.MC.field_1687 != null) {
                            boolean isLootManagerInner = false;
                            try {
                                isLootManagerInner = this.chestManager != null && this.chestManager.getClass().getName().equals("net.wurstclient.lootsearch.LootChestManager");
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (!isLootManagerInner) {
                                class_638 world = WurstClient.MC.field_1687;
                                class_2680 state = world.method_8320(useMin);
                                boolean container = state != null && (state.method_26204() instanceof class_2281 || state.method_26204() instanceof class_3708 || state.method_26204() instanceof class_2480 || state.method_26204() instanceof class_8168 || state.method_26204() instanceof class_2336);
                                boolean hasBe = world.method_8321(useMin) != null;
                                exists = container && hasBe;
                            } else {
                                exists = true;
                            }
                        }
                        if (!exists) {
                            try {
                                new ChestManager().removeChest(e.serverIp, e.dimension, useMin.method_10263(), useMin.method_10264(), useMin.method_10260());
                            }
                            catch (Throwable isLootManagerInner) {
                                // empty catch block
                            }
                            this.chestManager = new ChestManager();
                            this.onSearchChanged(this.searchField.method_1882());
                            this.field_22787.execute(this::refreshPins);
                            return;
                        }
                        ChestSearchHack hack = WurstClient.INSTANCE.getHax().chestSearchHack;
                        TargetHighlighter.INSTANCE.setColors(hack.getEspFillARGB(), hack.getEspLineARGB());
                        TargetHighlighter.INSTANCE.toggle(dimLocal, useMin, useMin, hack.getEspTimeMs());
                        this.field_22787.execute(this::refreshPins);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }).method_46434(0, btnY, 40, 16).method_46431();
                if (espActive) {
                    espBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"ESP active")));
                }
            }
            int boxRight = x + 340;
            int wpWidth = 56;
            int espWidth = isLootManager ? 0 : 40;
            int deleteWidth = 56;
            int stackWidth = Math.max(Math.max(wpWidth, espWidth), deleteWidth);
            int stackRight = boxRight - 6;
            int stackX = stackRight - stackWidth;
            if (!isLootManager && espBtn != null) {
                espBtn.method_48229(stackX + (stackWidth - espWidth) / 2, btnY);
                this.method_37063((class_364)espBtn);
                this.rowButtons.add(espBtn);
            }
            class_5250 wpLabel = (hasWp = waypointActive) ? class_2561.method_43470((String)"Remove*").method_27694(style -> style.method_10977(class_124.field_1065)) : class_2561.method_43470((String)"Waypoint");
            class_4185 wpBtn = class_4185.method_46430((class_2561)wpLabel, b -> {
                WaypointsHack wh = WurstClient.INSTANCE.getHax().waypointsHack;
                if (wh != null) {
                    class_2338 wpPos = e.getClickedPos();
                    String posKey = ChestSearchScreen.makePosKey(dim, wpPos);
                    if (TEMP_WP_BY_POS.containsKey(posKey)) {
                        TempWp tmp = TEMP_WP_BY_POS.remove(posKey);
                        UUID id = tmp == null ? null : tmp.id;
                        try {
                            wh.removeTemporaryWaypoint(id);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.field_22787.execute(this::refreshPins);
                        return;
                    }
                    ChestSearchHack hack = WurstClient.INSTANCE.getHax().chestSearchHack;
                    Waypoint w = new Waypoint(UUID.randomUUID(), System.currentTimeMillis());
                    w.setName("Chest: " + minPos.method_10263() + "," + minPos.method_10264() + "," + minPos.method_10260());
                    w.setPos(wpPos);
                    w.setMaxVisible(10000);
                    w.setLines(true);
                    w.setColor(hack.getWaypointColorARGB());
                    WaypointDimension wdim = WaypointDimension.OVERWORLD;
                    if (!dim.isEmpty()) {
                        String p = dim.toLowerCase();
                        if (p.contains("nether")) {
                            wdim = WaypointDimension.NETHER;
                        } else if (p.contains("end")) {
                            wdim = WaypointDimension.END;
                        }
                    }
                    w.setDimension(wdim);
                    UUID id = wh.addTemporaryWaypoint(w);
                    int sleep = hack.getWaypointTimeMs();
                    TEMP_WP_BY_POS.put(posKey, new TempWp(id, System.currentTimeMillis() + (long)sleep));
                    this.field_22787.execute(this::refreshPins);
                    Thread.ofPlatform().start(() -> {
                        try {
                            Thread.sleep(sleep);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            wh.removeTemporaryWaypoint(id);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        TEMP_WP_BY_POS.remove(posKey);
                        this.field_22787.execute(this::refreshPins);
                    });
                }
            }).method_46434(0, btnY, 56, 16).method_46431();
            if (hasWp) {
                wpBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Waypoint active")));
            }
            wpBtn.method_48229(stackX + (stackWidth - wpWidth) / 2, btnY + 18);
            this.method_37063((class_364)wpBtn);
            class_4185 delBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Delete"), b -> {
                try {
                    class_2338 delPos = e.getClickedPos();
                    new ChestManager().removeChest(e.serverIp, e.dimension, delPos.method_10263(), delPos.method_10264(), delPos.method_10260());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.chestManager = new ChestManager();
                this.onSearchChanged(this.searchField.method_1882());
                this.field_22787.execute(this::refreshPins);
            }).method_46434(0, btnY, deleteWidth, 16).method_46431();
            delBtn.method_48229(stackX + (stackWidth - deleteWidth) / 2, btnY + 36);
            boolean bl = rowVisible = btnY >= visibleTop && btnY <= visibleBottom;
            if (!isLootManager && espBtn != null) {
                espBtn.field_22764 = rowVisible;
            }
            wpBtn.field_22764 = rowVisible;
            delBtn.field_22764 = rowVisible;
            if (!isLootManager && espBtn != null) {
                espBtn.field_22763 = rowVisible;
            }
            wpBtn.field_22763 = rowVisible;
            delBtn.field_22763 = rowVisible;
            delBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Delete entry")));
            this.method_37063((class_364)delBtn);
            this.rowButtons.add(delBtn);
            this.rowButtons.add(wpBtn);
            y += boxHeight + 6;
        }
    }

    private int getResultsTop() {
        int sfY = 18;
        int summaryY = sfY + 24;
        return summaryY + 22;
    }

    private int getVisibleBottom() {
        return this.field_22790 - 40;
    }

    private void clampScroll() {
        double maxScroll;
        String query = this.searchField == null ? "" : this.searchField.method_1882();
        int contentHeight = this.calculateContentHeight(query);
        int visibleHeight = Math.max(0, this.getVisibleBottom() - this.getResultsTop());
        this.scrollMaxOffset = maxScroll = (double)Math.max(0, contentHeight - visibleHeight);
        if (this.scrollOffset < 0.0) {
            this.scrollOffset = 0.0;
        } else if (this.scrollOffset > maxScroll) {
            this.scrollOffset = maxScroll;
        }
        if (maxScroll <= 0.0) {
            this.scrollOffset = 0.0;
            this.draggingScrollbar = false;
        }
    }

    private int calculateContentHeight(String query) {
        if (this.results == null || this.results.isEmpty()) {
            return 0;
        }
        int total = 0;
        for (ChestEntry e : this.results) {
            String dim = ChestSearchScreen.normalizeDimension(e.dimension);
            class_2338 chestPos = e.getClickedPos();
            boolean waypointActive = ChestSearchScreen.isWaypointActive(dim, chestPos);
            boolean espActive = ChestSearchScreen.isEspActive(dim, chestPos);
            boolean pinnedEntry = waypointActive || espActive;
            List<ChestEntry.ItemEntry> matches = this.collectMatches(e, query);
            int matchLines = matches.isEmpty() ? 1 : matches.size();
            int boxHeight = ChestSearchScreen.computeBoxHeight(pinnedEntry, matchLines);
            total += boxHeight + 6;
        }
        if (total > 0) {
            total -= 6;
        }
        return total;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (verticalAmount != 0.0 && this.results != null && !this.results.isEmpty()) {
            this.scrollOffset -= verticalAmount * 18.0;
            this.clampScroll();
            this.rebuildRowButtons();
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.scrollMaxOffset > 0.0) {
            if (this.isOverScrollbarThumb(mouseX, mouseY)) {
                this.draggingScrollbar = true;
                this.scrollbarDragStartY = mouseY;
                this.scrollbarStartOffset = this.scrollOffset;
                return true;
            }
            if (this.isOverScrollbarTrack(mouseX, mouseY)) {
                double trackRange = this.scrollTrackBottom - this.scrollTrackTop - this.scrollThumbHeight;
                if (trackRange > 0.0) {
                    double ratio = (mouseY - (double)this.scrollTrackTop - (double)this.scrollThumbHeight / 2.0) / trackRange;
                    this.scrollOffset = Math.max(0.0, Math.min(this.scrollMaxOffset, ratio * this.scrollMaxOffset));
                    this.clampScroll();
                    this.rebuildRowButtons();
                }
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.draggingScrollbar && button == 0 && this.scrollMaxOffset > 0.0) {
            double trackRange = this.scrollTrackBottom - this.scrollTrackTop - this.scrollThumbHeight;
            if (trackRange > 0.0) {
                double delta = mouseY - this.scrollbarDragStartY;
                double ratio = delta / trackRange;
                this.scrollOffset = Math.max(0.0, Math.min(this.scrollMaxOffset, this.scrollbarStartOffset + ratio * this.scrollMaxOffset));
                this.clampScroll();
                this.rebuildRowButtons();
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private boolean isOverScrollbarThumb(double mouseX, double mouseY) {
        return this.scrollMaxOffset > 0.0 && mouseX >= (double)this.scrollTrackX && mouseX <= (double)(this.scrollTrackX + this.scrollTrackWidth) && mouseY >= (double)this.scrollThumbTop && mouseY <= (double)(this.scrollThumbTop + this.scrollThumbHeight);
    }

    private boolean isOverScrollbarTrack(double mouseX, double mouseY) {
        return this.scrollMaxOffset > 0.0 && mouseX >= (double)this.scrollTrackX && mouseX <= (double)(this.scrollTrackX + this.scrollTrackWidth) && mouseY >= (double)this.scrollTrackTop && mouseY <= (double)this.scrollTrackBottom;
    }

    private void refreshPins() {
        if (this.searchField == null) {
            return;
        }
        this.onSearchChanged(this.searchField.method_1882());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int upButtonY;
        int downButtonY;
        int buttonHeight;
        double maxScroll;
        context.method_25294(0, 0, this.field_22789, this.field_22790, -2013265920);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.screenTitle), this.field_22789 / 2, 4, -1);
        int mid = this.field_22789 / 2;
        int sfX = mid - 150;
        int sfY = 18;
        context.method_25294(sfX - 2, sfY - 2, sfX + 222, sfY + 22, -13421773);
        int summaryY = sfY + 24;
        int x = this.field_22789 / 2 - 150;
        int visibleTop = this.getResultsTop();
        int visibleBottom = this.getVisibleBottom();
        int visibleHeight = Math.max(0, visibleBottom - visibleTop);
        String q = this.searchField.method_1882() == null ? "" : this.searchField.method_1882().toLowerCase();
        int contentHeight = this.calculateContentHeight(q);
        float scale = 1.0f;
        try {
            ChestSearchHack hack = WurstClient.INSTANCE.getHax().chestSearchHack;
            if (hack != null) {
                scale = hack.getTextScaleF();
            }
        }
        catch (Throwable hack) {
            // empty catch block
        }
        this.scrollMaxOffset = maxScroll = (double)Math.max(0, contentHeight - visibleHeight);
        if (this.scrollOffset < 0.0) {
            this.scrollOffset = 0.0;
        } else if (this.scrollOffset > maxScroll) {
            this.scrollOffset = maxScroll;
        }
        if (maxScroll <= 0.0) {
            this.draggingScrollbar = false;
        }
        int y = visibleTop - (int)Math.round(this.scrollOffset);
        int trackWidth = 8;
        int trackX = x + 340 + 6;
        int buttonWidth = this.scrollUpButton != null ? this.scrollUpButton.method_25368() : 44;
        int n = buttonHeight = this.scrollUpButton != null ? this.scrollUpButton.method_25364() : 16;
        if (this.scrollDownButton != null) {
            buttonWidth = Math.max(buttonWidth, this.scrollDownButton.method_25368());
            buttonHeight = Math.max(buttonHeight, this.scrollDownButton.method_25364());
        }
        if ((downButtonY = visibleBottom - buttonHeight) < (upButtonY = visibleTop) + buttonHeight) {
            downButtonY = upButtonY + buttonHeight;
        }
        if (this.scrollUpButton != null) {
            this.scrollUpButton.field_22764 = maxScroll > 0.0;
            this.scrollUpButton.field_22763 = maxScroll > 0.0;
            this.scrollUpButton.method_48229(trackX - (buttonWidth - trackWidth) / 2, upButtonY);
        }
        if (this.scrollDownButton != null) {
            this.scrollDownButton.field_22764 = maxScroll > 0.0;
            this.scrollDownButton.field_22763 = maxScroll > 0.0;
            this.scrollDownButton.method_48229(trackX - (buttonWidth - trackWidth) / 2, downButtonY);
        }
        int trackTop = upButtonY + buttonHeight + 4;
        int trackBottom = downButtonY - 4;
        this.scrollTrackX = trackX;
        this.scrollTrackWidth = trackWidth;
        if (maxScroll > 0.0 && trackBottom > trackTop + 1) {
            this.scrollTrackTop = trackTop;
            this.scrollTrackBottom = trackBottom;
            int trackHeight = trackBottom - trackTop;
            int thumbHeight = (int)Math.round((double)visibleHeight / Math.max(1.0, (double)contentHeight) * (double)trackHeight);
            this.scrollThumbHeight = Math.max(12, Math.min(trackHeight, thumbHeight));
            int thumbTravel = trackHeight - this.scrollThumbHeight;
            int thumbOffset = thumbTravel > 0 ? (int)Math.round(this.scrollOffset / maxScroll * (double)thumbTravel) : 0;
            this.scrollThumbTop = trackTop + thumbOffset;
            context.method_25294(trackX, trackTop, trackX + trackWidth, trackBottom, 0x55222222);
            context.method_25294(trackX, this.scrollThumbTop, trackX + trackWidth, this.scrollThumbTop + this.scrollThumbHeight, -5592406);
        } else {
            this.scrollTrackTop = trackTop;
            this.scrollTrackBottom = trackTop;
            this.scrollThumbTop = trackTop;
            this.scrollThumbHeight = 0;
            if (this.scrollUpButton != null) {
                this.scrollUpButton.field_22764 = false;
                this.scrollDownButton.field_22764 = false;
            }
        }
        for (ChestEntry e : this.results) {
            String dim = ChestSearchScreen.normalizeDimension(e.dimension);
            class_2338 minPos = e.getClickedPos();
            boolean waypointActive = ChestSearchScreen.isWaypointActive(dim, minPos);
            boolean espActive = ChestSearchScreen.isEspActive(dim, minPos);
            boolean pinnedEntry = waypointActive || espActive;
            List<ChestEntry.ItemEntry> matches = this.collectMatches(e, q);
            int totalCount = 0;
            for (ChestEntry.ItemEntry it : matches) {
                totalCount += it.count;
            }
            int matchLines = matches.isEmpty() ? 1 : matches.size();
            int boxHeight = ChestSearchScreen.computeBoxHeight(pinnedEntry, matchLines);
            if (y + boxHeight < visibleTop) {
                y += boxHeight + 6;
                continue;
            }
            if (y > visibleBottom) break;
            int bgColor = pinnedEntry ? -2143145456 : -2145378272;
            context.method_25294(x - 6, y, x + 340, y + boxHeight, bgColor);
            int headerY = y + 6;
            String locationLabel = this.formatLocationLabel(e, dim);
            int boxRight = x + 340;
            int wpWidth = 56;
            int espWidth = 40;
            int availWidth = boxRight - x - (espWidth + 4 + wpWidth + 12);
            if (availWidth < 50) {
                availWidth = 50;
            }
            if (pinnedEntry) {
                header = "[PINNED] " + locationLabel;
                if (totalCount > 0) {
                    header = header + "  x" + totalCount;
                }
                lines = this.wrapText(header, availWidth, scale);
                for (i = 0; i < lines.size(); ++i) {
                    RenderUtils.drawScaledText(context, this.field_22793, lines.get(i), x, headerY + i * 12, -468890, false, scale);
                }
            } else {
                header = locationLabel + (String)(totalCount > 0 ? "  x" + totalCount : "");
                lines = this.wrapText(header, availWidth, scale);
                for (i = 0; i < lines.size(); ++i) {
                    RenderUtils.drawScaledText(context, this.field_22793, lines.get(i), x, headerY + i * 12, -1, false, scale);
                }
            }
            int headerLines = ChestSearchScreen.headerLineCount(pinnedEntry);
            int lineY = headerY + headerLines * 14;
            lineY += 12;
            if (matches.isEmpty()) {
                String msg = q.isEmpty() ? "No items recorded." : "No items match this search.";
                RenderUtils.drawScaledText(context, this.field_22793, msg, x, lineY + 2, -4473925, false, scale);
                lineY += Math.round(18.0f * scale);
            } else {
                for (ChestEntry.ItemEntry it : matches) {
                    try {
                        class_2960 id = class_2960.method_12829((String)it.itemId);
                        if (id != null) {
                            class_1792 item = (class_1792)class_7923.field_41178.method_63535(id);
                            class_1799 stack = new class_1799((class_1935)item, 1);
                            context.method_51427(stack, x + 2, lineY - 2);
                        }
                    }
                    catch (Throwable id) {
                        // empty catch block
                    }
                    String name = it.displayName != null ? it.displayName : it.itemId;
                    Object extra = "";
                    try {
                        if (it.enchantments != null && !it.enchantments.isEmpty()) {
                            ArrayList<CallSite> human = new ArrayList<CallSite>();
                            for (int ei = 0; ei < it.enchantments.size(); ++ei) {
                                String ench = it.enchantments.get(ei);
                                class_2960 eid = null;
                                try {
                                    eid = class_2960.method_12829((String)ench);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                String path = eid != null ? eid.method_12832() : ItemNameUtils.sanitizePath(ench);
                                String baseName = ItemNameUtils.buildEnchantmentName(eid, path);
                                Object levelText = "";
                                try {
                                    int lvl;
                                    if (it.enchantmentLevels != null && ei < it.enchantmentLevels.size() && (lvl = it.enchantmentLevels.get(ei).intValue()) > 0) {
                                        levelText = " " + class_2561.method_43471((String)("enchantment.level." + lvl)).getString();
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                human.add((CallSite)((Object)(baseName + (String)levelText)));
                            }
                            extra = " [" + String.join((CharSequence)", ", human) + "\u00a7r]";
                        } else if (it.primaryPotion != null && !it.primaryPotion.isBlank()) {
                            class_2960 pid = null;
                            try {
                                pid = class_2960.method_12829((String)it.primaryPotion);
                            }
                            catch (Throwable ei) {
                                // empty catch block
                            }
                            String ppath = pid != null ? pid.method_12832() : ItemNameUtils.sanitizePath(it.primaryPotion);
                            extra = " [" + ItemNameUtils.buildPotionName(pid, ppath) + "\u00a7r]";
                        }
                        if (((String)extra).isEmpty() && it.nbt != null) {
                            String s = it.nbt.toString().toLowerCase(Locale.ROOT);
                            Matcher m = Pattern.compile("([a-z0-9_]+):([a-z0-9_]+)").matcher(s);
                            ArrayList<String> found = new ArrayList<String>();
                            while (m.find() && found.size() < 3) {
                                String part = m.group(2);
                                if (part == null || found.contains(part) || part.equals("nbt") || part.equals("ench") || part.equals("id") || part.equals("item")) continue;
                                found.add(part);
                            }
                            if (!found.isEmpty()) {
                                extra = " [" + String.join((CharSequence)", ", (CharSequence[])found.stream().map(ChestSearchScreen::humanize).toArray(String[]::new)) + "\u00a7r]";
                            }
                        }
                    }
                    catch (Throwable s) {
                        // empty catch block
                    }
                    if (extra != null && !((String)extra).isEmpty()) {
                        String extraContent = ((String)extra).length() > 3 ? ((String)extra).substring(2, ((String)extra).length() - 1) : "";
                        try {
                            extraContent = extraContent.replaceAll("\u00a7.", "");
                        }
                        catch (Throwable m) {
                            // empty catch block
                        }
                        String normExtra = extraContent.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9 ]", "").trim();
                        String normName = (name == null ? "" : name).toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9 ]", "").trim();
                        if (normExtra.equals(normName)) {
                            extra = "";
                        }
                    }
                    String line = name + (String)extra + " x" + it.count + " (slot " + it.slot + ")";
                    RenderUtils.drawScaledText(context, this.field_22793, line, x + 20, lineY + 2, -1052689, false, scale);
                    lineY += Math.max(18, Math.round(18.0f * scale));
                }
            }
            y += boxHeight + 6;
        }
        try {
            context.method_44380();
        }
        catch (Throwable trackHeight) {
            // empty catch block
        }
        super.method_25394(context, mouseX, mouseY, delta);
        int shown = this.results == null ? 0 : this.results.size();
        String limiter = this.limitedResults ? " (showing first " + WurstClient.INSTANCE.getHax().chestSearchHack.getMaxSearchResults() + ")" : "";
        ArrayList<CallSite> summaryExtras = new ArrayList<CallSite>();
        if (this.radiusFilterActive && this.radiusLimitBlocks < Integer.MAX_VALUE) {
            summaryExtras.add((CallSite)((Object)("radius <= " + this.radiusLimitBlocks + " blocks")));
        }
        if (this.radiusFilterActive && this.radiusFilteredOut > 0) {
            summaryExtras.add((CallSite)((Object)(this.radiusFilteredOut + " outside radius")));
        }
        String extra = summaryExtras.isEmpty() ? "" : " (" + String.join((CharSequence)", ", summaryExtras) + ")";
        String matchLabel = this.currentQuery.isEmpty() ? "Listed items" : "Matching items";
        String summary = "Showing " + shown + "/" + this.totalMatches + limiter + extra + " - " + matchLabel + ": " + this.totalMatchingItems + " - Tracking " + this.totalChestsLogged + " chests, " + this.totalItemsLogged + " items";
        int summaryPadding = 8;
        int summaryWidth = this.field_22793.method_1727(summary) + summaryPadding * 2;
        if (summaryWidth > this.field_22789 - 4) {
            summaryWidth = this.field_22789 - 4;
        }
        int summaryHalf = summaryWidth / 2;
        int summaryCenter = this.field_22789 / 2;
        int summaryLeft = Math.max(0, summaryCenter - summaryHalf);
        int summaryRight = Math.min(this.field_22789, summaryCenter + summaryHalf);
        context.method_25294(summaryLeft, summaryY - 2, summaryRight, summaryY + 18, -14540254);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)summary), this.field_22789 / 2, summaryY + 2, -3355444);
        if (shown == 0) {
            String msg = this.totalChestsLogged > 0 ? "No chests match this search. Tracking " + this.totalChestsLogged + " chests with " + this.totalItemsLogged + " items. Matching items: 0." : "No chests recorded yet.";
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)msg), this.field_22789 / 2, this.field_22790 / 2, -5592406);
        }
    }

    private String formatLocationLabel(ChestEntry entry, String dimension) {
        class_2338 min = entry.getMinPos();
        class_2338 max = entry.getMaxPos();
        StringBuilder sb = new StringBuilder();
        if (dimension != null && !dimension.isEmpty()) {
            String dimLabel = dimension;
            int colon = dimLabel.indexOf(58);
            if (colon >= 0 && colon < dimLabel.length() - 1) {
                dimLabel = dimLabel.substring(colon + 1);
            }
            sb.append(dimLabel).append(" @ ");
        }
        sb.append(min.method_10263()).append(",").append(min.method_10264()).append(",").append(min.method_10260());
        if (!min.equals((Object)max)) {
            sb.append(" - ").append(max.method_10263()).append(",").append(max.method_10264()).append(",").append(max.method_10260());
            int sizeX = Math.abs(max.method_10263() - min.method_10263()) + 1;
            int sizeY = Math.abs(max.method_10264() - min.method_10264()) + 1;
            int sizeZ = Math.abs(max.method_10260() - min.method_10260()) + 1;
            sb.append(" size ").append(sizeX).append("x").append(sizeY).append("x").append(sizeZ);
        }
        if (entry.facing != null && !entry.facing.isBlank()) {
            sb.append(" facing ").append(entry.facing);
        }
        return sb.toString();
    }

    private List<ChestEntry.ItemEntry> collectMatches(ChestEntry entry, String query) {
        List<ChestEntry.ItemEntry> cached;
        String q = (query == null ? "" : query.trim()).toLowerCase(Locale.ROOT);
        if (q.equals(this.lastMatchQuery) && (cached = this.matchCache.get(entry)) != null) {
            return cached;
        }
        if (entry.items == null) {
            List<ChestEntry.ItemEntry> empty = Collections.emptyList();
            if (q.equals(this.lastMatchQuery)) {
                this.matchCache.put(entry, empty);
            }
            return empty;
        }
        ArrayList<ChestEntry.ItemEntry> matches = new ArrayList<ChestEntry.ItemEntry>();
        for (ChestEntry.ItemEntry it : entry.items) {
            String n;
            if (it == null) continue;
            boolean matched = false;
            if (q.isEmpty()) {
                matched = true;
            }
            if (!matched && it.itemId != null && it.itemId.toLowerCase(Locale.ROOT).contains(q)) {
                matched = true;
            }
            if (!matched && it.displayName != null && it.displayName.toLowerCase(Locale.ROOT).contains(q)) {
                matched = true;
            }
            if (!matched && it.nbt != null && (n = it.nbt.toString().toLowerCase(Locale.ROOT)).contains(q)) {
                matched = true;
            }
            if (!matched && it.enchantments != null) {
                for (String en : it.enchantments) {
                    if (en == null || !en.toLowerCase(Locale.ROOT).contains(q)) continue;
                    matched = true;
                    break;
                }
            }
            if (!matched && it.potionEffects != null) {
                for (String pe : it.potionEffects) {
                    if (pe == null || !pe.toLowerCase(Locale.ROOT).contains(q)) continue;
                    matched = true;
                    break;
                }
            }
            if (!matched && it.primaryPotion != null && it.primaryPotion.toLowerCase(Locale.ROOT).contains(q)) {
                matched = true;
            }
            if (!matched) continue;
            matches.add(it);
        }
        List<ChestEntry.ItemEntry> immutable = Collections.unmodifiableList(new ArrayList(matches));
        if (q.equals(this.lastMatchQuery)) {
            this.matchCache.put(entry, immutable);
        }
        return immutable;
    }

    private static int headerLineCount(boolean pinnedEntry) {
        return 1;
    }

    private static int computeBoxHeight(boolean pinnedEntry, int matchLines) {
        int headerLines = ChestSearchScreen.headerLineCount(pinnedEntry);
        int effectiveLines = Math.max(1, matchLines);
        int topPadding = 6;
        int bottomPadding = 6;
        int headerHeight = headerLines * 14;
        int lineHeight = 18;
        int base = topPadding + headerHeight + effectiveLines * lineHeight + bottomPadding;
        int minButtonSpace = 3 * lineHeight;
        return Math.max(base, topPadding + headerHeight + minButtonSpace + bottomPadding);
    }

    private List<String> wrapText(String text, int maxWidth, float scale) {
        ArrayList<String> lines = new ArrayList<String>();
        if (text == null || text.isEmpty()) {
            return lines;
        }
        String remaining = text;
        for (int line = 0; line < 2 && !remaining.isEmpty(); ++line) {
            if ((float)this.field_22793.method_1727(remaining) * scale <= (float)maxWidth) {
                lines.add(remaining);
                break;
            }
            int cut = remaining.length();
            while (cut > 0 && (float)this.field_22793.method_1727(remaining.substring(0, cut)) * scale > (float)maxWidth) {
                cut = remaining.lastIndexOf(32, Math.max(0, cut - 1));
            }
            if (cut <= 0) {
                int pos;
                for (pos = 1; pos < remaining.length() && (float)this.field_22793.method_1727(remaining.substring(0, pos)) * scale <= (float)maxWidth; ++pos) {
                }
                lines.add(remaining.substring(0, pos - 1));
                remaining = remaining.substring(pos - 1).trim();
                continue;
            }
            lines.add(remaining.substring(0, cut).trim());
            remaining = remaining.substring(cut).trim();
        }
        return lines.isEmpty() ? List.of("") : lines;
    }

    private static String humanize(String path) {
        if (path == null || path.isEmpty()) {
            return "Unknown";
        }
        String humanized = Arrays.stream(path.split("_")).filter(part -> !part.isEmpty()).map(part -> Character.toUpperCase(part.charAt(0)) + (part.length() > 1 ? part.substring(1) : "")).collect(Collectors.joining(" "));
        return humanized.isEmpty() ? "Unknown" : humanized;
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.clampScroll();
        this.rebuildRowButtons();
    }

    private static final class TempWp {
        final UUID id;
        final long expiresAtMs;

        TempWp(UUID id, long expiresAtMs) {
            this.id = id;
            this.expiresAtMs = expiresAtMs;
        }
    }
}

