/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui.screens;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_642;
import net.wurstclient.clickgui.screens.WaypointEditScreen;
import net.wurstclient.waypoints.Waypoint;
import net.wurstclient.waypoints.WaypointDimension;
import net.wurstclient.waypoints.WaypointsManager;

public final class WaypointsScreen
extends class_437 {
    private final class_437 prev;
    private final WaypointsManager manager;
    private List<Waypoint> cachedList;
    private int listStartY;
    private static final int ROW_HEIGHT = 24;
    private int scroll;
    private int viewportTop;
    private int viewportBottom;
    private boolean draggingScrollbar = false;
    private double scrollbarDragStartY = 0.0;
    private double scrollbarStartScroll = 0.0;
    private int scrollTrackTop = 0;
    private int scrollTrackBottom = 0;
    private int scrollTrackX = 0;
    private int scrollTrackWidth = 0;
    private int scrollThumbTop = 0;
    private int scrollThumbHeight = 0;
    private int scrollMax = 0;
    private WaypointDimension filterDim = null;
    private final ArrayList<RowWidgets> rows = new ArrayList();
    private static final Map<String, Integer> savedScrolls = new HashMap<String, Integer>();

    private void saveScrollState() {
        try {
            String key = this.resolveWorldId() + ":" + (this.filterDim == null ? "ALL" : this.filterDim.name());
            savedScrolls.put(key, this.scroll);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public WaypointsScreen(class_437 prev, WaypointsManager manager) {
        super((class_2561)class_2561.method_43470((String)"Waypoints"));
        this.prev = prev;
        this.manager = manager;
    }

    protected void method_25426() {
        int y = 32;
        int x = this.field_22789 / 2 - 150;
        this.rows.clear();
        if (this.filterDim == null) {
            this.filterDim = this.currentDim();
        }
        int filterBtnWidth = 64;
        int spacing = 8;
        int totalWidth = filterBtnWidth * 3 + spacing * 2;
        int fx = this.field_22789 / 2 - totalWidth / 2;
        int fy = y;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.filterDim == WaypointDimension.OVERWORLD ? "[OW]" : "OW")), b -> {
            this.filterDim = WaypointDimension.OVERWORLD;
            this.field_22787.method_1507((class_437)this);
        }).method_46434(fx, fy, filterBtnWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.filterDim == WaypointDimension.NETHER ? "[Nether]" : "Nether")), b -> {
            this.filterDim = WaypointDimension.NETHER;
            this.field_22787.method_1507((class_437)this);
        }).method_46434(fx + filterBtnWidth + spacing, fy, filterBtnWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.filterDim == WaypointDimension.END ? "[End]" : "End")), b -> {
            this.filterDim = WaypointDimension.END;
            this.field_22787.method_1507((class_437)this);
        }).method_46434(fx + (filterBtnWidth + spacing) * 2, fy, filterBtnWidth, 20).method_46431());
        int createY = y + 24;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Create waypoint"), b -> {
            Waypoint w = new Waypoint(UUID.randomUUID(), System.currentTimeMillis());
            w.setName("New Waypoint");
            if (this.field_22787.field_1724 != null) {
                w.setPos(class_2338.method_49638((class_2374)this.field_22787.field_1724.method_19538()));
            } else {
                w.setPos(class_2338.field_10980);
            }
            w.setDimension(this.currentDim());
            w.setMaxVisible(5000);
            w.setLines(false);
            this.field_22787.method_1507((class_437)new WaypointEditScreen(this, this.manager, w, true));
        }).method_46434(x, createY, 300, 20).method_46431());
        int toolsY = createY + 24;
        int toolGap = 10;
        int toolWidth = (300 - toolGap) / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Import Xaero"), b -> this.importFromXaero()).method_46434(x, toolsY, toolWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Export Xaero"), b -> this.exportToXaero()).method_46434(x + toolWidth + toolGap, toolsY, toolWidth, 20).method_46431());
        y = toolsY + 28;
        this.cachedList = new ArrayList<Waypoint>();
        for (Waypoint w : this.manager.all()) {
            if (this.filterDim != null && w.getDimension() != this.filterDim) continue;
            this.cachedList.add(w);
        }
        this.viewportTop = this.listStartY = y;
        this.viewportBottom = this.field_22790 - 36;
        try {
            String key = this.resolveWorldId() + ":" + (this.filterDim == null ? "ALL" : this.filterDim.name());
            Integer s = savedScrolls.get(key);
            if (s != null) {
                this.scroll = s;
            }
        }
        catch (Exception key) {
            // empty catch block
        }
        for (int i = 0; i < this.cachedList.size(); ++i) {
            Waypoint w;
            w = this.cachedList.get(i);
            int rowY = y + i * 24;
            class_4185 nameBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)w.getName()), b -> this.field_22787.method_1507((class_437)new WaypointEditScreen(this, this.manager, w, false))).method_46434(x, rowY, 140, 20).method_46431());
            class_4185 visBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(w.isVisible() ? "Hide" : "Show")), b -> {
                w.setVisible(!w.isVisible());
                this.manager.addOrUpdate(w);
                this.saveNow();
                this.field_22787.method_1507((class_437)this);
            }).method_46434(x + 145, rowY, 55, 20).method_46431());
            class_4185 delBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Delete"), b -> {
                this.manager.remove(w);
                this.saveNow();
                this.field_22787.method_1507((class_437)this);
            }).method_46434(x + 205, rowY, 55, 20).method_46431());
            class_4185 copyBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Copy"), b -> {
                String s = w.getPos().method_10263() + ", " + w.getPos().method_10264() + ", " + w.getPos().method_10260();
                this.field_22787.field_1774.method_1455(s);
            }).method_46434(x + 265, rowY, 35, 20).method_46431());
            RowWidgets rw = new RowWidgets();
            rw.w = w;
            rw.nameBtn = nameBtn;
            rw.visBtn = visBtn;
            rw.delBtn = delBtn;
            rw.copyBtn = copyBtn;
            this.rows.add(rw);
        }
        int contentHeight = this.rows.size() * 24;
        int maxScroll = Math.max(0, contentHeight - (this.viewportBottom - this.viewportTop));
        this.scroll = Math.max(0, Math.min(this.scroll, maxScroll));
        this.saveScrollState();
        int arrowX = x + 305;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25b2\u25b2"), b -> this.scrollToTop()).method_46434(arrowX + 20, Math.max(0, this.viewportTop - 20), 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25b2"), b -> this.scrollBy(-72)).method_46434(arrowX + 20, this.viewportTop, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25bc"), b -> this.scrollBy(72)).method_46434(arrowX + 20, this.viewportBottom - 20, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25bc\u25bc"), b -> this.scrollToBottom()).method_46434(arrowX + 20, this.viewportBottom, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), b -> this.field_22787.method_1507(this.prev)).method_46434(x, this.field_22790 - 28, 300, 20).method_46431());
    }

    private void scrollBy(int dy) {
        int contentHeight = this.rows.size() * 24;
        int maxScroll = Math.max(0, contentHeight - (this.viewportBottom - this.viewportTop));
        this.scroll = Math.max(0, Math.min(this.scroll + dy, maxScroll));
        this.saveScrollState();
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int step = (int)Math.signum(verticalAmount) * 24 * 2;
        if (step != 0) {
            this.scrollBy(-step);
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.scrollMax > 0) {
            if (this.isOverScrollbarThumb(mouseX, mouseY)) {
                this.draggingScrollbar = true;
                this.scrollbarDragStartY = mouseY;
                this.scrollbarStartScroll = this.scroll;
                return true;
            }
            if (this.isOverScrollbarTrack(mouseX, mouseY)) {
                int trackRange = this.scrollTrackBottom - this.scrollTrackTop - this.scrollThumbHeight;
                if (trackRange > 0) {
                    double ratio = (mouseY - (double)this.scrollTrackTop - (double)this.scrollThumbHeight / 2.0) / (double)trackRange;
                    this.scroll = (int)Math.max(0L, Math.min((long)this.scrollMax, Math.round(ratio * (double)this.scrollMax)));
                    this.saveScrollState();
                    return true;
                }
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.draggingScrollbar && button == 0 && this.scrollMax > 0) {
            int trackRange = this.scrollTrackBottom - this.scrollTrackTop - this.scrollThumbHeight;
            if (trackRange > 0) {
                double delta = mouseY - this.scrollbarDragStartY;
                double ratio = delta / (double)trackRange;
                this.scroll = (int)Math.max(0L, Math.min((long)this.scrollMax, Math.round(this.scrollbarStartScroll + ratio * (double)this.scrollMax)));
                this.saveScrollState();
                return true;
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private boolean isOverScrollbarThumb(double mouseX, double mouseY) {
        return this.scrollMax > 0 && mouseX >= (double)this.scrollTrackX && mouseX <= (double)(this.scrollTrackX + this.scrollTrackWidth) && mouseY >= (double)this.scrollThumbTop && mouseY <= (double)(this.scrollThumbTop + this.scrollThumbHeight);
    }

    private boolean isOverScrollbarTrack(double mouseX, double mouseY) {
        return this.scrollMax > 0 && mouseX >= (double)this.scrollTrackX && mouseX <= (double)(this.scrollTrackX + this.scrollTrackWidth) && mouseY >= (double)this.scrollTrackTop && mouseY <= (double)this.scrollTrackBottom;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, -2013265920);
        int x = this.field_22789 / 2 - 150;
        this.viewportTop = this.listStartY;
        this.viewportBottom = this.field_22790 - 36;
        for (int i = 0; i < this.rows.size(); ++i) {
            RowWidgets rw = this.rows.get(i);
            int rowY = this.listStartY + i * 24 - this.scroll;
            boolean visible = rowY >= this.viewportTop && rowY <= this.viewportBottom - 20;
            rw.nameBtn.method_46419(rowY);
            rw.visBtn.method_46419(rowY);
            rw.delBtn.method_46419(rowY);
            rw.copyBtn.method_46419(rowY);
            rw.nameBtn.field_22764 = visible;
            rw.visBtn.field_22764 = visible;
            rw.delBtn.field_22764 = visible;
            rw.copyBtn.field_22764 = visible;
        }
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_25300(this.field_22787.field_1772, "Waypoints", this.field_22789 / 2, 12, -1);
        int boxLeft = x - 20;
        ArrayList<Waypoint> liveList = new ArrayList<Waypoint>(this.manager.all());
        if (this.filterDim != null) {
            ArrayList<Waypoint> tmp = new ArrayList<Waypoint>();
            for (Waypoint w : liveList) {
                if (w.getDimension() != this.filterDim) continue;
                tmp.add(w);
            }
            liveList = tmp;
        }
        int scissorLeft = boxLeft - 2;
        int scissorTop = this.viewportTop;
        int scissorRight = x + 300 + 20;
        int scissorBottom = this.viewportBottom;
        context.method_44379(scissorLeft, scissorTop, scissorRight, scissorBottom);
        for (RowWidgets rw : this.rows) {
            int rowY;
            if (rw == null || rw.nameBtn == null || !rw.nameBtn.field_22764 || (rowY = rw.nameBtn.method_46427()) + 16 < this.viewportTop || rowY > this.viewportBottom) continue;
            int boxY = rowY + 2;
            int color = rw.w.getColor();
            context.method_25294(boxLeft - 1, boxY - 1, boxLeft + 17, boxY + 17, -13421773);
            context.method_25294(boxLeft, boxY, boxLeft + 16, boxY + 16, color);
        }
        context.method_44380();
        int contentHeight = this.rows.size() * 24;
        int trackWidth = 8;
        int arrowX = x + 305;
        int buttonX = arrowX + 20;
        int buttonWidth = 20;
        int trackX = buttonX + (buttonWidth - trackWidth) / 2;
        int trackTop = this.viewportTop + 24;
        int trackBottom = this.viewportBottom - 24;
        this.scrollMax = Math.max(0, contentHeight - (this.viewportBottom - this.viewportTop));
        if (this.scrollMax > 0 && trackBottom > trackTop + 1) {
            this.scrollTrackTop = trackTop;
            this.scrollTrackBottom = trackBottom;
            this.scrollTrackX = trackX;
            this.scrollTrackWidth = trackWidth;
            int trackHeight = trackBottom - trackTop;
            int thumbHeight = (int)Math.round((double)(this.viewportBottom - this.viewportTop) / Math.max(1.0, (double)contentHeight) * (double)trackHeight);
            this.scrollThumbHeight = Math.max(12, Math.min(trackHeight, thumbHeight));
            int thumbTravel = trackHeight - this.scrollThumbHeight;
            int thumbOffset = thumbTravel > 0 ? (int)Math.round((double)this.scroll / (double)this.scrollMax * (double)thumbTravel) : 0;
            this.scrollThumbTop = trackTop + thumbOffset;
            context.method_25294(trackX, trackTop, trackX + trackWidth, trackBottom, 0x55222222);
            context.method_25294(trackX, this.scrollThumbTop, trackX + trackWidth, this.scrollThumbTop + this.scrollThumbHeight, -5592406);
        } else {
            this.scrollTrackTop = trackTop;
            this.scrollTrackBottom = trackTop;
            this.scrollThumbTop = trackTop;
            this.scrollThumbHeight = 0;
        }
    }

    private WaypointDimension currentDim() {
        String key;
        if (this.field_22787.field_1687 == null) {
            return WaypointDimension.OVERWORLD;
        }
        switch (key = this.field_22787.field_1687.method_27983().method_29177().method_12832()) {
            case "the_nether": {
                return WaypointDimension.NETHER;
            }
            case "the_end": {
                return WaypointDimension.END;
            }
        }
        return WaypointDimension.OVERWORLD;
    }

    private String resolveWorldId() {
        class_642 s = this.field_22787.method_1558();
        if (s != null && s.field_3761 != null && !s.field_3761.isEmpty()) {
            return s.field_3761.replace(':', '_');
        }
        return "singleplayer";
    }

    private void importFromXaero() {
        String worldId = this.resolveWorldId();
        WaypointsManager.XaeroSyncStats stats = this.manager.importFromXaero(worldId);
        if (stats.imported() > 0 || stats.updated() > 0) {
            this.manager.save(worldId);
            this.refreshAfterDataChange();
        }
        this.sendXaeroMessage(this.importSummary(stats));
    }

    private void exportToXaero() {
        String worldId = this.resolveWorldId();
        WaypointsManager.XaeroSyncStats stats = this.manager.exportToXaero(worldId);
        this.sendXaeroMessage(this.exportSummary(stats));
    }

    private void refreshAfterDataChange() {
        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
    }

    private void sendXaeroMessage(String message) {
        if (message == null || message.isBlank() || this.field_22787 == null) {
            return;
        }
        class_5250 text = class_2561.method_43470((String)message);
        if (this.field_22787.field_1724 != null) {
            this.field_22787.field_1724.method_7353((class_2561)text, false);
        } else if (this.field_22787.field_1705 != null) {
            this.field_22787.field_1705.method_1743().method_1812((class_2561)text);
        }
    }

    private String importSummary(WaypointsManager.XaeroSyncStats stats) {
        if (stats.filesTouched().isEmpty() && stats.imported() == 0 && stats.updated() == 0 && stats.skipped() == 0) {
            return "No Xaero waypoint files found for this world.";
        }
        StringBuilder sb = new StringBuilder("Imported from Xaero: ");
        sb.append(stats.imported()).append(" added");
        sb.append(", ").append(stats.updated()).append(" updated");
        if (stats.skipped() > 0) {
            sb.append(" (").append(stats.skipped()).append(" skipped)");
        }
        return sb.toString();
    }

    private String exportSummary(WaypointsManager.XaeroSyncStats stats) {
        StringBuilder sb = new StringBuilder("Exported to Xaero: ");
        if (stats.exported() > 0) {
            sb.append(stats.exported()).append(" waypoints");
        } else {
            sb.append("no waypoints written");
        }
        if (!stats.filesTouched().isEmpty()) {
            sb.append(" -> ").append(stats.filesTouched().get(0));
        }
        if (stats.skipped() > 0) {
            sb.append(" (").append(stats.skipped()).append(" errors)");
        }
        return sb.toString();
    }

    void saveNow() {
        this.manager.save(this.resolveWorldId());
    }

    private void scrollToTop() {
        this.scroll = 0;
        this.saveScrollState();
    }

    private void scrollToBottom() {
        int maxScroll;
        int contentHeight = this.rows.size() * 24;
        this.scroll = maxScroll = Math.max(0, contentHeight - (this.viewportBottom - this.viewportTop));
        this.saveScrollState();
    }

    private static final class RowWidgets {
        Waypoint w;
        class_4185 nameBtn;
        class_4185 visBtn;
        class_4185 delBtn;
        class_4185 copyBtn;

        private RowWidgets() {
        }
    }
}

