/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.WurstRenderLayers;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.BlockListSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.util.BlockUtils;
import net.wurstclient.util.BlockVertexCompiler;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.EasyVertexBuffer;
import net.wurstclient.util.RegionPos;
import net.wurstclient.util.RenderUtils;

@SearchTags(value={"base finder", "factions"})
public final class BaseFinderHack
extends Hack
implements UpdateListener,
RenderListener {
    private final BlockListSetting naturalBlocks = new BlockListSetting("Natural Blocks", "These blocks will be considered part of natural generation.\n\nThey will NOT be highlighted as player bases.", "minecraft:air", "minecraft:cave_air", "minecraft:bubble_column", "minecraft:water", "minecraft:lava", "minecraft:stone", "minecraft:dirt", "minecraft:coarse_dirt", "minecraft:rooted_dirt", "minecraft:podzol", "minecraft:mycelium", "minecraft:grass_block", "minecraft:gravel", "minecraft:clay", "minecraft:sand", "minecraft:red_sand", "minecraft:sandstone", "minecraft:red_sandstone", "minecraft:granite", "minecraft:diorite", "minecraft:andesite", "minecraft:tuff", "minecraft:calcite", "minecraft:smooth_basalt", "minecraft:bedrock", "minecraft:infested_stone", "minecraft:mossy_cobblestone", "minecraft:snow", "minecraft:snow_block", "minecraft:powder_snow", "minecraft:ice", "minecraft:packed_ice", "minecraft:blue_ice", "minecraft:amethyst_block", "minecraft:budding_amethyst", "minecraft:amethyst_cluster", "minecraft:large_amethyst_bud", "minecraft:medium_amethyst_bud", "minecraft:small_amethyst_bud", "minecraft:dripstone_block", "minecraft:pointed_dripstone", "minecraft:glow_lichen", "minecraft:spore_blossom", "minecraft:small_dripleaf", "minecraft:big_dripleaf", "minecraft:cave_vines", "minecraft:cave_vines_plant", "minecraft:moss_block", "minecraft:moss_carpet", "minecraft:azalea", "minecraft:flowering_azalea", "minecraft:azalea_leaves", "minecraft:flowering_azalea_leaves", "minecraft:rooted_dirt", "minecraft:hanging_roots", "minecraft:grass", "minecraft:tall_grass", "minecraft:fern", "minecraft:large_fern", "minecraft:dead_bush", "minecraft:dandelion", "minecraft:poppy", "minecraft:blue_orchid", "minecraft:allium", "minecraft:azure_bluet", "minecraft:red_tulip", "minecraft:orange_tulip", "minecraft:white_tulip", "minecraft:pink_tulip", "minecraft:oxeye_daisy", "minecraft:cornflower", "minecraft:lily_of_the_valley", "minecraft:sunflower", "minecraft:lilac", "minecraft:rose_bush", "minecraft:peony", "minecraft:lily_pad", "minecraft:sweet_berry_bush", "minecraft:leaf_litter", "minecraft:pink_petals", "minecraft:short_dry_grass", "minecraft:tall_dry_grass", "minecraft:wildflowers", "minecraft:bush", "minecraft:cactus_flower", "minecraft:red_mushroom", "minecraft:brown_mushroom", "minecraft:red_mushroom_block", "minecraft:brown_mushroom_block", "minecraft:mushroom_stem", "minecraft:oak_log", "minecraft:oak_leaves", "minecraft:spruce_log", "minecraft:spruce_leaves", "minecraft:birch_log", "minecraft:birch_leaves", "minecraft:jungle_log", "minecraft:jungle_leaves", "minecraft:acacia_log", "minecraft:acacia_leaves", "minecraft:dark_oak_log", "minecraft:dark_oak_leaves", "minecraft:mangrove_log", "minecraft:mangrove_leaves", "minecraft:mangrove_roots", "minecraft:muddy_mangrove_roots", "minecraft:mangrove_propagule", "minecraft:cherry_log", "minecraft:cherry_leaves", "minecraft:bamboo", "minecraft:seagrass", "minecraft:tall_seagrass", "minecraft:kelp", "minecraft:kelp_plant", "minecraft:sea_pickle", "minecraft:sugar_cane", "minecraft:tube_coral_block", "minecraft:brain_coral_block", "minecraft:bubble_coral_block", "minecraft:fire_coral_block", "minecraft:horn_coral_block", "minecraft:tube_coral", "minecraft:brain_coral", "minecraft:bubble_coral", "minecraft:fire_coral", "minecraft:horn_coral", "minecraft:tube_coral_fan", "minecraft:brain_coral_fan", "minecraft:bubble_coral_fan", "minecraft:fire_coral_fan", "minecraft:horn_coral_fan", "minecraft:dead_tube_coral_block", "minecraft:dead_brain_coral_block", "minecraft:dead_bubble_coral_block", "minecraft:dead_fire_coral_block", "minecraft:dead_horn_coral_block", "minecraft:dead_tube_coral", "minecraft:dead_brain_coral", "minecraft:dead_bubble_coral", "minecraft:dead_fire_coral", "minecraft:dead_horn_coral", "minecraft:dead_tube_coral_fan", "minecraft:dead_brain_coral_fan", "minecraft:dead_bubble_coral_fan", "minecraft:dead_fire_coral_fan", "minecraft:dead_horn_coral_fan", "minecraft:wet_sponge", "minecraft:coal_ore", "minecraft:iron_ore", "minecraft:copper_ore", "minecraft:gold_ore", "minecraft:redstone_ore", "minecraft:emerald_ore", "minecraft:diamond_ore", "minecraft:lapis_ore", "minecraft:deepslate", "minecraft:deepslate_coal_ore", "minecraft:deepslate_iron_ore", "minecraft:deepslate_copper_ore", "minecraft:deepslate_gold_ore", "minecraft:deepslate_redstone_ore", "minecraft:deepslate_emerald_ore", "minecraft:deepslate_diamond_ore", "minecraft:deepslate_lapis_ore", "minecraft:suspicious_sand", "minecraft:suspicious_gravel", "minecraft:sculk", "minecraft:sculk_vein", "minecraft:sculk_sensor", "minecraft:sculk_catalyst", "minecraft:sculk_shrieker", "minecraft:netherrack", "minecraft:basalt", "minecraft:blackstone", "minecraft:soul_sand", "minecraft:soul_soil", "minecraft:magma_block", "minecraft:nether_quartz_ore", "minecraft:nether_gold_ore", "minecraft:ancient_debris", "minecraft:glowstone", "minecraft:crimson_nylium", "minecraft:warped_nylium", "minecraft:crimson_stem", "minecraft:warped_stem", "minecraft:crimson_roots", "minecraft:warped_roots", "minecraft:nether_sprouts", "minecraft:shroomlight", "minecraft:weeping_vines", "minecraft:weeping_vines_plant", "minecraft:twisting_vines", "minecraft:twisting_vines_plant", "minecraft:nether_wart_block", "minecraft:warped_wart_block", "minecraft:crimson_fungus", "minecraft:warped_fungus", "minecraft:nether_wart", "minecraft:end_stone", "minecraft:chorus_plant", "minecraft:chorus_flower", "minecraft:pale_oak_log", "minecraft:pale_oak_leaves", "minecraft:pale_moss_block", "minecraft:pale_moss_carpet", "minecraft:pale_hanging_moss", "minecraft:open_eyeblossom", "minecraft:closed_eyeblossom", "minecraft:resin_clump", "minecraft:pumpkin", "minecraft:melon", "minecraft:cocoa", "minecraft:trial_spawner", "minecraft:obsidian", "minecraft:crying_obsidian", "minecraft:spawner", "minecraft:vine");
    private final ColorSetting color = new ColorSetting("Color", "Man-made blocks will be highlighted in this color.", Color.RED);
    private ArrayList<String> blockNames;
    private Set<String> naturalExactIds;
    private String[] naturalKeywords;
    private final HashSet<class_2338> matchingBlocks = new HashSet();
    private ArrayList<int[]> vertices = new ArrayList();
    private EasyVertexBuffer vertexBuffer;
    private int messageTimer = 0;
    private int counter;
    private RegionPos lastRegion;

    public BaseFinderHack() {
        super("BaseFinder");
        this.setCategory(Category.RENDER);
        this.addSetting(this.naturalBlocks);
        this.addSetting(this.color);
    }

    @Override
    public String getRenderName() {
        String name = this.getName() + " [";
        name = this.counter >= 10000 ? name + "10000+ blocks" : (this.counter == 1 ? name + "1 block" : (this.counter == 0 ? name + "nothing" : name + this.counter + " blocks"));
        name = name + " found]";
        return name;
    }

    @Override
    protected void onEnable() {
        this.messageTimer = 0;
        this.blockNames = new ArrayList<String>(this.naturalBlocks.getBlockNames());
        this.rebuildNaturalCaches();
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(RenderListener.class, this);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        this.matchingBlocks.clear();
        this.vertices.clear();
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
        }
        this.vertexBuffer = null;
        this.lastRegion = null;
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        RegionPos region = RenderUtils.getCameraRegion();
        if (!region.equals(this.lastRegion)) {
            this.onUpdate();
        }
        if (this.vertexBuffer == null) {
            return;
        }
        matrixStack.method_22903();
        RenderUtils.applyRegionalRenderOffset(matrixStack, region);
        this.vertexBuffer.draw(matrixStack, WurstRenderLayers.ESP_QUADS, this.color.getColorF(), 0.25f);
        matrixStack.method_22909();
    }

    @Override
    public void onUpdate() {
        int modulo = BaseFinderHack.MC.field_1724.field_6012 % 64;
        RegionPos region = RenderUtils.getCameraRegion();
        if (modulo == 0 || !region.equals(this.lastRegion)) {
            if (this.vertexBuffer != null) {
                this.vertexBuffer.close();
            }
            this.vertexBuffer = EasyVertexBuffer.createAndUpload(VertexFormat.class_5596.field_27382, class_290.field_1576, buffer -> {
                for (int[] vertex : this.vertices) {
                    buffer.method_22912((float)(vertex[0] - region.x()), (float)vertex[1], (float)(vertex[2] - region.z())).method_39415(-1);
                }
            });
            this.lastRegion = region;
        }
        if (modulo == 0) {
            this.matchingBlocks.clear();
        }
        int stepSize = BaseFinderHack.MC.field_1687.method_31605() / 64;
        int startY = BaseFinderHack.MC.field_1687.method_31600() - 1 - modulo * stepSize;
        int endY = startY - stepSize;
        class_2338 playerPos = class_2338.method_49637((double)BaseFinderHack.MC.field_1724.method_23317(), (double)0.0, (double)BaseFinderHack.MC.field_1724.method_23321());
        block0: for (int y = startY; y > endY; --y) {
            for (int x = 64; x > -64; --x) {
                for (int z = 64; z > -64; --z) {
                    boolean isNatural;
                    if (this.matchingBlocks.size() >= 10000) break block0;
                    class_2338 pos = new class_2338(playerPos.method_10263() + x, y, playerPos.method_10260() + z);
                    String idFull = BlockUtils.getName(pos);
                    boolean bl = isNatural = this.naturalExactIds != null && this.naturalExactIds.contains(idFull);
                    if (!isNatural && this.naturalKeywords != null && this.naturalKeywords.length > 0) {
                        String localId = idFull.contains(":") ? idFull.substring(idFull.indexOf(":") + 1) : idFull;
                        String localSpaced = localId.replace('_', ' ');
                        class_2248 b = BlockUtils.getBlock(pos);
                        String transKey = b.method_63499();
                        String display = b.method_9518().getString();
                        for (String term : this.naturalKeywords) {
                            if (!BaseFinderHack.containsNormalized(idFull, term) && !BaseFinderHack.containsNormalized(localId, term) && !BaseFinderHack.containsNormalized(localSpaced, term) && !BaseFinderHack.containsNormalized(transKey, term) && !BaseFinderHack.containsNormalized(display, term)) continue;
                            isNatural = true;
                            break;
                        }
                    }
                    if (isNatural) continue;
                    this.matchingBlocks.add(pos);
                }
            }
        }
        if (modulo != 63) {
            return;
        }
        if (this.matchingBlocks.size() < 10000) {
            --this.messageTimer;
        } else {
            if (this.messageTimer <= 0) {
                ChatUtils.warning("BaseFinder found \u00a7lA LOT\u00a7r of blocks.");
                ChatUtils.message("To prevent lag, it will only show the first 10000 blocks.");
            }
            this.messageTimer = 3;
        }
        this.counter = this.matchingBlocks.size();
        this.vertices = BlockVertexCompiler.compile(this.matchingBlocks);
    }

    private void rebuildNaturalCaches() {
        HashSet<String> exact = new HashSet<String>();
        ArrayList<String> kw = new ArrayList<String>();
        for (String s : this.blockNames) {
            class_2960 id = class_2960.method_12829((String)s);
            if (id != null) {
                exact.add(id.toString());
                continue;
            }
            if (s == null || s.isBlank()) continue;
            kw.add(s.toLowerCase(Locale.ROOT));
        }
        this.naturalExactIds = exact;
        this.naturalKeywords = kw.toArray(new String[0]);
    }

    private static boolean containsNormalized(String haystack, String needle) {
        return haystack != null && haystack.toLowerCase(Locale.ROOT).contains(needle);
    }
}

