/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_4587;
import net.wurstclient.Category;
import net.wurstclient.WurstClient;
import net.wurstclient.chestsearch.ChestEntry;
import net.wurstclient.chestsearch.ChestManager;
import net.wurstclient.chestsearch.ChestSearchMarkerRenderer;
import net.wurstclient.events.CameraTransformViewBobbingListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.hacks.ChestSearchHack;
import net.wurstclient.hacks.chestesp.ChestEspGroup;
import net.wurstclient.hacks.chestesp.ChestEspGroupManager;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.EspStyleSetting;
import net.wurstclient.settings.Setting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.chunk.ChunkUtils;

public class ChestEspHack
extends Hack
implements UpdateListener,
CameraTransformViewBobbingListener,
RenderListener {
    private final EspStyleSetting style = new EspStyleSetting();
    private final CheckboxSetting stickyArea = new CheckboxSetting("Sticky area", "Off: ESP drop-off follows you as chunks change.\nOn: Keeps results anchored (useful for pathing back).\nNote: ChestESP tracks loaded block entities; visibility is still limited by server view distance.", false);
    private final ChestEspGroupManager groups = new ChestEspGroupManager();
    private final CheckboxSetting showCountInHackList = new CheckboxSetting("HackList count", "Appends the number of detected chests/containers to this hack's entry in the HackList.", false);
    private int foundCount;
    private final CheckboxSetting onlyAboveGround = new CheckboxSetting("Above ground only", "Only show chests/containers at or above the configured Y level.", false);
    private final SliderSetting aboveGroundY = new SliderSetting("Set ESP Y limit", 62.0, -65.0, 255.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private List<ChestEntry> openedChests = List.of();

    public ChestEspHack() {
        super("ChestESP");
        this.setCategory(Category.RENDER);
        this.addSetting(this.style);
        this.addSetting(this.stickyArea);
        this.groups.allGroups.stream().flatMap(ChestEspGroup::getSettings).forEach(x$0 -> this.addSetting((Setting)x$0));
        this.addSetting(this.onlyAboveGround);
        this.addSetting(this.aboveGroundY);
        this.addSetting(this.showCountInHackList);
    }

    @Override
    protected void onEnable() {
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(CameraTransformViewBobbingListener.class, this);
        EVENTS.add(RenderListener.class, this);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(CameraTransformViewBobbingListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        this.groups.allGroups.forEach(ChestEspGroup::clear);
        this.foundCount = 0;
    }

    @Override
    public void onUpdate() {
        this.groups.allGroups.forEach(ChestEspGroup::clear);
        double yLimit = this.aboveGroundY.getValue();
        boolean enforceAboveGround = this.onlyAboveGround.isChecked();
        ChunkUtils.getLoadedBlockEntities().forEach(be -> {
            if (enforceAboveGround && (double)be.method_11016().method_10264() < yLimit) {
                return;
            }
            this.groups.blockGroups.forEach(group -> group.addIfMatches((class_2586)be));
        });
        if (ChestEspHack.MC.field_1687 != null) {
            for (class_1297 entity : ChestEspHack.MC.field_1687.method_18112()) {
                if (enforceAboveGround && entity.method_23318() < yLimit) continue;
                this.groups.entityGroups.forEach(group -> group.addIfMatches(entity));
            }
        }
        int total = this.groups.allGroups.stream().filter(ChestEspGroup::isEnabled).mapToInt(g -> g.getBoxes().size()).sum();
        this.foundCount = Math.min(total, 999);
        try {
            ChestManager mgr = new ChestManager();
            this.openedChests = mgr.all();
        }
        catch (Throwable ignored) {
            this.openedChests = List.of();
        }
    }

    @Override
    public void onCameraTransformViewBobbing(CameraTransformViewBobbingListener.CameraTransformViewBobbingEvent event) {
        if (this.style.hasLines()) {
            event.cancel();
        }
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        this.groups.entityGroups.stream().filter(ChestEspGroup::isEnabled).forEach(g -> g.updateBoxes(partialTicks));
        if (this.style.hasBoxes()) {
            this.renderBoxes(matrixStack);
        }
        if (this.style.hasLines()) {
            this.renderTracers(matrixStack, partialTicks);
        }
    }

    private void renderBoxes(class_4587 matrixStack) {
        for (ChestEspGroup group : this.groups.allGroups) {
            if (!group.isEnabled()) continue;
            List<class_238> boxes = group.getBoxes();
            int quadsColor = group.getColorI(64);
            int linesColor = group.getColorI(128);
            RenderUtils.drawSolidBoxes(matrixStack, boxes, quadsColor, false);
            RenderUtils.drawOutlinedBoxes(matrixStack, boxes, linesColor, false);
            try {
                ChestSearchHack csh = WurstClient.INSTANCE.getHax().chestSearchHack;
                if (csh == null || !csh.isMarkOpenedChest() || this.openedChests.isEmpty()) continue;
                String curDimFull = ChestEspHack.MC.field_1687 == null ? "overworld" : ChestEspHack.MC.field_1687.method_27983().method_29177().toString();
                String curDim = ChestEspHack.MC.field_1687 == null ? "overworld" : ChestEspHack.MC.field_1687.method_27983().method_29177().method_12832();
                for (class_238 box : boxes) {
                    int boxMinX = (int)Math.floor(box.field_1323 + 1.0E-6);
                    int boxMaxX = (int)Math.floor(box.field_1320 - 1.0E-6);
                    int boxMinY = (int)Math.floor(box.field_1322 + 1.0E-6);
                    int boxMaxY = (int)Math.floor(box.field_1325 - 1.0E-6);
                    int boxMinZ = (int)Math.floor(box.field_1321 + 1.0E-6);
                    int boxMaxZ = (int)Math.floor(box.field_1324 - 1.0E-6);
                    boolean matched = false;
                    for (ChestEntry e : this.openedChests) {
                        String ed;
                        if (e == null || e.dimension == null || !(ed = e.dimension).equals(curDimFull) && !ed.equals(curDim) && !ed.endsWith(":" + curDim)) continue;
                        int minX = Math.min(e.x, e.maxX);
                        int maxX = Math.max(e.x, e.maxX);
                        int minY = Math.min(e.y, e.maxY);
                        int maxY = Math.max(e.y, e.maxY);
                        int minZ = Math.min(e.z, e.maxZ);
                        int maxZ = Math.max(e.z, e.maxZ);
                        boolean overlap = boxMinX <= maxX && boxMaxX >= minX && boxMinY <= maxY && boxMaxY >= minY && boxMinZ <= maxZ && boxMaxZ >= minZ;
                        if (!overlap) continue;
                        matched = true;
                        break;
                    }
                    if (!matched) continue;
                    ChestSearchMarkerRenderer.drawMarker(matrixStack, box, csh.getMarkXColorARGB(), csh.getMarkXThickness(), false);
                }
            }
            catch (Throwable throwable) {
            }
        }
    }

    private void renderTracers(class_4587 matrixStack, float partialTicks) {
        for (ChestEspGroup group : this.groups.allGroups) {
            if (!group.isEnabled()) continue;
            List<class_238> boxes = group.getBoxes();
            List<class_243> ends = boxes.stream().map(class_238::method_1005).toList();
            int color = group.getColorI(128);
            RenderUtils.drawTracers(matrixStack, partialTicks, ends, color, false);
        }
    }

    @Override
    public String getRenderName() {
        String base = this.getName();
        if (this.showCountInHackList.isChecked() && this.foundCount > 0) {
            return base + " [" + this.foundCount + "]";
        }
        return base;
    }
}

