/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.awt.Color;
import net.minecraft.class_437;
import net.wurstclient.Category;
import net.wurstclient.clickgui.screens.ChestSearchScreen;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.EnumSetting;
import net.wurstclient.settings.SliderSetting;

public final class ChestSearchHack
extends Hack {
    private static final int DISPLAY_RADIUS_UNLIMITED = 2001;
    private final EnumSetting<Mode> modeSetting = new EnumSetting("Mode", "Automatic scans instantly, Manual requires pressing the Scan button, and Off disables ChestSearch entirely.", (Enum[])Mode.values(), (Enum)Mode.AUTOMATIC);
    private final SliderSetting waypointTimeSec = new SliderSetting("Waypoint time (s)", 60.0, 5.0, 600.0, 5.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting espTimeSec = new SliderSetting("ESP time (s)", 60.0, 5.0, 600.0, 5.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting gracePeriodSec = new SliderSetting("Cleaner grace (s)", 10.0, 0.0, 60.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting scanRadius = new SliderSetting("Cleaner scan radius", 64.0, 8.0, 512.0, 8.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting maxResults = new SliderSetting("Max search results", 50.0, 10.0, 1000.0, 10.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting displayRadius = new SliderSetting("Display radius", 2001.0, 1.0, 2001.0, 1.0, SliderSetting.ValueDisplay.INTEGER.withSuffix(" blocks").withLabel(2001.0, "Unlimited"));
    private final ColorSetting waypointColor = new ColorSetting("Waypoint color", new Color(0xFFFF00));
    private final ColorSetting espFillColor = new ColorSetting("ESP fill", new Color(0x22FF88));
    private final ColorSetting espLineColor = new ColorSetting("ESP line", new Color(0x22FF88));
    private final ColorSetting markXColor = new ColorSetting("Opened chest color", new Color(0xFF2222));
    private final SliderSetting markXThickness = new SliderSetting("Opened chest line thickness", 2.0, 0.5, 6.0, 0.5, SliderSetting.ValueDisplay.DECIMAL);
    private final CheckboxSetting markOpenedChest = new CheckboxSetting("Mark opened chest", "Draw ESP/lines through opened chests that appear in your ChestSearch database.", true);
    private final SliderSetting textScale = new SliderSetting("Text scale", 1.0, 0.5, 1.25, 0.05, SliderSetting.ValueDisplay.DECIMAL);

    public ChestSearchHack() {
        super("ChestSearch");
        this.setCategory(Category.ITEMS);
        this.addSetting(this.modeSetting);
        this.addSetting(this.waypointTimeSec);
        this.addSetting(this.espTimeSec);
        this.addSetting(this.gracePeriodSec);
        this.addSetting(this.scanRadius);
        this.addSetting(this.maxResults);
        this.addSetting(this.displayRadius);
        this.addSetting(this.textScale);
        this.addSetting(this.waypointColor);
        this.addSetting(this.espFillColor);
        this.addSetting(this.espLineColor);
        this.addSetting(this.markXColor);
        this.addSetting(this.markXThickness);
        this.addSetting(this.markOpenedChest);
    }

    public int getMarkXColorARGB() {
        return 0xFF000000 | this.markXColor.getColor().getRGB() & 0xFFFFFF;
    }

    public double getMarkXThickness() {
        try {
            return this.markXThickness.getValue();
        }
        catch (Throwable t) {
            return 2.0;
        }
    }

    public boolean isMarkOpenedChest() {
        return this.markOpenedChest.isChecked();
    }

    public int getCleanerGraceTicks() {
        return this.gracePeriodSec.getValueI() * 20;
    }

    public int getCleanerScanRadius() {
        return this.scanRadius.getValueI();
    }

    public int getMaxSearchResults() {
        return this.maxResults.getValueI();
    }

    public boolean isDisplayRadiusUnlimited() {
        return this.displayRadius.getValueI() >= 2001;
    }

    public int getDisplayRadius() {
        return this.isDisplayRadiusUnlimited() ? Integer.MAX_VALUE : this.displayRadius.getValueI();
    }

    public int getWaypointTimeMs() {
        return (int)(this.waypointTimeSec.getValue() * 1000.0);
    }

    public boolean isAutomaticMode() {
        return this.getMode() == Mode.AUTOMATIC;
    }

    public boolean isManualMode() {
        return this.getMode() == Mode.MANUAL;
    }

    public boolean isOffMode() {
        return this.getMode() == Mode.OFF;
    }

    public Mode getMode() {
        try {
            Mode mode = this.modeSetting.getSelected();
            return mode != null ? mode : Mode.AUTOMATIC;
        }
        catch (Throwable t) {
            return Mode.AUTOMATIC;
        }
    }

    public int getEspTimeMs() {
        return (int)(this.espTimeSec.getValue() * 1000.0);
    }

    public float getTextScaleF() {
        try {
            return this.textScale.getValueF();
        }
        catch (Throwable t) {
            return 1.0f;
        }
    }

    public int getWaypointColorARGB() {
        return this.waypointColor.getColor().getRGB();
    }

    public int getEspFillARGB() {
        return 0x40000000 | this.espFillColor.getColor().getRGB() & 0xFFFFFF;
    }

    public int getEspLineARGB() {
        return Integer.MIN_VALUE | this.espLineColor.getColor().getRGB() & 0xFFFFFF;
    }

    @Override
    protected void onEnable() {
        try {
            MC.method_1507((class_437)new ChestSearchScreen(ChestSearchHack.MC.field_1755, Boolean.TRUE));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setEnabled(false);
    }

    public static enum Mode {
        AUTOMATIC("Automatic"),
        MANUAL("Manual"),
        OFF("Off");

        private final String displayName;

        private Mode(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

