/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2673;
import net.minecraft.class_2777;
import net.minecraft.class_4587;
import net.wurstclient.Category;
import net.wurstclient.events.PacketInputListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.RotationUtils;

public final class CoordLoggerHack
extends Hack
implements PacketInputListener,
RenderListener {
    private final SliderSetting minDistance = new SliderSetting("Minimum distance", "Minimum distance (in blocks) before logging an event.", 10.0, 0.0, 500.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final CheckboxSetting playerTeleports = new CheckboxSetting("Player teleports", "Log player teleports when they move more than the minimum distance.", true);
    private final CheckboxSetting logAllEntityTeleports = new CheckboxSetting("All entity teleports", "Log teleports of non-player entities.", false);
    private final CheckboxSetting logPortals = new CheckboxSetting("Portals", "Log portal/gateway events.", true);
    private final CheckboxSetting logRedstone = new CheckboxSetting("Redstone/technical", "Log redstone and technical events (dispensers, etc).", false);
    private final CheckboxSetting logMobs = new CheckboxSetting("Mobs", "Log mob-related events (wither, dragon, etc).", true);
    private final CheckboxSetting logMisc = new CheckboxSetting("Misc", "Log miscellaneous ambient/utility events.", true);
    private final CheckboxSetting logUnknown = new CheckboxSetting("Unknown events", "Log events with unknown IDs.", false);
    private final CheckboxSetting onlyGlobal = new CheckboxSetting("Only global events", "Only handle events that are marked global by the server.", false);
    private final CheckboxSetting debugLevelEvents = new CheckboxSetting("Debug level events", "Print debug info for every ClientboundLevelEventPacket (id, pos, global flag, player pos).", false);
    private final CheckboxSetting tracersEnabled = new CheckboxSetting("Draw tracers", "When enabled, draw tracer lines from the player to the event marker.", true);
    private final ColorSetting espColor = new ColorSetting("ESP color", "Color of the ESP boxes and tracers.", new Color(153, 0, 204));
    private static final double NEAR_EVENT_DISTANCE = 128.0;
    private static final double ARROW_LENGTH = 20.0;
    private static final long MARKER_LIFETIME_MS = 60000L;
    private static final double PROXIMITY_RADIUS = 5.0;
    private static final long PROXIMITY_REQUIRED_MS = 10000L;
    private final List<EventMarker> markers = new CopyOnWriteArrayList<EventMarker>();
    private static final Map<Integer, EventCategory> EVENT_CATEGORIES = new HashMap<Integer, EventCategory>();
    private static final Map<Integer, String> EVENT_NAMES = new HashMap<Integer, String>();
    private final Map<Integer, class_243> lastLoggedPos = new ConcurrentHashMap<Integer, class_243>();
    private final Map<Integer, Long> lastLoggedTime = new ConcurrentHashMap<Integer, Long>();
    private static final long TELEPORT_LOG_COOLDOWN_MS = 2000L;

    private static void register(int id, String name, EventCategory category) {
        EVENT_NAMES.put(id, name);
        EVENT_CATEGORIES.put(id, category);
    }

    public CoordLoggerHack() {
        super("CoordLogger");
        this.setCategory(Category.OTHER);
        this.addSetting(this.minDistance);
        this.addSetting(this.playerTeleports);
        this.addSetting(this.logAllEntityTeleports);
        this.addSetting(this.logPortals);
        this.addSetting(this.logRedstone);
        this.addSetting(this.logMobs);
        this.addSetting(this.logMisc);
        this.addSetting(this.logUnknown);
        this.addSetting(this.onlyGlobal);
        this.addSetting(this.debugLevelEvents);
        this.addSetting(this.tracersEnabled);
        this.addSetting(this.espColor);
    }

    @Override
    protected void onEnable() {
        this.markers.clear();
        EVENTS.add(PacketInputListener.class, this);
        EVENTS.add(RenderListener.class, this);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(PacketInputListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        this.markers.clear();
    }

    @Override
    public void onReceivedPacket(PacketInputListener.PacketInputEvent event) {
        try {
            class_2596<?> packet = event.getPacket();
            if (packet instanceof class_2777) {
                class_2777 tp = (class_2777)packet;
                this.handleTeleport(tp);
                return;
            }
            if (packet instanceof class_2673) {
                class_2673 lvl = (class_2673)packet;
                this.handleLevelEvent(lvl);
            }
        }
        catch (Throwable t) {
            String shortMsg = "[CoordLogger] Exception in packet handler: " + t.getClass().getSimpleName() + ": " + t.getMessage();
            if (MC != null) {
                MC.execute(() -> ChatUtils.message(shortMsg));
            } else {
                ChatUtils.message(shortMsg);
            }
            t.printStackTrace();
        }
    }

    private void handleTeleport(class_2777 packet) {
        if (CoordLoggerHack.MC.field_1687 == null) {
            return;
        }
        int entityId = packet.comp_3237();
        if (CoordLoggerHack.MC.field_1724 != null && entityId == CoordLoggerHack.MC.field_1724.method_5628()) {
            return;
        }
        class_1297 entity = CoordLoggerHack.MC.field_1687.method_8469(entityId);
        if (entity == null) {
            return;
        }
        class_243 oldPos = entity.method_19538();
        if (packet.comp_3238() == null || packet.comp_3238().comp_3148() == null) {
            return;
        }
        class_243 newPos = packet.comp_3238().comp_3148();
        double dist = oldPos.method_1022(newPos);
        if (dist < this.minDistance.getValue()) {
            return;
        }
        long now = System.currentTimeMillis();
        Long lastTime = this.lastLoggedTime.get(entityId);
        class_243 lastPos = this.lastLoggedPos.get(entityId);
        if (lastTime != null && now - lastTime < 2000L && lastPos != null && lastPos.method_1022(newPos) < this.minDistance.getValue()) {
            return;
        }
        boolean isPlayer = entity instanceof class_1657;
        if (isPlayer && !this.playerTeleports.isChecked()) {
            return;
        }
        if (!isPlayer && !this.logAllEntityTeleports.isChecked()) {
            return;
        }
        String entityName = entity.method_5477().getString();
        String msg = String.format("[CoordLogger] Teleport: %s (id=%d) -> x=%.1f, y=%.1f, z=%.1f (\u0394=%.1f)", entityName, entity.method_5628(), newPos.field_1352, newPos.field_1351, newPos.field_1350, dist);
        if (MC != null) {
            MC.execute(() -> ChatUtils.message(msg));
        } else {
            ChatUtils.message(msg);
        }
        this.lastLoggedTime.put(entityId, now);
        this.lastLoggedPos.put(entityId, newPos);
    }

    private void handleLevelEvent(class_2673 packet) {
        if (packet == null) {
            return;
        }
        if (this.onlyGlobal.isChecked() && !packet.method_11533()) {
            return;
        }
        class_2338 pos = packet.method_11531();
        if (pos == null) {
            return;
        }
        double dist = this.distanceToPlayer(pos);
        if (dist < this.minDistance.getValue()) {
            return;
        }
        int id = packet.method_11532();
        if (id != 1038 && id != 2003 && id != 1023 && id != 2001) {
            return;
        }
        if (this.debugLevelEvents.isChecked()) {
            class_2338 ppos = packet.method_11531();
            double px = CoordLoggerHack.MC.field_1724 == null ? Double.NaN : CoordLoggerHack.MC.field_1724.method_19538().field_1352;
            double py = CoordLoggerHack.MC.field_1724 == null ? Double.NaN : CoordLoggerHack.MC.field_1724.method_19538().field_1351;
            double pz = CoordLoggerHack.MC.field_1724 == null ? Double.NaN : CoordLoggerHack.MC.field_1724.method_19538().field_1350;
            String dbg = String.format("[CoordLogger:DEBUG] id=%d global=%b pktPos=(%d,%d,%d) player=(%.1f,%.1f,%.1f) dist=%.1f", id, packet.method_11533(), ppos == null ? Integer.MIN_VALUE : ppos.method_10263(), ppos == null ? Integer.MIN_VALUE : ppos.method_10264(), ppos == null ? Integer.MIN_VALUE : ppos.method_10260(), px, py, pz, dist);
            if (MC != null) {
                MC.execute(() -> ChatUtils.message(dbg));
            } else {
                ChatUtils.message(dbg);
            }
        }
        String name = EVENT_NAMES.getOrDefault(id, "UNKNOWN");
        EventCategory cat = EVENT_CATEGORIES.get(id);
        if (cat == null) {
            if (!this.logUnknown.isChecked()) {
                return;
            }
        } else {
            if (cat == EventCategory.PORTALS && !this.logPortals.isChecked()) {
                return;
            }
            if (cat == EventCategory.REDSTONE && !this.logRedstone.isChecked()) {
                return;
            }
            if (cat == EventCategory.MOBS && !this.logMobs.isChecked()) {
                return;
            }
            if (cat == EventCategory.MISC && !this.logMisc.isChecked()) {
                return;
            }
        }
        String catName = cat == null ? "UNKNOWN_CAT" : cat.name();
        String baseMsg = String.format("[CoordLogger] WorldEvent id=%d (%s, %s) at x=%d, y=%d, z=%d (dist=%.1f)", id, name, catName, pos.method_10263(), pos.method_10264(), pos.method_10260(), dist);
        if (MC != null && CoordLoggerHack.MC.field_1724 != null) {
            class_243 eventVec = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
            boolean isFar = dist > 128.0;
            EventMarker em = new EventMarker(eventVec, isFar, id, name, cat);
            this.markers.add(em);
            Object finalMsg = baseMsg;
            if (isFar && MC != null && CoordLoggerHack.MC.field_1724 != null) {
                String dirStr = CoordLoggerHack.getCompassDirection(CoordLoggerHack.MC.field_1724.method_19538(), eventVec);
                finalMsg = baseMsg + " dir=" + dirStr;
            }
            String toSend = finalMsg;
            if (MC != null) {
                MC.execute(() -> ChatUtils.message(toSend));
            } else {
                ChatUtils.message(toSend);
            }
        }
    }

    private double distanceToPlayer(class_2338 pos) {
        if (CoordLoggerHack.MC.field_1724 == null) {
            return 0.0;
        }
        class_243 playerPos = CoordLoggerHack.MC.field_1724.method_19538();
        class_243 eventPos = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        return playerPos.method_1022(eventPos);
    }

    private static String getCompassDirection(class_243 from, class_243 to) {
        double dz = to.field_1350 - from.field_1350;
        double dx = to.field_1352 - from.field_1352;
        double deg = Math.toDegrees(Math.atan2(dz, dx));
        if (deg < 0.0) {
            deg += 360.0;
        }
        int idx = (int)Math.round(deg / 45.0) % 8;
        switch (idx) {
            case 0: {
                return "E";
            }
            case 1: {
                return "NE";
            }
            case 2: {
                return "N";
            }
            case 3: {
                return "NW";
            }
            case 4: {
                return "W";
            }
            case 5: {
                return "SW";
            }
            case 6: {
                return "S";
            }
        }
        return "SE";
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        long now = System.currentTimeMillis();
        float[] col = this.espColor.getColorF();
        int color = RenderUtils.toIntColor(col, 0.9f);
        for (EventMarker m : this.markers) {
            double proxDist;
            class_2338 eventBlock;
            class_2338 playerBlock;
            class_243 markerPos;
            if (now - m.createdAt > 60000L) {
                this.markers.remove(m);
                continue;
            }
            class_243 class_2432 = markerPos = m.far ? RotationUtils.getEyesPos().method_1019(m.eventVec.method_1020(RotationUtils.getEyesPos()).method_1029().method_1021(20.0)) : m.eventVec;
            if (CoordLoggerHack.MC.field_1724 != null && ((playerBlock = new class_2338((int)Math.floor(CoordLoggerHack.MC.field_1724.method_19538().field_1352), (int)Math.floor(CoordLoggerHack.MC.field_1724.method_19538().field_1351), (int)Math.floor(CoordLoggerHack.MC.field_1724.method_19538().field_1350))).equals((Object)(eventBlock = new class_2338((int)Math.floor(m.eventVec.field_1352), (int)Math.floor(m.eventVec.field_1351), (int)Math.floor(m.eventVec.field_1350)))) || CoordLoggerHack.MC.field_1724.method_19538().method_1022(m.eventVec) <= 1.0)) {
                this.markers.remove(m);
                continue;
            }
            double d = proxDist = CoordLoggerHack.MC.field_1724 == null ? Double.POSITIVE_INFINITY : CoordLoggerHack.MC.field_1724.method_19538().method_1022(markerPos);
            if (proxDist <= 5.0) {
                if (m.proximityEnteredAt == 0L) {
                    m.proximityEnteredAt = now;
                } else if (now - m.proximityEnteredAt >= 10000L) {
                    this.markers.remove(m);
                    continue;
                }
            } else {
                m.proximityEnteredAt = 0L;
            }
            if (this.tracersEnabled.isChecked()) {
                RenderUtils.drawTracer(matrixStack, partialTicks, markerPos, color, false);
            }
            class_238 box = new class_238(markerPos.field_1352 - 0.5, markerPos.field_1351 - 0.5, markerPos.field_1350 - 0.5, markerPos.field_1352 + 0.5, markerPos.field_1351 + 0.5, markerPos.field_1350 + 0.5);
            RenderUtils.drawSolidBox(matrixStack, box, color, false);
        }
    }

    static {
        CoordLoggerHack.register(1005, "IRON_DOOR_OPENS", EventCategory.DOORS);
        CoordLoggerHack.register(1011, "IRON_DOOR_CLOSES", EventCategory.DOORS);
        CoordLoggerHack.register(1006, "WOODEN_DOOR_OPENS", EventCategory.DOORS);
        CoordLoggerHack.register(1012, "WOODEN_DOOR_CLOSES", EventCategory.DOORS);
        CoordLoggerHack.register(1007, "WOODEN_TRAPDOOR_OPENS", EventCategory.DOORS);
        CoordLoggerHack.register(1013, "WOODEN_TRAPDOOR_CLOSES", EventCategory.DOORS);
        CoordLoggerHack.register(1008, "FENCE_GATE_OPENS", EventCategory.DOORS);
        CoordLoggerHack.register(1014, "FENCE_GATE_CLOSES", EventCategory.DOORS);
        CoordLoggerHack.register(1032, "TRAVEL_THROUGH_PORTAL", EventCategory.PORTALS);
        CoordLoggerHack.register(1038, "END_PORTAL_OPENED", EventCategory.PORTALS);
        CoordLoggerHack.register(3000, "END_GATEWAY_SPAWNS", EventCategory.PORTALS);
        CoordLoggerHack.register(1503, "END_PORTAL_FRAME_FILLED", EventCategory.PORTALS);
        CoordLoggerHack.register(2000, "DISPENSER_ACTIVATED", EventCategory.REDSTONE);
        CoordLoggerHack.register(1000, "DISPENSER_DISPENSES", EventCategory.REDSTONE);
        CoordLoggerHack.register(1001, "DISPENSER_FAILS", EventCategory.REDSTONE);
        CoordLoggerHack.register(1002, "DISPENSER_LAUNCHES_PROJECTILE", EventCategory.REDSTONE);
        CoordLoggerHack.register(1500, "COMPOSTER_USED", EventCategory.REDSTONE);
        CoordLoggerHack.register(1501, "LAVA_EXTINGUISHED", EventCategory.REDSTONE);
        CoordLoggerHack.register(1502, "REDSTONE_TORCH_BURNS_OUT", EventCategory.REDSTONE);
        CoordLoggerHack.register(1504, "POINTED_DRIPSTONE_DRIPS", EventCategory.REDSTONE);
        CoordLoggerHack.register(1046, "POINTED_DRIPSTONE_DRIPS_LAVA_INTO_CAULDRON", EventCategory.REDSTONE);
        CoordLoggerHack.register(1047, "POINTED_DRIPSTONE_DRIPS_WATER_INTO_CAULDRON", EventCategory.REDSTONE);
        CoordLoggerHack.register(1505, "BONE_MEAL_USED", EventCategory.REDSTONE);
        CoordLoggerHack.register(2003, "EYE_OF_ENDER_BREAKS", EventCategory.REDSTONE);
        CoordLoggerHack.register(1003, "EYE_OF_ENDER_LAUNCHES", EventCategory.REDSTONE);
        CoordLoggerHack.register(2005, "PLANT_FERTILIZED", EventCategory.REDSTONE);
        CoordLoggerHack.register(2006, "DRAGON_BREATH_CLOUD_SPAWNS", EventCategory.REDSTONE);
        CoordLoggerHack.register(2004, "SPAWNER_SPAWNS_MOB", EventCategory.REDSTONE);
        CoordLoggerHack.register(3002, "ELECTRICITY_SPARKS", EventCategory.REDSTONE);
        CoordLoggerHack.register(3003, "BLOCK_WAXED", EventCategory.REDSTONE);
        CoordLoggerHack.register(3004, "WAX_REMOVED", EventCategory.REDSTONE);
        CoordLoggerHack.register(3005, "BLOCK_SCRAPED", EventCategory.REDSTONE);
        CoordLoggerHack.register(1018, "BLAZE_SHOOTS", EventCategory.MOBS);
        CoordLoggerHack.register(1017, "ENDER_DRAGON_SHOOTS", EventCategory.MOBS);
        CoordLoggerHack.register(1016, "GHAST_SHOOTS", EventCategory.MOBS);
        CoordLoggerHack.register(1015, "GHAST_WARNS", EventCategory.MOBS);
        CoordLoggerHack.register(1023, "WITHER_SPAWNS", EventCategory.MOBS);
        CoordLoggerHack.register(1024, "WITHER_SHOOTS", EventCategory.MOBS);
        CoordLoggerHack.register(1022, "WITHER_BREAKS_BLOCK", EventCategory.MOBS);
        CoordLoggerHack.register(1028, "ENDER_DRAGON_DIES", EventCategory.MOBS);
        CoordLoggerHack.register(2008, "ENDER_DRAGON_BREAKS_BLOCK", EventCategory.MOBS);
        CoordLoggerHack.register(3001, "ENDER_DRAGON_RESURRECTED", EventCategory.MOBS);
        CoordLoggerHack.register(1025, "BAT_TAKES_OFF", EventCategory.MOBS);
        CoordLoggerHack.register(1026, "ZOMBIE_INFECTS_VILLAGER", EventCategory.MOBS);
        CoordLoggerHack.register(1027, "ZOMBIE_VILLAGER_CURED", EventCategory.MOBS);
        CoordLoggerHack.register(1019, "ZOMBIE_ATTACKS_WOODEN_DOOR", EventCategory.MOBS);
        CoordLoggerHack.register(1020, "ZOMBIE_ATTACKS_IRON_DOOR", EventCategory.MOBS);
        CoordLoggerHack.register(1021, "ZOMBIE_BREAKS_WOODEN_DOOR", EventCategory.MOBS);
        CoordLoggerHack.register(1040, "ZOMBIE_CONVERTS_TO_DROWNED", EventCategory.MOBS);
        CoordLoggerHack.register(1041, "HUSK_CONVERTS_TO_ZOMBIE", EventCategory.MOBS);
        CoordLoggerHack.register(1048, "SKELETON_CONVERTS_TO_STRAY", EventCategory.MOBS);
        CoordLoggerHack.register(1039, "PHANTOM_BITES", EventCategory.MOBS);
        CoordLoggerHack.register(1029, "ANVIL_DESTROYED", EventCategory.MISC);
        CoordLoggerHack.register(1030, "ANVIL_USED", EventCategory.MISC);
        CoordLoggerHack.register(1031, "ANVIL_LANDS", EventCategory.MISC);
        CoordLoggerHack.register(1033, "CHORUS_FLOWER_GROWS", EventCategory.MISC);
        CoordLoggerHack.register(1034, "CHORUS_FLOWER_DIES", EventCategory.MISC);
        CoordLoggerHack.register(1004, "FIREWORK_ROCKET_SHOOTS", EventCategory.MISC);
        CoordLoggerHack.register(1009, "FIRE_EXTINGUISHED", EventCategory.MISC);
        CoordLoggerHack.register(1504, "POINTED_DRIPSTONE_DRIPS", EventCategory.MISC);
        CoordLoggerHack.register(1045, "POINTED_DRIPSTONE_LANDS", EventCategory.MISC);
        CoordLoggerHack.register(1010, "MUSIC_DISC_PLAYED", EventCategory.MISC);
        CoordLoggerHack.register(1035, "BREWING_STAND_BREWS", EventCategory.MISC);
        CoordLoggerHack.register(1042, "GRINDSTONE_USED", EventCategory.MISC);
        CoordLoggerHack.register(1043, "LECTERN_BOOK_PAGE_TURNED", EventCategory.MISC);
        CoordLoggerHack.register(1044, "SMITHING_TABLE_USED", EventCategory.MISC);
        CoordLoggerHack.register(1505, "BONE_MEAL_USED", EventCategory.MISC);
        CoordLoggerHack.register(1501, "LAVA_EXTINGUISHED", EventCategory.MISC);
        CoordLoggerHack.register(2001, "BLOCK_BROKEN", EventCategory.MISC);
        CoordLoggerHack.register(2002, "SPLASH_POTION_SPLASHED", EventCategory.MISC);
        CoordLoggerHack.register(2007, "INSTANT_SPLASH_POTION_SPLASHED", EventCategory.MISC);
        CoordLoggerHack.register(2009, "WET_SPONGE_DRIES_OUT", EventCategory.MISC);
    }

    private static enum EventCategory {
        DOORS,
        PORTALS,
        REDSTONE,
        MOBS,
        MISC;

    }

    private static final class EventMarker {
        final class_243 eventVec;
        final boolean far;
        final long createdAt;
        long proximityEnteredAt;
        final int id;
        final String name;
        final EventCategory cat;

        EventMarker(class_243 eventVec, boolean far, int id, String name, EventCategory cat) {
            this.eventVec = eventVec;
            this.far = far;
            this.createdAt = System.currentTimeMillis();
            this.proximityEnteredAt = 0L;
            this.id = id;
            this.name = name;
            this.cat = cat;
        }
    }
}

