/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1041;
import net.minecraft.class_10590;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_465;
import net.minecraft.class_6880;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.hack.Hack;
import net.wurstclient.mixin.HandledScreenAccessor;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.ItemUtils;
import net.wurstclient.util.RenderUtils;

@SearchTags(value={"enchantment handler", "gear enchantments", "book enchantments"})
public final class EnchantmentHandlerHack
extends Hack {
    private static final int MIN_BOX_WIDTH = 140;
    private static final int MAX_BOX_WIDTH = 360;
    private static final int PANEL_PADDING = 6;
    private static final int HEADER_MARGIN = 4;
    private static final int ENTRY_MARGIN = 3;
    private static final int TITLE_COLOR = -526345;
    private static final int HEADER_COLOR = -3614465;
    private static final int ENTRY_COLOR = -1184275;
    private static final int ENTRY_HOVER_COLOR = -6231;
    private static final int ACTION_COLOR = -7944705;
    private static final int ACTION_HOVER_COLOR = -4791809;
    private static final long HOVER_SCROLL_DELAY_MS = 400L;
    private static final double HOVER_SCROLL_PAUSE = 32.0;
    private final List<AbstractEntry> allEntries = new ArrayList<AbstractEntry>();
    private final Map<GearCategory, List<GearEntry>> gearGroupedEntries = new LinkedHashMap<GearCategory, List<GearEntry>>();
    private final Map<BookCategory, List<BookEntry>> bookGroupedEntries = new LinkedHashMap<BookCategory, List<BookEntry>>();
    private final Map<PotionCategory, List<PotionEntry>> potionGroupedEntries = new LinkedHashMap<PotionCategory, List<PotionEntry>>();
    private final Map<GearCategory, List<GearEntry>> gearGroupedEntriesPlayer = new LinkedHashMap<GearCategory, List<GearEntry>>();
    private final Map<BookCategory, List<BookEntry>> bookGroupedEntriesPlayer = new LinkedHashMap<BookCategory, List<BookEntry>>();
    private final Map<PotionCategory, List<PotionEntry>> potionGroupedEntriesPlayer = new LinkedHashMap<PotionCategory, List<PotionEntry>>();
    private final Map<GearCategory, List<GearEntry>> gearGroupedEntriesShulker = new LinkedHashMap<GearCategory, List<GearEntry>>();
    private final Map<BookCategory, List<BookEntry>> bookGroupedEntriesShulker = new LinkedHashMap<BookCategory, List<BookEntry>>();
    private final Map<PotionCategory, List<PotionEntry>> potionGroupedEntriesShulker = new LinkedHashMap<PotionCategory, List<PotionEntry>>();
    private final List<Hitbox> hitboxes = new ArrayList<Hitbox>();
    private final SliderSetting boxWidth = new SliderSetting("Box width", 200.0, 140.0, 360.0, 2.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting boxHeight = new SliderSetting("Box height", "Panel height in pixels.\n0 = match the container height.", 0.0, 0.0, 320.0, 2.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting offsetX = new SliderSetting("Horizontal offset", "Moves the panel left/right relative to the container.", 0.0, -300.0, 300.0, 2.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting offsetY = new SliderSetting("Vertical offset", "Moves the panel up/down relative to the container.", 0.0, -200.0, 200.0, 2.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting textScale = new SliderSetting("Text scale", 0.7, 0.5, 1.25, 0.05, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting hoverScrollSpeed = new SliderSetting("Hover scroll speed", "Pixels per second when hovering long entries.", 25.0, 5.0, 80.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final CheckboxSetting includePlayerInventory = new CheckboxSetting("Include player inventory", false);
    private final CheckboxSetting includeShulkerContents = new CheckboxSetting("Include shulker contents", false);
    private double scrollOffset;
    private double maxScroll;
    private int panelX;
    private int panelY;
    private int panelWidth;
    private int panelHeight;
    private boolean lastRenderActive;
    private boolean needsRescan = true;
    private int contentHeight;
    private int hoveredSlotId = -1;
    private long hoverStartMs;

    public EnchantmentHandlerHack() {
        super("EnchantmentHandler");
        this.setCategory(Category.ITEMS);
        this.addSetting(this.boxWidth);
        this.addSetting(this.boxHeight);
        this.addSetting(this.offsetX);
        this.addSetting(this.offsetY);
        this.addSetting(this.textScale);
        this.addSetting(this.hoverScrollSpeed);
        this.addSetting(this.includePlayerInventory);
        this.addSetting(this.includeShulkerContents);
        for (GearCategory gearCategory : GearCategory.ORDERED) {
            this.gearGroupedEntries.put(gearCategory, new ArrayList());
            this.gearGroupedEntriesPlayer.put(gearCategory, new ArrayList());
            this.gearGroupedEntriesShulker.put(gearCategory, new ArrayList());
        }
        for (BookCategory bookCategory : BookCategory.ORDERED) {
            this.bookGroupedEntries.put(bookCategory, new ArrayList());
            this.bookGroupedEntriesPlayer.put(bookCategory, new ArrayList());
            this.bookGroupedEntriesShulker.put(bookCategory, new ArrayList());
        }
        for (PotionCategory potionCategory : PotionCategory.ORDERED) {
            this.potionGroupedEntries.put(potionCategory, new ArrayList());
            this.potionGroupedEntriesPlayer.put(potionCategory, new ArrayList());
            this.potionGroupedEntriesShulker.put(potionCategory, new ArrayList());
        }
    }

    @Override
    protected void onDisable() {
        this.scrollOffset = 0.0;
        this.contentHeight = 0;
        this.maxScroll = 0.0;
        this.lastRenderActive = false;
        this.needsRescan = true;
        this.allEntries.clear();
        this.gearGroupedEntries.values().forEach(List::clear);
        this.bookGroupedEntries.values().forEach(List::clear);
        this.potionGroupedEntries.values().forEach(List::clear);
        this.gearGroupedEntriesPlayer.values().forEach(List::clear);
        this.bookGroupedEntriesPlayer.values().forEach(List::clear);
        this.potionGroupedEntriesPlayer.values().forEach(List::clear);
        this.gearGroupedEntriesShulker.values().forEach(List::clear);
        this.bookGroupedEntriesShulker.values().forEach(List::clear);
        this.potionGroupedEntriesShulker.values().forEach(List::clear);
        this.hitboxes.clear();
        this.hoveredSlotId = -1;
        this.hoverStartMs = 0L;
    }

    public void renderOnHandledScreen(class_465<?> screen, class_332 context, float partialTicks) {
        this.lastRenderActive = false;
        if (EnchantmentHandlerHack.MC.field_1724 == null || EnchantmentHandlerHack.MC.field_1761 == null) {
            return;
        }
        if (this.needsRescan) {
            this.rescan(screen);
        } else {
            this.refreshIfDirty(screen);
        }
        if (this.allEntries.isEmpty()) {
            this.hitboxes.clear();
            this.hoveredSlotId = -1;
            this.hoverStartMs = 0L;
            return;
        }
        HandledScreenAccessor accessor = (HandledScreenAccessor)screen;
        int windowWidth = context.method_51421();
        int windowHeight = context.method_51443();
        this.panelWidth = class_3532.method_15340((int)this.boxWidth.getValueI(), (int)140, (int)Math.min(360, windowWidth - 10));
        int configuredHeight = this.boxHeight.getValueI();
        this.panelHeight = configuredHeight <= 0 ? Math.min(accessor.getBackgroundHeight(), windowHeight - 10) : class_3532.method_15340((int)configuredHeight, (int)60, (int)Math.max(60, windowHeight - 10));
        this.panelY = accessor.getY() + this.offsetY.getValueI();
        this.panelX = accessor.getX() - this.panelWidth - 6 + this.offsetX.getValueI();
        this.panelX = class_3532.method_15340((int)this.panelX, (int)(2 - this.panelWidth), (int)(windowWidth - this.panelWidth - 2));
        this.panelY = class_3532.method_15340((int)this.panelY, (int)2, (int)(windowHeight - this.panelHeight - 2));
        this.renderOverlay(context);
        this.lastRenderActive = true;
    }

    public boolean handleMouseClick(class_465<?> screen, double mouseX, double mouseY, int button) {
        if (!this.lastRenderActive) {
            return false;
        }
        if (button != 0 && button != 1) {
            return this.isInsidePanel(mouseX, mouseY);
        }
        class_1703 handler = screen.method_17577();
        for (Hitbox hitbox : this.hitboxes) {
            Object object;
            if (!hitbox.contains(mouseX, mouseY)) continue;
            if (hitbox.entry != null) {
                BookEntry book;
                if (button == 0) {
                    AbstractEntry abstractEntry = hitbox.entry;
                    if (abstractEntry instanceof GearEntry) {
                        GearEntry gear = (GearEntry)abstractEntry;
                        this.takeEntry(gear, handler);
                    } else {
                        abstractEntry = hitbox.entry;
                        if (abstractEntry instanceof BookEntry) {
                            book = (BookEntry)abstractEntry;
                            this.takeEntry(book, handler);
                        } else {
                            abstractEntry = hitbox.entry;
                            if (abstractEntry instanceof PotionEntry) {
                                PotionEntry potion = (PotionEntry)abstractEntry;
                                this.takeEntry(potion, handler);
                            }
                        }
                    }
                    return true;
                }
                if (button != 1) continue;
                AbstractEntry abstractEntry = hitbox.entry;
                if (abstractEntry instanceof GearEntry) {
                    GearEntry gear = (GearEntry)abstractEntry;
                    this.takeGearCategory(gear.category, handler, hitbox.source);
                } else {
                    abstractEntry = hitbox.entry;
                    if (abstractEntry instanceof BookEntry) {
                        book = (BookEntry)abstractEntry;
                        this.takeBookCategory(book.category, handler, hitbox.source);
                    } else {
                        abstractEntry = hitbox.entry;
                        if (abstractEntry instanceof PotionEntry) {
                            PotionEntry potion = (PotionEntry)abstractEntry;
                            this.takePotionCategory(potion.category, handler, hitbox.source);
                        }
                    }
                }
                return true;
            }
            if (hitbox.categoryKind == CategoryKind.GEAR && (object = hitbox.category) instanceof GearCategory) {
                GearCategory gearCat = (GearCategory)((Object)object);
                this.takeGearCategory(gearCat, handler, hitbox.source);
                return true;
            }
            if (hitbox.categoryKind == CategoryKind.BOOK && (object = hitbox.category) instanceof BookCategory) {
                BookCategory bookCat = (BookCategory)((Object)object);
                this.takeBookCategory(bookCat, handler, hitbox.source);
                return true;
            }
            if (hitbox.categoryKind != CategoryKind.POTION || !((object = hitbox.category) instanceof PotionCategory)) continue;
            PotionCategory potCat = (PotionCategory)((Object)object);
            this.takePotionCategory(potCat, handler, hitbox.source);
            return true;
        }
        return this.isInsidePanel(mouseX, mouseY);
    }

    public boolean handleMouseScroll(class_465<?> screen, double mouseX, double mouseY, double amount) {
        if (!this.lastRenderActive) {
            return false;
        }
        if (!this.isInsidePanel(mouseX, mouseY)) {
            return false;
        }
        if (this.contentHeight <= this.panelInnerHeight()) {
            return true;
        }
        float scale = class_3532.method_15363((float)this.textScale.getValueF(), (float)0.5f, (float)1.25f);
        Objects.requireNonNull(EnchantmentHandlerHack.MC.field_1772);
        int step = Math.max(8, Math.round(9.0f * scale));
        this.scrollOffset = class_3532.method_15350((double)(this.scrollOffset - amount * (double)step), (double)0.0, (double)this.maxScroll);
        return true;
    }

    private boolean isInsidePanel(double mouseX, double mouseY) {
        return mouseX >= (double)this.panelX && mouseX <= (double)(this.panelX + this.panelWidth) && mouseY >= (double)this.panelY && mouseY <= (double)(this.panelY + this.panelHeight);
    }

    private void renderOverlay(class_332 context) {
        this.hitboxes.clear();
        class_327 tr = EnchantmentHandlerHack.MC.field_1772;
        float scale = class_3532.method_15363((float)this.textScale.getValueF(), (float)0.5f, (float)1.25f);
        Objects.requireNonNull(tr);
        int lineHeight = Math.max(1, Math.round(9.0f * scale));
        int headerMargin = Math.max(1, Math.round(4.0f * scale));
        int entryMargin = Math.max(1, Math.round(3.0f * scale));
        context.method_25294(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, -1072689136);
        context.method_25294(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + 1, -14671840);
        context.method_25294(this.panelX, this.panelY + this.panelHeight - 1, this.panelX + this.panelWidth, this.panelY + this.panelHeight, -14671840);
        context.method_25294(this.panelX, this.panelY, this.panelX + 1, this.panelY + this.panelHeight, -14671840);
        context.method_25294(this.panelX + this.panelWidth - 1, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, -14671840);
        int contentTop = this.panelY + 6;
        int titleX = this.panelX + 6;
        int contentBottom = this.panelY + this.panelHeight - 6;
        int innerHeight = contentBottom - contentTop;
        if (innerHeight <= 0) {
            this.contentHeight = 0;
            this.maxScroll = 0.0;
            this.scrollOffset = 0.0;
            return;
        }
        double scaledMouseX = EnchantmentHandlerHack.getScaledMouseX(context);
        double scaledMouseY = EnchantmentHandlerHack.getScaledMouseY(context);
        context.method_44379(this.panelX + 1, contentTop, this.panelX + this.panelWidth - 1, this.panelY + this.panelHeight - 1);
        double cursorY = contentTop;
        double offset = this.scrollOffset;
        boolean[] hoverFlag = new boolean[]{false};
        double textAreaWidth = Math.max(1.0, (double)this.panelWidth - 12.0 - 4.0);
        double hoverSpeed = Math.max(1.0, (double)this.hoverScrollSpeed.getValueI());
        cursorY = this.renderSourceSection(context, tr, scale, titleX, cursorY, offset, textAreaWidth, hoverSpeed, scaledMouseX, scaledMouseY, lineHeight, entryMargin, headerMargin, hoverFlag, "Container", this.gearGroupedEntries, this.potionGroupedEntries, this.bookGroupedEntries);
        if (this.includePlayerInventory.isChecked()) {
            cursorY = this.renderSourceSection(context, tr, scale, titleX, cursorY, offset, textAreaWidth, hoverSpeed, scaledMouseX, scaledMouseY, lineHeight, entryMargin, headerMargin, hoverFlag, "Player Inventory", this.gearGroupedEntriesPlayer, this.potionGroupedEntriesPlayer, this.bookGroupedEntriesPlayer);
        }
        if (this.includeShulkerContents.isChecked()) {
            cursorY = this.renderSourceSection(context, tr, scale, titleX, cursorY, offset, textAreaWidth, hoverSpeed, scaledMouseX, scaledMouseY, lineHeight, entryMargin, headerMargin, hoverFlag, "Shulker contents", this.gearGroupedEntriesShulker, this.potionGroupedEntriesShulker, this.bookGroupedEntriesShulker);
        }
        if (!hoverFlag[0]) {
            this.hoveredSlotId = -1;
            this.hoverStartMs = 0L;
        }
        this.contentHeight = (int)Math.max(0L, Math.round(cursorY - (double)contentTop));
        this.maxScroll = Math.max(0, this.contentHeight - innerHeight);
        this.scrollOffset = class_3532.method_15350((double)this.scrollOffset, (double)0.0, (double)this.maxScroll);
        context.method_44380();
    }

    private double renderGearSection(class_332 context, class_327 tr, float scale, int titleX, double cursorY, double offset, double textAreaWidth, double hoverSpeed, double scaledMouseX, double scaledMouseY, int lineHeight, int entryMargin, int headerMargin, boolean[] hoverFlag) {
        boolean hasEntries = GearCategory.ORDERED.stream().anyMatch(cat -> !this.gearGroupedEntries.getOrDefault(cat, List.of()).isEmpty());
        if (!hasEntries) {
            return cursorY;
        }
        int sectionTitleY = (int)Math.round(cursorY - offset);
        this.drawSectionHeader(context, tr, titleX, sectionTitleY, "Enchanted Gear", scale);
        Objects.requireNonNull(EnchantmentHandlerHack.MC.field_1772);
        int underlineY = sectionTitleY + Math.max(1, Math.round(9.0f * scale)) + 2;
        context.method_25294(this.panelX + 2, underlineY, this.panelX + this.panelWidth - 2, underlineY + 1, -3092272);
        cursorY += (double)(lineHeight + headerMargin + 4);
        for (GearCategory category : GearCategory.ORDERED) {
            List list = this.gearGroupedEntries.getOrDefault((Object)category, List.of());
            if (list.isEmpty()) continue;
            cursorY = this.renderCategoryEntries(context, tr, scale, titleX, cursorY, offset, textAreaWidth, hoverSpeed, scaledMouseX, scaledMouseY, lineHeight, entryMargin, headerMargin, category.getDisplayName(), CategoryKind.GEAR, (Object)category, list, hoverFlag, "Container");
        }
        return cursorY;
    }

    private double renderSourceSection(class_332 context, class_327 tr, float scale, int titleX, double cursorY, double offset, double textAreaWidth, double hoverSpeed, double scaledMouseX, double scaledMouseY, int lineHeight, int entryMargin, int headerMargin, boolean[] hoverFlag, String sourceTitle, Map<GearCategory, List<GearEntry>> gearMap, Map<PotionCategory, List<PotionEntry>> potionMap, Map<BookCategory, List<BookEntry>> bookMap) {
        List list;
        boolean hasEntries;
        boolean bl = hasEntries = GearCategory.ORDERED.stream().anyMatch(cat -> !gearMap.getOrDefault(cat, List.of()).isEmpty()) || BookCategory.ORDERED.stream().anyMatch(cat -> !bookMap.getOrDefault(cat, List.of()).isEmpty()) || PotionCategory.ORDERED.stream().anyMatch(cat -> !potionMap.getOrDefault(cat, List.of()).isEmpty());
        if (!hasEntries) {
            return cursorY;
        }
        int sectionTitleY = (int)Math.round(cursorY - offset);
        this.drawSectionHeader(context, tr, titleX, sectionTitleY, sourceTitle, scale);
        Objects.requireNonNull(EnchantmentHandlerHack.MC.field_1772);
        int underlineY = sectionTitleY + Math.max(1, Math.round(9.0f * scale)) + 2;
        context.method_25294(this.panelX + 2, underlineY, this.panelX + this.panelWidth - 2, underlineY + 1, -3092272);
        cursorY += (double)(lineHeight + headerMargin + 4);
        for (GearCategory gearCategory : GearCategory.ORDERED) {
            list = gearMap.getOrDefault((Object)gearCategory, List.of());
            if (list.isEmpty()) continue;
            cursorY = this.renderCategoryEntries(context, tr, scale, titleX, cursorY, offset, textAreaWidth, hoverSpeed, scaledMouseX, scaledMouseY, lineHeight, entryMargin, headerMargin, gearCategory.getDisplayName(), CategoryKind.GEAR, (Object)gearCategory, list, hoverFlag, sourceTitle);
        }
        for (PotionCategory potionCategory : PotionCategory.ORDERED) {
            list = potionMap.getOrDefault((Object)potionCategory, List.of());
            if (list.isEmpty()) continue;
            cursorY = this.renderCategoryEntries(context, tr, scale, titleX, cursorY, offset, textAreaWidth, hoverSpeed, scaledMouseX, scaledMouseY, lineHeight, entryMargin, headerMargin, potionCategory.getDisplayName(), CategoryKind.POTION, (Object)potionCategory, list, hoverFlag, sourceTitle);
        }
        for (BookCategory bookCategory : BookCategory.ORDERED) {
            list = bookMap.getOrDefault((Object)bookCategory, List.of());
            if (list.isEmpty()) continue;
            cursorY = this.renderCategoryEntries(context, tr, scale, titleX, cursorY, offset, textAreaWidth, hoverSpeed, scaledMouseX, scaledMouseY, lineHeight, entryMargin, headerMargin, bookCategory.getDisplayName(), CategoryKind.BOOK, (Object)bookCategory, list, hoverFlag, sourceTitle);
        }
        return cursorY;
    }

    private double renderBookSection(class_332 context, class_327 tr, float scale, int titleX, double cursorY, double offset, double textAreaWidth, double hoverSpeed, double scaledMouseX, double scaledMouseY, int lineHeight, int entryMargin, int headerMargin, boolean[] hoverFlag) {
        boolean hasEntries = BookCategory.ORDERED.stream().anyMatch(cat -> !this.bookGroupedEntries.getOrDefault(cat, List.of()).isEmpty());
        if (!hasEntries) {
            return cursorY;
        }
        int sectionTitleY = (int)Math.round(cursorY - offset);
        this.drawSectionHeader(context, tr, titleX, sectionTitleY, "Enchanted Books", scale);
        Objects.requireNonNull(EnchantmentHandlerHack.MC.field_1772);
        int underlineY = sectionTitleY + Math.max(1, Math.round(9.0f * scale)) + 2;
        context.method_25294(this.panelX + 2, underlineY, this.panelX + this.panelWidth - 2, underlineY + 1, -3092272);
        cursorY += (double)(lineHeight + headerMargin + 4);
        for (BookCategory category : BookCategory.ORDERED) {
            List list = this.bookGroupedEntries.getOrDefault((Object)category, List.of());
            if (list.isEmpty()) continue;
            cursorY = this.renderCategoryEntries(context, tr, scale, titleX, cursorY, offset, textAreaWidth, hoverSpeed, scaledMouseX, scaledMouseY, lineHeight, entryMargin, headerMargin, category.getDisplayName(), CategoryKind.BOOK, (Object)category, list, hoverFlag, "Container");
        }
        return cursorY;
    }

    private double renderPotionSection(class_332 context, class_327 tr, float scale, int titleX, double cursorY, double offset, double textAreaWidth, double hoverSpeed, double scaledMouseX, double scaledMouseY, int lineHeight, int entryMargin, int headerMargin, boolean[] hoverFlag) {
        boolean hasEntries = PotionCategory.ORDERED.stream().anyMatch(cat -> !this.potionGroupedEntries.getOrDefault(cat, List.of()).isEmpty());
        if (!hasEntries) {
            return cursorY;
        }
        int sectionTitleY = (int)Math.round(cursorY - offset);
        this.drawSectionHeader(context, tr, titleX, sectionTitleY, "Potions", scale);
        Objects.requireNonNull(EnchantmentHandlerHack.MC.field_1772);
        int underlineY = sectionTitleY + Math.max(1, Math.round(9.0f * scale)) + 2;
        context.method_25294(this.panelX + 2, underlineY, this.panelX + this.panelWidth - 2, underlineY + 1, -3092272);
        cursorY += (double)(lineHeight + headerMargin + 4);
        for (PotionCategory category : PotionCategory.ORDERED) {
            List list = this.potionGroupedEntries.getOrDefault((Object)category, List.of());
            if (list.isEmpty()) continue;
            cursorY = this.renderCategoryEntries(context, tr, scale, titleX, cursorY, offset, textAreaWidth, hoverSpeed, scaledMouseX, scaledMouseY, lineHeight, entryMargin, headerMargin, category.getDisplayName(), CategoryKind.POTION, (Object)category, list, hoverFlag, "Container");
        }
        return cursorY;
    }

    private double renderCategoryEntries(class_332 context, class_327 tr, float scale, int titleX, double cursorY, double offset, double textAreaWidth, double hoverSpeed, double scaledMouseX, double scaledMouseY, int lineHeight, int entryMargin, int headerMargin, String displayName, CategoryKind kind, Object category, List<? extends AbstractEntry> entries, boolean[] hoverFlag, String source) {
        int headerY = (int)Math.round(cursorY - offset);
        String headerText = displayName + " (" + entries.size() + ")";
        EnchantmentHandlerHack.drawScaledText(context, tr, headerText, titleX, headerY, -3614465, scale);
        String takeAllText = "Take All";
        int takeAllWidth = Math.max(1, Math.round((float)tr.method_1727(takeAllText) * scale));
        int takeAllX = this.panelX + this.panelWidth - 6 - takeAllWidth;
        int takeAllY = headerY;
        boolean actionHovered = scaledMouseX >= (double)(takeAllX - 2) && scaledMouseX <= (double)(takeAllX + takeAllWidth + 2) && scaledMouseY >= (double)(takeAllY - 2) && scaledMouseY <= (double)(takeAllY + lineHeight + 2);
        EnchantmentHandlerHack.drawScaledText(context, tr, takeAllText, takeAllX, takeAllY, actionHovered ? -4791809 : -7944705, scale);
        this.hitboxes.add(Hitbox.forCategory(takeAllX - 2, takeAllY - 2, takeAllWidth + 4, lineHeight + 4, kind, category, source));
        cursorY += (double)(lineHeight + entryMargin);
        for (AbstractEntry abstractEntry : entries) {
            boolean hovered;
            int entryY = (int)Math.round(cursorY - offset);
            boolean bl = hovered = scaledMouseX >= (double)(this.panelX + 2) && scaledMouseX <= (double)(this.panelX + this.panelWidth - 2) && scaledMouseY >= (double)(entryY - 2) && scaledMouseY <= (double)(entryY + lineHeight + 2);
            if (hovered) {
                context.method_25294(this.panelX + 2, entryY - 2, this.panelX + this.panelWidth - 2, entryY + lineHeight + 2, -2144720342);
            }
            double textWidth = Math.max(1.0, (double)((float)tr.method_1727(abstractEntry.line) * scale));
            double travel = textWidth - textAreaWidth;
            double scrollX = 0.0;
            if (hovered) {
                long elapsed;
                hoverFlag[0] = true;
                if (abstractEntry.slotId != this.hoveredSlotId) {
                    this.hoveredSlotId = abstractEntry.slotId;
                    this.hoverStartMs = System.currentTimeMillis();
                }
                if (travel > 1.0 && (elapsed = System.currentTimeMillis() - this.hoverStartMs) > 400L) {
                    double progress = (double)(elapsed - 400L) / 1000.0 * hoverSpeed;
                    double cycle = travel * 2.0 + 32.0;
                    double cyclePos = progress % cycle;
                    if (cyclePos <= travel) {
                        scrollX = cyclePos;
                    } else if (cyclePos <= travel + 32.0) {
                        scrollX = travel;
                    } else {
                        double back = cyclePos - travel - 32.0;
                        scrollX = Math.max(0.0, travel - back);
                    }
                }
                scrollX = class_3532.method_15350((double)scrollX, (double)0.0, (double)Math.max(0.0, travel));
            } else if (this.hoveredSlotId == abstractEntry.slotId) {
                this.hoveredSlotId = -1;
                this.hoverStartMs = 0L;
            }
            float renderScroll = (float)(scrollX / (double)scale);
            EnchantmentHandlerHack.drawScaledText(context, tr, abstractEntry.line, (float)titleX - renderScroll, entryY, hovered ? -6231 : -1184275, scale);
            this.hitboxes.add(Hitbox.forEntry(this.panelX + 2, entryY - 2, this.panelWidth - 4, lineHeight + 4, abstractEntry));
            cursorY += (double)(lineHeight + entryMargin);
        }
        return cursorY += (double)headerMargin;
    }

    private void rescan(class_465<?> screen) {
        this.refreshEntries(screen.method_17577());
        this.needsRescan = false;
    }

    private void refreshIfDirty(class_465<?> screen) {
        this.refreshEntries(screen.method_17577());
    }

    private void refreshEntries(class_1703 handler) {
        int containerSlots;
        this.allEntries.clear();
        this.gearGroupedEntries.values().forEach(List::clear);
        this.bookGroupedEntries.values().forEach(List::clear);
        this.potionGroupedEntries.values().forEach(List::clear);
        this.gearGroupedEntriesPlayer.values().forEach(List::clear);
        this.bookGroupedEntriesPlayer.values().forEach(List::clear);
        this.potionGroupedEntriesPlayer.values().forEach(List::clear);
        this.gearGroupedEntriesShulker.values().forEach(List::clear);
        this.bookGroupedEntriesShulker.values().forEach(List::clear);
        this.potionGroupedEntriesShulker.values().forEach(List::clear);
        class_2371 slots = handler.field_7761;
        int totalSlots = slots.size();
        if (handler instanceof class_1707) {
            class_1707 genericHandler = (class_1707)handler;
            containerSlots = Math.min(genericHandler.method_17388() * 9, totalSlots);
        } else {
            int playerInvSlots = 36;
            if (EnchantmentHandlerHack.MC.field_1724 != null && handler == EnchantmentHandlerHack.MC.field_1724.field_7498) {
                containerSlots = totalSlots;
            } else {
                containerSlots = Math.max(0, totalSlots - playerInvSlots);
                if (containerSlots == 0) {
                    containerSlots = totalSlots;
                }
            }
        }
        for (int i = 0; i < containerSlots; ++i) {
            GearEntry entry;
            GearCategory category;
            class_9288 container;
            class_1799 stack;
            class_1735 slot = (class_1735)slots.get(i);
            if (slot == null || !slot.method_7681() || (stack = slot.method_7677()).method_7960()) continue;
            if (this.includeShulkerContents.isChecked() && (container = (class_9288)stack.method_58694(class_9334.field_49622)) != null) {
                int parentSlotNumber = slot.method_34266() + 1;
                for (class_1799 inner : container.method_59714()) {
                    GearEntry entry2;
                    GearCategory gCatInner;
                    AbstractEntry entry3;
                    if (inner == null || inner.method_7960()) continue;
                    if (inner.method_31574(class_1802.field_8598)) {
                        Set ench = class_1890.method_57532((class_1799)inner).method_57539();
                        entry3 = this.buildBookEntryFromStack(parentSlotNumber, inner, ench);
                        if (entry3 == null) continue;
                        this.allEntries.add(entry3);
                        this.bookGroupedEntries.computeIfAbsent(entry3.category, c -> new ArrayList()).add(entry3);
                        continue;
                    }
                    PotionCategory pCatInner = PotionCategory.fromItem(inner.method_7909());
                    if (pCatInner != null) {
                        entry3 = this.buildPotionEntryFromStack(parentSlotNumber, inner, pCatInner);
                        if (entry3 == null) continue;
                        this.allEntries.add(entry3);
                        this.potionGroupedEntries.computeIfAbsent(((PotionEntry)entry3).category, c -> new ArrayList()).add(entry3);
                        continue;
                    }
                    Set enchInner = class_1890.method_57532((class_1799)inner).method_57539();
                    if (enchInner.isEmpty() || (gCatInner = GearCategory.fromStack(inner)) == null || (entry2 = this.buildGearEntryFromStack(parentSlotNumber, inner, gCatInner, enchInner)) == null) continue;
                    this.allEntries.add(entry2);
                    this.gearGroupedEntries.computeIfAbsent(entry2.category, c -> new ArrayList()).add(entry2);
                }
            }
            if (stack.method_31574(class_1802.field_8598)) {
                BookEntry entry4;
                Set enchantments = class_1890.method_57532((class_1799)stack).method_57539();
                if (enchantments.isEmpty() || (entry4 = this.buildBookEntry(slot, enchantments)) == null) continue;
                this.allEntries.add(entry4);
                this.bookGroupedEntries.computeIfAbsent(entry4.category, c -> new ArrayList()).add(entry4);
                continue;
            }
            PotionCategory pCat = PotionCategory.fromItem(stack.method_7909());
            if (pCat != null) {
                PotionEntry entry5 = this.buildPotionEntry(slot, stack, pCat);
                if (entry5 == null) continue;
                this.allEntries.add(entry5);
                this.potionGroupedEntries.computeIfAbsent(entry5.category, c -> new ArrayList()).add(entry5);
                continue;
            }
            Set enchantments = class_1890.method_57532((class_1799)stack).method_57539();
            if (enchantments.isEmpty() || (category = GearCategory.fromStack(stack)) == null || (entry = this.buildGearEntry(slot, stack, category, enchantments)) == null) continue;
            this.allEntries.add(entry);
            this.gearGroupedEntries.computeIfAbsent(category, c -> new ArrayList()).add(entry);
        }
        int scanSlots = containerSlots;
        if (this.includePlayerInventory.isChecked()) {
            scanSlots = slots.size();
        }
        for (int i = containerSlots; i < scanSlots; ++i) {
            class_9288 container;
            AbstractEntry entry;
            class_1799 stack;
            class_1735 slot = (class_1735)slots.get(i);
            if (slot == null || !slot.method_7681() || (stack = slot.method_7677()).method_7960()) continue;
            if (stack.method_31574(class_1802.field_8598)) {
                Set enchantments = class_1890.method_57532((class_1799)stack).method_57539();
                if (enchantments.isEmpty() || (entry = this.buildBookEntry(slot, enchantments)) == null) continue;
                this.allEntries.add(entry);
                this.bookGroupedEntriesPlayer.computeIfAbsent(entry.category, c -> new ArrayList()).add(entry);
                continue;
            }
            PotionCategory pCat = PotionCategory.fromItem(stack.method_7909());
            if (pCat != null) {
                entry = this.buildPotionEntry(slot, stack, pCat);
                if (entry == null) continue;
                this.allEntries.add(entry);
                this.potionGroupedEntriesPlayer.computeIfAbsent(((PotionEntry)entry).category, c -> new ArrayList()).add(entry);
                continue;
            }
            Set enchantments = class_1890.method_57532((class_1799)stack).method_57539();
            if (!enchantments.isEmpty()) {
                GearEntry entry6;
                GearCategory category = GearCategory.fromStack(stack);
                if (category == null || (entry6 = this.buildGearEntry(slot, stack, category, enchantments)) == null) continue;
                this.allEntries.add(entry6);
                this.gearGroupedEntriesPlayer.computeIfAbsent(category, c -> new ArrayList()).add(entry6);
                continue;
            }
            if (!this.includeShulkerContents.isChecked() || (container = (class_9288)stack.method_58694(class_9334.field_49622)) == null) continue;
            int parentSlotNumber = slot.method_34266() + 1;
            for (class_1799 inner : container.method_59714()) {
                GearEntry entry7;
                GearCategory gCatInner;
                AbstractEntry entry8;
                if (inner == null || inner.method_7960()) continue;
                if (inner.method_31574(class_1802.field_8598)) {
                    Set ench = class_1890.method_57532((class_1799)inner).method_57539();
                    entry8 = this.buildBookEntryFromStack(parentSlotNumber, inner, ench);
                    if (entry8 == null) continue;
                    this.allEntries.add(entry8);
                    this.bookGroupedEntriesShulker.computeIfAbsent(entry8.category, c -> new ArrayList()).add(entry8);
                    continue;
                }
                PotionCategory pCatInner = PotionCategory.fromItem(inner.method_7909());
                if (pCatInner != null) {
                    entry8 = this.buildPotionEntryFromStack(parentSlotNumber, inner, pCatInner);
                    if (entry8 == null) continue;
                    this.allEntries.add(entry8);
                    this.potionGroupedEntriesShulker.computeIfAbsent(((PotionEntry)entry8).category, c -> new ArrayList()).add(entry8);
                    continue;
                }
                Set enchInner = class_1890.method_57532((class_1799)inner).method_57539();
                if (enchInner.isEmpty() || (gCatInner = GearCategory.fromStack(inner)) == null || (entry7 = this.buildGearEntryFromStack(parentSlotNumber, inner, gCatInner, enchInner)) == null) continue;
                this.allEntries.add(entry7);
                this.gearGroupedEntriesShulker.computeIfAbsent(entry7.category, c -> new ArrayList()).add(entry7);
            }
        }
        this.gearGroupedEntries.values().forEach(list -> list.sort((a, b) -> Integer.compare(a.displaySlot, b.displaySlot)));
        this.gearGroupedEntriesPlayer.values().forEach(list -> list.sort((a, b) -> Integer.compare(a.displaySlot, b.displaySlot)));
        this.gearGroupedEntriesShulker.values().forEach(list -> list.sort((a, b) -> Integer.compare(a.displaySlot, b.displaySlot)));
        this.bookGroupedEntries.values().forEach(list -> list.sort((a, b) -> Integer.compare(a.displaySlot, b.displaySlot)));
        this.bookGroupedEntriesPlayer.values().forEach(list -> list.sort((a, b) -> Integer.compare(a.displaySlot, b.displaySlot)));
        this.bookGroupedEntriesShulker.values().forEach(list -> list.sort((a, b) -> Integer.compare(a.displaySlot, b.displaySlot)));
        this.potionGroupedEntries.values().forEach(list -> list.sort((a, b) -> {
            int n = a.primaryName.compareToIgnoreCase(b.primaryName);
            if (n != 0) {
                return n;
            }
            n = Integer.compare(b.primaryLevel, a.primaryLevel);
            if (n != 0) {
                return n;
            }
            n = Integer.compare(b.primaryDuration, a.primaryDuration);
            if (n != 0) {
                return n;
            }
            return Integer.compare(a.displaySlot, b.displaySlot);
        }));
        this.potionGroupedEntriesPlayer.values().forEach(list -> list.sort((a, b) -> {
            int n = a.primaryName.compareToIgnoreCase(b.primaryName);
            if (n != 0) {
                return n;
            }
            n = Integer.compare(b.primaryLevel, a.primaryLevel);
            if (n != 0) {
                return n;
            }
            n = Integer.compare(b.primaryDuration, a.primaryDuration);
            if (n != 0) {
                return n;
            }
            return Integer.compare(a.displaySlot, b.displaySlot);
        }));
        this.potionGroupedEntriesShulker.values().forEach(list -> list.sort((a, b) -> {
            int n = a.primaryName.compareToIgnoreCase(b.primaryName);
            if (n != 0) {
                return n;
            }
            n = Integer.compare(b.primaryLevel, a.primaryLevel);
            if (n != 0) {
                return n;
            }
            n = Integer.compare(b.primaryDuration, a.primaryDuration);
            if (n != 0) {
                return n;
            }
            return Integer.compare(a.displaySlot, b.displaySlot);
        }));
    }

    private GearEntry buildGearEntry(class_1735 slot, class_1799 stack, GearCategory category, Set<Object2IntMap.Entry<class_6880<class_1887>>> enchantments) {
        ArrayList<CallSite> parts = new ArrayList<CallSite>();
        for (Object2IntMap.Entry<class_6880<class_1887>> entry : enchantments) {
            class_6880 enchantmentEntry = (class_6880)entry.getKey();
            if (enchantmentEntry == null) continue;
            int level = entry.getIntValue();
            class_2960 id = enchantmentEntry.method_40230().map(registryKey -> registryKey.method_29177()).orElse(null);
            String path = id != null ? id.method_12832() : EnchantmentHandlerHack.sanitizePath(enchantmentEntry.method_55840());
            String name = EnchantmentHandlerHack.buildEnchantmentName(id, path);
            String levelText = class_2561.method_43471((String)("enchantment.level." + level)).getString();
            parts.add((CallSite)((Object)(name + " " + levelText)));
        }
        if (parts.isEmpty()) {
            return null;
        }
        String enchantSummary = EnchantmentHandlerHack.limitLength(String.join((CharSequence)", ", parts), 90);
        int slotNumber = slot.method_34266() + 1;
        String itemName = EnchantmentHandlerHack.limitLength(stack.method_7964().getString(), 40);
        String line = slotNumber + " - " + itemName + " | " + enchantSummary;
        return new GearEntry(slot.field_7874, slotNumber, category, line);
    }

    private GearEntry buildGearEntryFromStack(int parentSlotNumber, class_1799 stack, GearCategory category, Set<Object2IntMap.Entry<class_6880<class_1887>>> enchantments) {
        ArrayList<CallSite> parts = new ArrayList<CallSite>();
        for (Object2IntMap.Entry<class_6880<class_1887>> entry : enchantments) {
            class_6880 enchantmentEntry = (class_6880)entry.getKey();
            if (enchantmentEntry == null) continue;
            int level = entry.getIntValue();
            class_2960 id = enchantmentEntry.method_40230().map(registryKey -> registryKey.method_29177()).orElse(null);
            String path = id != null ? id.method_12832() : EnchantmentHandlerHack.sanitizePath(enchantmentEntry.method_55840());
            String name = EnchantmentHandlerHack.buildEnchantmentName(id, path);
            String levelText = class_2561.method_43471((String)("enchantment.level." + level)).getString();
            parts.add((CallSite)((Object)(name + " " + levelText)));
        }
        if (parts.isEmpty()) {
            return null;
        }
        String enchantSummary = EnchantmentHandlerHack.limitLength(String.join((CharSequence)", ", parts), 90);
        String itemName = EnchantmentHandlerHack.limitLength(stack.method_7964().getString(), 40);
        String line = parentSlotNumber + " - " + itemName + " | " + enchantSummary + " (in shulker)";
        return new GearEntry(-1, parentSlotNumber, category, line);
    }

    private BookEntry buildBookEntry(class_1735 slot, Set<Object2IntMap.Entry<class_6880<class_1887>>> enchantments) {
        ArrayList<CallSite> parts = new ArrayList<CallSite>();
        EnumSet<BookCategory> categories = EnumSet.noneOf(BookCategory.class);
        for (Object2IntMap.Entry<class_6880<class_1887>> entry : enchantments) {
            class_6880 enchantmentEntry = (class_6880)entry.getKey();
            if (enchantmentEntry == null) continue;
            int level = entry.getIntValue();
            class_2960 id = enchantmentEntry.method_40230().map(registryKey -> registryKey.method_29177()).orElse(null);
            String path = id != null ? id.method_12832() : EnchantmentHandlerHack.sanitizePath(enchantmentEntry.method_55840());
            BookCategory category = BookCategory.fromPath(path);
            categories.add(category);
            String name = EnchantmentHandlerHack.buildEnchantmentName(id, path);
            String levelText = class_2561.method_43471((String)("enchantment.level." + level)).getString();
            parts.add((CallSite)((Object)(name + " " + levelText)));
        }
        if (parts.isEmpty()) {
            return null;
        }
        BookCategory primary = categories.stream().filter(c -> c != BookCategory.MISC).findFirst().orElseGet(() -> categories.stream().findFirst().orElse(BookCategory.MISC));
        String enchantSummary = EnchantmentHandlerHack.limitLength(String.join((CharSequence)", ", parts), 90);
        int slotNumber = slot.method_34266() + 1;
        String line = slotNumber + " - " + enchantSummary;
        return new BookEntry(slot.field_7874, slotNumber, primary, line);
    }

    private BookEntry buildBookEntryFromStack(int parentSlotNumber, class_1799 stack, Set<Object2IntMap.Entry<class_6880<class_1887>>> enchantments) {
        ArrayList<CallSite> parts = new ArrayList<CallSite>();
        EnumSet<BookCategory> categories = EnumSet.noneOf(BookCategory.class);
        for (Object2IntMap.Entry<class_6880<class_1887>> entry : enchantments) {
            class_6880 enchantmentEntry = (class_6880)entry.getKey();
            if (enchantmentEntry == null) continue;
            int level = entry.getIntValue();
            class_2960 id = enchantmentEntry.method_40230().map(registryKey -> registryKey.method_29177()).orElse(null);
            String path = id != null ? id.method_12832() : EnchantmentHandlerHack.sanitizePath(enchantmentEntry.method_55840());
            BookCategory category = BookCategory.fromPath(path);
            categories.add(category);
            String name = EnchantmentHandlerHack.buildEnchantmentName(id, path);
            String levelText = class_2561.method_43471((String)("enchantment.level." + level)).getString();
            parts.add((CallSite)((Object)(name + " " + levelText)));
        }
        if (parts.isEmpty()) {
            return null;
        }
        BookCategory primary = categories.stream().filter(c -> c != BookCategory.MISC).findFirst().orElseGet(() -> categories.stream().findFirst().orElse(BookCategory.MISC));
        String enchantSummary = EnchantmentHandlerHack.limitLength(String.join((CharSequence)", ", parts), 90);
        String line = parentSlotNumber + " - " + enchantSummary + " (in shulker)";
        return new BookEntry(-1, parentSlotNumber, primary, line);
    }

    private PotionEntry buildPotionEntry(class_1735 slot, class_1799 stack, PotionCategory category) {
        Optional basePotion;
        ArrayList<Object> parts = new ArrayList<Object>();
        class_1844 potionContents = (class_1844)stack.method_57353().method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
        for (class_1293 effectInstance : potionContents.method_57397()) {
            class_6880 effEntry = effectInstance.method_5579();
            class_2960 id = effEntry.method_40230().map(k -> k.method_29177()).orElse(null);
            String path = id != null ? id.method_12832() : EnchantmentHandlerHack.sanitizePath(effEntry.method_55840());
            String name = EnchantmentHandlerHack.buildEffectName(id, path);
            String ampText = effectInstance.method_5578() > 0 ? " " + (effectInstance.method_5578() + 1) : "";
            String durText = effectInstance.method_5584() > 0 ? " " + Math.max(0, effectInstance.method_5584() / 20) + "s" : "";
            parts.add(name + ampText + durText);
        }
        if (parts.isEmpty() && (basePotion = potionContents.comp_2378()).isPresent()) {
            class_6880 p = (class_6880)basePotion.get();
            class_2960 id = p.method_40230().map(k -> k.method_29177()).orElse(null);
            String path = id != null ? id.method_12832() : EnchantmentHandlerHack.sanitizePath(p.method_55840());
            String name = EnchantmentHandlerHack.buildPotionName(id, path);
            parts.add(name);
        }
        String primaryName = null;
        int primaryLevel = 0;
        int primaryDuration = 0;
        Iterable effects = potionContents.method_57397();
        Iterator it = effects.iterator();
        if (it.hasNext()) {
            class_1293 first = (class_1293)it.next();
            id = first.method_5579().method_40230().map(k -> k.method_29177()).orElse(null);
            path = id != null ? id.method_12832() : EnchantmentHandlerHack.sanitizePath(first.method_5579().method_55840());
            primaryName = EnchantmentHandlerHack.buildEffectName(id, path);
            primaryLevel = first.method_5578() + 1;
            primaryDuration = Math.max(0, first.method_5584());
        } else {
            Optional basePotion2 = potionContents.comp_2378();
            if (basePotion2.isPresent()) {
                id = ((class_6880)basePotion2.get()).method_40230().map(k -> k.method_29177()).orElse(null);
                path = id != null ? id.method_12832() : EnchantmentHandlerHack.sanitizePath(((class_6880)basePotion2.get()).method_55840());
                primaryName = EnchantmentHandlerHack.buildPotionName(id, path);
            } else {
                primaryName = "Unknown";
            }
        }
        if (parts.isEmpty()) {
            return null;
        }
        String summary = EnchantmentHandlerHack.limitLength(String.join((CharSequence)", ", parts), 90);
        int slotNumber = slot.method_34266() + 1;
        String itemName = EnchantmentHandlerHack.limitLength(stack.method_7964().getString(), 40);
        String line = slotNumber + " - " + itemName + " | " + summary;
        return new PotionEntry(slot.field_7874, slotNumber, category, line, primaryName, primaryLevel, primaryDuration);
    }

    private PotionEntry buildPotionEntryFromStack(int parentSlotNumber, class_1799 stack, PotionCategory category) {
        Optional basePotion;
        ArrayList<Object> parts = new ArrayList<Object>();
        class_1844 potionContents = (class_1844)stack.method_57353().method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
        for (class_1293 effectInstance : potionContents.method_57397()) {
            class_6880 effEntry = effectInstance.method_5579();
            class_2960 id = effEntry.method_40230().map(k -> k.method_29177()).orElse(null);
            String path = id != null ? id.method_12832() : EnchantmentHandlerHack.sanitizePath(effEntry.method_55840());
            String name = EnchantmentHandlerHack.buildEffectName(id, path);
            String ampText = effectInstance.method_5578() > 0 ? " " + (effectInstance.method_5578() + 1) : "";
            String durText = effectInstance.method_5584() > 0 ? " " + Math.max(0, effectInstance.method_5584() / 20) + "s" : "";
            parts.add(name + ampText + durText);
        }
        if (parts.isEmpty() && (basePotion = potionContents.comp_2378()).isPresent()) {
            class_6880 p = (class_6880)basePotion.get();
            class_2960 id = p.method_40230().map(k -> k.method_29177()).orElse(null);
            String path = id != null ? id.method_12832() : EnchantmentHandlerHack.sanitizePath(p.method_55840());
            String name = EnchantmentHandlerHack.buildPotionName(id, path);
            parts.add(name);
        }
        if (parts.isEmpty()) {
            return null;
        }
        String summary = EnchantmentHandlerHack.limitLength(String.join((CharSequence)", ", parts), 90);
        String itemName = EnchantmentHandlerHack.limitLength(stack.method_7964().getString(), 40);
        String line = parentSlotNumber + " - " + itemName + " | " + summary + " (in shulker)";
        String primaryName = null;
        int primaryLevel = 0;
        int primaryDuration = 0;
        Iterable effects = potionContents.method_57397();
        Iterator it = effects.iterator();
        if (it.hasNext()) {
            class_1293 first = (class_1293)it.next();
            class_2960 id = first.method_5579().method_40230().map(k -> k.method_29177()).orElse(null);
            String path = id != null ? id.method_12832() : EnchantmentHandlerHack.sanitizePath(first.method_5579().method_55840());
            primaryName = EnchantmentHandlerHack.buildEffectName(id, path);
            primaryLevel = first.method_5578() + 1;
            primaryDuration = Math.max(0, first.method_5584());
        } else {
            Optional basePotion2 = potionContents.comp_2378();
            if (basePotion2.isPresent()) {
                class_2960 id = ((class_6880)basePotion2.get()).method_40230().map(k -> k.method_29177()).orElse(null);
                String path = id != null ? id.method_12832() : EnchantmentHandlerHack.sanitizePath(((class_6880)basePotion2.get()).method_55840());
                primaryName = EnchantmentHandlerHack.buildPotionName(id, path);
            } else {
                primaryName = "Unknown";
            }
        }
        return new PotionEntry(-1, parentSlotNumber, category, line, primaryName, primaryLevel, primaryDuration);
    }

    private void takeEntry(GearEntry entry, class_1703 handler) {
        if (EnchantmentHandlerHack.MC.field_1724 == null || EnchantmentHandlerHack.MC.field_1761 == null || entry == null) {
            return;
        }
        if (entry.slotId < 0) {
            return;
        }
        class_1735 slot = this.getSlotSafe(handler, entry.slotId);
        if (slot == null || !slot.method_7681()) {
            return;
        }
        EnchantmentHandlerHack.MC.field_1761.method_2906(handler.field_7763, entry.slotId, 0, class_1713.field_7794, (class_1657)EnchantmentHandlerHack.MC.field_1724);
        this.needsRescan = true;
    }

    private void takeEntry(BookEntry entry, class_1703 handler) {
        if (EnchantmentHandlerHack.MC.field_1724 == null || EnchantmentHandlerHack.MC.field_1761 == null || entry == null) {
            return;
        }
        if (entry.slotId < 0) {
            return;
        }
        class_1735 slot = this.getSlotSafe(handler, entry.slotId);
        if (slot == null || !slot.method_7681()) {
            return;
        }
        EnchantmentHandlerHack.MC.field_1761.method_2906(handler.field_7763, entry.slotId, 0, class_1713.field_7794, (class_1657)EnchantmentHandlerHack.MC.field_1724);
        this.needsRescan = true;
    }

    private void takeEntry(PotionEntry entry, class_1703 handler) {
        if (EnchantmentHandlerHack.MC.field_1724 == null || EnchantmentHandlerHack.MC.field_1761 == null || entry == null) {
            return;
        }
        if (entry.slotId < 0) {
            return;
        }
        class_1735 slot = this.getSlotSafe(handler, entry.slotId);
        if (slot == null || !slot.method_7681()) {
            return;
        }
        EnchantmentHandlerHack.MC.field_1761.method_2906(handler.field_7763, entry.slotId, 0, class_1713.field_7794, (class_1657)EnchantmentHandlerHack.MC.field_1724);
        this.needsRescan = true;
    }

    private void takeGearCategory(GearCategory category, class_1703 handler, String source) {
        if (EnchantmentHandlerHack.MC.field_1724 == null || EnchantmentHandlerHack.MC.field_1761 == null) {
            return;
        }
        List<GearEntry> list = switch (source) {
            case "Player Inventory" -> this.gearGroupedEntriesPlayer.get((Object)category);
            case "Shulker contents" -> this.gearGroupedEntriesShulker.get((Object)category);
            default -> this.gearGroupedEntries.get((Object)category);
        };
        if (list == null || list.isEmpty()) {
            return;
        }
        for (GearEntry entry : new ArrayList<GearEntry>(list)) {
            class_1735 slot;
            if (entry.slotId < 0 || (slot = this.getSlotSafe(handler, entry.slotId)) == null || !slot.method_7681()) continue;
            EnchantmentHandlerHack.MC.field_1761.method_2906(handler.field_7763, entry.slotId, 0, class_1713.field_7794, (class_1657)EnchantmentHandlerHack.MC.field_1724);
        }
        this.needsRescan = true;
    }

    private void takeBookCategory(BookCategory category, class_1703 handler, String source) {
        if (EnchantmentHandlerHack.MC.field_1724 == null || EnchantmentHandlerHack.MC.field_1761 == null) {
            return;
        }
        List<BookEntry> list = switch (source) {
            case "Player Inventory" -> this.bookGroupedEntriesPlayer.get((Object)category);
            case "Shulker contents" -> this.bookGroupedEntriesShulker.get((Object)category);
            default -> this.bookGroupedEntries.get((Object)category);
        };
        if (list == null || list.isEmpty()) {
            return;
        }
        for (BookEntry entry : new ArrayList<BookEntry>(list)) {
            class_1735 slot;
            if (entry.slotId < 0 || (slot = this.getSlotSafe(handler, entry.slotId)) == null || !slot.method_7681()) continue;
            EnchantmentHandlerHack.MC.field_1761.method_2906(handler.field_7763, entry.slotId, 0, class_1713.field_7794, (class_1657)EnchantmentHandlerHack.MC.field_1724);
        }
        this.needsRescan = true;
    }

    private void takePotionCategory(PotionCategory category, class_1703 handler, String source) {
        if (EnchantmentHandlerHack.MC.field_1724 == null || EnchantmentHandlerHack.MC.field_1761 == null) {
            return;
        }
        List<PotionEntry> list = switch (source) {
            case "Player Inventory" -> this.potionGroupedEntriesPlayer.get((Object)category);
            case "Shulker contents" -> this.potionGroupedEntriesShulker.get((Object)category);
            default -> this.potionGroupedEntries.get((Object)category);
        };
        if (list == null || list.isEmpty()) {
            return;
        }
        for (PotionEntry entry : new ArrayList<PotionEntry>(list)) {
            class_1735 slot;
            if (entry.slotId < 0 || (slot = this.getSlotSafe(handler, entry.slotId)) == null || !slot.method_7681()) continue;
            EnchantmentHandlerHack.MC.field_1761.method_2906(handler.field_7763, entry.slotId, 0, class_1713.field_7794, (class_1657)EnchantmentHandlerHack.MC.field_1724);
        }
        this.needsRescan = true;
    }

    private class_1735 getSlotSafe(class_1703 handler, int slotId) {
        if (handler == null || slotId < 0) {
            return null;
        }
        class_2371 slots = handler.field_7761;
        if (slots == null || slotId >= slots.size()) {
            return null;
        }
        return handler.method_7611(slotId);
    }

    private int panelInnerHeight() {
        float scale = class_3532.method_15363((float)this.textScale.getValueF(), (float)0.5f, (float)1.25f);
        class_327 tr = EnchantmentHandlerHack.MC.field_1772;
        Objects.requireNonNull(tr);
        int titleHeight = Math.max(1, Math.round(9.0f * scale));
        int headerMargin = Math.max(1, Math.round(4.0f * scale));
        int contentTop = this.panelY + 6 + titleHeight + headerMargin + 1;
        int contentBottom = this.panelY + this.panelHeight - 6;
        return Math.max(0, contentBottom - contentTop);
    }

    private static double getScaledMouseX(class_332 context) {
        class_1041 window = MC.method_22683();
        return EnchantmentHandlerHack.MC.field_1729.method_1603() * (double)context.method_51421() / (double)window.method_4480();
    }

    private static double getScaledMouseY(class_332 context) {
        class_1041 window = MC.method_22683();
        return EnchantmentHandlerHack.MC.field_1729.method_1604() * (double)context.method_51443() / (double)window.method_4507();
    }

    private static void drawScaledText(class_332 context, class_327 tr, String text, float x, float y, int color, float scale) {
        RenderUtils.drawScaledText(context, tr, text, Math.round(x), Math.round(y), color, false, scale);
    }

    private void drawSectionHeader(class_332 context, class_327 tr, int x, int y, String text, float scale) {
        int textWidth = Math.max(1, Math.round((float)tr.method_1727(text) * scale));
        Objects.requireNonNull(tr);
        int textHeight = Math.max(1, Math.round(9.0f * scale));
        int left = Math.round(x - 4);
        int right = Math.round(x + textWidth + 4);
        int top = Math.round(y - 4);
        int bottom = Math.round(y + textHeight + 4);
        context.method_25294(left, top, right, bottom, -1071110104);
        EnchantmentHandlerHack.drawScaledText(context, tr, text, x, y, -526345, scale);
    }

    private static String limitLength(String text, int max) {
        if (text.length() <= max) {
            return text;
        }
        return text.substring(0, Math.max(0, max - 3)) + "...";
    }

    private static String buildEnchantmentName(class_2960 id, String path) {
        if (path == null || path.isEmpty()) {
            return "Unknown Enchant";
        }
        String namespace = id != null ? id.method_12836() : "minecraft";
        String key = "enchantment." + namespace + "." + path;
        String translated = class_2561.method_43471((String)key).getString();
        if (translated.equals(key)) {
            return EnchantmentHandlerHack.humanize(path);
        }
        return translated;
    }

    private static String buildEffectName(class_2960 id, String path) {
        if (path == null || path.isEmpty()) {
            return "Unknown Effect";
        }
        String namespace = id != null ? id.method_12836() : "minecraft";
        String key = "effect." + namespace + "." + path;
        String translated = class_2561.method_43471((String)key).getString();
        if (translated.equals(key)) {
            return EnchantmentHandlerHack.humanize(path);
        }
        return translated;
    }

    private static String buildPotionName(class_2960 id, String path) {
        if (path == null || path.isEmpty()) {
            return "Unknown Potion";
        }
        String namespace = id != null ? id.method_12836() : "minecraft";
        String key = "potion." + namespace + "." + path;
        String translated = class_2561.method_43471((String)key).getString();
        if (translated.equals(key)) {
            return EnchantmentHandlerHack.humanize(path);
        }
        return translated;
    }

    private static String humanize(String path) {
        if (path == null || path.isEmpty()) {
            return "Unknown";
        }
        String humanized = Arrays.stream(path.split("_")).filter(part -> !part.isEmpty()).map(part -> Character.toUpperCase(part.charAt(0)) + (part.length() > 1 ? part.substring(1) : "")).collect(Collectors.joining(" "));
        return humanized.isEmpty() ? "Unknown" : humanized;
    }

    private static String sanitizePath(String raw) {
        if (raw == null || raw.isEmpty()) {
            return "";
        }
        int colon = raw.indexOf(58);
        return colon >= 0 && colon + 1 < raw.length() ? raw.substring(colon + 1) : raw;
    }

    private static enum GearCategory {
        HELMET("Armor (Helmet)"),
        CHESTPLATE("Armor (Chest)"),
        LEGGINGS("Armor (Leggings)"),
        BOOTS("Armor (Boots)"),
        SHIELD("Shield"),
        WEAPON("Weapons");

        static final List<GearCategory> ORDERED;
        private final String displayName;

        private GearCategory(String displayName) {
            this.displayName = displayName;
        }

        String getDisplayName() {
            return this.displayName;
        }

        static GearCategory fromStack(class_1799 stack) {
            class_1792 item = stack.method_7909();
            class_1304 slot = ItemUtils.getArmorSlot(item);
            if (slot != null) {
                return switch (slot) {
                    case class_1304.field_6169 -> HELMET;
                    case class_1304.field_6174 -> CHESTPLATE;
                    case class_1304.field_6172 -> LEGGINGS;
                    case class_1304.field_6166 -> BOOTS;
                    case class_1304.field_6171 -> {
                        if (stack.method_31574(class_1802.field_8255)) {
                            yield SHIELD;
                        }
                        yield null;
                    }
                    default -> null;
                };
            }
            if (stack.method_31574(class_1802.field_8255)) {
                return SHIELD;
            }
            if (stack.method_31574(class_1802.field_8547) || stack.method_31574(class_1802.field_8102) || stack.method_31574(class_1802.field_8399)) {
                return WEAPON;
            }
            class_10590 weapon = (class_10590)stack.method_57353().method_58694(class_9334.field_55878);
            if (weapon != null) {
                return WEAPON;
            }
            return null;
        }

        static {
            ORDERED = List.of(GearCategory.values());
        }
    }

    private static enum BookCategory {
        HELMET("Armor (Helmet)", "respiration", "aqua_affinity"),
        CHEST("Armor (Chest)", "protection", "fire_protection", "blast_protection", "projectile_protection", "thorns"),
        LEGGINGS("Armor (Leggings)", "swift_sneak"),
        BOOTS("Armor (Boots)", "feather_falling", "depth_strider", "frost_walker", "soul_speed"),
        WEAPON("Weapons", "sharpness", "smite", "bane_of_arthropods", "knockback", "looting", "fire_aspect", "sweeping", "sweeping_edge", "breach", "density", "wind_burst"),
        TOOLS("Tools", "efficiency", "silk_touch", "fortune"),
        BOW("Bow", "power", "punch", "flame", "infinity"),
        CROSSBOW("Crossbow", "piercing", "quick_charge", "multishot"),
        TRIDENT("Trident", "impaling", "riptide", "channeling", "loyalty"),
        SHIELD("Shield", "bulwark"),
        ELYTRA("Elytra", "wind_burst"),
        MISC("Misc", "mending", "unbreaking", "binding_curse", "vanishing_curse", "lure", "luck_of_the_sea");

        static final List<BookCategory> ORDERED;
        private final String displayName;
        private final Set<String> enchantIds;

        private BookCategory(String displayName, String ... enchantIds) {
            this.displayName = displayName;
            this.enchantIds = Set.of(enchantIds);
        }

        String getDisplayName() {
            return this.displayName;
        }

        static BookCategory fromPath(String path) {
            if (path == null || path.isEmpty()) {
                return MISC;
            }
            for (BookCategory category : ORDERED) {
                if (!category.enchantIds.contains(path)) continue;
                return category;
            }
            return MISC;
        }

        static {
            ORDERED = List.of(BookCategory.values());
        }
    }

    private static enum PotionCategory {
        NORMAL("Potions (Normal)"),
        SPLASH("Potions (Splash)"),
        LINGERING("Potions (Lingering)");

        static final List<PotionCategory> ORDERED;
        private final String displayName;

        private PotionCategory(String displayName) {
            this.displayName = displayName;
        }

        String getDisplayName() {
            return this.displayName;
        }

        static PotionCategory fromItem(class_1792 item) {
            if (item == class_1802.field_8574) {
                return NORMAL;
            }
            if (item == class_1802.field_8436) {
                return SPLASH;
            }
            if (item == class_1802.field_8150) {
                return LINGERING;
            }
            return null;
        }

        static {
            ORDERED = List.of(PotionCategory.values());
        }
    }

    private static final class Hitbox {
        final int x;
        final int y;
        final int width;
        final int height;
        final AbstractEntry entry;
        final CategoryKind categoryKind;
        final Object category;
        final String source;

        private Hitbox(int x, int y, int width, int height, AbstractEntry entry, CategoryKind categoryKind, Object category, String source) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.entry = entry;
            this.categoryKind = categoryKind;
            this.category = category;
            this.source = source;
        }

        static Hitbox forEntry(int x, int y, int width, int height, AbstractEntry entry) {
            return new Hitbox(x, y, width, height, entry, null, null, "Container");
        }

        static Hitbox forCategory(int x, int y, int width, int height, CategoryKind kind, Object category, String source) {
            return new Hitbox(x, y, width, height, null, kind, category, source);
        }

        boolean contains(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
        }
    }

    private static abstract class AbstractEntry {
        final int slotId;
        final int displaySlot;
        final String line;

        AbstractEntry(int slotId, int displaySlot, String line) {
            this.slotId = slotId;
            this.displaySlot = displaySlot;
            this.line = line;
        }
    }

    private static final class GearEntry
    extends AbstractEntry {
        final GearCategory category;

        GearEntry(int slotId, int displaySlot, GearCategory category, String line) {
            super(slotId, displaySlot, line);
            this.category = Objects.requireNonNull(category);
        }
    }

    private static final class BookEntry
    extends AbstractEntry {
        final BookCategory category;

        BookEntry(int slotId, int displaySlot, BookCategory category, String line) {
            super(slotId, displaySlot, line);
            this.category = Objects.requireNonNull(category);
        }
    }

    private static final class PotionEntry
    extends AbstractEntry {
        final PotionCategory category;
        final String primaryName;
        final int primaryLevel;
        final int primaryDuration;

        PotionEntry(int slotId, int displaySlot, PotionCategory category, String line, String primaryName, int primaryLevel, int primaryDuration) {
            super(slotId, displaySlot, line);
            this.category = Objects.requireNonNull(category);
            this.primaryName = primaryName != null ? primaryName : "";
            this.primaryLevel = primaryLevel;
            this.primaryDuration = primaryDuration;
        }
    }

    private static enum CategoryKind {
        GEAR,
        BOOK,
        POTION;

    }
}

