/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_7923;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.events.CameraTransformViewBobbingListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.EntityTypeListSetting;
import net.wurstclient.settings.EnumSetting;
import net.wurstclient.settings.EspBoxSizeSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.settings.TextFieldSetting;
import net.wurstclient.util.EntityUtils;
import net.wurstclient.util.RenderUtils;

@SearchTags(value={"mobsearch", "mob search", "entity search", "mob esp search"})
public final class MobSearchHack
extends Hack
implements UpdateListener,
CameraTransformViewBobbingListener,
RenderListener {
    private static final int MAX_TEXT_LENGTH = 256;
    private final EnumSetting<SearchMode> mode = new EnumSetting("Mode", (Enum[])SearchMode.values(), (Enum)SearchMode.TYPE_ID);
    private final EntityTypeListSetting entityList = new EntityTypeListSetting("Entity List", "Entities to match when Mode is set to List.");
    private final MobSearchStyleSetting style = new MobSearchStyleSetting();
    private final EspBoxSizeSetting boxSize = new EspBoxSizeSetting("Box size", "\u00a7lAccurate\u00a7r mode shows the exact hitbox of each mob.\n\u00a7lFancy\u00a7r mode shows slightly larger boxes that look better.", EspBoxSizeSetting.BoxSize.ACCURATE);
    private final CheckboxSetting fillShapes = new CheckboxSetting("Fill shapes", "Render filled versions of the ESP shapes.", true);
    private final TextFieldSetting typeId = new TextFieldSetting("Type", "The entity type to match when Query is empty (e.g. minecraft:zombie or zombie).", "minecraft:zombie", v -> v.length() <= 256);
    private final TextFieldSetting query = new TextFieldSetting("Query", "Enter text to match entity IDs or names by keyword. Separate multiple terms with commas.", "", v -> v.length() <= 256);
    private final CheckboxSetting useRainbow = new CheckboxSetting("Rainbow colors", "Use a rainbow color instead of the fixed color.", false);
    private final CheckboxSetting onlyAboveGround = new CheckboxSetting("Above ground only", "Only show mobs at or above the configured Y level.", false);
    private final SliderSetting aboveGroundY = new SliderSetting("Set ESP Y limit", 62.0, -65.0, 255.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final ColorSetting color = new ColorSetting("Color", "Fixed color used when Rainbow colors is disabled.", Color.PINK);
    private final CheckboxSetting showCountInHackList = new CheckboxSetting("HackList count", "Appends the number of matched mobs to this hack's entry in the HackList.", false);
    private final ArrayList<class_1309> matches = new ArrayList();
    private SearchMode lastMode;
    private int lastEntityListHash;
    private Set<String> listExactIds;
    private String[] listKeywords;
    private int foundCount;

    public MobSearchHack() {
        super("MobSearch");
        this.setCategory(Category.RENDER);
        this.addSetting(this.mode);
        this.addSetting(this.entityList);
        this.addSetting(this.style);
        this.addSetting(this.boxSize);
        this.addSetting(this.fillShapes);
        this.addSetting(this.typeId);
        this.addSetting(this.query);
        this.addSetting(this.useRainbow);
        this.addSetting(this.onlyAboveGround);
        this.addSetting(this.aboveGroundY);
        this.addSetting(this.color);
        this.addSetting(this.showCountInHackList);
    }

    @Override
    protected void onEnable() {
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(CameraTransformViewBobbingListener.class, this);
        EVENTS.add(RenderListener.class, this);
        this.lastMode = this.mode.getSelected();
        this.lastEntityListHash = this.entityList.getTypeNames().hashCode();
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(CameraTransformViewBobbingListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        this.matches.clear();
        this.foundCount = 0;
    }

    @Override
    public String getRenderName() {
        String q = this.query.getValue().trim();
        switch (this.mode.getSelected().ordinal()) {
            case 0: {
                return this.appendCountIfEnabled(this.getName() + " [List:" + this.entityList.getTypeNames().size() + "]");
            }
            case 2: {
                if (!q.isEmpty()) {
                    return this.appendCountIfEnabled(this.getName() + " [" + this.abbreviate(q) + "]");
                }
                return this.appendCountIfEnabled(this.getName() + " [query]");
            }
        }
        String t = this.typeId.getValue().trim();
        if (t.startsWith("minecraft:")) {
            t = t.substring("minecraft:".length());
        }
        return this.appendCountIfEnabled(this.getName() + " [" + t + "]");
    }

    @Override
    public void onUpdate() {
        Predicate<class_1309> predicate;
        this.matches.clear();
        SearchMode currentMode = this.mode.getSelected();
        if (currentMode != this.lastMode) {
            this.lastMode = currentMode;
        }
        if (currentMode == SearchMode.LIST) {
            int h = this.entityList.getTypeNames().hashCode();
            if (h != this.lastEntityListHash) {
                this.lastEntityListHash = h;
            }
            HashSet<String> exact = new HashSet<String>();
            ArrayList<String> kw = new ArrayList<String>();
            for (String s : this.entityList.getTypeNames()) {
                String raw;
                if (s == null || (raw = s.trim()).isEmpty()) continue;
                class_2960 id = class_2960.method_12829((String)raw);
                if (id != null && class_7923.field_41177.method_10250(id)) {
                    exact.add(id.toString());
                    continue;
                }
                kw.add(raw.toLowerCase(Locale.ROOT));
            }
            this.listExactIds = exact;
            this.listKeywords = kw.toArray(new String[0]);
        }
        switch (currentMode.ordinal()) {
            case 0: {
                predicate = e -> {
                    String idFull;
                    class_2960 id = class_7923.field_41177.method_10221((Object)e.method_5864());
                    String string = idFull = id == null ? "" : id.toString();
                    if (this.listExactIds != null && this.listExactIds.contains(idFull)) {
                        return true;
                    }
                    String local = idFull.contains(":") ? idFull.substring(idFull.indexOf(":") + 1) : idFull;
                    String localSpaced = local.replace('_', ' ');
                    String transKey = e.method_5864().method_5882();
                    String display = e.method_5864().method_5897().getString();
                    if (this.listKeywords != null) {
                        for (String term : this.listKeywords) {
                            if (!this.containsNormalized(idFull, term) && !this.containsNormalized(local, term) && !this.containsNormalized(localSpaced, term) && !this.containsNormalized(transKey, term) && !this.containsNormalized(display, term)) continue;
                            return true;
                        }
                    }
                    return false;
                };
                break;
            }
            case 2: {
                predicate = this.byFuzzyQuery(this.normalize(this.query.getValue()));
                break;
            }
            default: {
                predicate = this.byExactType(this.normalize(this.typeId.getValue()));
            }
        }
        Stream<class_1309> stream = StreamSupport.stream(MobSearchHack.MC.field_1687.method_18112().spliterator(), false).filter(class_1309.class::isInstance).map(e -> (class_1309)e).filter(e -> !(e instanceof class_1657)).filter(e -> !e.method_31481() && e.method_6032() > 0.0f).filter(predicate);
        if (this.onlyAboveGround.isChecked()) {
            stream = stream.filter(e -> e.method_23318() >= this.aboveGroundY.getValue());
        }
        this.matches.addAll(stream.collect(Collectors.toList()));
        this.foundCount = Math.min(this.matches.size(), 999);
    }

    private String appendCountIfEnabled(String base) {
        if (this.showCountInHackList.isChecked() && this.foundCount > 0) {
            return base + " [" + this.foundCount + "]";
        }
        return base;
    }

    @Override
    public void onCameraTransformViewBobbing(CameraTransformViewBobbingListener.CameraTransformViewBobbingEvent event) {
        if (this.style.hasLines()) {
            event.cancel();
        }
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        ArrayList<RenderUtils.ColoredPoint> ends;
        if (this.matches.isEmpty()) {
            return;
        }
        MobSearchStyleSetting.Shape shape = this.style.getShape();
        boolean glowMode = shape == MobSearchStyleSetting.Shape.GLOW;
        boolean drawShape = !glowMode && shape != MobSearchStyleSetting.Shape.NONE;
        boolean drawLines = this.style.hasLines();
        boolean drawFill = drawShape && this.fillShapes.isChecked();
        ArrayList<RenderUtils.ColoredBox> outlineShapes = drawShape ? new ArrayList<RenderUtils.ColoredBox>(this.matches.size()) : null;
        ArrayList<RenderUtils.ColoredBox> filledShapes = drawFill ? new ArrayList<RenderUtils.ColoredBox>(this.matches.size()) : null;
        ArrayList<RenderUtils.ColoredPoint> arrayList = ends = drawLines ? new ArrayList<RenderUtils.ColoredPoint>(this.matches.size()) : null;
        if (drawShape || drawLines) {
            double extra = drawShape ? (double)this.boxSize.getExtraSize() / 2.0 : 0.0;
            for (class_1309 e : this.matches) {
                class_238 lerpedBox = EntityUtils.getLerpedBox((class_1297)e, partialTicks);
                int outlineColor = this.getColorI(0.5f);
                if (drawShape) {
                    class_238 box = lerpedBox.method_989(0.0, extra, 0.0).method_1014(extra);
                    outlineShapes.add(new RenderUtils.ColoredBox(box, outlineColor));
                    if (filledShapes != null) {
                        int fillColor = this.getColorI(0.15f);
                        filledShapes.add(new RenderUtils.ColoredBox(box, fillColor));
                    }
                }
                if (!drawLines || ends == null) continue;
                ends.add(new RenderUtils.ColoredPoint(lerpedBox.method_1005(), outlineColor));
            }
        }
        if (!glowMode) {
            if (filledShapes != null && !filledShapes.isEmpty()) {
                switch (shape.ordinal()) {
                    case 1: {
                        RenderUtils.drawSolidBoxes(matrixStack, filledShapes, false);
                        break;
                    }
                    case 2: {
                        RenderUtils.drawSolidOctahedrons(matrixStack, filledShapes, false);
                        break;
                    }
                }
            }
            if (outlineShapes != null && !outlineShapes.isEmpty()) {
                switch (shape.ordinal()) {
                    case 1: {
                        RenderUtils.drawOutlinedBoxes(matrixStack, outlineShapes, false);
                        break;
                    }
                    case 2: {
                        RenderUtils.drawOutlinedOctahedrons(matrixStack, outlineShapes, false);
                        break;
                    }
                }
            }
        }
        if (ends != null && !ends.isEmpty()) {
            RenderUtils.drawTracers(matrixStack, partialTicks, ends, false);
        }
    }

    private int getColorI(float alpha) {
        if (this.useRainbow.isChecked()) {
            float[] rgb = RenderUtils.getRainbowColor();
            return RenderUtils.toIntColor(rgb, alpha);
        }
        return RenderUtils.toIntColor(this.color.getColorF(), alpha);
    }

    private Predicate<class_1309> byExactType(String normalizedType) {
        return e -> {
            class_2960 id = class_7923.field_41177.method_10221((Object)e.method_5864());
            String s = id == null ? "" : id.toString().toLowerCase(Locale.ROOT);
            String local = s.contains(":") ? s.substring(s.indexOf(":") + 1) : s;
            return s.equals(normalizedType) || local.equals(normalizedType);
        };
    }

    private Predicate<class_1309> byFuzzyQuery(String q) {
        String[] terms = (String[])Stream.of(q.split(",")).map(String::trim).filter(s -> !s.isEmpty()).toArray(String[]::new);
        return e -> {
            class_2960 id = class_7923.field_41177.method_10221((Object)e.method_5864());
            String s = id == null ? "" : id.toString();
            String local = s.contains(":") ? s.substring(s.indexOf(":") + 1) : s;
            String localSpaced = local.replace('_', ' ');
            String transKey = e.method_5864().method_5882();
            String display = e.method_5864().method_5897().getString();
            for (String term : terms) {
                if (!this.containsNormalized(s, term) && !this.containsNormalized(local, term) && !this.containsNormalized(localSpaced, term) && !this.containsNormalized(transKey, term) && !this.containsNormalized(display, term)) continue;
                return true;
            }
            return false;
        };
    }

    private String normalize(String s) {
        if (s == null) {
            return "";
        }
        return s.trim().toLowerCase(Locale.ROOT);
    }

    private boolean containsNormalized(String haystack, String needle) {
        return haystack != null && haystack.toLowerCase(Locale.ROOT).contains(needle);
    }

    private String abbreviate(String text) {
        if (text.length() <= 32) {
            return text;
        }
        return text.substring(0, 32) + "...";
    }

    public Integer getGlowColor(class_1309 entity) {
        if (!this.isEnabled()) {
            return null;
        }
        if (this.style.getShape() != MobSearchStyleSetting.Shape.GLOW) {
            return null;
        }
        if (!this.matches.contains(entity)) {
            return null;
        }
        return this.getColorI(1.0f);
    }

    private static enum SearchMode {
        LIST,
        TYPE_ID,
        QUERY;

    }

    private static final class MobSearchStyleSetting
    extends EnumSetting<Style> {
        private MobSearchStyleSetting() {
            super("Style", (Enum[])Style.values(), (Enum)Style.LINES_AND_GLOW);
        }

        public Shape getShape() {
            return ((Style)((Object)this.getSelected())).shape;
        }

        public boolean hasLines() {
            return ((Style)((Object)this.getSelected())).lines;
        }

        private static enum Style {
            BOXES("Boxes only", Shape.BOX, false),
            OCTAHEDRONS("Octahedrons only", Shape.OCTAHEDRON, false),
            LINES("Lines only", Shape.NONE, true),
            LINES_AND_BOXES("Lines and boxes", Shape.BOX, true),
            LINES_AND_OCTAHEDRONS("Lines and octahedrons", Shape.OCTAHEDRON, true),
            GLOW("Glow only", Shape.GLOW, false),
            LINES_AND_GLOW("Lines and glow", Shape.GLOW, true);

            private final String name;
            private final Shape shape;
            private final boolean lines;

            private Style(String name, Shape shape, boolean lines) {
                this.name = name;
                this.shape = shape;
                this.lines = lines;
            }

            public String toString() {
                return this.name;
            }
        }

        static enum Shape {
            NONE,
            BOX,
            OCTAHEDRON,
            GLOW;

        }
    }
}

