/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.events.IsPlayerInLavaListener;
import net.wurstclient.events.IsPlayerInWaterListener;
import net.wurstclient.events.VelocityFromFluidListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.CheckboxSetting;

@SearchTags(value={"no slowdown", "no slow down"})
public final class NoSlowdownHack
extends Hack
implements IsPlayerInLavaListener,
IsPlayerInWaterListener,
VelocityFromFluidListener {
    private final CheckboxSetting lavaSpeed = new CheckboxSetting("No lava slowdown", "Removes lava movement penalties.\nSome servers treat this like a speedhack.", false);
    private final CheckboxSetting waterSpeed = new CheckboxSetting("No water slowdown", "Removes water movement penalties.\nSome servers treat this like a speedhack.", false);
    private boolean bypassingLava;
    private boolean bypassingWater;

    public NoSlowdownHack() {
        super("NoSlowdown");
        this.setCategory(Category.MOVEMENT);
        this.addSetting(this.lavaSpeed);
        this.addSetting(this.waterSpeed);
    }

    @Override
    protected void onEnable() {
        EVENTS.add(IsPlayerInLavaListener.class, this);
        EVENTS.add(IsPlayerInWaterListener.class, this);
        EVENTS.add(VelocityFromFluidListener.class, this);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(IsPlayerInLavaListener.class, this);
        EVENTS.remove(IsPlayerInWaterListener.class, this);
        EVENTS.remove(VelocityFromFluidListener.class, this);
        this.bypassingLava = false;
        this.bypassingWater = false;
    }

    @Override
    public void onIsPlayerInLava(IsPlayerInLavaListener.IsPlayerInLavaEvent event) {
        if (!this.lavaSpeed.isChecked()) {
            this.bypassingLava = false;
            return;
        }
        if (event.isNormallyInLava()) {
            this.bypassingLava = true;
            event.setInLava(false);
            return;
        }
        this.bypassingLava = false;
    }

    @Override
    public void onIsPlayerInWater(IsPlayerInWaterListener.IsPlayerInWaterEvent event) {
        if (!this.waterSpeed.isChecked()) {
            this.bypassingWater = false;
            return;
        }
        if (event.isNormallyInWater()) {
            this.bypassingWater = true;
            event.setInWater(false);
            return;
        }
        this.bypassingWater = false;
    }

    @Override
    public void onVelocityFromFluid(VelocityFromFluidListener.VelocityFromFluidEvent event) {
        boolean cancelWater;
        boolean cancelLava = this.lavaSpeed.isChecked() && this.bypassingLava;
        boolean bl = cancelWater = this.waterSpeed.isChecked() && this.bypassingWater;
        if (!cancelLava && !cancelWater) {
            return;
        }
        if (event.getEntity() != NoSlowdownHack.MC.field_1724) {
            return;
        }
        event.cancel();
    }
}

