/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_7417;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.events.CameraTransformViewBobbingListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.EnumSetting;
import net.wurstclient.settings.EspBoxSizeSetting;
import net.wurstclient.settings.Setting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.settings.filterlists.EntityFilterList;
import net.wurstclient.settings.filters.FilterInvisibleSetting;
import net.wurstclient.settings.filters.FilterSleepingSetting;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.EntityUtils;
import net.wurstclient.util.FakePlayerEntity;
import net.wurstclient.util.PlayerColorRegistry;
import net.wurstclient.util.PlayerRangeAlertManager;
import net.wurstclient.util.RenderUtils;

@SearchTags(value={"player esp", "PlayerTracers", "player tracers"})
public final class PlayerEspHack
extends Hack
implements UpdateListener,
CameraTransformViewBobbingListener,
RenderListener {
    private final PlayerEspStyleSetting style = new PlayerEspStyleSetting(PlayerEspStyleSetting.Style.LINES_AND_GLOW);
    private final EspBoxSizeSetting boxSize = new EspBoxSizeSetting("\u00a7lAccurate\u00a7r mode shows the exact hitbox of each player.\n\u00a7lFancy\u00a7r mode shows slightly larger boxes that look better.");
    private final EntityFilterList entityFilters = new EntityFilterList(new FilterSleepingSetting("Won't show sleeping players.", false), new FilterInvisibleSetting("Won't show invisible players.", false));
    private final ArrayList<class_1657> players = new ArrayList();
    private final Map<UUID, PendingEnterAlert> pendingEnterAlerts = new HashMap<UUID, PendingEnterAlert>();
    private final CheckboxSetting enterAlert = new CheckboxSetting("Enter alert", "When enabled, notifies in chat when a player first becomes visible\nto PlayerESP, showing distance and XYZ.", false);
    private final CheckboxSetting exitAlert = new CheckboxSetting("Exit alert", "When enabled, notifies in chat when a player leaves PlayerESP\nvisibility, showing distance and XYZ at which they left.", false);
    private final PlayerRangeAlertManager alertManager = WURST.getPlayerRangeAlertManager();
    private final PlayerRangeAlertManager.Listener alertListener = new PlayerRangeAlertManager.Listener(){

        @Override
        public void onPlayerEnter(class_1657 player, PlayerRangeAlertManager.PlayerInfo info) {
            if (!PlayerEspHack.this.isEnabled() || !PlayerEspHack.this.enterAlert.isChecked()) {
                return;
            }
            PlayerEspHack.this.pendingEnterAlerts.remove(info.getUuid());
            if (PlayerEspHack.this.ignoreNpcs.isChecked()) {
                if (PlayerEspHack.this.shouldIgnoreNpcCandidate(info)) {
                    return;
                }
                PlayerEspHack.this.pendingEnterAlerts.put(info.getUuid(), new PendingEnterAlert(info, class_156.method_658()));
                return;
            }
            PlayerEspHack.this.sendEnterMessage(info);
        }

        @Override
        public void onPlayerExit(PlayerRangeAlertManager.PlayerInfo info) {
            PlayerEspHack.this.pendingEnterAlerts.remove(info.getUuid());
            if (!PlayerEspHack.this.isEnabled() || !PlayerEspHack.this.exitAlert.isChecked()) {
                return;
            }
            if (PlayerEspHack.this.ignoreNpcs.isChecked() && (info.isProbablyNpc() || PlayerEspHack.this.isMissingIdentity(info))) {
                return;
            }
            PlayerEspHack.this.sendExitMessage(info);
        }
    };
    private final CheckboxSetting randomBrightColors = new CheckboxSetting("Unique colors for players", "When enabled, assigns each player a bright color from a shared\npalette and forces it into the shared color registry.\nPlayerESP takes ownership of these colors (overrides Breadcrumbs).", false);
    private final CheckboxSetting losThreatDetection = new CheckboxSetting("Line-of-sight detection", "Highlights players who currently have direct line of sight on you\nand temporarily overrides their ESP color.", false);
    private final SliderSetting losThreatFov = new SliderSetting("LOS FOV (degrees)", 140.0, 30.0, 180.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting losThreatRange = new SliderSetting("LOS detection range", 100.0, 16.0, 100.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final CheckboxSetting ignoreNpcs = new CheckboxSetting("Ignore NPCs", "When enabled, players not present on the client's tab-list are\nconsidered likely NPCs and will be ignored. This filters common\nserver-side NPCs but may hide real players who are intentionally\nhidden from the tab-list.", true);
    private final SliderSetting tracerThickness = new SliderSetting("Tracer thickness", 2.0, 0.5, 8.0, 0.1, SliderSetting.ValueDisplay.DECIMAL.withSuffix("px"));
    private final CheckboxSetting filledBoxes = new CheckboxSetting("Filled boxes", "When enabled, renders solid filled boxes instead of outlined boxes.", false);
    private final CheckboxSetting useStaticPlayerColor = new CheckboxSetting("Use static player color", "When enabled, uses the selected static color for all players and\nforces it into the shared color registry. PlayerESP owns the\nassignment while this is enabled (will override Breadcrumbs).", false);
    private final ColorSetting playerColor = new ColorSetting("Player color", "Static color used when 'Use static player color' is enabled.", new Color(255, 196, 64));
    private final SliderSetting filledAlpha = new SliderSetting("Filled box alpha", 35.0, 0.0, 100.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final Map<UUID, LosState> losStates = new HashMap<UUID, LosState>();
    private static final long LOS_HOLD_MS = 250L;
    private static final long LOS_FADE_MS = 120L;
    private static final double THREAT_LINE_WIDTH = 4.0;
    private static final long NPC_CONFIRM_DELAY_MS = 400L;

    public PlayerEspHack() {
        super("PlayerESP");
        this.setCategory(Category.RENDER);
        this.addSetting(this.style);
        this.addSetting(this.randomBrightColors);
        this.addSetting(this.losThreatDetection);
        this.addSetting(this.losThreatFov);
        this.addSetting(this.losThreatRange);
        this.addSetting(this.tracerThickness);
        this.addSetting(this.filledBoxes);
        this.addSetting(this.filledAlpha);
        this.addSetting(this.useStaticPlayerColor);
        this.addSetting(this.playerColor);
        this.addSetting(this.boxSize);
        this.addSetting(this.enterAlert);
        this.addSetting(this.exitAlert);
        this.entityFilters.forEach(x$0 -> this.addSetting((Setting)x$0));
        this.addSetting(this.ignoreNpcs);
    }

    @Override
    protected void onEnable() {
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(CameraTransformViewBobbingListener.class, this);
        EVENTS.add(RenderListener.class, this);
        this.alertManager.addListener(this.alertListener);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(CameraTransformViewBobbingListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        this.alertManager.removeListener(this.alertListener);
        this.losStates.clear();
        this.pendingEnterAlerts.clear();
    }

    @Override
    public void onUpdate() {
        this.players.clear();
        Stream<class_742> stream = PlayerEspHack.MC.field_1687.method_18456().parallelStream().filter(e -> !e.method_31481() && e.method_6032() > 0.0f).filter(e -> e != PlayerEspHack.MC.field_1724).filter(e -> !(e instanceof FakePlayerEntity)).filter(e -> Math.abs(e.method_23318() - PlayerEspHack.MC.field_1724.method_23318()) <= 1000000.0);
        if (this.ignoreNpcs.isChecked()) {
            stream = stream.filter(e -> {
                if (MC.method_1562() == null) {
                    return true;
                }
                return MC.method_1562().method_2871(e.method_5667()) != null;
            });
        }
        stream = this.entityFilters.applyTo(stream);
        this.players.addAll(stream.collect(Collectors.toList()));
        long now = class_156.method_658();
        if (this.losThreatDetection.isChecked()) {
            this.updateLosStates(now);
        } else {
            this.losStates.clear();
        }
        this.processPendingEnterAlerts(now);
    }

    private void processPendingEnterAlerts(long now) {
        if (this.pendingEnterAlerts.isEmpty()) {
            return;
        }
        if (!this.enterAlert.isChecked()) {
            this.pendingEnterAlerts.clear();
            return;
        }
        if (!this.ignoreNpcs.isChecked()) {
            for (PendingEnterAlert alert : this.pendingEnterAlerts.values()) {
                this.sendEnterMessage(alert.info);
            }
            this.pendingEnterAlerts.clear();
            return;
        }
        if (PlayerEspHack.MC.field_1724 == null || PlayerEspHack.MC.field_1687 == null) {
            this.pendingEnterAlerts.clear();
            return;
        }
        Iterator<Map.Entry<UUID, PendingEnterAlert>> it = this.pendingEnterAlerts.entrySet().iterator();
        while (it.hasNext()) {
            PendingEnterAlert alert = it.next().getValue();
            if (this.shouldIgnoreNpcCandidate(alert.info)) {
                it.remove();
                continue;
            }
            if (now - alert.createdAt < 400L) continue;
            this.sendEnterMessage(alert.info);
            it.remove();
        }
    }

    private void sendEnterMessage(PlayerRangeAlertManager.PlayerInfo info) {
        if (PlayerEspHack.MC.field_1724 == null) {
            return;
        }
        String rawName = info.getName();
        if (rawName == null) {
            return;
        }
        String trimmedName = rawName.trim();
        if (trimmedName.isEmpty()) {
            return;
        }
        UUID id = info.getUuid();
        class_243 pos = info.getLastPos();
        double dist = pos == null ? -1.0 : (double)Math.round(pos.method_1022(new class_243(PlayerEspHack.MC.field_1724.method_23317(), PlayerEspHack.MC.field_1724.method_23318(), PlayerEspHack.MC.field_1724.method_23321())) * 10.0) / 10.0;
        int x = pos == null ? 0 : (int)Math.round(pos.field_1352);
        int y = pos == null ? 0 : (int)Math.round(pos.field_1351);
        int z = pos == null ? 0 : (int)Math.round(pos.field_1350);
        class_5250 nameText = class_5250.method_43477((class_7417)class_2561.method_43470((String)trimmedName).method_10851());
        if (this.randomBrightColors.isChecked()) {
            int idx = Math.abs(id.hashCode());
            Color gen = PlayerColorRegistry.generateBrightColor(idx);
            nameText.method_10862(nameText.method_10866().method_27703(class_5251.method_27717((int)(gen.getRed() << 16 | gen.getGreen() << 8 | gen.getBlue()))));
        }
        Object distStr = dist < 0.0 ? "unknown" : dist + " blocks";
        class_5250 msg = nameText.method_10852((class_2561)class_2561.method_43470((String)(" entered range (" + (String)distStr + ") at " + x + ", " + y + ", " + z + ".")).method_27694(s -> s.method_27703(class_5251.method_27718((class_124)class_124.field_1068))));
        ChatUtils.component((class_2561)msg);
    }

    private boolean shouldIgnoreNpcCandidate(PlayerRangeAlertManager.PlayerInfo info) {
        if (info == null) {
            return true;
        }
        if (info.isProbablyNpc()) {
            return true;
        }
        if (this.isMissingIdentity(info)) {
            return true;
        }
        return MC != null && MC.method_1562() != null && MC.method_1562().method_2871(info.getUuid()) == null;
    }

    private boolean isMissingIdentity(PlayerRangeAlertManager.PlayerInfo info) {
        if (info == null) {
            return true;
        }
        String name = info.getName();
        return name == null || name.trim().isEmpty();
    }

    private void sendExitMessage(PlayerRangeAlertManager.PlayerInfo info) {
        if (PlayerEspHack.MC.field_1724 == null) {
            return;
        }
        class_243 pos = info.getLastPos();
        double dist = pos == null ? -1.0 : (double)Math.round(pos.method_1022(new class_243(PlayerEspHack.MC.field_1724.method_23317(), PlayerEspHack.MC.field_1724.method_23318(), PlayerEspHack.MC.field_1724.method_23321())) * 10.0) / 10.0;
        int x = pos == null ? 0 : (int)Math.round(pos.field_1352);
        int y = pos == null ? 0 : (int)Math.round(pos.field_1351);
        int z = pos == null ? 0 : (int)Math.round(pos.field_1350);
        String rawName = info.getName();
        if (rawName == null) {
            return;
        }
        String trimmedName = rawName.trim();
        if (trimmedName.isEmpty()) {
            return;
        }
        class_5250 nameText = class_5250.method_43477((class_7417)class_2561.method_43470((String)trimmedName).method_10851());
        if (this.randomBrightColors.isChecked()) {
            int idx = Math.abs(info.getUuid().hashCode());
            Color gen = PlayerColorRegistry.generateBrightColor(idx);
            nameText.method_10862(nameText.method_10866().method_27703(class_5251.method_27717((int)(gen.getRed() << 16 | gen.getGreen() << 8 | gen.getBlue()))));
        }
        Object distStr = dist < 0.0 ? "unknown" : dist + " blocks";
        class_5250 msg = nameText.method_10852((class_2561)class_2561.method_43470((String)(" left range (" + (String)distStr + ") at " + x + ", " + y + ", " + z + ".")).method_27694(s -> s.method_27703(class_5251.method_27718((class_124)class_124.field_1068))));
        ChatUtils.component((class_2561)msg);
    }

    @Override
    public void onCameraTransformViewBobbing(CameraTransformViewBobbingListener.CameraTransformViewBobbingEvent event) {
        if (this.style.hasLines()) {
            event.cancel();
        }
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        long now = class_156.method_658();
        HashMap<UUID, PlayerVisual> visualCache = new HashMap<UUID, PlayerVisual>(this.players.size());
        if (this.style.hasBoxes()) {
            double extraSize = this.boxSize.getExtraSize() / 2.0f;
            ArrayList normalOutline = new ArrayList();
            ArrayList<RenderUtils.ColoredBox> threatOutline = new ArrayList<RenderUtils.ColoredBox>();
            ArrayList<RenderUtils.ColoredBox> solid = this.filledBoxes.isChecked() ? new ArrayList<RenderUtils.ColoredBox>(this.players.size()) : null;
            for (class_1657 e : this.players) {
                class_238 box = EntityUtils.getLerpedBox((class_1297)e, partialTicks).method_989(0.0, extraSize, 0.0).method_1014(extraSize);
                PlayerVisual visual = visualCache.computeIfAbsent(e.method_5667(), id -> this.getVisual(e, now));
                int boxColor = visual.boxColor();
                if (this.filledBoxes.isChecked()) {
                    int rgb = boxColor & 0xFFFFFF;
                    int solidAlpha = (int)(this.filledAlpha.getValue() / 100.0 * 255.0) << 24;
                    int solidColor = rgb | solidAlpha;
                    if (solid != null) {
                        solid.add(new RenderUtils.ColoredBox(box, solidColor));
                    }
                    int outlineColor = rgb | 0xFF000000;
                    RenderUtils.ColoredBox outlineBox = new RenderUtils.ColoredBox(box, outlineColor);
                    if (visual.isThreat()) {
                        threatOutline.add(outlineBox);
                        continue;
                    }
                    normalOutline.add(outlineBox);
                    continue;
                }
                RenderUtils.ColoredBox cb = new RenderUtils.ColoredBox(box, boxColor);
                if (visual.isThreat()) {
                    threatOutline.add(cb);
                    continue;
                }
                normalOutline.add(cb);
            }
            if (this.filledBoxes.isChecked()) {
                if (solid != null && !solid.isEmpty()) {
                    RenderUtils.drawSolidBoxes(matrixStack, solid, false);
                }
                if (!normalOutline.isEmpty()) {
                    RenderUtils.drawOutlinedBoxes(matrixStack, normalOutline, false);
                }
                if (!threatOutline.isEmpty()) {
                    RenderUtils.drawOutlinedBoxes(matrixStack, threatOutline, false, 4.0);
                }
            } else {
                if (!normalOutline.isEmpty()) {
                    RenderUtils.drawOutlinedBoxes(matrixStack, normalOutline, false);
                }
                if (!threatOutline.isEmpty()) {
                    RenderUtils.drawOutlinedBoxes(matrixStack, threatOutline, false, 4.0);
                }
            }
        }
        if (this.style.hasLines()) {
            ArrayList<RenderUtils.ColoredPoint> normalEnds = new ArrayList<RenderUtils.ColoredPoint>(this.players.size());
            ArrayList<RenderUtils.ColoredPoint> threatEnds = new ArrayList<RenderUtils.ColoredPoint>();
            for (class_1657 e : this.players) {
                PlayerVisual visual = visualCache.computeIfAbsent(e.method_5667(), id -> this.getVisual(e, now));
                class_243 point = EntityUtils.getLerpedBox((class_1297)e, partialTicks).method_1005();
                RenderUtils.ColoredPoint colored = new RenderUtils.ColoredPoint(point, visual.tracerColor());
                if (visual.isThreat()) {
                    threatEnds.add(colored);
                    continue;
                }
                normalEnds.add(colored);
            }
            double normalLineWidth = this.tracerThickness.getValue();
            double threatLineWidth = normalLineWidth + Math.max(0.0, 4.0 - this.tracerThickness.getDefaultValue());
            if (!normalEnds.isEmpty()) {
                RenderUtils.drawTracers(matrixStack, partialTicks, normalEnds, false, normalLineWidth);
            }
            if (!threatEnds.isEmpty()) {
                RenderUtils.drawTracers(matrixStack, partialTicks, threatEnds, false, threatLineWidth);
            }
        }
    }

    public Integer getGlowColor(class_1309 entity) {
        if (!this.isEnabled()) {
            return null;
        }
        if (!this.style.hasGlow()) {
            return null;
        }
        if (!(entity instanceof class_1657)) {
            return null;
        }
        class_1657 player = (class_1657)entity;
        if (!this.players.contains(player)) {
            return null;
        }
        return PlayerEspHack.makeOpaque(this.getBaseColor(player));
    }

    private int getBaseColor(class_1657 e) {
        Color reg2;
        if (WURST.getFriends().contains(e.method_5477().getString())) {
            return -2147483393;
        }
        if (this.useStaticPlayerColor.isChecked()) {
            Color pc = this.playerColor.getColor();
            PlayerColorRegistry.forceAssign(e.method_5667(), pc, "PlayerESP");
            return RenderUtils.toIntColor(new float[]{(float)pc.getRed() / 255.0f, (float)pc.getGreen() / 255.0f, (float)pc.getBlue() / 255.0f}, 0.85f);
        }
        if (this.randomBrightColors.isChecked()) {
            int idx = Math.abs(e.method_5667().hashCode());
            Color gen = PlayerColorRegistry.generateBrightColor(idx);
            PlayerColorRegistry.forceAssign(e.method_5667(), gen, "PlayerESP");
            return RenderUtils.toIntColor(new float[]{(float)gen.getRed() / 255.0f, (float)gen.getGreen() / 255.0f, (float)gen.getBlue() / 255.0f}, 0.9f);
        }
        if (!this.useStaticPlayerColor.isChecked() && !this.randomBrightColors.isChecked()) {
            PlayerColorRegistry.removeByOwner("PlayerESP");
        }
        if ((this.useStaticPlayerColor.isChecked() || this.randomBrightColors.isChecked()) && (reg2 = PlayerColorRegistry.get(e.method_5667())) != null) {
            return RenderUtils.toIntColor(new float[]{(float)reg2.getRed() / 255.0f, (float)reg2.getGreen() / 255.0f, (float)reg2.getBlue() / 255.0f}, 0.9f);
        }
        float f = PlayerEspHack.MC.field_1724.method_5739((class_1297)e) / 20.0f;
        float r = class_3532.method_15363((float)(2.0f - f), (float)0.0f, (float)1.0f);
        float g = class_3532.method_15363((float)f, (float)0.0f, (float)1.0f);
        float[] rgb = new float[]{r, g, 0.0f};
        return RenderUtils.toIntColor(rgb, 0.5f);
    }

    private PlayerVisual getVisual(class_1657 e, long now) {
        int baseColor = this.getBaseColor(e);
        if (!this.losThreatDetection.isChecked()) {
            return new PlayerVisual(baseColor, PlayerEspHack.makeOpaque(baseColor), 0.0f);
        }
        float factor = this.getLosFactor(e, now);
        int boxColor = this.mixThreatColor(baseColor, factor, false);
        int tracerColor = this.mixThreatColor(PlayerEspHack.makeOpaque(baseColor), factor, true);
        return new PlayerVisual(boxColor, tracerColor, factor);
    }

    private float getLosFactor(class_1657 e, long now) {
        LosState state = this.losStates.get(e.method_5667());
        if (state == null) {
            return 0.0f;
        }
        if (state.los) {
            return 1.0f;
        }
        if (now <= state.holdUntil) {
            return 1.0f;
        }
        if (state.fadeUntil > now) {
            long fadeStart = state.fadeUntil - 120L;
            long elapsed = Math.max(0L, now - fadeStart);
            float progress = 1.0f - (float)elapsed / 120.0f;
            return class_3532.method_15363((float)progress, (float)0.0f, (float)1.0f);
        }
        return 0.0f;
    }

    private float getFovDotThreshold() {
        double fovDegrees = class_3532.method_15350((double)this.losThreatFov.getValue(), (double)1.0, (double)180.0);
        double halfAngle = fovDegrees / 2.0;
        return (float)Math.cos(Math.toRadians(halfAngle));
    }

    private int mixThreatColor(int baseColor, float factor, boolean tracer) {
        if (factor <= 0.0f) {
            return tracer ? PlayerEspHack.makeOpaque(baseColor) : baseColor;
        }
        if (tracer) {
            baseColor = PlayerEspHack.makeOpaque(baseColor);
        }
        float clampedFactor = class_3532.method_15363((float)factor, (float)0.0f, (float)1.0f);
        float baseA = (float)(baseColor >>> 24 & 0xFF) / 255.0f;
        float baseR = (float)(baseColor >>> 16 & 0xFF) / 255.0f;
        float baseG = (float)(baseColor >>> 8 & 0xFF) / 255.0f;
        float baseB = (float)(baseColor & 0xFF) / 255.0f;
        float threatAlpha = class_3532.method_15363((float)(baseA + (tracer ? 0.45f : 0.35f)), (float)0.0f, (float)1.0f);
        float inv = 1.0f - clampedFactor;
        float r = 1.0f * clampedFactor + baseR * inv;
        float g = baseG * inv;
        float b = baseB * inv;
        float a = tracer ? 1.0f : threatAlpha * clampedFactor + baseA * inv;
        return RenderUtils.toIntColor(new float[]{r, g, b}, a);
    }

    private static int makeOpaque(int color) {
        return color | 0xFF000000;
    }

    private void updateLosStates(long now) {
        if (PlayerEspHack.MC.field_1724 == null || PlayerEspHack.MC.field_1687 == null) {
            return;
        }
        for (LosState state : this.losStates.values()) {
            state.touched = false;
        }
        for (class_1657 player : this.players) {
            LosState state = this.losStates.computeIfAbsent(player.method_5667(), uuid -> new LosState((UUID)uuid, now));
            state.touched = true;
            this.updateLosState(player, state, now);
        }
        this.losStates.entrySet().removeIf(entry -> !((LosState)entry.getValue()).touched);
    }

    private void updateLosState(class_1657 target, LosState state, long now) {
        class_746 self = PlayerEspHack.MC.field_1724;
        if (self == null) {
            return;
        }
        double maxRange = this.losThreatRange.getValue();
        double maxRangeSq = maxRange * maxRange;
        double distSq = target.method_5858((class_1297)self);
        if (distSq > maxRangeSq) {
            state.setLos(false, now);
            state.scheduleNext(now);
            return;
        }
        if (now < state.nextCheckAt) {
            return;
        }
        boolean hasLos = this.computeLineOfSight(target);
        state.setLos(hasLos, now);
        state.scheduleNext(now);
    }

    private boolean computeLineOfSight(class_1657 target) {
        double targetDistSq;
        class_243 hitPos;
        class_3959 ctx;
        class_3965 blockHit;
        double clampedZ;
        double clampedY;
        class_243 eyePos;
        class_746 self = PlayerEspHack.MC.field_1724;
        if (self == null || PlayerEspHack.MC.field_1687 == null) {
            return false;
        }
        class_238 myBox = self.method_5829();
        if (myBox.method_1006(eyePos = new class_243(target.method_23317(), target.method_23318() + (double)target.method_5751(), target.method_23321()))) {
            return true;
        }
        double clampedX = class_3532.method_15350((double)eyePos.field_1352, (double)myBox.field_1323, (double)myBox.field_1320);
        class_243 closestPoint = new class_243(clampedX, clampedY = class_3532.method_15350((double)eyePos.field_1351, (double)myBox.field_1322, (double)myBox.field_1325), clampedZ = class_3532.method_15350((double)eyePos.field_1350, (double)myBox.field_1321, (double)myBox.field_1324));
        class_243 dirToYouVec = closestPoint.method_1020(eyePos);
        double distance = dirToYouVec.method_1033();
        if (distance < 1.0E-4) {
            return true;
        }
        class_243 dirToYou = dirToYouVec.method_1029();
        class_243 lookVec = target.method_5828(1.0f);
        float fovThreshold = this.getFovDotThreshold();
        if (lookVec.method_1026(dirToYou) < (double)fovThreshold) {
            return false;
        }
        Optional hitOpt = myBox.method_992(eyePos, closestPoint);
        if (hitOpt.isEmpty()) {
            hitOpt = myBox.method_992(eyePos, myBox.method_1005());
        }
        if ((blockHit = PlayerEspHack.MC.field_1687.method_17742(ctx = new class_3959(eyePos, hitPos = hitOpt.orElse(closestPoint), class_3959.class_3960.field_23142, class_3959.class_242.field_1348, (class_1297)target))).method_17783() == class_239.class_240.field_1333) {
            return true;
        }
        double blockDistSq = blockHit.method_17784().method_1025(eyePos);
        return blockDistSq >= (targetDistSq = hitPos.method_1025(eyePos)) - 0.001;
    }

    private static final class PlayerEspStyleSetting
    extends EnumSetting<Style> {
        private PlayerEspStyleSetting(Style defaultStyle) {
            super("Style", (Enum[])Style.values(), (Enum)defaultStyle);
        }

        public boolean hasBoxes() {
            return ((Style)((Object)this.getSelected())).boxes;
        }

        public boolean hasLines() {
            return ((Style)((Object)this.getSelected())).lines;
        }

        public boolean hasGlow() {
            return ((Style)((Object)this.getSelected())).glow;
        }

        private static enum Style {
            BOXES("Boxes only", true, false, false),
            LINES("Lines only", false, true, false),
            LINES_AND_BOXES("Lines and boxes", true, true, false),
            GLOW("Glow only", false, false, true),
            LINES_AND_GLOW("Lines and glow", false, true, true);

            private final String name;
            private final boolean boxes;
            private final boolean lines;
            private final boolean glow;

            private Style(String name, boolean boxes, boolean lines, boolean glow) {
                this.name = name;
                this.boxes = boxes;
                this.lines = lines;
                this.glow = glow;
            }

            public String toString() {
                return this.name;
            }
        }
    }

    private static final class PendingEnterAlert {
        private final PlayerRangeAlertManager.PlayerInfo info;
        private final long createdAt;

        private PendingEnterAlert(PlayerRangeAlertManager.PlayerInfo info, long createdAt) {
            this.info = info;
            this.createdAt = createdAt;
        }
    }

    private static final class PlayerVisual {
        private final int boxColor;
        private final int tracerColor;
        private final float threatFactor;

        private PlayerVisual(int boxColor, int tracerColor, float threatFactor) {
            this.boxColor = boxColor;
            this.tracerColor = tracerColor;
            this.threatFactor = threatFactor;
        }

        public int boxColor() {
            return this.boxColor;
        }

        public int tracerColor() {
            return this.tracerColor;
        }

        public boolean isThreat() {
            return this.threatFactor > 0.001f;
        }
    }

    private static final class LosState {
        private final int checkIntervalMs;
        private long nextCheckAt;
        private boolean los;
        private long holdUntil = Long.MIN_VALUE;
        private long fadeUntil = Long.MIN_VALUE;
        private boolean touched;

        private LosState(UUID uuid, long now) {
            int hash = Math.floorMod(uuid.hashCode(), 10000);
            this.checkIntervalMs = 80 + hash % 90;
            int offset = hash % this.checkIntervalMs;
            this.nextCheckAt = now + (long)offset;
        }

        private void scheduleNext(long now) {
            this.nextCheckAt = now + (long)this.checkIntervalMs;
        }

        private void setLos(boolean value, long now) {
            if (this.los == value) {
                return;
            }
            this.los = value;
            if (value) {
                this.holdUntil = Long.MIN_VALUE;
                this.fadeUntil = Long.MIN_VALUE;
            } else {
                this.holdUntil = now + 250L;
                this.fadeUntil = this.holdUntil + 120L;
            }
        }
    }
}

