/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_7923;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.WurstRenderLayers;
import net.wurstclient.events.CameraTransformViewBobbingListener;
import net.wurstclient.events.PacketInputListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.BlockListSetting;
import net.wurstclient.settings.BlockSetting;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ChunkAreaSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.EnumSetting;
import net.wurstclient.settings.EspStyleSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.settings.TextFieldSetting;
import net.wurstclient.util.BlockUtils;
import net.wurstclient.util.BlockVertexCompiler;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.EasyVertexBuffer;
import net.wurstclient.util.RegionPos;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.RotationUtils;
import net.wurstclient.util.chunk.ChunkSearcher;
import net.wurstclient.util.chunk.ChunkSearcherCoordinator;

@SearchTags(value={"BlockESP", "block esp"})
public final class SearchHack
extends Hack
implements UpdateListener,
CameraTransformViewBobbingListener,
RenderListener {
    private static final int MAX_QUERY_LENGTH = 256;
    private final EnumSetting<SearchMode> mode = new EnumSetting("Mode", (Enum[])SearchMode.values(), (Enum)SearchMode.BLOCK_ID);
    private final BlockListSetting blockList = new BlockListSetting("Block List", "Blocks to search when Mode is set to List.", new String[0]);
    private final TextFieldSetting query = new TextFieldSetting("Query", "Enter text to match block IDs or names by keyword. Separate multiple terms with commas.", "", value -> value.length() <= 256);
    private final BlockSetting block = new BlockSetting("Block", "The type of block to search for.", "minecraft:diamond_ore", false);
    private final EspStyleSetting style = new EspStyleSetting();
    private final CheckboxSetting stickyArea = new CheckboxSetting("Sticky area", "Off: Re-centers the scan every chunk to match ESP drop-off.\nOn: Keeps results anchored so you can path back to them.", false);
    private final CheckboxSetting useFixedColor = new CheckboxSetting("Use fixed color", "Enable to use a fixed color instead of rainbow.", false);
    private final ColorSetting fixedColor = new ColorSetting("Fixed color", "Color used when \"Use fixed color\" is enabled.", Color.RED);
    private final CheckboxSetting showCountInHackList = new CheckboxSetting("HackList count", "Appends the number of found blocks to this hack's entry in the HackList.", false);
    private final CheckboxSetting onlyAboveGround = new CheckboxSetting("Above ground only", "Only show blocks at or above the configured Y level.", false);
    private final SliderSetting aboveGroundY = new SliderSetting("Set ESP Y limit", 62.0, -65.0, 255.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private class_2248 lastBlock;
    private String lastQuery = "";
    private ChunkAreaSetting.ChunkArea lastAreaSelection;
    private final ChunkAreaSetting area = new ChunkAreaSetting("Area", "The area around the player to search in.\nHigher values require a faster computer.", ChunkAreaSetting.ChunkArea.A33);
    private final SliderSetting limit = new SliderSetting("Limit", "The maximum number of blocks to display.\nHigher values require a faster computer.", 4.0, 2.0, 6.0, 1.0, SliderSetting.ValueDisplay.LOGARITHMIC);
    private int prevLimit;
    private boolean notify;
    private final ChunkSearcherCoordinator coordinator = new ChunkSearcherCoordinator(this.area);
    private ForkJoinPool forkJoinPool;
    private ForkJoinTask<HashSet<class_2338>> getMatchingBlocksTask;
    private ForkJoinTask<ArrayList<int[]>> compileVerticesTask;
    private HashSet<class_2338> lastMatchingBlocks;
    private EasyVertexBuffer vertexBuffer;
    private RegionPos bufferRegion;
    private boolean bufferUpToDate;
    private List<class_243> tracerEnds;
    private class_1923 lastPlayerChunk;
    private int lastMatchesVersion;
    private SearchMode lastMode;
    private int lastListHash;
    private Set<String> listExactIds;
    private String[] listKeywords;
    private int foundCount;

    public SearchHack() {
        super("Search");
        this.setCategory(Category.RENDER);
        this.addSetting(this.mode);
        this.addSetting(this.blockList);
        this.addSetting(this.query);
        this.addSetting(this.block);
        this.addSetting(this.style);
        this.addSetting(this.stickyArea);
        this.addSetting(this.useFixedColor);
        this.addSetting(this.fixedColor);
        this.addSetting(this.area);
        this.addSetting(this.limit);
        this.addSetting(this.onlyAboveGround);
        this.addSetting(this.aboveGroundY);
        this.addSetting(this.showCountInHackList);
    }

    @Override
    public String getRenderName() {
        String colorMode = this.useFixedColor.isChecked() ? "Fixed" : "Rainbow";
        String base = switch (this.mode.getSelected().ordinal()) {
            case 0 -> this.getName() + " [List:" + this.blockList.size() + "] (" + colorMode + ")";
            case 2 -> {
                String rawQuery = this.query.getValue().trim();
                if (!rawQuery.isEmpty()) {
                    yield this.getName() + " [" + this.abbreviate(rawQuery) + "] (" + colorMode + ")";
                }
                yield this.getName() + " [query] (" + colorMode + ")";
            }
            default -> this.getName() + " [" + this.block.getBlockName().replace("minecraft:", "") + "] (" + colorMode + ")";
        };
        if (this.showCountInHackList.isChecked() && this.foundCount > 0) {
            return base + " [" + Math.min(this.foundCount, 999) + "]";
        }
        return base;
    }

    @Override
    protected void onEnable() {
        this.prevLimit = this.limit.getValueI();
        this.notify = true;
        this.forkJoinPool = new ForkJoinPool();
        this.bufferUpToDate = false;
        this.lastAreaSelection = (ChunkAreaSetting.ChunkArea)((Object)this.area.getSelected());
        this.lastPlayerChunk = new class_1923(SearchHack.MC.field_1724.method_24515());
        this.lastMode = this.mode.getSelected();
        this.lastListHash = this.blockList.getBlockNames().hashCode();
        this.applySearchCriteria(this.block.getBlock(), "");
        this.lastMatchesVersion = this.coordinator.getMatchesVersion();
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(PacketInputListener.class, this.coordinator);
        EVENTS.add(RenderListener.class, this);
        EVENTS.add(CameraTransformViewBobbingListener.class, this);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(PacketInputListener.class, this.coordinator);
        EVENTS.remove(RenderListener.class, this);
        EVENTS.remove(CameraTransformViewBobbingListener.class, this);
        this.stopBuildingBuffer(true);
        this.coordinator.reset();
        this.forkJoinPool.shutdownNow();
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
        }
        this.vertexBuffer = null;
        this.bufferRegion = null;
        this.lastMatchingBlocks = null;
        this.tracerEnds = null;
        this.lastPlayerChunk = null;
        this.foundCount = 0;
    }

    @Override
    public void onUpdate() {
        String currentQuery;
        ChunkAreaSetting.ChunkArea currentArea;
        int listHash;
        SearchMode currentMode = this.mode.getSelected();
        if (currentMode != this.lastMode) {
            this.lastMode = currentMode;
            this.applySearchCriteria(this.block.getBlock(), "");
        }
        if (currentMode == SearchMode.LIST && (listHash = this.blockList.getBlockNames().hashCode()) != this.lastListHash) {
            this.lastListHash = listHash;
            this.applySearchCriteria(this.block.getBlock(), "");
        }
        class_1923 currentChunk = new class_1923(SearchHack.MC.field_1724.method_24515());
        if (!this.stickyArea.isChecked() && !currentChunk.equals((Object)this.lastPlayerChunk)) {
            this.lastPlayerChunk = currentChunk;
            this.coordinator.reset();
            this.stopBuildingBuffer(false);
        }
        if ((currentArea = (ChunkAreaSetting.ChunkArea)((Object)this.area.getSelected())) != this.lastAreaSelection) {
            this.lastAreaSelection = currentArea;
            this.coordinator.reset();
            this.stopBuildingBuffer(true);
            this.notify = true;
        }
        if (currentMode == SearchMode.BLOCK_ID) {
            class_2248 currentBlock = this.block.getBlock();
            if (currentBlock != this.lastBlock) {
                this.applySearchCriteria(currentBlock, "");
            }
        } else if (currentMode == SearchMode.QUERY && !(currentQuery = this.normalizeQuery(this.query.getValue())).equals(this.lastQuery)) {
            this.applySearchCriteria(this.block.getBlock(), currentQuery);
        }
        this.coordinator.update();
        int matchesVersion = this.coordinator.getMatchesVersion();
        if (matchesVersion != this.lastMatchesVersion) {
            this.lastMatchesVersion = matchesVersion;
            this.stopBuildingBuffer(false);
        }
        if (this.limit.getValueI() != this.prevLimit) {
            this.stopBuildingBuffer(false);
            this.prevLimit = this.limit.getValueI();
            this.notify = true;
        }
        if (!this.coordinator.hasReadyMatches()) {
            return;
        }
        if (this.getMatchingBlocksTask == null) {
            this.startGetMatchingBlocksTask();
        }
        if (!this.getMatchingBlocksTask.isDone()) {
            return;
        }
        if (this.compileVerticesTask == null) {
            this.startCompileVerticesTask();
        }
        if (!this.compileVerticesTask.isDone()) {
            return;
        }
        if (!this.bufferUpToDate) {
            this.setBufferFromTask();
        }
    }

    @Override
    public void onCameraTransformViewBobbing(CameraTransformViewBobbingListener.CameraTransformViewBobbingEvent event) {
        if (this.style.hasLines()) {
            event.cancel();
        }
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        float[] rgb;
        boolean drawTracers;
        boolean drawBoxes = this.style.hasBoxes() && this.vertexBuffer != null && this.bufferRegion != null;
        boolean bl = drawTracers = this.style.hasLines() && this.tracerEnds != null && !this.tracerEnds.isEmpty();
        if (!drawBoxes && !drawTracers) {
            return;
        }
        float[] fArray = rgb = this.useFixedColor.isChecked() ? this.fixedColor.getColorF() : RenderUtils.getRainbowColor();
        if (drawBoxes) {
            matrixStack.method_22903();
            RenderUtils.applyRegionalRenderOffset(matrixStack, this.bufferRegion);
            this.vertexBuffer.draw(matrixStack, WurstRenderLayers.ESP_QUADS, rgb, 0.5f);
            matrixStack.method_22909();
        }
        if (drawTracers) {
            int tracerColor = RenderUtils.toIntColor(rgb, 0.5f);
            RenderUtils.drawTracers(matrixStack, partialTicks, this.tracerEnds, tracerColor, false);
        }
    }

    private String normalizeQuery(String rawQuery) {
        if (rawQuery == null) {
            return "";
        }
        return rawQuery.trim().toLowerCase(Locale.ROOT);
    }

    private String abbreviate(String text) {
        if (text.length() <= 32) {
            return text;
        }
        return text.substring(0, 32) + "...";
    }

    private void applySearchCriteria(class_2248 currentBlock, String normalizedQuery) {
        this.stopBuildingBuffer(true);
        switch (this.mode.getSelected().ordinal()) {
            case 0: {
                this.lastBlock = currentBlock;
                List<String> names = this.blockList.getBlockNames();
                ArrayList<String> kw = new ArrayList<String>();
                HashSet<String> exact = new HashSet<String>();
                for (String s : names) {
                    String raw;
                    if (s == null || (raw = s.trim()).isEmpty()) continue;
                    class_2960 id = class_2960.method_12829((String)raw);
                    if (id != null && class_7923.field_41175.method_10250(id)) {
                        exact.add(id.toString());
                        continue;
                    }
                    kw.add(raw.toLowerCase(Locale.ROOT));
                }
                this.listExactIds = exact;
                this.listKeywords = kw.toArray(new String[0]);
                this.coordinator.setQuery((pos, state) -> {
                    if (this.onlyAboveGround.isChecked() && (double)pos.method_10264() < this.aboveGroundY.getValue()) {
                        return false;
                    }
                    String idFull = BlockUtils.getName(state.method_26204());
                    if (this.listExactIds.contains(idFull)) {
                        return true;
                    }
                    String localId = idFull.contains(":") ? idFull.substring(idFull.indexOf(":") + 1) : idFull;
                    String localSpaced = localId.replace('_', ' ');
                    String transKey = state.method_26204().method_63499();
                    String display = state.method_26204().method_9518().getString();
                    for (String term : this.listKeywords) {
                        if (!this.containsNormalized(idFull, term) && !this.containsNormalized(localId, term) && !this.containsNormalized(localSpaced, term) && !this.containsNormalized(transKey, term) && !this.containsNormalized(display, term)) continue;
                        return true;
                    }
                    return false;
                });
                this.lastQuery = "";
                break;
            }
            case 2: {
                this.lastBlock = currentBlock;
                this.coordinator.setQuery((pos, state) -> {
                    if (this.onlyAboveGround.isChecked() && (double)pos.method_10264() < this.aboveGroundY.getValue()) {
                        return false;
                    }
                    return this.blockMatchesQuery(state.method_26204(), normalizedQuery);
                });
                this.lastQuery = normalizedQuery;
                break;
            }
            default: {
                this.lastBlock = currentBlock;
                this.coordinator.setQuery((pos, state) -> {
                    if (this.onlyAboveGround.isChecked() && (double)pos.method_10264() < this.aboveGroundY.getValue()) {
                        return false;
                    }
                    return state.method_26204() == currentBlock;
                });
                this.lastQuery = "";
            }
        }
        this.notify = true;
        this.lastMatchesVersion = this.coordinator.getMatchesVersion();
    }

    private boolean blockMatchesQuery(class_2248 block, String normalizedQuery) {
        String id = BlockUtils.getName(block);
        String localId = id.contains(":") ? id.substring(id.indexOf(":") + 1) : id;
        String[] terms = (String[])Arrays.stream(normalizedQuery.split(",")).map(String::trim).filter(s -> !s.isEmpty()).toArray(String[]::new);
        if (terms.length == 0) {
            terms = new String[]{normalizedQuery};
        }
        String localSpaced = localId.replace('_', ' ');
        String transKey = block.method_63499();
        String display = block.method_9518().getString();
        for (String term : terms) {
            if (!this.containsNormalized(id, term) && !this.containsNormalized(localId, term) && !this.containsNormalized(localSpaced, term) && !this.containsNormalized(transKey, term) && !this.containsNormalized(display, term)) continue;
            return true;
        }
        return false;
    }

    private boolean containsNormalized(String haystack, String normalizedQuery) {
        return haystack != null && haystack.toLowerCase(Locale.ROOT).contains(normalizedQuery);
    }

    private void startGetMatchingBlocksTask() {
        class_2338 eyesPos = class_2338.method_49638((class_2374)RotationUtils.getEyesPos());
        int limitCount = this.limit.getValueLog();
        this.getMatchingBlocksTask = this.forkJoinPool.submit(() -> {
            PriorityQueue<class_2338> heap = new PriorityQueue<class_2338>(limitCount + 1, (a, b) -> Integer.compare(b.method_19455((class_2382)eyesPos), a.method_19455((class_2382)eyesPos)));
            Iterator it = this.coordinator.getReadyMatches().iterator();
            while (it.hasNext()) {
                ChunkSearcher.Result r = (ChunkSearcher.Result)it.next();
                class_2338 pos = r.pos();
                if (heap.size() < limitCount) {
                    heap.offer(pos);
                    continue;
                }
                if (pos.method_19455((class_2382)eyesPos) >= ((class_2338)heap.peek()).method_19455((class_2382)eyesPos)) continue;
                heap.poll();
                heap.offer(pos);
            }
            return new HashSet(heap);
        });
    }

    private void startCompileVerticesTask() {
        HashSet<class_2338> matchingBlocks = this.getMatchingBlocksTask.join();
        this.lastMatchingBlocks = matchingBlocks;
        if (matchingBlocks.size() < this.limit.getValueLog()) {
            this.notify = true;
        } else if (this.notify) {
            ChatUtils.warning("Search found \u00a7lA LOT\u00a7r of blocks! To prevent lag, it will only show the closest \u00a76" + this.limit.getValueString() + "\u00a7r results.");
            this.notify = false;
        }
        this.compileVerticesTask = this.forkJoinPool.submit(() -> BlockVertexCompiler.compile(matchingBlocks));
    }

    private void setBufferFromTask() {
        ArrayList<int[]> vertices = this.compileVerticesTask.join();
        RegionPos region = RenderUtils.getCameraRegion();
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
        }
        this.vertexBuffer = EasyVertexBuffer.createAndUpload(VertexFormat.class_5596.field_27382, class_290.field_1576, buffer -> {
            for (int[] vertex : vertices) {
                buffer.method_22912((float)(vertex[0] - region.x()), (float)vertex[1], (float)(vertex[2] - region.z())).method_39415(-1);
            }
        });
        this.bufferUpToDate = true;
        this.bufferRegion = region;
        if (this.lastMatchingBlocks != null) {
            this.tracerEnds = this.lastMatchingBlocks.stream().map(pos -> {
                if (BlockUtils.canBeClicked(pos)) {
                    return BlockUtils.getBoundingBox(pos).method_1005();
                }
                return pos.method_46558();
            }).collect(Collectors.toList());
            this.foundCount = Math.min(this.lastMatchingBlocks.size(), 999);
        } else {
            this.foundCount = 0;
        }
    }

    private void stopBuildingBuffer(boolean discardCurrent) {
        if (this.getMatchingBlocksTask != null) {
            this.getMatchingBlocksTask.cancel(true);
        }
        this.getMatchingBlocksTask = null;
        if (this.compileVerticesTask != null) {
            this.compileVerticesTask.cancel(true);
        }
        this.compileVerticesTask = null;
        this.bufferUpToDate = false;
        if (discardCurrent) {
            this.tracerEnds = null;
            this.lastMatchingBlocks = null;
            this.foundCount = 0;
            if (this.vertexBuffer != null) {
                this.vertexBuffer.close();
                this.vertexBuffer = null;
            }
            this.bufferRegion = null;
        }
    }

    private static enum SearchMode {
        LIST,
        BLOCK_ID,
        QUERY;

    }
}

