/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import com.google.gson.JsonElement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.clickgui.screens.EditBlockListScreen;
import net.wurstclient.events.GetAmbientOcclusionLightLevelListener;
import net.wurstclient.events.SetOpaqueCubeListener;
import net.wurstclient.events.ShouldDrawSideListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.BlockListSetting;
import net.wurstclient.settings.SliderSetting;

@SearchTags(value={"SurfaceXray", "Surface X-Ray", "SurfaceX-Ray", "surface xray", "surface x ray"})
public final class SurfaceXrayHack
extends Hack
implements ShouldDrawSideListener,
UpdateListener,
SetOpaqueCubeListener,
GetAmbientOcclusionLightLevelListener {
    private static final int MAX_COMPONENT_SIZE = 4096;
    private static final long CACHE_TTL = 200L;
    private static final long CACHE_CLEAN_INTERVAL = 200L;
    private final SliderSetting transparency = new SliderSetting("Surface opacity", "Controls how transparent the exposed surface should appear.", 0.5, 0.0, 1.0, 0.01, SliderSetting.ValueDisplay.PERCENTAGE){

        @Override
        public void update() {
            super.update();
            SurfaceXrayHack.this.onSettingsChanged(false);
        }
    };
    private final BlockListSetting targetBlocks = new BlockListSetting("Tracked blocks", "List of blocks that SurfaceXray will make semi-transparent.", new String[]{"minecraft:lava", "minecraft:water"}){

        @Override
        public void add(class_2248 block) {
            int before = this.size();
            super.add(block);
            if (this.size() != before) {
                SurfaceXrayHack.this.onTrackedBlocksChanged();
            }
        }

        @Override
        public void addRawName(String raw) {
            int before = this.size();
            super.addRawName(raw);
            if (this.size() != before) {
                SurfaceXrayHack.this.onTrackedBlocksChanged();
            }
        }

        @Override
        public void remove(int index) {
            boolean valid = index >= 0 && index < this.size();
            super.remove(index);
            if (valid) {
                SurfaceXrayHack.this.onTrackedBlocksChanged();
            }
        }

        @Override
        public void clear() {
            boolean changed = this.size() > 0;
            super.clear();
            if (changed) {
                SurfaceXrayHack.this.onTrackedBlocksChanged();
            }
        }

        @Override
        public void resetToDefaults() {
            boolean changed = this.size() > 0;
            super.resetToDefaults();
            if (changed) {
                SurfaceXrayHack.this.onTrackedBlocksChanged();
            }
        }

        @Override
        public void fromJson(JsonElement json) {
            ArrayList<String> before = new ArrayList<String>(this.getBlockNames());
            super.fromJson(json);
            if (!before.equals(this.getBlockNames())) {
                SurfaceXrayHack.this.onTrackedBlocksChanged();
            }
        }
    };
    private final ConcurrentHashMap<Long, CacheEntry> visibilityCache = new ConcurrentHashMap();
    private class_638 cachedWorld;
    private long lastCleanupTick;

    public SurfaceXrayHack() {
        super("SurfaceXray");
        this.setCategory(Category.RENDER);
        this.addSetting(this.transparency);
        this.addSetting(this.targetBlocks);
    }

    @Override
    protected void onEnable() {
        this.clearCache();
        this.cachedWorld = null;
        this.lastCleanupTick = 0L;
        EVENTS.add(ShouldDrawSideListener.class, this);
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(SetOpaqueCubeListener.class, this);
        EVENTS.add(GetAmbientOcclusionLightLevelListener.class, this);
        this.onSettingsChanged(true);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(ShouldDrawSideListener.class, this);
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(SetOpaqueCubeListener.class, this);
        EVENTS.remove(GetAmbientOcclusionLightLevelListener.class, this);
        this.clearCache();
        this.cachedWorld = null;
        this.onSettingsChanged(false);
    }

    @Override
    public void onUpdate() {
        class_638 world = SurfaceXrayHack.MC.field_1687;
        if (world == null || world != this.cachedWorld) {
            this.clearCache();
            this.cachedWorld = world;
            this.lastCleanupTick = 0L;
            return;
        }
        long time = world.method_8510();
        if (time - this.lastCleanupTick >= 200L) {
            this.pruneCache(time);
            this.lastCleanupTick = time;
        }
    }

    @Override
    public void onShouldDrawSide(ShouldDrawSideListener.ShouldDrawSideEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        class_2338 pos = event.getPos();
        if (pos == null) {
            return;
        }
        SurfaceState state = this.classifyBlock(event.getState(), pos);
        if (state == SurfaceState.INTERIOR) {
            event.setRendered(false);
        } else if (state == SurfaceState.SURFACE) {
            event.setRendered(true);
        }
    }

    @Override
    public void onSetOpaqueCube(SetOpaqueCubeListener.SetOpaqueCubeEvent event) {
        if (this.isEnabled()) {
            event.cancel();
        }
    }

    @Override
    public void onGetAmbientOcclusionLightLevel(GetAmbientOcclusionLightLevelListener.GetAmbientOcclusionLightLevelEvent event) {
        if (this.isEnabled()) {
            event.setLightLevel(1.0f);
        }
    }

    public SurfaceState classifyBlock(class_2680 state, class_2338 pos) {
        if (!this.isEnabled() || state == null || pos == null) {
            return SurfaceState.NONE;
        }
        if (!this.targetBlocks.matchesBlock(state.method_26204())) {
            return SurfaceState.NONE;
        }
        return this.classifyPos(pos, state.method_26204());
    }

    public SurfaceState classifyFluid(class_3610 state, class_2338 pos) {
        if (!this.isEnabled() || state == null || pos == null) {
            return SurfaceState.NONE;
        }
        class_2248 block = state.method_15759().method_26204();
        if (!this.targetBlocks.matchesBlock(block)) {
            return SurfaceState.NONE;
        }
        return this.classifyPos(pos, block);
    }

    public boolean isTarget(class_2680 state) {
        return state != null && this.targetBlocks.matchesBlock(state.method_26204());
    }

    public boolean isTarget(class_2248 block) {
        return block != null && this.targetBlocks.matchesBlock(block);
    }

    public float getSurfaceOpacity() {
        return this.transparency.getValueF();
    }

    public int getSurfaceOpacityMask() {
        int alpha = Math.max(0, Math.min(255, Math.round(this.getSurfaceOpacity() * 255.0f)));
        if (alpha == 0) {
            alpha = 1;
        }
        return alpha << 24 | 0xFFFFFF;
    }

    public void openBlockListEditor(class_437 prevScreen) {
        MC.method_1507((class_437)new EditBlockListScreen(prevScreen, this.targetBlocks));
    }

    private SurfaceState classifyPos(class_2338 pos, class_2248 block) {
        class_638 world = SurfaceXrayHack.MC.field_1687;
        if (world == null) {
            return SurfaceState.NONE;
        }
        long key = pos.method_10063();
        CacheEntry cached = this.visibilityCache.get(key);
        long time = world.method_8510();
        if (cached != null) {
            if (cached.block == block && time - cached.lastUpdate <= 200L) {
                return cached.state;
            }
            this.visibilityCache.remove(key);
        }
        this.computeComponent(world, pos, block, time);
        cached = this.visibilityCache.get(key);
        if (cached != null) {
            return cached.state;
        }
        SurfaceState fallback = this.classifyColumn(world, pos, block);
        this.visibilityCache.put(key, new CacheEntry(block, fallback, time));
        return fallback;
    }

    private void computeComponent(class_638 world, class_2338 start, class_2248 block, long time) {
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>();
        HashSet<Long> visited = new HashSet<Long>();
        ArrayList<class_2338> component = new ArrayList<class_2338>();
        queue.add(start);
        visited.add(start.method_10063());
        int processed = 0;
        while (!queue.isEmpty()) {
            class_2338 current = (class_2338)queue.removeFirst();
            class_2680 state = world.method_8320(current);
            if (state.method_26204() != block) continue;
            component.add(current);
            if (++processed >= 4096) {
                this.fillWithColumnFallback(world, component, block, time);
                return;
            }
            for (class_2350 dir : class_2350.values()) {
                class_2338 neighbor = current.method_10093(dir);
                long key = neighbor.method_10063();
                if (!visited.add(key) || world.method_8320(neighbor).method_26204() != block) continue;
                queue.add(neighbor);
            }
        }
        if (component.isEmpty()) {
            return;
        }
        HashMap<ColumnKey, Integer> topYByColumn = new HashMap<ColumnKey, Integer>();
        for (class_2338 pos : component) {
            ColumnKey columnKey = new ColumnKey(pos.method_10263(), pos.method_10260(), block);
            topYByColumn.merge(columnKey, pos.method_10264(), Math::max);
        }
        for (class_2338 pos : component) {
            long posKey = pos.method_10063();
            ColumnKey columnKey = new ColumnKey(pos.method_10263(), pos.method_10260(), block);
            int topY = (Integer)topYByColumn.get(columnKey);
            SurfaceState state = pos.method_10264() == topY ? SurfaceState.SURFACE : SurfaceState.INTERIOR;
            this.visibilityCache.put(posKey, new CacheEntry(block, state, time));
        }
    }

    private void fillWithColumnFallback(class_638 world, ArrayList<class_2338> component, class_2248 block, long time) {
        for (class_2338 pos : component) {
            long posKey = pos.method_10063();
            SurfaceState state = this.classifyColumn(world, pos, block);
            this.visibilityCache.put(posKey, new CacheEntry(block, state, time));
        }
    }

    private SurfaceState classifyColumn(class_638 world, class_2338 pos, class_2248 block) {
        class_2338 above = pos.method_10084();
        if (world.method_8320(above).method_26204() == block) {
            return SurfaceState.INTERIOR;
        }
        return SurfaceState.SURFACE;
    }

    private void pruneCache(long time) {
        ArrayList<Long> expired = new ArrayList<Long>();
        for (Map.Entry<Long, CacheEntry> entry : this.visibilityCache.entrySet()) {
            if (time - entry.getValue().lastUpdate <= 200L) continue;
            expired.add(entry.getKey());
        }
        for (Long key : expired) {
            this.visibilityCache.remove(key);
        }
    }

    private void clearCache() {
        this.visibilityCache.clear();
    }

    private void onTrackedBlocksChanged() {
        this.onSettingsChanged(true);
    }

    private void onSettingsChanged(boolean clearCache) {
        if (clearCache) {
            this.clearCache();
            this.lastCleanupTick = 0L;
        }
        if (SurfaceXrayHack.MC.field_1769 != null) {
            SurfaceXrayHack.MC.field_1769.method_3279();
        }
    }

    public static enum SurfaceState {
        NONE,
        SURFACE,
        INTERIOR;

    }

    private static final class CacheEntry {
        private final class_2248 block;
        private final SurfaceState state;
        private final long lastUpdate;

        private CacheEntry(class_2248 block, SurfaceState state, long lastUpdate) {
            this.block = block;
            this.state = state;
            this.lastUpdate = lastUpdate;
        }
    }

    private static final class ColumnKey {
        private final int x;
        private final int z;
        private final class_2248 block;

        private ColumnKey(int x, int z, class_2248 block) {
            this.x = x;
            this.z = z;
            this.block = block;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ColumnKey)) {
                return false;
            }
            ColumnKey other = (ColumnKey)obj;
            return this.x == other.x && this.z == other.z && this.block == other.block;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.z, this.block);
        }
    }
}

