/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.awt.Color;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.wurstclient.Category;
import net.wurstclient.WurstClient;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.mixinterface.IMinecraftClient;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.TextFieldSetting;
import net.wurstclient.util.BlockUtils;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.Rotation;
import net.wurstclient.util.RotationUtils;

public final class TargetPlaceHack
extends Hack
implements RenderListener,
UpdateListener {
    private static final WurstClient WURST = WurstClient.INSTANCE;
    private static final IMinecraftClient IMC = WurstClient.IMC;
    private final ColorSetting highlightColor = new ColorSetting("Highlight color", Color.CYAN);
    private final TextFieldSetting activationKey = new TextFieldSetting("Activation key", "Determines which key activates TargetPlace.\n\nUse translation keys such as key.keyboard.p.", "key.keyboard.p", this::isValidActivationKey);
    private class_2338 targetBlock;
    private boolean activationKeyDown;
    private long lastActivationTime;

    public TargetPlaceHack() {
        super("TargetPlace");
        this.setCategory(Category.BLOCKS);
        this.addSetting(this.highlightColor);
        this.addSetting(this.activationKey);
    }

    @Override
    protected void onEnable() {
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(RenderListener.class, this);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        this.targetBlock = null;
        this.activationKeyDown = false;
    }

    @Override
    public void onUpdate() {
        if (TargetPlaceHack.MC.field_1755 != null) {
            this.activationKeyDown = false;
            return;
        }
        class_3675.class_306 key = this.getActivationKey();
        if (key != null) {
            boolean currentlyDown = class_3675.method_15987((long)MC.method_22683().method_4490(), (int)key.method_1444());
            if (currentlyDown && !this.activationKeyDown) {
                this.handleActivation(TargetPlaceHack.MC.field_1690.field_1832.method_1434());
            }
            this.activationKeyDown = currentlyDown;
        }
        if (this.targetBlock == null || TargetPlaceHack.MC.field_1687 == null || TargetPlaceHack.MC.field_1724 == null) {
            return;
        }
        class_1799 stack = TargetPlaceHack.MC.field_1724.method_6047();
        if (stack.method_7960()) {
            return;
        }
        if (BlockUtils.getState(this.targetBlock).method_26215()) {
            this.attemptPlace(this.targetBlock);
        }
        for (int i = 0; i < 3; ++i) {
            this.attemptPlace(this.targetBlock);
        }
    }

    @Override
    public void onRender(class_4587 matrices, float partialTicks) {
        class_238 box;
        if (this.targetBlock == null || TargetPlaceHack.MC.field_1687 == null) {
            return;
        }
        class_2680 state = TargetPlaceHack.MC.field_1687.method_8320(this.targetBlock);
        if (state.method_26215()) {
            return;
        }
        try {
            box = BlockUtils.getBoundingBox(this.targetBlock);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        if (box == null) {
            return;
        }
        int color = this.highlightColor.getColorI(160);
        RenderUtils.drawOutlinedBox(matrices, box, color, false);
    }

    public boolean hasValidTarget() {
        return this.isTargetValid(this.targetBlock);
    }

    private boolean isTargetValid(class_2338 blockPos) {
        if (blockPos == null || TargetPlaceHack.MC.field_1687 == null) {
            return false;
        }
        class_2680 state = TargetPlaceHack.MC.field_1687.method_8320(blockPos);
        if (state.method_26215()) {
            return false;
        }
        return !BlockUtils.isUnbreakable(blockPos);
    }

    public boolean handleActivation() {
        return this.handleActivation(false);
    }

    public boolean handleActivation(boolean shiftDown) {
        if (!this.isEnabled()) {
            return false;
        }
        class_3965 hitResult = null;
        class_239 class_2392 = TargetPlaceHack.MC.field_1765;
        if (class_2392 instanceof class_3965) {
            class_3965 blockHit;
            hitResult = blockHit = (class_3965)class_2392;
        }
        return this.handleActivation(hitResult, shiftDown);
    }

    private boolean handleActivation(class_3965 hitResult, boolean shiftDown) {
        class_2338 lookedPos = null;
        if (hitResult != null && hitResult.method_17783() == class_239.class_240.field_1332) {
            lookedPos = hitResult.method_17777();
        }
        if (lookedPos != null && lookedPos.equals((Object)this.targetBlock)) {
            if (shiftDown) {
                this.targetBlock = null;
                ChatUtils.message("TargetPlace: selection cleared.");
                return this.finishActivation(true);
            }
            return this.finishActivation(false);
        }
        if (lookedPos != null && this.isTargetValid(lookedPos)) {
            this.faceUnderside(lookedPos);
            this.targetBlock = lookedPos;
            ChatUtils.message("TargetPlace: selected " + BlockUtils.getName(lookedPos) + " at " + lookedPos.method_23854() + ".");
            return this.finishActivation(true);
        }
        return this.finishActivation(false);
    }

    private boolean finishActivation(boolean handled) {
        if (handled) {
            this.lastActivationTime = System.currentTimeMillis();
        }
        return handled;
    }

    private void attemptPlace(class_2338 target) {
        this.faceUnderside(target);
        Placement placement = this.findPlacement(target);
        if (placement == null) {
            return;
        }
        class_1799 stack = TargetPlaceHack.MC.field_1724.method_6047();
        if (stack.method_7960()) {
            return;
        }
        if (TargetPlaceHack.MC.field_1724 != null) {
            float yaw = TargetPlaceHack.MC.field_1724.method_36454();
            Rotation rot = new Rotation(yaw, -89.0f);
            rot.sendPlayerLookPacket();
        }
        WURST.getRotationFaker().faceVectorPacket(placement.hitVec());
        IMC.getInteractionManager().rightClickBlock(placement.neighbor(), placement.side(), placement.hitVec());
    }

    private void faceUnderside(class_2338 target) {
        if (TargetPlaceHack.MC.field_1724 == null || TargetPlaceHack.MC.field_1687 == null) {
            return;
        }
        class_2338 above = target.method_10093(class_2350.field_11036);
        class_243 hitVec = class_243.method_24954((class_2382)above).method_1031(0.5, -0.5, 0.5);
        WURST.getRotationFaker().faceVectorPacket(hitVec);
        Rotation needed = RotationUtils.getNeededRotations(hitVec);
        needed.sendPlayerLookPacket();
    }

    private Placement findPlacement(class_2338 target) {
        class_243[] offsets;
        class_2338 above = target.method_10093(class_2350.field_11036);
        if (TargetPlaceHack.MC.field_1687 == null) {
            return null;
        }
        class_2680 state = TargetPlaceHack.MC.field_1687.method_8320(above);
        if (state.method_26215()) {
            return null;
        }
        class_243 center = class_243.method_24954((class_2382)above).method_1031(0.5, 0.5, 0.5);
        for (class_243 offset : offsets = new class_243[]{new class_243(0.2, -0.5, 0.2), new class_243(0.2, -0.5, -0.2), new class_243(-0.2, -0.5, 0.2), new class_243(-0.2, -0.5, -0.2), new class_243(0.0, -0.5, 0.2), new class_243(0.2, -0.5, 0.0), new class_243(0.0, -0.5, -0.2), new class_243(-0.2, -0.5, 0.0), new class_243(-0.1, -0.5, 0.1), new class_243(0.1, -0.5, -0.1)}) {
            class_243 hitVec = center.method_1019(offset);
            if (!this.needsPlacementAdjust(above, hitVec)) continue;
            return new Placement(above, class_2350.field_11033, hitVec);
        }
        return new Placement(above, class_2350.field_11033, center.method_1031(0.0, -0.5, 0.0));
    }

    private boolean needsPlacementAdjust(class_2338 above, class_243 hitVec) {
        class_243 center = class_243.method_24954((class_2382)above).method_1031(0.5, 0.5, 0.5);
        double dx = Math.abs(hitVec.field_1352 - center.field_1352);
        double dz = Math.abs(hitVec.field_1350 - center.field_1350);
        return dx >= 0.2 || dz >= 0.2;
    }

    private class_3675.class_306 getActivationKey() {
        try {
            return class_3675.method_15981((String)this.activationKey.getValue());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private boolean isValidActivationKey(String translationKey) {
        try {
            return class_3675.method_15981((String)translationKey) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isActivationKeyDown() {
        return this.activationKeyDown;
    }

    public long getLastActivationTime() {
        return this.lastActivationTime;
    }

    private record Placement(class_2338 neighbor, class_2350 side, class_243 hitVec) {
    }
}

