/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_332;
import net.wurstclient.Category;
import net.wurstclient.DontBlock;
import net.wurstclient.Feature;
import net.wurstclient.SearchTags;
import net.wurstclient.TooManyHaxFile;
import net.wurstclient.clickgui.ClickGui;
import net.wurstclient.clickgui.ClickGuiIcons;
import net.wurstclient.clickgui.Component;
import net.wurstclient.hack.Hack;
import net.wurstclient.keybinds.PossibleKeybind;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.text.WText;

@SearchTags(value={"too many hax", "TooManyHacks", "too many hacks", "YesCheat+", "YesCheatPlus", "yes cheat plus"})
@DontBlock
public final class TooManyHaxHack
extends Hack {
    private final ArrayList<Feature> blockedFeatures = new ArrayList();
    private final Path profilesFolder;
    private final TooManyHaxFile file;
    private final HackSelectionSetting hackSelectionSetting = new HackSelectionSetting();

    public TooManyHaxHack() {
        super("TooManyHax");
        this.setCategory(Category.OTHER);
        this.addSetting(this.hackSelectionSetting);
        Path wurstFolder = WURST.getWurstFolder();
        this.profilesFolder = wurstFolder.resolve("toomanyhax");
        Path filePath = wurstFolder.resolve("toomanyhax.json");
        this.file = new TooManyHaxFile(filePath, this.blockedFeatures);
    }

    public void loadBlockedHacksFile() {
        this.file.load();
    }

    @Override
    public String getRenderName() {
        return this.getName() + " [" + this.blockedFeatures.size() + " blocked]";
    }

    @Override
    protected void onEnable() {
        this.disableBlockedHacks();
    }

    private void disableBlockedHacks() {
        for (Feature feature : this.blockedFeatures) {
            if (!(feature instanceof Hack)) continue;
            ((Hack)feature).setEnabled(false);
        }
        try {
            if (WURST.getGui() != null) {
                WURST.getGui().init();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ArrayList<Path> listProfiles() {
        ArrayList arrayList;
        block9: {
            if (!Files.isDirectory(this.profilesFolder, new LinkOption[0])) {
                return new ArrayList<Path>();
            }
            Stream<Path> files = Files.list(this.profilesFolder);
            try {
                arrayList = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toCollection(ArrayList::new));
                if (files == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            files.close();
        }
        return arrayList;
    }

    public void loadProfile(String fileName) throws IOException, JsonException {
        this.file.loadProfile(this.profilesFolder.resolve(fileName));
        this.disableBlockedHacks();
    }

    public void saveProfile(String fileName) throws IOException, JsonException {
        this.file.saveProfile(this.profilesFolder.resolve(fileName));
    }

    public boolean isBlocked(Feature feature) {
        return this.blockedFeatures.contains(feature);
    }

    public void setBlocked(Feature feature, boolean blocked) {
        if (blocked) {
            if (!feature.isSafeToBlock()) {
                throw new IllegalArgumentException();
            }
            this.blockedFeatures.add(feature);
            this.blockedFeatures.sort(Comparator.comparing(f -> f.getName().toLowerCase()));
        } else {
            this.blockedFeatures.remove(feature);
        }
        this.file.save();
        try {
            if (WURST.getGui() != null) {
                WURST.getGui().init();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void blockAll() {
        this.blockedFeatures.clear();
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.addAll(WURST.getHax().getAllHax());
        features.addAll(WURST.getCmds().getAllCmds());
        features.addAll(WURST.getOtfs().getAllOtfs());
        for (Feature feature : features) {
            if (!feature.isSafeToBlock()) continue;
            this.blockedFeatures.add(feature);
        }
        this.blockedFeatures.sort(Comparator.comparing(f -> f.getName().toLowerCase()));
        this.file.save();
        try {
            if (WURST.getGui() != null) {
                WURST.getGui().init();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unblockAll() {
        this.blockedFeatures.clear();
        this.file.save();
        try {
            if (WURST.getGui() != null) {
                WURST.getGui().init();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onDisable() {
        try {
            if (WURST.getGui() != null) {
                WURST.getGui().init();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<Feature> getBlockedFeatures() {
        return Collections.unmodifiableList(this.blockedFeatures);
    }

    private List<Hack> getSortedHacks() {
        return WURST.getHax().getAllHax().stream().sorted(Comparator.comparing(h -> h.getName().toLowerCase())).collect(Collectors.toList());
    }

    private final class HackSelectionSetting
    extends Setting {
        private HackSelectionSetting() {
            super("Blocked hacks", WText.literal("Select the hacks that TooManyHax should keep disabled."));
        }

        @Override
        public Component getComponent() {
            HackSelectionComponent component = new HackSelectionComponent();
            component.refreshSize();
            return component;
        }

        @Override
        public void fromJson(JsonElement json) {
        }

        @Override
        public JsonElement toJson() {
            return JsonNull.INSTANCE;
        }

        @Override
        public JsonObject exportWikiData() {
            JsonObject json = new JsonObject();
            json.addProperty("name", this.getName());
            json.addProperty("description", this.getDescription());
            json.addProperty("type", "Custom");
            return json;
        }

        @Override
        public Set<PossibleKeybind> getPossibleKeybinds(String featureName) {
            return Collections.emptySet();
        }
    }

    private final class HackSelectionComponent
    extends Component {
        private static final int ROW_HEIGHT = 11;
        private static final int BOX_SIZE = 11;

        private HackSelectionComponent() {
        }

        private void refreshSize() {
            this.refreshSize(TooManyHaxHack.this.getSortedHacks());
        }

        private void refreshSize(List<Hack> hacks) {
            int desiredHeight = Math.max(11 * Math.max(hacks.size(), 1), 11);
            if (this.getHeight() != desiredHeight) {
                this.setHeight(desiredHeight);
            }
        }

        @Override
        public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
            int my;
            if (mouseButton != 0) {
                return;
            }
            int mx = (int)Math.floor(mouseX);
            if (!this.isHovering(mx, my = (int)Math.floor(mouseY))) {
                return;
            }
            List<Hack> hacks = TooManyHaxHack.this.getSortedHacks();
            if (hacks.isEmpty()) {
                return;
            }
            int relativeY = my - this.getY();
            if (relativeY < 0) {
                return;
            }
            int index = relativeY / 11;
            if (index < 0 || index >= hacks.size()) {
                return;
            }
            Hack hack = hacks.get(index);
            if (!hack.isSafeToBlock()) {
                ChatUtils.error("The hack '" + hack.getName() + "' is not safe to block.");
                return;
            }
            boolean blocked = TooManyHaxHack.this.isBlocked(hack);
            TooManyHaxHack.this.setBlocked(hack, !blocked);
        }

        @Override
        public void render(class_332 context, int mouseX, int mouseY, float partialTicks) {
            List<Hack> hacks = TooManyHaxHack.this.getSortedHacks();
            this.refreshSize(hacks);
            if (hacks.isEmpty()) {
                context.method_51433(HackSelectionComponent.MC.field_1772, "No hacks available.", this.getX() + 2, this.getY() + 2, WURST.getGui().getTxtColor(), false);
                return;
            }
            ClickGui gui = WURST.getGui();
            int x1 = this.getX();
            int x2 = x1 + this.getWidth();
            boolean hovering = this.isHovering(mouseX, mouseY);
            for (int i = 0; i < hacks.size(); ++i) {
                boolean rowHover;
                Hack hack = hacks.get(i);
                int y1 = this.getY() + i * 11;
                int y2 = y1 + 11;
                boolean blocked = TooManyHaxHack.this.isBlocked(hack);
                boolean bl = rowHover = hovering && mouseY >= y1 && mouseY < y2;
                if (rowHover) {
                    Object tooltip = hack.getWrappedDescription(200);
                    if (!hack.isSafeToBlock()) {
                        tooltip = (String)tooltip + "\n\nThis hack cannot be blocked.";
                    }
                    gui.setTooltip((String)tooltip);
                }
                float[] bg = gui.getBgColor();
                float opacity = gui.getOpacity();
                float intensity = rowHover ? 1.2f : (blocked ? 1.05f : 1.0f);
                float rowOpacity = opacity * intensity;
                if (!hack.isSafeToBlock()) {
                    rowOpacity *= 0.6f;
                }
                int boxX2 = x1 + 11;
                context.method_25294(boxX2, y1, x2, y2, RenderUtils.toIntColor(bg, rowOpacity));
                float boxOpacity = opacity * (rowHover ? 1.3f : 1.0f);
                context.method_25294(x1, y1, boxX2, y2, RenderUtils.toIntColor(bg, boxOpacity));
                int outlineColor = RenderUtils.toIntColor(gui.getAcColor(), 0.5f);
                RenderUtils.drawBorder2D(context, x1, y1, boxX2, y2, outlineColor);
                if (blocked) {
                    ClickGuiIcons.drawCheck(context, x1, y1, boxX2, y2, rowHover, !hack.isSafeToBlock());
                }
                int textColor = gui.getTxtColor();
                if (!hack.isSafeToBlock()) {
                    textColor = textColor & 0xFFFFFF | 0x55000000;
                }
                context.method_51433(HackSelectionComponent.MC.field_1772, hack.getName(), boxX2 + 2, y1 + 2, textColor, false);
            }
        }

        @Override
        public int getDefaultWidth() {
            List<Hack> hacks = TooManyHaxHack.this.getSortedHacks();
            int maxNameWidth = 0;
            for (Hack hack : hacks) {
                maxNameWidth = Math.max(maxNameWidth, HackSelectionComponent.MC.field_1772.method_1727(hack.getName()));
            }
            return Math.max(130, 15 + maxNameWidth);
        }

        @Override
        public int getDefaultHeight() {
            return 110;
        }
    }
}

