/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8961;
import net.minecraft.class_8963;
import net.minecraft.class_8965;
import net.minecraft.class_8966;
import net.minecraft.class_8967;
import net.minecraft.class_9197;
import net.minecraft.class_9199;
import net.minecraft.class_9206;
import net.wurstclient.Category;
import net.wurstclient.events.CameraTransformViewBobbingListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.RightClickListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.mixin.TrialSpawnerDataAccessor;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.chunk.ChunkUtils;
import org.joml.Quaternionfc;

public final class TrialSpawnerEspHack
extends Hack
implements UpdateListener,
CameraTransformViewBobbingListener,
RenderListener,
RightClickListener {
    private final SliderSetting maxDistance = new SliderSetting("Max distance", 160.0, 0.0, 256.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final CheckboxSetting drawTracers = new CheckboxSetting("Show tracer", true);
    private final CheckboxSetting fillShapes = new CheckboxSetting("Fill boxes", true);
    private final CheckboxSetting showOverlay = new CheckboxSetting("Text overlay", true);
    private final SliderSetting overlayScale = new SliderSetting("Overlay scale", 1.0, 0.5, 2.0, 0.05, SliderSetting.ValueDisplay.DECIMAL);
    private final CheckboxSetting showMobType = new CheckboxSetting("Show mob type", true);
    private final CheckboxSetting showStatus = new CheckboxSetting("Show status", true);
    private final CheckboxSetting showNextSpawn = new CheckboxSetting("Show next wave", true);
    private final CheckboxSetting showCooldown = new CheckboxSetting("Show cooldown", true);
    private final CheckboxSetting markOnApproach = new CheckboxSetting("Mark on approach", false);
    private final SliderSetting approachRange = new SliderSetting("Approach range", 4.0, 1.0, 16.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final ColorSetting vaultBoxColor = new ColorSetting("Vault box color", new Color(-8588599));
    private final ColorSetting ominousVaultBoxColor = new ColorSetting("Ominous vault color", new Color(-6596170));
    private final CheckboxSetting showDistance = new CheckboxSetting("Show distance", true);
    private final CheckboxSetting showTrialType = new CheckboxSetting("Show trial type", true);
    private final CheckboxSetting showActivationRadius = new CheckboxSetting("Show activation radius", true);
    private final CheckboxSetting showVaultLink = new CheckboxSetting("Show vault link", true);
    private final SliderSetting vaultLinkRange = new SliderSetting("Vault link range", 48.0, 8.0, 96.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final CheckboxSetting showCountInHackList = new CheckboxSetting("HackList count", false);
    private final ColorSetting colorIdle = new ColorSetting("Idle color", new Color(-5592406));
    private final ColorSetting colorCharging = new ColorSetting("Charging color", new Color(-735934));
    private final ColorSetting colorActive = new ColorSetting("Active color", new Color(-1748149));
    private final ColorSetting colorCompleted = new ColorSetting("Completed color", new Color(-11419023));
    private final ColorSetting radiusColor = new ColorSetting("Radius color", new Color(-10046465));
    private final ColorSetting vaultLinkColor = new ColorSetting("Vault link color", new Color(-8588599));
    private final ArrayList<TrialSpawnerInfo> spawners = new ArrayList();
    private final ArrayList<VaultInfo> vaults = new ArrayList();
    private final HashSet<String> openedVaultKeys = new HashSet();
    private boolean openedVaultsLoaded = false;
    private final Set<String> approachScheduledKeys = new HashSet<String>();
    private final Timer approachTimer = new Timer(true);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<class_2338, Long> predictedCooldownEnds = new HashMap<class_2338, Long>();
    private final Map<class_2338, class_8967> prevStates = new HashMap<class_2338, class_8967>();
    private int foundCount;
    private final CheckboxSetting estimateCooldownOnTransition = new CheckboxSetting("Estimate cooldown when observed", true);

    public TrialSpawnerEspHack() {
        super("TrialSpawnerESP");
        this.setCategory(Category.RENDER);
        this.addSetting(this.maxDistance);
        this.addSetting(this.drawTracers);
        this.addSetting(this.fillShapes);
        this.addSetting(this.showOverlay);
        this.addSetting(this.overlayScale);
        this.addSetting(this.showMobType);
        this.addSetting(this.showStatus);
        this.addSetting(this.showNextSpawn);
        this.addSetting(this.showCooldown);
        this.addSetting(this.markOnApproach);
        this.addSetting(this.approachRange);
        this.addSetting(this.estimateCooldownOnTransition);
        this.addSetting(this.showDistance);
        this.addSetting(this.showTrialType);
        this.addSetting(this.showActivationRadius);
        this.addSetting(this.showVaultLink);
        this.addSetting(this.vaultLinkRange);
        this.addSetting(this.vaultBoxColor);
        this.addSetting(this.ominousVaultBoxColor);
        this.addSetting(this.showCountInHackList);
        this.addSetting(this.colorIdle);
        this.addSetting(this.colorCharging);
        this.addSetting(this.colorActive);
        this.addSetting(this.colorCompleted);
        this.addSetting(this.radiusColor);
        this.addSetting(this.vaultLinkColor);
    }

    @Override
    protected void onEnable() {
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(CameraTransformViewBobbingListener.class, this);
        EVENTS.add(RenderListener.class, this);
        EVENTS.add(RightClickListener.class, this);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(CameraTransformViewBobbingListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        EVENTS.remove(RightClickListener.class, this);
        this.spawners.clear();
        this.vaults.clear();
        this.foundCount = 0;
        this.openedVaultsLoaded = false;
        this.openedVaultKeys.clear();
    }

    @Override
    public void onUpdate() {
        this.spawners.clear();
        if (TrialSpawnerEspHack.MC.field_1687 == null || TrialSpawnerEspHack.MC.field_1724 == null) {
            this.vaults.clear();
            this.foundCount = 0;
            return;
        }
        if (!this.openedVaultsLoaded) {
            this.loadOpenedVaults();
            this.openedVaultsLoaded = true;
        }
        this.vaults.clear();
        ChunkUtils.getLoadedBlockEntities().filter(be -> be instanceof class_9199).map(be -> (class_9199)be).forEach(be -> {
            class_9206 vs;
            class_2680 state;
            class_2338 vpos = be.method_11016().method_10062();
            this.vaults.add(new VaultInfo(vpos));
            if (TrialSpawnerEspHack.MC.field_1687 != null && (state = TrialSpawnerEspHack.MC.field_1687.method_8320(vpos)).method_27852(class_2246.field_48851) && state.method_28498((class_2769)class_9197.field_50171) && ((Boolean)state.method_11654((class_2769)class_9197.field_50171)).booleanValue() && state.method_28498(class_9197.field_48857) && (vs = (class_9206)state.method_11654(class_9197.field_48857)) == class_9206.field_48902) {
                String dim = "unknown";
                try {
                    if (MC != null && TrialSpawnerEspHack.MC.field_1687 != null) {
                        dim = TrialSpawnerEspHack.MC.field_1687.method_27983().method_29177().toString();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                String key = dim + "|" + vpos.method_10263() + "," + vpos.method_10264() + "," + vpos.method_10260();
                if (this.openedVaultKeys.add(key)) {
                    this.saveOpenedVaults();
                }
            }
        });
        boolean limit = this.maxDistance.getValue() > 0.0;
        double maxDistanceSq = this.maxDistance.getValue() * this.maxDistance.getValue();
        if (this.markOnApproach.isChecked()) {
            double range = this.approachRange.getValue();
            double rangeSq = range * range;
            for (VaultInfo v : this.vaults) {
                class_9206 prev;
                String key;
                class_2338 vpos = v.pos();
                String dim = "unknown";
                try {
                    if (MC != null && TrialSpawnerEspHack.MC.field_1687 != null) {
                        dim = TrialSpawnerEspHack.MC.field_1687.method_27983().method_29177().toString();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.openedVaultKeys.contains(key = dim + "|" + vpos.method_10263() + "," + vpos.method_10264() + "," + vpos.method_10260()) || this.approachScheduledKeys.contains(key) || !(TrialSpawnerEspHack.MC.field_1724.method_5649((double)vpos.method_10263() + 0.5, (double)vpos.method_10264() + 0.5, (double)vpos.method_10260() + 0.5) <= rangeSq)) continue;
                class_2680 state = TrialSpawnerEspHack.MC.field_1687.method_8320(vpos);
                final class_9206 prevFinal = prev = state.method_28498(class_9197.field_48857) ? (class_9206)state.method_11654(class_9197.field_48857) : null;
                final String keyFinal = key;
                final class_2338 vposFinal = vpos;
                this.approachScheduledKeys.add(keyFinal);
                this.approachTimer.schedule(new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            boolean prevIdle;
                            if (MC == null || MC.field_1687 == null) {
                                return;
                            }
                            class_2680 after = MC.field_1687.method_8320(vposFinal);
                            class_9206 afterState = after.method_28498(class_9197.field_48857) ? (class_9206)after.method_11654(class_9197.field_48857) : null;
                            boolean bl = prevIdle = prevFinal == null || prevFinal == class_9206.field_48899;
                            if (prevIdle && (afterState == null && prevFinal == null || afterState == prevFinal) && TrialSpawnerEspHack.this.openedVaultKeys.add(keyFinal)) {
                                TrialSpawnerEspHack.this.saveOpenedVaults();
                            }
                        }
                        catch (Throwable throwable) {
                        }
                        finally {
                            TrialSpawnerEspHack.this.approachScheduledKeys.remove(keyFinal);
                        }
                    }
                }, 1500L);
            }
        }
        ChunkUtils.getLoadedBlockEntities().filter(be -> be instanceof class_8961).map(be -> (class_8961)be).forEach(spawner -> {
            class_2338 pos = spawner.method_11016();
            double distSq = TrialSpawnerEspHack.MC.field_1724.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
            if (limit && distSq > maxDistanceSq) {
                return;
            }
            class_2338 immutablePos = pos.method_10062();
            VaultInfo link = this.showVaultLink.isChecked() ? this.findLinkedVault(immutablePos) : null;
            String decorMob = this.detectMobFromDecor(immutablePos);
            this.spawners.add(new TrialSpawnerInfo((class_8961)spawner, immutablePos, distSq, link, decorMob));
        });
        this.foundCount = this.spawners.size();
        if (TrialSpawnerEspHack.MC.field_1687 != null && this.estimateCooldownOnTransition.isChecked()) {
            long worldTime = TrialSpawnerEspHack.MC.field_1687.method_8510();
            for (TrialSpawnerInfo info : this.spawners) {
                class_2338 pos;
                class_8967 prev;
                class_8963 logic;
                class_8961 be2 = info.blockEntity();
                if (be2 == null || be2.method_11015() || be2.method_10997() != TrialSpawnerEspHack.MC.field_1687 || (logic = be2.method_55150()) == null) continue;
                class_8967 state = logic.method_55175() == null ? class_8967.field_47383 : logic.method_55175();
                class_8966 data = logic.method_55174();
                long cooldownEnd = 0L;
                if (data != null) {
                    TrialSpawnerDataAccessor acc = (TrialSpawnerDataAccessor)data;
                    cooldownEnd = acc.getCooldownEnd();
                }
                if ((prev = this.prevStates.get(pos = info.pos())) == class_8967.field_47385 && state != class_8967.field_47385 && cooldownEnd <= worldTime) {
                    long predicted = worldTime + (long)logic.method_58706();
                    this.predictedCooldownEnds.put(pos, predicted);
                }
                if (cooldownEnd > worldTime) {
                    this.predictedCooldownEnds.remove(pos);
                }
                this.prevStates.put(pos, state);
            }
            this.predictedCooldownEnds.entrySet().removeIf(e -> (Long)e.getValue() <= TrialSpawnerEspHack.MC.field_1687.method_8510());
        }
    }

    @Override
    public void onCameraTransformViewBobbing(CameraTransformViewBobbingListener.CameraTransformViewBobbingEvent event) {
        if (this.drawTracers.isChecked() || this.showOverlay.isChecked()) {
            event.cancel();
        }
    }

    @Override
    public void onRightClick(RightClickListener.RightClickEvent event) {
        if (MC == null || TrialSpawnerEspHack.MC.field_1687 == null || TrialSpawnerEspHack.MC.field_1724 == null) {
            return;
        }
        class_239 hit = TrialSpawnerEspHack.MC.field_1765;
        if (!(hit instanceof class_3965)) {
            return;
        }
        class_3965 bhr = (class_3965)hit;
        class_2338 pos = bhr.method_17777();
        class_2680 state = TrialSpawnerEspHack.MC.field_1687.method_8320(pos);
        if (!state.method_27852(class_2246.field_48851)) {
            return;
        }
        class_9206 before = state.method_28498(class_9197.field_48857) ? (class_9206)state.method_11654(class_9197.field_48857) : null;
        String dim = "unknown";
        try {
            if (TrialSpawnerEspHack.MC.field_1687 != null) {
                dim = TrialSpawnerEspHack.MC.field_1687.method_27983().method_29177().toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        final class_9206 beforeFinal = before;
        final String dimFinal = dim;
        final class_2338 posFinal = pos;
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    String key;
                    boolean beforeIdle;
                    if (MC == null || MC.field_1687 == null) {
                        return;
                    }
                    class_2680 after = MC.field_1687.method_8320(posFinal);
                    class_9206 afterState = after.method_28498(class_9197.field_48857) ? (class_9206)after.method_11654(class_9197.field_48857) : null;
                    boolean bl = beforeIdle = beforeFinal == null || beforeFinal == class_9206.field_48899;
                    if (beforeIdle && (afterState == null && beforeFinal == null || afterState == beforeFinal) && TrialSpawnerEspHack.this.openedVaultKeys.add(key = dimFinal + "|" + posFinal.method_10263() + "," + posFinal.method_10264() + "," + posFinal.method_10260())) {
                        TrialSpawnerEspHack.this.saveOpenedVaults();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        new Timer(true).schedule(task, 1500L);
    }

    @Override
    public void onRender(class_4587 matrices, float partialTicks) {
        ArrayList<RenderUtils.ColoredPoint> tracerTargets;
        if (TrialSpawnerEspHack.MC.field_1687 == null) {
            return;
        }
        ArrayList<RenderUtils.ColoredBox> outlineBoxes = new ArrayList<RenderUtils.ColoredBox>();
        ArrayList<RenderUtils.ColoredBox> filledBoxes = this.fillShapes.isChecked() ? new ArrayList<RenderUtils.ColoredBox>() : null;
        ArrayList<RenderUtils.ColoredPoint> arrayList = tracerTargets = this.drawTracers.isChecked() ? new ArrayList<RenderUtils.ColoredPoint>() : null;
        if (!this.vaults.isEmpty()) {
            for (VaultInfo v : this.vaults) {
                boolean ominous;
                class_2338 vpos = v.pos();
                class_2680 vstate = TrialSpawnerEspHack.MC.field_1687.method_8320(vpos);
                int vcolor = this.vaultBoxColor.getColorI();
                boolean bl = ominous = vstate.method_28498((class_2769)class_9197.field_50171) && (Boolean)vstate.method_11654((class_2769)class_9197.field_50171) != false;
                if (ominous) {
                    vcolor = this.ominousVaultBoxColor.getColorI();
                }
                String dim = "unknown";
                try {
                    if (MC != null && TrialSpawnerEspHack.MC.field_1687 != null) {
                        dim = TrialSpawnerEspHack.MC.field_1687.method_27983().method_29177().toString();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                String key = dim + "|" + vpos.method_10263() + "," + vpos.method_10264() + "," + vpos.method_10260();
                if (ominous && this.openedVaultKeys.contains(key)) {
                    vcolor = this.mixWithWhite(vcolor, 0.6f);
                }
                class_238 vbox = new class_238(vpos);
                outlineBoxes.add(new RenderUtils.ColoredBox(vbox, vcolor));
                if (filledBoxes != null) {
                    filledBoxes.add(new RenderUtils.ColoredBox(vbox, this.withAlpha(vcolor, 0.18f)));
                }
                String status = this.describeVaultState(vstate);
                ArrayList<OverlayLine> lines = new ArrayList<OverlayLine>();
                lines.add(new OverlayLine("Vault", vcolor));
                lines.add(new OverlayLine(status, -1));
                if (ominous && this.openedVaultKeys.contains(key)) {
                    lines.add(new OverlayLine("Opened", -2276284));
                }
                class_243 labelPos = class_243.method_24953((class_2382)vpos).method_1031(0.0, 1.0, 0.0);
                labelPos = this.resolveLabelPosition(labelPos);
                this.drawLabel(matrices, labelPos, lines, this.overlayScale.getValueF());
            }
        }
        for (TrialSpawnerInfo info : this.spawners) {
            class_8963 logic;
            class_8961 be = info.blockEntity();
            if (be == null || be.method_11015() || be.method_10997() != TrialSpawnerEspHack.MC.field_1687 || (logic = be.method_55150()) == null) continue;
            class_8967 state = logic.method_55175() == null ? class_8967.field_47383 : logic.method_55175();
            TrialStatus status = TrialStatus.fromState(state);
            int color = this.getColorForStatus(status);
            class_238 box = new class_238(info.pos());
            outlineBoxes.add(new RenderUtils.ColoredBox(box, color));
            if (filledBoxes != null) {
                filledBoxes.add(new RenderUtils.ColoredBox(box, this.withAlpha(color, 0.18f)));
            }
            if (tracerTargets != null) {
                tracerTargets.add(new RenderUtils.ColoredPoint(class_243.method_24953((class_2382)info.pos()), color));
            }
            if (this.showActivationRadius.isChecked()) {
                this.drawActivationRadius(matrices, info, logic, color);
            }
            if (this.showVaultLink.isChecked() && info.vault() != null) {
                this.drawVaultLink(matrices, info, color);
            }
            if (!this.showOverlay.isChecked()) continue;
            this.drawOverlay(matrices, info, logic, state, color);
        }
        if (filledBoxes != null && !filledBoxes.isEmpty()) {
            RenderUtils.drawSolidBoxes(matrices, filledBoxes, false);
        }
        if (!outlineBoxes.isEmpty()) {
            RenderUtils.drawOutlinedBoxes(matrices, outlineBoxes, false);
        }
        if (tracerTargets != null && !tracerTargets.isEmpty()) {
            RenderUtils.drawTracers(matrices, partialTicks, tracerTargets, false);
        }
    }

    private void drawActivationRadius(class_4587 matrices, TrialSpawnerInfo info, class_8963 logic, int stateColor) {
        int radius = logic.method_58707();
        if (radius <= 0) {
            return;
        }
        class_243 center = class_243.method_24953((class_2382)info.pos()).method_1031(0.0, 0.05, 0.0);
        double radiusSq = radius * radius;
        class_243 playerPos = TrialSpawnerEspHack.MC.field_1724 == null ? null : new class_243(TrialSpawnerEspHack.MC.field_1724.method_23317(), TrialSpawnerEspHack.MC.field_1724.method_23318(), TrialSpawnerEspHack.MC.field_1724.method_23321());
        boolean inside = playerPos != null && playerPos.method_1025(center) <= radiusSq;
        int color = this.withAlpha(inside ? this.mixWithWhite(stateColor, 0.35f) : this.radiusColor.getColorI(), inside ? 0.65f : 0.35f);
        int segments = Math.max(32, radius * 12);
        double step = Math.PI * 2 / (double)segments;
        class_243 prev = center.method_1031((double)radius, 0.0, 0.0);
        for (int i = 1; i <= segments; ++i) {
            double angle = (double)i * step;
            class_243 next = center.method_1031((double)radius * Math.cos(angle), 0.0, (double)radius * Math.sin(angle));
            RenderUtils.drawLine(matrices, prev, next, color, false);
            prev = next;
        }
    }

    private void drawVaultLink(class_4587 matrices, TrialSpawnerInfo info, int stateColor) {
        if (TrialSpawnerEspHack.MC.field_1687 == null || info.vault() == null) {
            return;
        }
        class_2338 vaultPos = info.vault().pos();
        class_243 start = class_243.method_24953((class_2382)info.pos());
        class_243 end = class_243.method_24953((class_2382)vaultPos).method_1031(0.0, 0.25, 0.0);
        int color = this.vaultLinkColor.getColorI();
        RenderUtils.drawLine(matrices, start, end, color, false);
        class_2680 state = TrialSpawnerEspHack.MC.field_1687.method_8320(vaultPos);
        if (!state.method_27852(class_2246.field_48851)) {
            return;
        }
        String status = this.describeVaultState(state);
        List<OverlayLine> lines = List.of(new OverlayLine("Vault", stateColor), new OverlayLine(status, color));
        class_243 labelPos = end.method_1031(0.0, 0.6, 0.0);
        this.drawLabel(matrices, labelPos, lines, this.overlayScale.getValueF());
    }

    private void drawOverlay(class_4587 matrices, TrialSpawnerInfo info, class_8963 logic, class_8967 state, int headerColor) {
        String mobName;
        Long predicted;
        if (TrialSpawnerEspHack.MC.field_1687 == null) {
            return;
        }
        class_8966 data = logic.method_55174();
        if (data == null) {
            return;
        }
        TrialSpawnerDataAccessor accessor = (TrialSpawnerDataAccessor)data;
        long worldTime = TrialSpawnerEspHack.MC.field_1687.method_8510();
        long cooldownTicks = accessor.getCooldownEnd() - worldTime;
        double cooldownSeconds = Math.max(0.0, (double)cooldownTicks / 20.0);
        boolean cooldownEstimated = false;
        if (cooldownTicks <= 0L && this.estimateCooldownOnTransition.isChecked() && (predicted = this.predictedCooldownEnds.get(info.pos())) != null && predicted > worldTime) {
            cooldownSeconds = Math.max(0.0, (double)(predicted - worldTime) / 20.0);
            cooldownEstimated = true;
        }
        long nextSpawnTicks = accessor.getNextMobSpawnsAt() - worldTime;
        double nextSpawnSeconds = Math.max(0.0, (double)nextSpawnTicks / 20.0);
        int additionalPlayers = data.method_55195(info.pos());
        class_8965 config = logic.method_71403();
        int totalMobs = Math.max(1, config.method_55179(additionalPlayers));
        int simultaneous = Math.max(1, config.method_55181(additionalPlayers));
        int trackedSpawned = class_3532.method_15340((int)accessor.getTotalSpawnedMobs(), (int)0, (int)totalMobs);
        Set<UUID> aliveSet = accessor.getSpawnedMobsAlive();
        int aliveFromData = aliveSet == null ? 0 : Math.min(aliveSet.size(), totalMobs);
        int totalWaves = Math.max(1, (int)Math.ceil((double)totalMobs / (double)simultaneous));
        String decorMob = info.decorMob() == null ? "" : info.decorMob();
        String spawnId = this.readMobId(data.method_55194(state));
        String resolvedMob = this.resolveMobName(spawnId);
        String string = !decorMob.isEmpty() ? decorMob : (mobName = resolvedMob == null ? "" : resolvedMob);
        if (mobName.isEmpty()) {
            mobName = "Unknown";
        }
        class_1299<?> mobType = this.resolveEntityType(spawnId, decorMob);
        int aliveFromWorld = this.countWorldMobs(info.pos(), logic, mobType, mobName);
        int alive = Math.max(aliveFromWorld, aliveFromData);
        if (trackedSpawned <= 0 && alive > 0) {
            trackedSpawned = alive;
        }
        int mobsProgress = class_3532.method_15340((int)Math.max(trackedSpawned, alive), (int)0, (int)totalMobs);
        int currentWave = class_3532.method_15340((int)((int)Math.ceil((double)Math.max(1, mobsProgress) / (double)simultaneous)), (int)(mobsProgress > 0 ? 1 : 0), (int)totalWaves);
        String trialType = this.describeTrialType(mobName, spawnId);
        TrialStatus status = TrialStatus.fromState(state);
        String statusLine = this.describeStatus(status);
        ArrayList<OverlayLine> lines = new ArrayList<OverlayLine>();
        String title = logic.method_58705() ? "Ominous Trial Spawner" : "Trial Spawner";
        lines.add(new OverlayLine(title, headerColor));
        if (this.showMobType.isChecked()) {
            lines.add(new OverlayLine("Mob: " + mobName, -1));
        }
        if (this.showStatus.isChecked()) {
            lines.add(new OverlayLine("Status: " + statusLine, -1));
        }
        if (alive > 0) {
            lines.add(new OverlayLine("Active mobs: " + alive, -1));
        }
        if (this.showNextSpawn.isChecked() && state == class_8967.field_47385) {
            String next = "Next: " + simultaneous + "x " + mobName + " in " + this.formatSeconds(nextSpawnSeconds);
            lines.add(new OverlayLine(next, -1));
        }
        if (this.showCooldown.isChecked() && cooldownSeconds > 0.0) {
            String prefix = cooldownEstimated ? "Cooldown (est): " : "Cooldown: ";
            lines.add(new OverlayLine(prefix + this.formatSeconds(cooldownSeconds), -1));
        }
        if (this.showTrialType.isChecked()) {
            lines.add(new OverlayLine("Trial: " + trialType, -1));
        }
        if (this.showDistance.isChecked()) {
            double meters = Math.sqrt(info.distanceSq());
            lines.add(new OverlayLine("Distance: " + Math.round(meters) + "m", -1));
        }
        if (this.showVaultLink.isChecked() && info.vault() != null) {
            String vaultInfo = this.describeVaultState(TrialSpawnerEspHack.MC.field_1687.method_8320(info.vault().pos()));
            lines.add(new OverlayLine("Vault: " + vaultInfo, -1));
        }
        class_243 labelPos = class_243.method_24953((class_2382)info.pos()).method_1031(0.0, 1.6, 0.0);
        labelPos = this.resolveLabelPosition(labelPos);
        this.drawLabel(matrices, labelPos, lines, this.overlayScale.getValueF());
    }

    private void drawLabel(class_4587 matrices, class_243 position, List<OverlayLine> lines, float scale) {
        if (lines.isEmpty() || TrialSpawnerEspHack.MC.field_1772 == null) {
            return;
        }
        matrices.method_22903();
        class_243 cam = RenderUtils.getCameraPos();
        matrices.method_22904(position.field_1352 - cam.field_1352, position.field_1351 - cam.field_1351, position.field_1350 - cam.field_1350);
        class_1297 camEntity = MC.method_1560();
        if (camEntity != null) {
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-camEntity.method_36454()));
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(camEntity.method_36455()));
        }
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
        float s = 0.025f * scale;
        matrices.method_22905(s, -s, s);
        class_327 tr = TrialSpawnerEspHack.MC.field_1772;
        int bg = (int)(TrialSpawnerEspHack.MC.field_1690.method_19343(0.25f) * 255.0f) << 24;
        Objects.requireNonNull(tr);
        int lineHeight = 9 + 2;
        int maxWidth = lines.stream().mapToInt(line -> tr.method_1727(line.text())).max().orElse(0);
        int x = -maxWidth / 2;
        class_4597.class_4598 vcp = RenderUtils.getVCP();
        for (int i = 0; i < lines.size(); ++i) {
            OverlayLine line2 = lines.get(i);
            int y = i * lineHeight;
            class_327.class_6415 layerType = class_327.class_6415.field_33994;
            tr.method_27521(line2.text(), (float)x, (float)y, line2.color(), false, matrices.method_23760().method_23761(), (class_4597)vcp, layerType, bg, 0xF000F0);
        }
        vcp.method_22993();
        matrices.method_22909();
    }

    private class_243 resolveLabelPosition(class_243 target) {
        double anchor;
        class_243 cam = RenderUtils.getCameraPos();
        double distance = cam.method_1022(target);
        if (distance <= (anchor = 12.0)) {
            return target;
        }
        class_243 dir = target.method_1020(cam);
        double len = dir.method_1033();
        if (len < 1.0E-4) {
            return target;
        }
        return cam.method_1019(dir.method_1021(anchor / len));
    }

    private VaultInfo findLinkedVault(class_2338 spawnerPos) {
        if (this.vaults.isEmpty()) {
            return null;
        }
        double maxRangeSq = this.vaultLinkRange.getValue() * this.vaultLinkRange.getValue();
        VaultInfo closest = null;
        double best = maxRangeSq;
        for (VaultInfo info : this.vaults) {
            double distSq = info.pos().method_10262((class_2382)spawnerPos);
            if (!(distSq <= best)) continue;
            closest = info;
            best = distSq;
        }
        return closest;
    }

    private void loadOpenedVaults() {
        File file;
        String server = null;
        try {
            if (MC != null && MC.method_1558() != null) {
                server = TrialSpawnerEspHack.MC.method_1558().field_3761;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String name = this.sanitizeServer(server);
        File dir = new File("config/wurst/opened_vaults");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(file = new File(dir, name + ".json")).isFile()) {
            return;
        }
        try (FileReader r = new FileReader(file);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)r, JsonObject.class);
            JsonArray arr = root.getAsJsonArray("openedPositions");
            if (arr == null) {
                return;
            }
            for (JsonElement el : arr) {
                try {
                    JsonObject o = el.getAsJsonObject();
                    int x = o.get("x").getAsInt();
                    int y = o.get("y").getAsInt();
                    int z = o.get("z").getAsInt();
                    String dim = null;
                    if (o.has("dimension")) {
                        dim = o.get("dimension").getAsString();
                    }
                    if (dim == null) {
                        try {
                            if (MC != null && TrialSpawnerEspHack.MC.field_1687 != null) {
                                dim = TrialSpawnerEspHack.MC.field_1687.method_27983().method_29177().toString();
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (dim == null) {
                            dim = "unknown";
                        }
                    }
                    String key = dim + "|" + x + "," + y + "," + z;
                    this.openedVaultKeys.add(key);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void saveOpenedVaults() {
        String server = null;
        try {
            if (MC != null && MC.method_1558() != null) {
                server = TrialSpawnerEspHack.MC.method_1558().field_3761;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String name = this.sanitizeServer(server);
        File dir = new File("config/wurst/opened_vaults");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, name + ".json");
        JsonObject root = new JsonObject();
        JsonArray arr = new JsonArray();
        for (String key : this.openedVaultKeys) {
            try {
                String[] parts;
                String dim = "unknown";
                String coords = key;
                int sep = key.indexOf(124);
                if (sep >= 0) {
                    dim = key.substring(0, sep);
                    coords = key.substring(sep + 1);
                }
                if ((parts = coords.split(",")).length < 3) continue;
                int x = Integer.parseInt(parts[0]);
                int y = Integer.parseInt(parts[1]);
                int z = Integer.parseInt(parts[2]);
                JsonObject o = new JsonObject();
                o.addProperty("dimension", dim);
                o.addProperty("x", (Number)x);
                o.addProperty("y", (Number)y);
                o.addProperty("z", (Number)z);
                arr.add((JsonElement)o);
            }
            catch (Throwable throwable) {}
        }
        root.add("openedPositions", (JsonElement)arr);
        try (FileWriter w = new FileWriter(file);){
            w.write(GSON.toJson((JsonElement)root));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String sanitizeServer(String serverIp) {
        if (serverIp == null || serverIp.isBlank()) {
            return "singleplayer";
        }
        return serverIp.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9._-]", "_");
    }

    private String detectMobFromDecor(class_2338 spawnerPos) {
        boolean hasPodzolMushroom;
        if (TrialSpawnerEspHack.MC.field_1687 == null || spawnerPos == null) {
            return "";
        }
        class_2338 base = spawnerPos.method_10074();
        boolean hasCobble = false;
        boolean hasMossyCobble = false;
        boolean hasStone = false;
        boolean hasCobweb = false;
        boolean hasPodzol = false;
        boolean hasMushroom = false;
        boolean hasChiseledSandstone = false;
        boolean hasChiseledTuff = false;
        boolean hasPackedIce = false;
        boolean hasStoneBricks = false;
        boolean hasMossBlock = false;
        boolean hasBoneBlock = false;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0) continue;
                class_2338 check = base.method_10069(dx, 0, dz);
                class_2680 state = TrialSpawnerEspHack.MC.field_1687.method_8320(check);
                class_2680 above = TrialSpawnerEspHack.MC.field_1687.method_8320(check.method_10084());
                if (state.method_27852(class_2246.field_10445)) {
                    hasCobble = true;
                }
                if (state.method_27852(class_2246.field_9989)) {
                    hasMossyCobble = true;
                }
                if (state.method_27852(class_2246.field_10340)) {
                    hasStone = true;
                }
                if (state.method_27852(class_2246.field_10343) || above.method_27852(class_2246.field_10343)) {
                    hasCobweb = true;
                }
                if (state.method_27852(class_2246.field_10520)) {
                    hasPodzol = true;
                }
                if (this.isMushroom(state) || this.isMushroom(above)) {
                    hasMushroom = true;
                }
                if (state.method_27852(class_2246.field_10292)) {
                    hasChiseledSandstone = true;
                }
                if (state.method_27852(class_2246.field_47034)) {
                    hasChiseledTuff = true;
                }
                if (state.method_27852(class_2246.field_10225)) {
                    hasPackedIce = true;
                }
                if (state.method_27852(class_2246.field_10056)) {
                    hasStoneBricks = true;
                }
                if (state.method_27852(class_2246.field_28681)) {
                    hasMossBlock = true;
                }
                if (!state.method_27852(class_2246.field_10166)) continue;
                hasBoneBlock = true;
            }
        }
        boolean bl = hasPodzolMushroom = hasPodzol && hasMushroom;
        if (hasBoneBlock && hasPodzolMushroom) {
            return "Bogged";
        }
        if (hasCobble && hasMossyCobble) {
            return "Baby Zombie";
        }
        if (hasStone && hasCobweb && hasPodzolMushroom) {
            return "Cave Spider";
        }
        if (hasStone && hasCobweb) {
            return "Spider";
        }
        if (hasChiseledTuff) {
            return "Breeze";
        }
        if (hasChiseledSandstone) {
            return "Husk";
        }
        if (hasPackedIce) {
            return "Stray";
        }
        if (hasMossBlock) {
            return "Slime";
        }
        if (hasBoneBlock) {
            return "Skeleton";
        }
        if (hasStoneBricks) {
            return "Silverfish";
        }
        if (hasMossyCobble) {
            return "Zombie";
        }
        return "";
    }

    private boolean isMushroom(class_2680 state) {
        return state.method_27852(class_2246.field_10251) || state.method_27852(class_2246.field_10559);
    }

    private int getColorForStatus(TrialStatus status) {
        return switch (status.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> this.colorActive.getColorI();
            case 1 -> this.colorCharging.getColorI();
            case 3 -> this.colorCompleted.getColorI();
            case 0 -> this.colorIdle.getColorI();
        };
    }

    private String readMobId(class_2487 spawnData) {
        Optional id;
        if (spawnData == null) {
            return "";
        }
        Optional entity = spawnData.method_10562("entity");
        if (entity.isPresent() && (id = ((class_2487)entity.get()).method_10558("id")).isPresent()) {
            return (String)id.get();
        }
        return spawnData.method_10558("id").orElse("");
    }

    private String resolveMobName(String mobId) {
        class_1299 entity;
        if (mobId == null || mobId.isEmpty()) {
            return "Unknown";
        }
        class_2960 id = class_2960.method_12829((String)mobId);
        if (id != null && (entity = (class_1299)class_7923.field_41177.method_63535(id)) != null) {
            return entity.method_5897().getString();
        }
        return this.prettifyId(mobId);
    }

    private String prettifyId(String raw) {
        int colon = raw.indexOf(58);
        String clean = colon >= 0 ? raw.substring(colon + 1) : raw;
        String[] parts = clean.split("_");
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(Character.toUpperCase(part.charAt(0)));
            if (part.length() <= 1) continue;
            sb.append(part.substring(1));
        }
        return sb.length() == 0 ? clean : sb.toString();
    }

    private String describeTrialType(String resolvedName, String mobId) {
        String trial = this.describeTrialTypeFromValue(resolvedName);
        if (!"Unknown".equals(trial)) {
            return trial;
        }
        return this.describeTrialTypeFromValue(mobId);
    }

    private String describeTrialTypeFromValue(String value) {
        if (value == null || value.isEmpty()) {
            return "Unknown";
        }
        String lower = value.toLowerCase(Locale.ROOT);
        if (lower.contains("breeze")) {
            return "Breeze / Parkour";
        }
        if (lower.contains("bogged") || lower.contains("drifter") || lower.contains("husk") || lower.contains("skeleton") || lower.contains("stray") || lower.contains("zombie") || lower.contains("spider") || lower.contains("slime") || lower.contains("silverfish") || lower.contains("baby")) {
            return "Combat";
        }
        return "Unknown";
    }

    private class_1299<?> resolveEntityType(String mobId, String decorMob) {
        class_1299<?> type = this.parseMobType(mobId);
        if (type != null) {
            return type;
        }
        return this.mapDecorMobToType(decorMob);
    }

    private class_1299<?> parseMobType(String mobId) {
        if (mobId == null || mobId.isEmpty()) {
            return null;
        }
        class_2960 id = class_2960.method_12829((String)mobId);
        if (id == null) {
            return null;
        }
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)id);
        return (class_1299)class_7923.field_41177.method_29107(key);
    }

    private class_1299<?> mapDecorMobToType(String decorMob) {
        if (decorMob == null || decorMob.isEmpty()) {
            return null;
        }
        return switch (decorMob.toLowerCase(Locale.ROOT)) {
            case "baby zombie", "zombie" -> class_1299.field_6051;
            case "husk" -> class_1299.field_6071;
            case "spider" -> class_1299.field_6079;
            case "cave spider" -> class_1299.field_6084;
            case "silverfish" -> class_1299.field_6125;
            case "slime" -> class_1299.field_6069;
            case "skeleton" -> class_1299.field_6137;
            case "bogged" -> class_1299.field_49148;
            case "stray" -> class_1299.field_6098;
            case "breeze" -> class_1299.field_47244;
            default -> null;
        };
    }

    private int countWorldMobs(class_2338 pos, class_8963 logic, class_1299<?> mobType, String mobName) {
        if (TrialSpawnerEspHack.MC.field_1687 == null || pos == null) {
            return 0;
        }
        double radius = logic == null ? 8.0 : (double)Math.max(6, logic.method_58707() + 4);
        class_238 box = class_238.method_30048((class_243)class_243.method_24953((class_2382)pos), (double)(radius * 2.0), (double)(radius * 2.0), (double)(radius * 2.0));
        return TrialSpawnerEspHack.MC.field_1687.method_8390(class_1309.class, box, entity -> this.matchesMob((class_1309)entity, mobType, mobName)).size();
    }

    private boolean matchesMob(class_1309 entity, class_1299<?> mobType, String mobName) {
        if (entity == null) {
            return false;
        }
        if (mobType != null && entity.method_5864() == mobType) {
            return true;
        }
        if (mobName == null || mobName.isEmpty()) {
            return false;
        }
        String typeName = entity.method_5864().method_5897().getString();
        return typeName.equalsIgnoreCase(mobName);
    }

    private String describeVaultState(class_2680 state) {
        if (!state.method_27852(class_2246.field_48851) || !state.method_28498(class_9197.field_48857)) {
            return "Missing";
        }
        class_9206 vaultState = (class_9206)state.method_11654(class_9197.field_48857);
        boolean ominous = state.method_28498((class_2769)class_9197.field_50171) && (Boolean)state.method_11654((class_2769)class_9197.field_50171) != false;
        String prefix = ominous ? "Ominous " : "";
        return switch (vaultState) {
            default -> throw new MatchException(null, null);
            case class_9206.field_48900 -> prefix + "Active";
            case class_9206.field_48901 -> prefix + "Unlocking";
            case class_9206.field_48902 -> prefix + "Ejecting loot";
            case class_9206.field_48899 -> prefix + "Locked";
        };
    }

    private String describeStatus(TrialStatus status) {
        return switch (status.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> "Spawning";
            case 1 -> "Priming";
            case 3 -> "Completed";
            case 0 -> "Idle";
        };
    }

    private String formatSeconds(double seconds) {
        if (seconds >= 60.0) {
            int mins = (int)Math.floor(seconds / 60.0);
            int secs = (int)Math.round(seconds - (double)(mins * 60));
            if (secs == 60) {
                ++mins;
                secs = 0;
            }
            return mins + "m " + String.format(Locale.ROOT, "%02ds", secs);
        }
        if (seconds >= 10.0) {
            return (int)Math.round(seconds) + "s";
        }
        return String.format(Locale.ROOT, "%.1fs", seconds);
    }

    private String progressBar(double progress) {
        int segments = 10;
        int filled = class_3532.method_15340((int)((int)Math.round(progress * 10.0)), (int)0, (int)10);
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < 10; ++i) {
            sb.append(i < filled ? "#" : "-");
        }
        sb.append("]");
        return sb.toString();
    }

    private int withAlpha(int color, float alpha) {
        int a = class_3532.method_15340((int)((int)(alpha * 255.0f)), (int)0, (int)255);
        return color & 0xFFFFFF | a << 24;
    }

    private int mixWithWhite(int color, float factor) {
        int a = color >>> 24;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = class_3532.method_15340((int)class_3532.method_48781((float)factor, (int)r, (int)255), (int)0, (int)255);
        g = class_3532.method_15340((int)class_3532.method_48781((float)factor, (int)g, (int)255), (int)0, (int)255);
        b = class_3532.method_15340((int)class_3532.method_48781((float)factor, (int)b, (int)255), (int)0, (int)255);
        return a << 24 | r << 16 | g << 8 | b;
    }

    @Override
    public String getRenderName() {
        if (this.showCountInHackList.isChecked() && this.foundCount > 0) {
            return this.getName() + " [" + this.foundCount + "]";
        }
        return super.getRenderName();
    }

    private record VaultInfo(class_2338 pos) {
    }

    private record TrialSpawnerInfo(class_8961 blockEntity, class_2338 pos, double distanceSq, VaultInfo vault, String decorMob) {
    }

    private record OverlayLine(String text, int color) {
    }

    private static enum TrialStatus {
        IDLE,
        CHARGING,
        ACTIVE,
        COMPLETED;


        public static TrialStatus fromState(class_8967 state) {
            return switch (state) {
                default -> throw new MatchException(null, null);
                case class_8967.field_47385 -> ACTIVE;
                case class_8967.field_47384 -> CHARGING;
                case class_8967.field_47386, class_8967.field_47387 -> COMPLETED;
                case class_8967.field_47388, class_8967.field_47383 -> IDLE;
            };
        }
    }
}

